/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.ArrayFormulaImpl;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.BitvectorFormulaImpl;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.BooleanFormulaImpl;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FloatingPointFormulaImpl;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.IntegerFormulaImpl;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.RationalFormulaImpl;

public abstract class FormulaCreator<TFormulaInfo, TType, TEnv> {
    private final TType boolType;
    private final TType integerType;
    private final TType rationalType;
    private final TEnv environment;

    protected FormulaCreator(TEnv env, TType boolType, TType pIntegerType, TType pRationalType) {
        this.environment = env;
        this.boolType = boolType;
        this.integerType = pIntegerType;
        this.rationalType = pRationalType;
    }

    public final TEnv getEnv() {
        return this.environment;
    }

    public TType getBoolType() {
        return this.boolType;
    }

    public TType getIntegerType() {
        return this.integerType;
    }

    public TType getRationalType() {
        return this.rationalType;
    }

    public abstract TType getBitvectorType(int var1);

    public abstract TType getFloatingPointType(FormulaType.FloatingPointType var1);

    public abstract TType getArrayType(TType var1, TType var2);

    public abstract TFormulaInfo makeVariable(TType var1, String var2);

    public BooleanFormula encapsulateBoolean(TFormulaInfo pTerm) {
        return new BooleanFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected BitvectorFormula encapsulateBitvector(TFormulaInfo pTerm) {
        return new BitvectorFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected FloatingPointFormula encapsulateFloatingPoint(TFormulaInfo pTerm) {
        return new FloatingPointFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(TFormulaInfo pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        return new ArrayFormulaImpl<TI, TE, TFormulaInfo>(pTerm, pIndexType, pElementType);
    }

    public <T extends Formula> T encapsulate(FormulaType<T> pType, TFormulaInfo pTerm) {
        if (pType.isBooleanType()) {
            return (T)new BooleanFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new IntegerFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new RationalFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)new BitvectorFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new FloatingPointFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)pType;
            return (T)this.encapsulateArray(pTerm, arrayType.getIndexType(), arrayType.getElementType());
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in the Solver!");
    }

    protected TFormulaInfo extractInfo(Formula pT) {
        if (pT instanceof AbstractFormula) {
            return ((AbstractFormula)pT).getFormulaInfo();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    protected <TI extends Formula, TE extends Formula> FormulaType<TE> getArrayFormulaElementType(ArrayFormula<TI, TE> pArray) {
        return ((ArrayFormulaImpl)pArray).getElementType();
    }

    protected <TI extends Formula, TE extends Formula> FormulaType<TI> getArrayFormulaIndexType(ArrayFormula<TI, TE> pArray) {
        return ((ArrayFormulaImpl)pArray).getIndexType();
    }

    protected <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        FormulaType<Formula> t;
        Preconditions.checkNotNull(formula);
        if (formula instanceof BooleanFormula) {
            t = FormulaType.BooleanType;
        } else if (formula instanceof NumeralFormula.IntegerFormula) {
            t = FormulaType.IntegerType;
        } else if (formula instanceof NumeralFormula.RationalFormula) {
            t = FormulaType.RationalType;
        } else {
            if (formula instanceof ArrayFormula) {
                throw new UnsupportedOperationException("SMT solvers with support for arrays needs to overwrite FormulaCreator.getFormulaType()");
            }
            if (formula instanceof BitvectorFormula) {
                throw new UnsupportedOperationException("SMT solvers with support for bitvectors needs to overwrite FormulaCreator.getFormulaType()");
            }
            throw new IllegalArgumentException("Formula with unexpected type " + formula.getClass());
        }
        return t;
    }

    public abstract FormulaType<?> getFormulaType(TFormulaInfo var1);
}

