/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.WrappingFormula;

public class ArrayFormulaManagerView
extends BaseManagerView
implements ArrayFormulaManager {
    private ArrayFormulaManager manager;

    ArrayFormulaManagerView(FormulaManagerView pViewManager, ArrayFormulaManager pManager) {
        super(pViewManager);
        this.manager = pManager;
    }

    @Override
    public <TI extends Formula, TE extends Formula> TE select(ArrayFormula<TI, TE> pArray, Formula pIndex) {
        ArrayFormula declaredArray = (ArrayFormula)this.unwrap(pArray);
        Object selectResult = this.manager.select(declaredArray, this.unwrap(pIndex));
        Object resultType = this.getElementType(pArray);
        return (TE)this.wrap(resultType, selectResult);
    }

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> store(ArrayFormula<TI, TE> pArray, Formula pIndex, Formula pValue) {
        ArrayFormula declaredArray = (ArrayFormula)this.unwrap(pArray);
        return this.manager.store(declaredArray, this.unwrap(pIndex), this.unwrap(pValue));
    }

    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, FTI pIndexType, FTE pElementType) {
        FormulaType.ArrayFormulaType inputArrayType = new FormulaType.ArrayFormulaType(pIndexType, pElementType);
        FormulaType<?> unwrappedIndexType = this.unwrapType(pIndexType);
        FormulaType<?> unwrappedElementType = this.unwrapType(pElementType);
        ArrayFormula result = this.manager.makeArray(pName, unwrappedIndexType, unwrappedElementType);
        return (ArrayFormula)this.wrap(inputArrayType, result);
    }

    @Override
    public <TI extends Formula, FTI extends FormulaType<TI>> FTI getIndexType(ArrayFormula<TI, ?> pArray) {
        if (pArray instanceof WrappingFormula) {
            FormulaType.ArrayFormulaType t = (FormulaType.ArrayFormulaType)((WrappingFormula)((Object)pArray)).getType();
            return (FTI)t.getIndexType();
        }
        return this.manager.getIndexType(pArray);
    }

    @Override
    public <TE extends Formula, FTE extends FormulaType<TE>> FTE getElementType(ArrayFormula<?, TE> pArray) {
        if (pArray instanceof WrappingFormula) {
            FormulaType.ArrayFormulaType t = (FormulaType.ArrayFormulaType)((WrappingFormula)((Object)pArray)).getType();
            return (FTE)t.getElementType();
        }
        return this.manager.getElementType(pArray);
    }

    @Override
    public <TI extends Formula, TE extends Formula> BooleanFormula equivalence(ArrayFormula<TI, TE> pArray1, ArrayFormula<TI, TE> pArray2) {
        ArrayFormula declaredArray1 = (ArrayFormula)this.unwrap(pArray1);
        ArrayFormula declaredArray2 = (ArrayFormula)this.unwrap(pArray2);
        BooleanFormula result = this.manager.equivalence(declaredArray1, declaredArray2);
        return this.wrap(FormulaType.BooleanType, result);
    }
}

