/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class BooleanFormulaManagerView
extends BaseManagerView
implements BooleanFormulaManager {
    private final BooleanFormulaManager manager;
    private final UnsafeFormulaManager unsafe;

    public BooleanFormulaManagerView(FormulaManagerView pViewManager, BooleanFormulaManager pManager, UnsafeFormulaManager pUnsafe) {
        super(pViewManager);
        this.manager = pManager;
        this.unsafe = pUnsafe;
    }

    public BooleanFormula makeVariable(String pVar, int pI) {
        return this.makeVariable(FormulaManagerView.makeName(pVar, pI));
    }

    @Override
    public BooleanFormula not(BooleanFormula pBits) {
        return this.manager.not(pBits);
    }

    @Override
    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        return this.manager.and(pBits1, pBits2);
    }

    @Override
    public BooleanFormula and(List<BooleanFormula> pBits) {
        return this.manager.and(pBits);
    }

    @Override
    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        return this.manager.or(pBits1, pBits2);
    }

    @Override
    public BooleanFormula or(List<BooleanFormula> pBits) {
        return this.manager.or(pBits);
    }

    @Override
    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        return this.manager.xor(pBits1, pBits2);
    }

    @Override
    public boolean isNot(BooleanFormula pBits) {
        return this.manager.isNot(pBits);
    }

    @Override
    public boolean isAnd(BooleanFormula pBits) {
        return this.manager.isAnd(pBits);
    }

    @Override
    public boolean isOr(BooleanFormula pBits) {
        return this.manager.isOr(pBits);
    }

    @Override
    public boolean isXor(BooleanFormula pBits) {
        return this.manager.isXor(pBits);
    }

    @Override
    public boolean isBoolean(Formula pF) {
        return pF instanceof BooleanFormula;
    }

    @Override
    public BooleanFormula makeBoolean(boolean pValue) {
        return this.manager.makeBoolean(pValue);
    }

    @Override
    public BooleanFormula makeVariable(String pVar) {
        return this.manager.makeVariable(pVar);
    }

    @Override
    public boolean isTrue(BooleanFormula pFormula) {
        return this.manager.isTrue(pFormula);
    }

    @Override
    public boolean isFalse(BooleanFormula pFormula) {
        return this.manager.isFalse(pFormula);
    }

    @Override
    public <T extends Formula> T ifThenElse(BooleanFormula pCond, T pF1, T pF2) {
        Formula f1 = this.unwrap(pF1);
        Formula f2 = this.unwrap(pF2);
        FormulaType<T> targetType = this.getFormulaType(pF1);
        return this.wrap(targetType, this.manager.ifThenElse(pCond, f1, f2));
    }

    @Override
    public <T extends Formula> boolean isIfThenElse(T pF) {
        return this.manager.isIfThenElse(this.unwrap(pF));
    }

    public <T extends Formula> Triple<BooleanFormula, T, T> splitIfThenElse(T pF) {
        Preconditions.checkArgument((boolean)this.isIfThenElse(pF));
        Formula f = this.unwrap(pF);
        assert (this.unsafe.getArity(f) == 3);
        BooleanFormula cond = (BooleanFormula)this.unsafe.getArg(f, 0);
        FormulaType<Formula> innerType = this.getFormulaType(f);
        Formula thenBranch = this.unsafe.typeFormula(innerType, this.unsafe.getArg(f, 1));
        Formula elseBranch = this.unsafe.typeFormula(innerType, this.unsafe.getArg(f, 2));
        FormulaType<T> targetType = this.getFormulaType(pF);
        return Triple.of((Object)cond, this.wrap(targetType, thenBranch), this.wrap(targetType, elseBranch));
    }

    @Override
    public boolean isEquivalence(BooleanFormula pFormula) {
        return this.manager.isEquivalence(pFormula);
    }

    public BooleanFormula implication(BooleanFormula p, BooleanFormula q) {
        return this.or(this.not(p), q);
    }

    @Override
    public boolean isImplication(BooleanFormula pFormula) {
        return this.manager.isImplication(pFormula);
    }

    @Override
    public BooleanFormula equivalence(BooleanFormula pFormula1, BooleanFormula pFormula2) {
        return this.manager.equivalence(pFormula1, pFormula2);
    }

    public BooleanFormula notEquivalence(BooleanFormula p, BooleanFormula q) {
        return this.not(this.equivalence(p, q));
    }

    public static abstract class RecursiveBooleanFormulaVisitor
    extends BooleanFormulaVisitor<Void> {
        private final Set<BooleanFormula> seen = new HashSet<BooleanFormula>();

        protected RecursiveBooleanFormulaVisitor(FormulaManagerView pFmgr) {
            super(pFmgr);
        }

        private Void visitIfNotSeen(BooleanFormula f) {
            if (this.seen.add(f)) {
                return (Void)this.visit(f);
            }
            return null;
        }

        private Void visitMulti(BooleanFormula ... pOperands) {
            for (BooleanFormula operand : pOperands) {
                this.visitIfNotSeen(operand);
            }
            return null;
        }

        @Override
        protected Void visitNot(BooleanFormula pOperand) {
            return this.visitIfNotSeen(pOperand);
        }

        @Override
        protected Void visitAnd(BooleanFormula ... pOperands) {
            return this.visitMulti(pOperands);
        }

        @Override
        protected Void visitOr(BooleanFormula ... pOperands) {
            return this.visitMulti(pOperands);
        }

        @Override
        protected Void visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            this.visitIfNotSeen(pOperand1);
            this.visitIfNotSeen(pOperand2);
            return null;
        }

        @Override
        protected Void visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            this.visitIfNotSeen(pOperand1);
            this.visitIfNotSeen(pOperand2);
            return null;
        }

        @Override
        protected Void visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            this.visitIfNotSeen(pCondition);
            this.visitIfNotSeen(pThenFormula);
            this.visitIfNotSeen(pElseFormula);
            return null;
        }
    }

    public static abstract class DefaultBooleanFormulaVisitor<R>
    extends BooleanFormulaVisitor<R> {
        protected DefaultBooleanFormulaVisitor(FormulaManagerView pFmgr) {
            super(pFmgr);
        }

        @Override
        protected R visitTrue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitFalse() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitAtom(BooleanFormula pAtom) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitNot(BooleanFormula pOperand) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitAnd(BooleanFormula ... pOperands) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitOr(BooleanFormula ... pOperands) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected R visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class BooleanFormulaVisitor<R> {
        private final FormulaManagerView fmgr;
        private final BooleanFormulaManagerView bfmgr;
        private final UnsafeFormulaManager unsafe;

        protected BooleanFormulaVisitor(FormulaManagerView pFmgr) {
            this.fmgr = pFmgr;
            this.bfmgr = this.fmgr.getBooleanFormulaManager();
            this.unsafe = this.bfmgr.unsafe;
        }

        public final R visit(BooleanFormula f) {
            if (this.bfmgr.isTrue(f)) {
                assert (this.unsafe.getArity(f) == 0);
                return this.visitTrue();
            }
            if (this.bfmgr.isFalse(f)) {
                assert (this.unsafe.getArity(f) == 0);
                return this.visitFalse();
            }
            if (this.unsafe.isAtom(f)) {
                return this.visitAtom(f);
            }
            if (this.bfmgr.isNot(f)) {
                assert (this.unsafe.getArity(f) == 1);
                return this.visitNot(this.getArg(f, 0));
            }
            if (this.bfmgr.isAnd(f)) {
                assert (this.unsafe.getArity(f) >= 2);
                return this.visitAnd(this.getAllArgs(f));
            }
            if (this.bfmgr.isOr(f)) {
                assert (this.unsafe.getArity(f) >= 2);
                return this.visitOr(this.getAllArgs(f));
            }
            if (this.bfmgr.isEquivalence(f)) {
                assert (this.unsafe.getArity(f) == 2);
                return this.visitEquivalence(this.getArg(f, 0), this.getArg(f, 1));
            }
            if (this.bfmgr.isImplication(f)) {
                assert (this.unsafe.getArity(f) == 2);
                return this.visitImplication(this.getArg(f, 0), this.getArg(f, 1));
            }
            if (this.bfmgr.isIfThenElse(f)) {
                assert (this.unsafe.getArity(f) == 3);
                return this.visitIfThenElse(this.getArg(f, 0), this.getArg(f, 1), this.getArg(f, 2));
            }
            throw new UnsupportedOperationException("Unknown boolean operator " + f);
        }

        private final BooleanFormula getArg(BooleanFormula pF, int i) {
            Formula arg = this.unsafe.getArg(pF, i);
            assert (this.fmgr.getFormulaType(arg).isBooleanType());
            return (BooleanFormula)arg;
        }

        private final BooleanFormula[] getAllArgs(BooleanFormula pF) {
            int arity = this.unsafe.getArity(pF);
            BooleanFormula[] args = new BooleanFormula[arity];
            for (int i = 0; i < arity; ++i) {
                args[i] = this.getArg(pF, i);
            }
            return args;
        }

        protected abstract R visitTrue();

        protected abstract R visitFalse();

        protected abstract R visitAtom(BooleanFormula var1);

        protected abstract R visitNot(BooleanFormula var1);

        protected abstract R visitAnd(BooleanFormula ... var1);

        protected abstract R visitOr(BooleanFormula ... var1);

        protected abstract R visitEquivalence(BooleanFormula var1, BooleanFormula var2);

        protected abstract R visitImplication(BooleanFormula var1, BooleanFormula var2);

        protected abstract R visitIfThenElse(BooleanFormula var1, BooleanFormula var2, BooleanFormula var3);
    }
}

