/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ReplaceBitvectorWithNumeralAndFunctionTheory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ReplaceFloatingPointWithNumeralAndFunctionTheory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.WrappingArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.WrappingBitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.WrappingFloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.WrappingFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.rationals.Rational;

@Options(prefix="cpa.predicate")
public class FormulaManagerView {
    private final LogManager logger;
    private final FormulaManager manager;
    private final UnsafeFormulaManager unsafeManager;
    private final BooleanFormulaManagerView booleanFormulaManager;
    private final BitvectorFormulaManagerView bitvectorFormulaManager;
    private final FloatingPointFormulaManagerView floatingPointFormulaManager;
    private final NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> integerFormulaManager;
    private NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> rationalFormulaManager;
    private final FunctionFormulaManagerView functionFormulaManager;
    private final QuantifiedFormulaManagerView quantifiedFormulaManager;
    private final ArrayFormulaManagerView arrayFormulaManager;
    @Option(secure=true, name="formulaDumpFilePattern", description="where to dump interpolation and abstraction problems (format string)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate formulaDumpFile = PathTemplate.ofFormatString((String)"%s%04d-%s%03d.smt2");
    @Option(secure=true, description="try to add some useful static-learning-like axioms for bitwise operations (which are encoded as UFs): essentially, we simply collect all the numbers used in bitwise operations, and add axioms like (0 & n = 0)")
    private boolean useBitwiseAxioms = false;
    @Option(secure=true, description="Theory to use as backend for bitvectors. If different from BITVECTOR, the specified theory is used to approximate bitvectors. This can be used for solvers that do not support bitvectors, or for increased performance.")
    private Theory encodeBitvectorAs = Theory.INTEGER;
    @Option(secure=true, description="Theory to use as backend for floats. If different from FLOAT, the specified theory is used to approximate floats. This can be used for solvers that do not support floating-point arithmetic, or for increased performance.")
    private Theory encodeFloatAs = Theory.RATIONAL;
    @Option(secure=true, description="Allows to ignore Concat and Extract Calls when Bitvector theory was replaced with Integer or Rational.")
    private boolean ignoreExtractConcat = true;
    private static final String INDEX_SEPARATOR = "@";
    private final Map<Formula, Boolean> arithCache = new HashMap<Formula, Boolean>();
    private final Map<Formula, Formula> uninstantiateCache = new HashMap<Formula, Formula>();
    private final Predicate<Formula> FILTER_VARIABLES = new Predicate<Formula>(){

        public boolean apply(Formula input) {
            return FormulaManagerView.this.unsafeManager.isVariable(input);
        }
    };
    private final Predicate<Formula> FILTER_UF = new Predicate<Formula>(){

        public boolean apply(Formula input) {
            return FormulaManagerView.this.unsafeManager.isUF(input);
        }
    };
    public static final String BitwiseAndUfName = "_&_";
    public static final String BitwiseOrUfName = "_!!_";
    public static final String BitwiseXorUfName = "_^_";
    public static final String BitwiseNotUfName = "_~_";

    public FormulaManagerView(FormulaManagerFactory solverFactory, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        ReplaceFloatingPointWithNumeralAndFunctionTheory<NumeralFormula> rawFloatingPointFormulaManager;
        ReplaceBitvectorWithNumeralAndFunctionTheory<NumeralFormula> rawBitvectorFormulaManager;
        config.inject((Object)this, FormulaManagerView.class);
        this.logger = pLogger;
        this.manager = (FormulaManager)Preconditions.checkNotNull((Object)solverFactory.getFormulaManager());
        this.unsafeManager = this.manager.getUnsafeFormulaManager();
        switch (this.encodeBitvectorAs) {
            case BITVECTOR: {
                try {
                    rawBitvectorFormulaManager = this.manager.getBitvectorFormulaManager();
                    break;
                }
                catch (UnsupportedOperationException e) {
                    throw new InvalidConfigurationException("The chosen SMT solver does not support the theory of bitvectors, please choose another SMT solver or use the option cpa.predicate.encodeBitvectorAs to approximate bitvectors with another theory.", (Throwable)e);
                }
            }
            case INTEGER: {
                rawBitvectorFormulaManager = new ReplaceBitvectorWithNumeralAndFunctionTheory<NumeralFormula.IntegerFormula>(this, this.manager.getIntegerFormulaManager(), this.manager.getFunctionFormulaManager(), this.ignoreExtractConcat);
                break;
            }
            case RATIONAL: {
                rawBitvectorFormulaManager = new ReplaceBitvectorWithNumeralAndFunctionTheory<NumeralFormula.RationalFormula>(this, this.manager.getRationalFormulaManager(), this.manager.getFunctionFormulaManager(), this.ignoreExtractConcat);
                break;
            }
            case FLOAT: {
                throw new InvalidConfigurationException("Value FLOAT is not valid for option cpa.predicate.encodeBitvectorAs");
            }
            default: {
                throw new AssertionError();
            }
        }
        this.bitvectorFormulaManager = new BitvectorFormulaManagerView(this, rawBitvectorFormulaManager);
        this.integerFormulaManager = new NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>(this, this.manager.getIntegerFormulaManager());
        this.booleanFormulaManager = new BooleanFormulaManagerView(this, this.manager.getBooleanFormulaManager(), this.manager.getUnsafeFormulaManager());
        this.functionFormulaManager = new FunctionFormulaManagerView(this, this.manager.getFunctionFormulaManager());
        this.quantifiedFormulaManager = new QuantifiedFormulaManagerView(this, this.manager.getQuantifiedFormulaManager());
        this.arrayFormulaManager = new ArrayFormulaManagerView(this, this.manager.getArrayFormulaManager());
        switch (this.encodeFloatAs) {
            case FLOAT: {
                try {
                    rawFloatingPointFormulaManager = this.manager.getFloatingPointFormulaManager();
                    break;
                }
                catch (UnsupportedOperationException e) {
                    throw new InvalidConfigurationException("The chosen SMT solver does not support the theory of floats, please choose another SMT solver or use the option cpa.predicate.encodeFloatAs to approximate floats with another theory.", (Throwable)e);
                }
            }
            case INTEGER: {
                rawFloatingPointFormulaManager = new ReplaceFloatingPointWithNumeralAndFunctionTheory<NumeralFormula.IntegerFormula>(this, this.getIntegerFormulaManager());
                break;
            }
            case RATIONAL: {
                rawFloatingPointFormulaManager = new ReplaceFloatingPointWithNumeralAndFunctionTheory<NumeralFormula.RationalFormula>(this, this.getRationalFormulaManager());
                break;
            }
            case BITVECTOR: {
                throw new InvalidConfigurationException("Value BITVECTOR is not valid for option cpa.predicate.encodeFloatAs");
            }
            default: {
                throw new AssertionError();
            }
        }
        this.floatingPointFormulaManager = new FloatingPointFormulaManagerView(this, rawFloatingPointFormulaManager);
    }

    <T1 extends Formula, T2 extends Formula> T1 wrap(FormulaType<T1> targetType, T2 toWrap) {
        assert (!(toWrap instanceof WrappingFormula));
        if (targetType.isBitvectorType() && this.encodeBitvectorAs != Theory.BITVECTOR) {
            return (T1)new WrappingBitvectorFormula<T2>((FormulaType.BitvectorType)targetType, toWrap);
        }
        if (targetType.isFloatingPointType() && this.encodeFloatAs != Theory.FLOAT) {
            return (T1)new WrappingFloatingPointFormula<T2>((FormulaType.FloatingPointType)targetType, toWrap);
        }
        if (targetType.isArrayType()) {
            FormulaType.ArrayFormulaType targetArrayType = (FormulaType.ArrayFormulaType)targetType;
            return (T1)new WrappingArrayFormula(targetArrayType, toWrap);
        }
        if (targetType.equals(this.manager.getFormulaType(toWrap))) {
            return (T1)toWrap;
        }
        throw new IllegalArgumentException("invalid wrap call");
    }

    <T extends Formula> Formula unwrap(T f) {
        if (f instanceof WrappingFormula) {
            return ((WrappingFormula)((Object)f)).getWrapped();
        }
        return f;
    }

    FormulaType<?> unwrapType(FormulaType<?> type) {
        if (type.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)type;
            return FormulaType.getArrayType(this.unwrapType(arrayType.getIndexType()), this.unwrapType(arrayType.getElementType()));
        }
        if (type.isBitvectorType()) {
            switch (this.encodeBitvectorAs) {
                case BITVECTOR: {
                    return type;
                }
                case INTEGER: {
                    return FormulaType.IntegerType;
                }
                case RATIONAL: {
                    return FormulaType.RationalType;
                }
            }
        }
        if (type.isFloatingPointType()) {
            switch (this.encodeFloatAs) {
                case FLOAT: {
                    return type;
                }
                case INTEGER: {
                    return FormulaType.IntegerType;
                }
                case RATIONAL: {
                    return FormulaType.RationalType;
                }
            }
        }
        return type;
    }

    public Path formatFormulaOutputFile(String function, int call, String formula, int index) {
        if (this.formulaDumpFile == null) {
            return null;
        }
        return this.formulaDumpFile.getPath(new Object[]{function, call, formula, index});
    }

    public void dumpFormulaToFile(BooleanFormula f, Path outputFile) {
        if (outputFile != null) {
            try {
                Files.writeFile((Path)outputFile, (Object)this.dumpFormula(f));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to save formula to file");
            }
        }
    }

    public <T extends Formula> T makeVariable(T f, String name) {
        return this.makeVariable(this.getFormulaType(f), name);
    }

    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name) {
        Formula t;
        if (formulaType.isBooleanType()) {
            t = this.booleanFormulaManager.makeVariable(name);
        } else if (formulaType.isIntegerType()) {
            t = this.integerFormulaManager.makeVariable(name);
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeVariable(name);
        } else if (formulaType.isBitvectorType()) {
            FormulaType.BitvectorType impl = (FormulaType.BitvectorType)formulaType;
            t = this.bitvectorFormulaManager.makeVariable(impl.getSize(), name);
        } else if (formulaType.isFloatingPointType()) {
            t = this.floatingPointFormulaManager.makeVariable(name, (FormulaType.FloatingPointType)formulaType);
        } else if (formulaType.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)formulaType;
            t = this.arrayFormulaManager.makeArray(name, arrayType.getIndexType(), arrayType.getElementType());
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeNumber(FormulaType<T> formulaType, long value) {
        Formula t;
        if (formulaType.isIntegerType()) {
            t = this.integerFormulaManager.makeNumber(value);
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeNumber(value);
        } else if (formulaType.isBitvectorType()) {
            t = this.bitvectorFormulaManager.makeBitvector(formulaType, value);
        } else if (formulaType.isFloatingPointType()) {
            t = this.floatingPointFormulaManager.makeNumber(value, (FormulaType.FloatingPointType)formulaType);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeNumber(T formula, Rational value) {
        Formula t;
        FormulaType<BitvectorFormula> formulaType = this.getFormulaType(formula);
        if (formulaType.isIntegerType() && value.isIntegral()) {
            t = this.integerFormulaManager.makeNumber(value.toString());
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeNumber(value.toString());
        } else if (value.isIntegral() && formulaType.isBitvectorType()) {
            t = this.bitvectorFormulaManager.makeBitvector(formulaType, new BigInteger(value.toString()));
        } else if (formulaType.isFloatingPointType()) {
            t = this.floatingPointFormulaManager.makeNumber(value.toString(), (FormulaType.FloatingPointType)formulaType);
        } else {
            throw new IllegalArgumentException("Not supported interface: " + formula);
        }
        return (T)t;
    }

    public <T extends Formula> T makeNumber(FormulaType<T> formulaType, BigInteger value) {
        Formula t;
        if (formulaType.isIntegerType()) {
            t = this.integerFormulaManager.makeNumber(value);
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeNumber(value);
        } else if (formulaType.isBitvectorType()) {
            t = this.bitvectorFormulaManager.makeBitvector(formulaType, value);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeNegate(T pNum) {
        Formula t;
        if (pNum instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.negate((NumeralFormula.IntegerFormula)pNum);
        } else if (pNum instanceof NumeralFormula.RationalFormula) {
            t = this.getRationalFormulaManager().negate((NumeralFormula.RationalFormula)pNum);
        } else if (pNum instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.negate((BitvectorFormula)pNum);
        } else if (pNum instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.negate((FloatingPointFormula)pNum);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makePlus(T pF1, T pF2) {
        Formula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.add((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.rationalFormulaManager.add((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.add((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.add((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeMinus(T pF1, T pF2) {
        Formula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.subtract((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().subtract((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.subtract((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.subtract((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeMultiply(T pF1, T pF2) {
        Formula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.multiply((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().multiply((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.multiply((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.multiply((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeDivide(T pF1, T pF2, boolean pSigned) {
        Formula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.divide((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().divide((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.divide((BitvectorFormula)pF1, (BitvectorFormula)pF2, pSigned);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.divide((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeModulo(T pF1, T pF2, boolean pSigned) {
        Formula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.modulo((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().modulo((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.modulo((BitvectorFormula)pF1, (BitvectorFormula)pF2, pSigned);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> BooleanFormula makeModularCongruence(T pF1, T pF2, long pModulo) {
        BooleanFormula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.modularCongruence((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2, pModulo);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().modularCongruence((NumeralFormula)pF1, (NumeralFormula)pF2, pModulo);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.modularCongruence((BitvectorFormula)pF1, (BitvectorFormula)pF2, pModulo);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> T makeNot(T pF1) {
        Formula t;
        if (pF1 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.not((BooleanFormula)pF1);
        } else if (pF1 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.not((BitvectorFormula)pF1);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeAnd(T pF1, T pF2) {
        Formula t;
        if (pF1 instanceof BooleanFormula && pF2 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.and((BooleanFormula)pF1, (BooleanFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.and((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeOr(T pF1, T pF2) {
        Formula t;
        if (pF1 instanceof BooleanFormula && pF2 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.or((BooleanFormula)pF1, (BooleanFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.or((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeXor(T pF1, T pF2) {
        Formula t;
        if (pF1 instanceof BooleanFormula && pF2 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.xor((BooleanFormula)pF1, (BooleanFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.xor((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeShiftLeft(T pF1, T pF2) {
        if (!(pF1 instanceof BitvectorFormula) || !(pF2 instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.bitvectorFormulaManager.shiftLeft((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        return (T)t;
    }

    public <T extends Formula> T makeShiftRight(T pF1, T pF2, boolean signed) {
        if (!(pF1 instanceof BitvectorFormula) || !(pF2 instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.bitvectorFormulaManager.shiftRight((BitvectorFormula)pF1, (BitvectorFormula)pF2, signed);
        return (T)t;
    }

    public <T extends Formula> T makeExtract(T pFormula, int pMsb, int pLsb) {
        Preconditions.checkArgument((pLsb >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pMsb >= pLsb ? 1 : 0) != 0);
        if (!(pFormula instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.bitvectorFormulaManager.extract((BitvectorFormula)pFormula, pMsb, pLsb);
        return (T)t;
    }

    public <T extends Formula> T makeConcat(T pFormula, T pAppendFormula) {
        if (!(pFormula instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.bitvectorFormulaManager.concat((BitvectorFormula)pFormula, (BitvectorFormula)pAppendFormula);
        return (T)t;
    }

    public <T extends Formula> T makeConcat(List<T> formulas) {
        Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
        Formula conc = null;
        for (Formula t : formulas) {
            if (conc == null) {
                conc = t;
                continue;
            }
            conc = this.makeConcat(conc, t);
        }
        return (T)conc;
    }

    public <T extends Formula> T makeExtend(T pFormula, int pExtensionBits, boolean pSigned) {
        Preconditions.checkArgument((pExtensionBits >= 0 ? 1 : 0) != 0);
        if (!(pFormula instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.bitvectorFormulaManager.extend((BitvectorFormula)pFormula, pExtensionBits, pSigned);
        return (T)t;
    }

    public <T extends Formula> BooleanFormula makeEqual(T pLhs, T pRhs) {
        BooleanFormula t;
        if (pLhs instanceof BooleanFormula && pRhs instanceof BooleanFormula) {
            t = this.booleanFormulaManager.equivalence((BooleanFormula)pLhs, (BooleanFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.equal((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().equal((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.equal((BitvectorFormula)pLhs, (BitvectorFormula)pRhs);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.equalWithFPSemantics((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeLessOrEqual(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.lessOrEquals((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().lessOrEquals((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.lessOrEquals((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.lessOrEquals((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface: " + pLhs + " " + pRhs);
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeLessThan(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.lessThan((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().lessThan((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.lessThan((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.lessThan((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeGreaterThan(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.greaterThan((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().greaterThan((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.greaterThan((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.greaterThan((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeGreaterOrEqual(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.integerFormulaManager.greaterOrEquals((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().greaterOrEquals((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.bitvectorFormulaManager.greaterOrEquals((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.floatingPointFormulaManager.greaterOrEquals((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name, int idx) {
        return this.makeVariable(formulaType, FormulaManagerView.makeName(name, idx));
    }

    public NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> getIntegerFormulaManager() {
        return this.integerFormulaManager;
    }

    public NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> getRationalFormulaManager() {
        if (this.rationalFormulaManager == null) {
            this.rationalFormulaManager = new NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula>(this, this.manager.getRationalFormulaManager());
        }
        return this.rationalFormulaManager;
    }

    public BooleanFormulaManagerView getBooleanFormulaManager() {
        return this.booleanFormulaManager;
    }

    public BitvectorFormulaManagerView getBitvectorFormulaManager() {
        return this.bitvectorFormulaManager;
    }

    public FloatingPointFormulaManagerView getFloatingPointFormulaManager() {
        return this.floatingPointFormulaManager;
    }

    public FunctionFormulaManagerView getFunctionFormulaManager() {
        return this.functionFormulaManager;
    }

    public QuantifiedFormulaManagerView getQuantifiedFormulaManager() {
        return this.quantifiedFormulaManager;
    }

    public ArrayFormulaManagerView getArrayFormulaManager() {
        return this.arrayFormulaManager;
    }

    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Preconditions.checkNotNull(pFormula);
        if (pFormula instanceof WrappingFormula) {
            WrappingFormula castFormula = (WrappingFormula)((Object)pFormula);
            return castFormula.getType();
        }
        return this.getRawFormulaType(pFormula);
    }

    private <T extends Formula> FormulaType<T> getRawFormulaType(T pFormula) {
        return this.manager.getFormulaType(pFormula);
    }

    public <T extends Formula> BooleanFormula assignment(T left, T right) {
        FormulaType<T> rformulaType;
        FormulaType<T> lformulaType = this.getFormulaType(left);
        if (!lformulaType.equals(rformulaType = this.getFormulaType(right))) {
            throw new IllegalArgumentException("Can't assign different types! (" + lformulaType + " and " + rformulaType + ")");
        }
        if (lformulaType.isFloatingPointType()) {
            return this.getFloatingPointFormulaManager().assignment((FloatingPointFormula)left, (FloatingPointFormula)right);
        }
        return this.makeEqual(left, right);
    }

    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.manager.parse(pS);
    }

    public <F extends Formula> F instantiate(F pF, SSAMap pSsa) {
        return this.myInstantiate(pSsa, pF);
    }

    public <F extends Formula> List<F> instantiate(List<F> pFormulas, final SSAMap pSsa) {
        return Lists.transform(pFormulas, (Function)new Function<F, F>(){

            public F apply(F pF) {
                return FormulaManagerView.this.instantiate(pF, pSsa);
            }
        });
    }

    public Set<String> instantiate(Set<String> pVariableNames, final SSAMap pSsa) {
        return Sets.newHashSet((Iterable)Collections2.transform(pVariableNames, (Function)new Function<String, String>(){

            public String apply(String pArg0) {
                Pair<String, Integer> parsedVar = FormulaManagerView.parseName(pArg0);
                return FormulaManagerView.makeName((String)parsedVar.getFirst(), pSsa.getIndex((String)parsedVar.getFirst()));
            }
        }));
    }

    public <F extends Formula> List<F> uninstantiate(List<F> pFormulas) {
        return Lists.transform(pFormulas, (Function)new Function<F, F>(){

            public F apply(F pF) {
                return FormulaManagerView.this.uninstantiate(pF);
            }
        });
    }

    static String makeName(String name, int idx) {
        if (idx < 0) {
            return name;
        }
        return name + INDEX_SEPARATOR + idx;
    }

    private <T extends Formula> T myInstantiate(final SSAMap pSsa, T pF) {
        return this.myFreeVariableNodeTransformer(pF, new HashMap<Formula, Formula>(), new Function<String, String>(){

            public String apply(String pFullSymbolName) {
                Pair<String, Integer> indexedSymbol = FormulaManagerView.parseName(pFullSymbolName);
                int reInstantiateWithIndex = pSsa.getIndex((String)indexedSymbol.getFirst());
                if (reInstantiateWithIndex > 0) {
                    return FormulaManagerView.makeName((String)indexedSymbol.getFirst(), reInstantiateWithIndex);
                }
                return pFullSymbolName;
            }
        });
    }

    private boolean ufCanBeLvalue(String name) {
        return name.startsWith("*");
    }

    public <F extends Formula> F uninstantiate(F pF) {
        return this.myUninstantiate(pF);
    }

    public static Pair<String, Integer> parseName(String name) {
        String[] s = name.split(INDEX_SEPARATOR);
        if (s.length == 2) {
            return Pair.of((Object)s[0], (Object)Integer.parseInt(s[1]));
        }
        if (s.length == 1) {
            return Pair.of((Object)s[0], null);
        }
        throw new IllegalArgumentException("Not an instantiated variable nor constant: " + name);
    }

    private <T extends Formula> T myUninstantiate(T f) {
        return this.myFreeVariableNodeTransformer(f, this.uninstantiateCache, new Function<String, String>(){

            public String apply(String pArg0) {
                return (String)FormulaManagerView.parseName(pArg0).getFirst();
            }
        });
    }

    private <T extends Formula> T myFreeVariableNodeTransformer(T pFormula, Map<Formula, Formula> pCache, Function<String, String> pRenameFunction) {
        Preconditions.checkNotNull(pCache);
        Preconditions.checkNotNull(pFormula);
        Preconditions.checkNotNull(pRenameFunction);
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.push(pFormula);
        while (!toProcess.isEmpty()) {
            Formula newt;
            Formula tt = (Formula)toProcess.peek();
            if (pCache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            if (this.unsafeManager.isFreeVariable(tt)) {
                String oldName = this.unsafeManager.getName(tt);
                String newName = (String)pRenameFunction.apply((Object)oldName);
                Formula renamed = this.unsafeManager.replaceName(tt, newName);
                pCache.put(tt, renamed);
                continue;
            }
            if (this.unsafeManager.isBoundVariable(tt)) {
                pCache.put(tt, tt);
                continue;
            }
            if (this.unsafeManager.isQuantification(tt)) {
                BooleanFormula ttBody = this.unsafeManager.getQuantifiedBody(tt);
                BooleanFormula transformedBody = (BooleanFormula)pCache.get(ttBody);
                if (transformedBody != null) {
                    BooleanFormula newTt = this.unsafeManager.replaceQuantifiedBody((BooleanFormula)tt, transformedBody);
                    pCache.put(tt, newTt);
                    continue;
                }
                toProcess.push(ttBody);
                continue;
            }
            boolean allArgumentsTransformed = true;
            int arity = this.unsafeManager.getArity(tt);
            ArrayList newargs = Lists.newArrayListWithExpectedSize((int)arity);
            for (int i = 0; i < arity; ++i) {
                Formula c = this.unsafeManager.getArg(tt, i);
                Formula newC = pCache.get(c);
                if (newC != null) {
                    newargs.add(newC);
                    continue;
                }
                toProcess.push(c);
                allArgumentsTransformed = false;
            }
            if (!allArgumentsTransformed) continue;
            toProcess.pop();
            if (this.unsafeManager.isUF(tt)) {
                String oldName = this.unsafeManager.getName(tt);
                assert (oldName != null);
                if (this.ufCanBeLvalue(oldName)) {
                    String newName = (String)pRenameFunction.apply((Object)oldName);
                    newt = this.unsafeManager.replaceArgsAndName(tt, newName, newargs);
                } else {
                    newt = this.unsafeManager.replaceArgs(tt, newargs);
                }
            } else {
                newt = this.unsafeManager.replaceArgs(tt, newargs);
            }
            pCache.put(tt, newt);
        }
        Formula result = pCache.get(pFormula);
        assert (result != null);
        assert (this.getRawFormulaType(pFormula).equals(this.getRawFormulaType(result)));
        return (T)result;
    }

    public Collection<BooleanFormula> extractAtoms(BooleanFormula f, boolean splitArithEqualities, boolean conjunctionsOnly) {
        return this.unwrapFormulasOfList(this.myExtractAtoms(f, splitArithEqualities, conjunctionsOnly, FormulaStructure.ATOM, true));
    }

    public Collection<BooleanFormula> extractAtoms(BooleanFormula f, boolean splitArithEqualities, boolean conjunctionsOnly, boolean uninstanciate) {
        return this.unwrapFormulasOfList(this.myExtractAtoms(f, splitArithEqualities, conjunctionsOnly, FormulaStructure.ATOM, uninstanciate));
    }

    public Collection<BooleanFormula> extractLiterals(BooleanFormula f, boolean splitArithEqualities, boolean conjunctionsOnly, boolean uninstanciate) {
        return this.unwrapFormulasOfList(this.myExtractAtoms(f, splitArithEqualities, conjunctionsOnly, FormulaStructure.LITERAL, uninstanciate));
    }

    private List<BooleanFormula> unwrapFormulasOfList(Collection<BooleanFormula> unwrapped) {
        ArrayList<BooleanFormula> atoms = new ArrayList<BooleanFormula>(unwrapped.size());
        for (BooleanFormula booleanFormula : unwrapped) {
            atoms.add(booleanFormula);
        }
        return atoms;
    }

    private FormulaStructure getFormulaStructure(Formula f) {
        if (this.unsafeManager.isAtom(f)) {
            return FormulaStructure.ATOM;
        }
        if (this.unsafeManager.isLiteral(f)) {
            return FormulaStructure.LITERAL;
        }
        return FormulaStructure.FORMULA;
    }

    private Collection<BooleanFormula> myExtractAtoms(BooleanFormula f, boolean splitArithEqualities, boolean conjunctionsOnly, FormulaStructure breakdownTo, boolean uninstanciate) {
        HashSet<BooleanFormula> handled = new HashSet<BooleanFormula>();
        ArrayList<BooleanFormula> atoms = new ArrayList<BooleanFormula>();
        if (breakdownTo != FormulaStructure.ATOM && breakdownTo != FormulaStructure.LITERAL) {
            throw new UnsupportedOperationException("Formulas cannot be splitted onto the requested level!");
        }
        ArrayDeque<BooleanFormula> toProcess = new ArrayDeque<BooleanFormula>();
        toProcess.push(f);
        handled.add(f);
        while (!toProcess.isEmpty()) {
            boolean isSmallesConsidered;
            BooleanFormula tt = (BooleanFormula)toProcess.pop();
            assert (handled.contains(tt));
            if (this.booleanFormulaManager.isTrue(tt) || this.booleanFormulaManager.isFalse(tt)) continue;
            FormulaStructure ttStructure = this.getFormulaStructure(tt);
            boolean bl = isSmallesConsidered = ttStructure == breakdownTo || breakdownTo == FormulaStructure.LITERAL && ttStructure == FormulaStructure.ATOM;
            if (isSmallesConsidered) {
                if (uninstanciate) {
                    tt = this.myUninstantiate(tt);
                }
                if (splitArithEqualities && this.myIsPurelyArithmetic(tt)) {
                    NumeralFormula a1;
                    NumeralFormula a0;
                    BooleanFormula tt1 = null;
                    if (this.rationalFormulaManager == null && this.getIntegerFormulaManager().isEqual(tt)) {
                        a0 = this.unsafeManager.typeFormula(FormulaType.IntegerType, this.unsafeManager.getArg(tt, 0));
                        a1 = this.unsafeManager.typeFormula(FormulaType.IntegerType, this.unsafeManager.getArg(tt, 1));
                        tt1 = this.getIntegerFormulaManager().lessOrEquals((NumeralFormula.IntegerFormula)a0, (NumeralFormula.IntegerFormula)a1);
                    } else if (this.rationalFormulaManager != null && this.rationalFormulaManager.isEqual(tt)) {
                        a0 = this.unsafeManager.typeFormula(FormulaType.RationalType, this.unsafeManager.getArg(tt, 0));
                        a1 = this.unsafeManager.typeFormula(FormulaType.RationalType, this.unsafeManager.getArg(tt, 1));
                        tt1 = this.rationalFormulaManager.lessOrEquals(a0, a1);
                    } else if (this.bitvectorFormulaManager.isEqual(tt)) {
                        FormulaType.BitvectorType type = FormulaType.getBitvectorTypeWithSize(32);
                        BitvectorFormula a02 = this.unsafeManager.typeFormula(type, this.unsafeManager.getArg(tt, 0));
                        BitvectorFormula a12 = this.unsafeManager.typeFormula(type, this.unsafeManager.getArg(tt, 1));
                        tt1 = this.bitvectorFormulaManager.lessOrEquals(a02, a12, true);
                    }
                    if (tt1 == null) continue;
                    handled.add(tt1);
                    atoms.add(tt1);
                    atoms.add(tt);
                    continue;
                }
                atoms.add(tt);
                continue;
            }
            if (conjunctionsOnly && !this.booleanFormulaManager.isNot(tt) && !this.booleanFormulaManager.isAnd(tt)) {
                if (uninstanciate) {
                    tt = this.myUninstantiate(tt);
                }
                atoms.add(tt);
                continue;
            }
            for (int i = 0; i < this.unsafeManager.getArity(tt); ++i) {
                Formula c = this.unsafeManager.getArg(tt, i);
                assert (this.getRawFormulaType(c).isBooleanType());
                if (!handled.add((BooleanFormula)c)) continue;
                toProcess.push((BooleanFormula)c);
            }
        }
        return atoms;
    }

    public boolean isPurelyArithmetic(Formula f) {
        return this.myIsPurelyArithmetic(this.unwrap(f));
    }

    private boolean myIsPurelyArithmetic(Formula f) {
        Boolean result = this.arithCache.get(f);
        if (result != null) {
            return result;
        }
        boolean res = true;
        if (this.unsafeManager.isUF(f)) {
            res = false;
        } else {
            int arity = this.unsafeManager.getArity(f);
            for (int i = 0; i < arity && (res = this.myIsPurelyArithmetic(this.unsafeManager.getArg(f, i))); ++i) {
            }
        }
        this.arithCache.put(f, res);
        return res;
    }

    public Set<String> extractVariableNames(Formula f) {
        HashSet result = Sets.newHashSet();
        for (Formula v : this.myExtractSubformulas(this.unwrap(f), this.FILTER_VARIABLES)) {
            result.add(this.unsafeManager.getName(v));
        }
        return result;
    }

    public Set<String> extractFunctionNames(Formula f) {
        HashSet result = Sets.newHashSet();
        for (Formula v : this.myExtractSubformulas(this.unwrap(f), (Predicate<Formula>)Predicates.or(this.FILTER_UF, this.FILTER_VARIABLES))) {
            result.add(this.unsafeManager.getName(v));
        }
        return result;
    }

    public Map<String, Formula> extractFreeVariableMap(Formula pF) {
        HashMap result = Maps.newHashMap();
        for (Formula v : this.myExtractSubformulas(this.unwrap(pF), this.FILTER_VARIABLES)) {
            result.put(this.unsafeManager.getName(v), v);
        }
        return result;
    }

    public Set<Triple<Formula, String, Integer>> extractFunctionSymbols(Formula f) {
        return this.extractSubformulas(f, (Predicate<Formula>)Predicates.or(this.FILTER_UF, this.FILTER_VARIABLES));
    }

    public Set<Triple<Formula, String, Integer>> extractFreeVariables(Formula f) {
        return this.extractSubformulas(f, this.FILTER_VARIABLES);
    }

    private Set<Triple<Formula, String, Integer>> extractSubformulas(Formula f, Predicate<Formula> predicate) {
        HashSet result = Sets.newHashSet();
        for (Formula varFormula : this.myExtractSubformulas(this.unwrap(f), predicate)) {
            Pair<String, Integer> var = FormulaManagerView.parseName(this.unsafeManager.getName(varFormula));
            result.add(Triple.of((Object)varFormula, (Object)var.getFirst(), (Object)var.getSecond()));
        }
        return result;
    }

    private Set<Formula> myExtractSubformulas(Formula pExtractFrom, Predicate<Formula> filter) {
        HashSet<Formula> seen = new HashSet<Formula>();
        HashSet<Formula> varFormulas = new HashSet<Formula>();
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        toProcess.push(pExtractFrom);
        while (!toProcess.isEmpty()) {
            Formula t = (Formula)toProcess.pop();
            if (filter.apply((Object)t)) {
                varFormulas.add(t);
                continue;
            }
            if (this.unsafeManager.isBoundVariable(t)) continue;
            if (this.unsafeManager.isQuantification(t)) {
                BooleanFormula body = this.unsafeManager.getQuantifiedBody(t);
                if (!seen.add(body)) continue;
                toProcess.push(body);
                continue;
            }
            for (int i = 0; i < this.unsafeManager.getArity(t); ++i) {
                Formula c = this.unsafeManager.getArg(t, i);
                if (!seen.add(c)) continue;
                toProcess.push(c);
            }
        }
        return varFormulas;
    }

    public Appender dumpFormula(Formula pT) {
        return this.manager.dumpFormula(this.unwrap(pT));
    }

    public boolean isPurelyConjunctive(BooleanFormula t) {
        return this.myIsPurelyConjunctive(t);
    }

    private boolean myIsPurelyConjunctive(BooleanFormula t) {
        if (this.unsafeManager.isAtom(t) || this.unsafeManager.isUF(t)) {
            return true;
        }
        if (this.booleanFormulaManager.isNot(t)) {
            return this.unsafeManager.isUF(t = (BooleanFormula)this.unsafeManager.getArg(t, 0)) || this.unsafeManager.isAtom(t);
        }
        if (this.booleanFormulaManager.isAnd(t)) {
            for (int i = 0; i < this.unsafeManager.getArity(t); ++i) {
                if (this.myIsPurelyConjunctive((BooleanFormula)this.unsafeManager.getArg(t, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private BooleanFormula myGetBitwiseAxioms(Formula f) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashSet<Formula> seen = new HashSet<Formula>();
        HashSet<Formula> allLiterals = new HashSet<Formula>();
        boolean andFound = false;
        toProcess.add(f);
        while (!toProcess.isEmpty()) {
            Formula tt = (Formula)toProcess.pollLast();
            if (this.unsafeManager.isNumber(tt)) {
                allLiterals.add(tt);
            }
            if (this.unsafeManager.isUF(tt) && this.unsafeManager.getName(tt).equals(BitwiseAndUfName) && !andFound) {
                andFound = true;
            }
            int arity = this.unsafeManager.getArity(tt);
            for (int i = 0; i < arity; ++i) {
                Formula c = this.unsafeManager.getArg(tt, i);
                if (!seen.add(c)) continue;
                toProcess.add(c);
            }
        }
        BooleanFormula result = this.booleanFormulaManager.makeBoolean(true);
        if (andFound) {
            BitvectorFormula z = this.bitvectorFormulaManager.makeBitvector(1, 0L);
            FormulaType.BitvectorType type = FormulaType.getBitvectorTypeWithSize(1);
            for (Formula nn : allLiterals) {
                BitvectorFormula n = this.bitvectorFormulaManager.wrap(type, nn);
                BitvectorFormula u1 = this.bitvectorFormulaManager.and(z, n);
                BitvectorFormula u2 = this.bitvectorFormulaManager.and(n, z);
                BooleanFormula e1 = this.bitvectorFormulaManager.equal(u1, z);
                BooleanFormula e2 = this.bitvectorFormulaManager.equal(u2, z);
                BooleanFormula a = this.booleanFormulaManager.and(e1, e2);
                result = this.booleanFormulaManager.and(result, a);
            }
        }
        return result;
    }

    public BooleanFormula getBitwiseAxioms(BooleanFormula f) {
        return this.myGetBitwiseAxioms(f);
    }

    public String getVersion() {
        return this.manager.getVersion();
    }

    public boolean useBitwiseAxioms() {
        return this.useBitwiseAxioms;
    }

    public BooleanFormula createPredicateVariable(String pName) {
        return this.booleanFormulaManager.makeVariable(pName);
    }

    public BooleanFormula simplify(BooleanFormula input) {
        return this.unsafeManager.simplify(input);
    }

    public Formula addPrefixToAll(Formula input, String prefix) {
        Formula formula = this.unwrap(input);
        Set<Triple<Formula, String, Integer>> allVars = this.extractFunctionSymbols(formula);
        FormulaType<Formula> t = this.getFormulaType(formula);
        ArrayList<Formula> from = new ArrayList<Formula>(allVars.size());
        ArrayList<Formula> to = new ArrayList<Formula>(allVars.size());
        for (Triple<Formula, String, Integer> e : allVars) {
            Formula token = (Formula)e.getFirst();
            String oldName = this.unsafeManager.getName(token);
            from.add(token);
            to.add(this.makeVariable(t, prefix + oldName));
        }
        return this.unsafeManager.substitute(formula, from, to);
    }

    public Set<String> getDeadVariableNames(BooleanFormula pFormula, SSAMap pSsa) {
        HashSet result = Sets.newHashSet();
        List<Formula> varFormulas = this.getDeadVariables(pFormula, pSsa);
        for (Formula f : varFormulas) {
            result.add(this.unsafeManager.getName(f));
        }
        return result;
    }

    public List<Formula> getDeadVariables(BooleanFormula pFormula, SSAMap pSsa) {
        Set<Triple<Formula, String, Integer>> formulaVariables = this.extractFreeVariables(pFormula);
        ArrayList result = Lists.newArrayList();
        for (Triple<Formula, String, Integer> var : formulaVariables) {
            Formula varFormula = (Formula)var.getFirst();
            String varName = (String)var.getSecond();
            Integer varSsaIndex = (Integer)var.getThird();
            if (varSsaIndex == null) {
                if (!pSsa.containsVariable(varName)) continue;
                result.add(varFormula);
                continue;
            }
            if (varSsaIndex.intValue() == pSsa.getIndex(varName)) continue;
            result.add(varFormula);
        }
        return result;
    }

    public BooleanFormula eliminateDeadVariables(BooleanFormula pF, SSAMap pSsa) throws SolverException, InterruptedException {
        Preconditions.checkNotNull((Object)pF);
        Preconditions.checkNotNull((Object)pSsa);
        List<Formula> irrelevantVariables = this.getDeadVariables(pF, pSsa);
        BooleanFormula eliminationResult = pF;
        if (!irrelevantVariables.isEmpty()) {
            QuantifiedFormulaManagerView qfmgr = this.getQuantifiedFormulaManager();
            BooleanFormula quantifiedFormula = qfmgr.exists(irrelevantVariables, pF);
            eliminationResult = qfmgr.eliminateQuantifiers(quantifiedFormula);
        }
        eliminationResult = this.simplify(eliminationResult);
        return eliminationResult;
    }

    public static enum Theory {
        INTEGER,
        RATIONAL,
        BITVECTOR,
        FLOAT;

    }

    public static enum FormulaStructure {
        ATOM,
        LITERAL,
        DISJUNCTIVE_CLAUSE,
        CONJUNCTIVE_CLAUSE,
        FORMULA;

    }
}

