/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FormulaManagerViewTest0
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public FormulaManagerFactory.Solvers solver;
    private FormulaManagerView mv;
    private ArrayFormulaManagerView amv;
    private BooleanFormulaManagerView bmv;
    private QuantifiedFormulaManagerView qmv;
    private NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> imv;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _1;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _i1;
    private NumeralFormula.IntegerFormula _j;
    private NumeralFormula.IntegerFormula _j1;
    private NumeralFormula.IntegerFormula _x;
    private NumeralFormula.IntegerFormula _x1;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return FormulaManagerFactory.Solvers.values();
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setUp() throws Exception {
        this.mv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.imv = this.mv.getIntegerFormulaManager();
        this.amv = this.mv.getArrayFormulaManager();
        this.qmv = this.mv.getQuantifiedFormulaManager();
        this.bmv = this.mv.getBooleanFormulaManager();
        this._0 = this.imv.makeNumber(0L);
        this._1 = this.imv.makeNumber(1L);
        this._i = this.imv.makeVariable("i");
        this._i1 = this.imv.makeVariable("i@1");
        this._j = this.imv.makeVariable("j");
        this._j1 = this.imv.makeVariable("j@1");
        this._x = this.imv.makeVariable("x");
        this._x1 = this.imv.makeVariable("x@1");
        this._b = this.amv.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
    }

    @Test
    @Ignore
    public void testExtractAtomsArrays() {
        this.requireArrays();
    }

    @Test
    @Ignore
    public void testExtractAtomsQuantifiers() {
        this.requireQuantifiers();
    }

    @Test
    @Ignore
    public void testExtractAtomsQuantifiersAndArrays() {
        this.requireQuantifiers();
        this.requireArrays();
    }

    @Test
    @Ignore
    public void testExtractLiteralsArrays() {
        this.requireArrays();
    }

    @Test
    @Ignore
    public void testExtractLiteralsQuantifiers() {
        this.requireQuantifiers();
    }

    @Test
    @Ignore
    public void testExtractLiteralsQuantifiersAndArrays() {
        this.requireQuantifiers();
        this.requireArrays();
    }

    @Test
    public void testUnInstanciateQuantifiersAndArrays() {
        this.requireQuantifiers();
        this.requireArrays();
        BooleanFormula _b_at_x_NOTEQ_0 = this.bmv.not(this.imv.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.amv.select(this._b, this._x)), this._0));
        BooleanFormula instantiated = this.qmv.forall(Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{this._x}), this.bmv.and(Lists.newArrayList((Object[])new BooleanFormula[]{_b_at_x_NOTEQ_0, this.imv.greaterOrEquals(this._x, this._j1), this.imv.lessOrEquals(this._x, this._i1)})));
        BooleanFormula uninstantiated = this.qmv.forall(Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{this._x}), this.bmv.and(Lists.newArrayList((Object[])new BooleanFormula[]{_b_at_x_NOTEQ_0, this.imv.greaterOrEquals(this._x, this._j), this.imv.lessOrEquals(this._x, this._i)})));
        SSAMap.SSAMapBuilder ssaBuilder = SSAMap.emptySSAMap().builder();
        ssaBuilder.setIndex("i", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("j", CNumericTypes.INT, 1);
        this.testUnInstanciate(instantiated, uninstantiated, ssaBuilder);
    }

    @Test
    public void testUnInstanciate1() {
        this.requireQuantifiers();
        this.requireArrays();
        BooleanFormula _inst1 = this.imv.equal(this.imv.add(this._1, this._j1), this.imv.add(this._0, this._i1));
        BooleanFormula _inst2 = this.imv.equal(this.imv.add(this._1, this.imv.subtract(this._0, this._i1)), this.imv.add(this.imv.add(this._0, this._x1), this._i1));
        BooleanFormula _inst3 = this.bmv.and(Lists.newArrayList((Object[])new BooleanFormula[]{_inst1, _inst2, this.bmv.not(_inst1)}));
        BooleanFormula _uinst1 = this.imv.equal(this.imv.add(this._1, this._j), this.imv.add(this._0, this._i));
        BooleanFormula _uinst2 = this.imv.equal(this.imv.add(this._1, this.imv.subtract(this._0, this._i)), this.imv.add(this.imv.add(this._0, this._x), this._i));
        BooleanFormula _uinst3 = this.bmv.and(Lists.newArrayList((Object[])new BooleanFormula[]{_uinst1, _uinst2, this.bmv.not(_uinst1)}));
        SSAMap.SSAMapBuilder ssaBuilder = SSAMap.emptySSAMap().builder();
        ssaBuilder.setIndex("i", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("j", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("x", CNumericTypes.INT, 1);
        this.testUnInstanciate(_inst3, _uinst3, ssaBuilder);
    }

    private void testUnInstanciate(BooleanFormula pInstantiated, BooleanFormula pUninstantiated, SSAMap.SSAMapBuilder pSsaBuilder) {
        BooleanFormula r1 = this.mv.instantiate(pUninstantiated, pSsaBuilder.build());
        Truth.assertThat((String)r1.toString()).isEqualTo((Object)pInstantiated.toString());
        BooleanFormula r2 = this.mv.uninstantiate(pInstantiated);
        Truth.assertThat((String)r2.toString()).isEqualTo((Object)pUninstantiated.toString());
    }
}

