/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class FunctionFormulaManagerView
extends BaseManagerView
implements FunctionFormulaManager {
    private final FunctionFormulaManager manager;

    public FunctionFormulaManagerView(FormulaManagerView pViewManager, FunctionFormulaManager pManager) {
        super(pViewManager);
        this.manager = pManager;
    }

    @Override
    public <T extends Formula> UninterpretedFunctionDeclaration<T> declareUninterpretedFunction(String pName, FormulaType<T> pReturnType, List<FormulaType<?>> pArgs) {
        List<FormulaType<?>> newArgs = this.unwrapType(pArgs);
        FormulaType<?> ret = this.unwrapType(pReturnType);
        UninterpretedFunctionDeclaration<?> func = this.manager.declareUninterpretedFunction(pName, ret, newArgs);
        return new ReplaceUninterpretedFunctionDeclaration<T>(func, pReturnType, pArgs);
    }

    @Override
    public <T extends Formula> UninterpretedFunctionDeclaration<T> declareUninterpretedFunction(String pName, FormulaType<T> pReturnType, FormulaType<?> ... pArgs) {
        return this.declareUninterpretedFunction(pName, pReturnType, Arrays.asList(pArgs));
    }

    public <T extends Formula> T declareAndCallUninterpretedFunction(String pName, int idx, FormulaType<T> pReturnType, List<Formula> pArgs) {
        String name = FormulaManagerView.makeName(pName, idx);
        return this.declareAndCallUninterpretedFunction(name, pReturnType, pArgs);
    }

    public <T extends Formula> T declareAndCallUninterpretedFunction(String pName, int pIdx, FormulaType<T> pReturnType, Formula ... pArgs) {
        return this.declareAndCallUninterpretedFunction(pName, pIdx, pReturnType, Arrays.asList(pArgs));
    }

    public <T extends Formula> T declareAndCallUninterpretedFunction(String name, FormulaType<T> pReturnType, List<Formula> pArgs) {
        ImmutableList argTypes = FluentIterable.from(pArgs).transform(new Function<Formula, FormulaType<?>>(){

            public FormulaType<?> apply(Formula pArg0) {
                return FunctionFormulaManagerView.this.getFormulaType(pArg0);
            }
        }).toList();
        UninterpretedFunctionDeclaration<T> func = this.declareUninterpretedFunction(name, pReturnType, (List<FormulaType<?>>)argTypes);
        return this.callUninterpretedFunction(func, pArgs);
    }

    public <T extends Formula> T declareAndCallUninterpretedFunction(String pName, FormulaType<T> pReturnType, Formula ... pArgs) {
        return this.declareAndCallUninterpretedFunction(pName, pReturnType, Arrays.asList(pArgs));
    }

    @Override
    public <T extends Formula> T callUninterpretedFunction(UninterpretedFunctionDeclaration<T> pFuncType, List<? extends Formula> pArgs) {
        ReplaceUninterpretedFunctionDeclaration rep = (ReplaceUninterpretedFunctionDeclaration)pFuncType;
        Object f = this.manager.callUninterpretedFunction(rep.wrapped, this.unwrap(pArgs));
        return this.wrap(pFuncType.getReturnType(), f);
    }

    public <T extends Formula> T callUninterpretedFunction(UninterpretedFunctionDeclaration<T> pFuncType, Formula ... pArgs) {
        return this.callUninterpretedFunction(pFuncType, Arrays.asList(pArgs));
    }

    private static class ReplaceUninterpretedFunctionDeclaration<T extends Formula>
    extends UninterpretedFunctionDeclaration<T> {
        private final UninterpretedFunctionDeclaration<?> wrapped;

        ReplaceUninterpretedFunctionDeclaration(UninterpretedFunctionDeclaration<?> wrapped, FormulaType<T> pReturnType, List<FormulaType<?>> pArgumentTypes) {
            super(pReturnType, pArgumentTypes);
            this.wrapped = (UninterpretedFunctionDeclaration)Preconditions.checkNotNull(wrapped);
        }

        public int hashCode() {
            return 17 + this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReplaceUninterpretedFunctionDeclaration)) {
                return false;
            }
            ReplaceUninterpretedFunctionDeclaration other = (ReplaceUninterpretedFunctionDeclaration)obj;
            return this.wrapped.equals(other.wrapped);
        }
    }
}

