/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

class ReplaceBitvectorWithNumeralAndFunctionTheory<T extends NumeralFormula>
extends BaseManagerView
implements BitvectorFormulaManager {
    private final NumeralFormulaManager<? super T, T> numericFormulaManager;
    private final FunctionFormulaManager functionManager;
    private final UninterpretedFunctionDeclaration<T> bitwiseAndUfDecl;
    private final UninterpretedFunctionDeclaration<T> bitwiseOrUfDecl;
    private final UninterpretedFunctionDeclaration<T> bitwiseXorUfDecl;
    private final UninterpretedFunctionDeclaration<T> bitwiseNotUfDecl;
    private final UninterpretedFunctionDeclaration<T> leftShiftUfDecl;
    private final UninterpretedFunctionDeclaration<T> rightShiftUfDecl;
    private final FormulaType<T> formulaType;
    private final boolean ignoreExtractConcat;
    private final Map<Integer[], UninterpretedFunctionDeclaration<T>> extractMethods = new HashMap<Integer[], UninterpretedFunctionDeclaration<T>>();
    private Map<Integer[], UninterpretedFunctionDeclaration<T>> concatMethods = new HashMap<Integer[], UninterpretedFunctionDeclaration<T>>();
    private Map<Integer, UninterpretedFunctionDeclaration<T>> extendSignedMethods = new HashMap<Integer, UninterpretedFunctionDeclaration<T>>();
    private Map<Integer, UninterpretedFunctionDeclaration<T>> extendUnsignedMethods = new HashMap<Integer, UninterpretedFunctionDeclaration<T>>();

    public ReplaceBitvectorWithNumeralAndFunctionTheory(FormulaManagerView pViewManager, NumeralFormulaManager<? super T, T> rawNumericFormulaManager, FunctionFormulaManager rawFunctionManager, boolean ignoreExtractConcat) {
        super(pViewManager);
        this.numericFormulaManager = rawNumericFormulaManager;
        this.ignoreExtractConcat = ignoreExtractConcat;
        this.functionManager = rawFunctionManager;
        this.formulaType = this.numericFormulaManager.getFormulaType();
        this.bitwiseAndUfDecl = this.createBinaryFunction("_&_");
        this.bitwiseOrUfDecl = this.createBinaryFunction("_!!_");
        this.bitwiseXorUfDecl = this.createBinaryFunction("_^_");
        this.bitwiseNotUfDecl = this.createUnaryFunction("_~_");
        this.leftShiftUfDecl = this.createBinaryFunction("_<<_");
        this.rightShiftUfDecl = this.createBinaryFunction("_>>_");
    }

    private T unwrap(BitvectorFormula pNumber) {
        return (T)((NumeralFormula)super.unwrap(pNumber));
    }

    private UninterpretedFunctionDeclaration<T> createUnaryFunction(String name) {
        return this.functionManager.declareUninterpretedFunction(name, this.formulaType, this.formulaType);
    }

    private UninterpretedFunctionDeclaration<T> createBinaryFunction(String name) {
        return this.functionManager.declareUninterpretedFunction(name, this.formulaType, this.formulaType, this.formulaType);
    }

    private BitvectorFormula makeUf(FormulaType<BitvectorFormula> realreturn, UninterpretedFunctionDeclaration<T> decl, BitvectorFormula ... t1) {
        List<Formula> args = this.unwrap(Arrays.asList(t1));
        return this.wrap(realreturn, this.functionManager.callUninterpretedFunction(decl, args));
    }

    private UninterpretedFunctionDeclaration<T> getExtractDecl(int pMsb, int pLsb) {
        Integer[] hasKey = new Integer[]{pMsb, pLsb};
        UninterpretedFunctionDeclaration<T> value = this.extractMethods.get(hasKey);
        if (value == null) {
            value = this.createUnaryFunction("_extract(" + pMsb + "," + pLsb + ")_");
            this.extractMethods.put(hasKey, value);
        }
        return value;
    }

    private UninterpretedFunctionDeclaration<T> getConcatDecl(int firstSize, int secoundSize) {
        Integer[] hasKey = new Integer[]{firstSize, secoundSize};
        UninterpretedFunctionDeclaration<T> value = this.concatMethods.get(hasKey);
        if (value == null) {
            value = this.createUnaryFunction("_concat(" + firstSize + "," + secoundSize + ")_");
            this.concatMethods.put(hasKey, value);
        }
        return value;
    }

    private UninterpretedFunctionDeclaration<T> getExtendDecl(int extensionBits, boolean pSigned) {
        UninterpretedFunctionDeclaration<T> value;
        Integer hasKey = extensionBits;
        if (pSigned) {
            value = this.extendSignedMethods.get(hasKey);
            if (value == null) {
                value = this.createUnaryFunction("_extendSigned(" + extensionBits + ")_");
                this.extendSignedMethods.put(hasKey, value);
            }
        } else {
            value = this.extendUnsignedMethods.get(hasKey);
            if (value == null) {
                value = this.createUnaryFunction("_extendUnsigned(" + extensionBits + ")_");
                this.extendUnsignedMethods.put(hasKey, value);
            }
        }
        return value;
    }

    @Override
    public BitvectorFormula makeBitvector(int pLength, long pI) {
        T number = this.numericFormulaManager.makeNumber(pI);
        return this.wrap(FormulaType.getBitvectorTypeWithSize(pLength), number);
    }

    @Override
    public BitvectorFormula makeBitvector(int pLength, BigInteger pI) {
        T number = this.numericFormulaManager.makeNumber(pI);
        return this.wrap(FormulaType.getBitvectorTypeWithSize(pLength), number);
    }

    @Override
    public BitvectorFormula makeVariable(int pLength, String pVar) {
        return this.wrap(FormulaType.getBitvectorTypeWithSize(pLength), this.numericFormulaManager.makeVariable(pVar));
    }

    @Override
    public int getLength(BitvectorFormula pNumber) {
        return ((FormulaType.BitvectorType)this.getFormulaType(pNumber)).getSize();
    }

    @Override
    public BitvectorFormula negate(BitvectorFormula pNumber) {
        return this.wrap(this.getFormulaType(pNumber), this.numericFormulaManager.negate(this.unwrap(pNumber)));
    }

    @Override
    public BitvectorFormula add(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.add(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public BitvectorFormula subtract(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.subtract(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public BitvectorFormula divide(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.divide(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public BitvectorFormula modulo(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.modulo(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public BooleanFormula modularCongruence(BitvectorFormula pNumber1, BitvectorFormula pNumber2, long pModulo) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.numericFormulaManager.modularCongruence(this.unwrap(pNumber1), this.unwrap(pNumber2), pModulo);
    }

    @Override
    public BitvectorFormula multiply(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.multiply(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public BooleanFormula equal(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public boolean isEqual(BooleanFormula pNumber) {
        return this.numericFormulaManager.isEqual(pNumber);
    }

    @Override
    public BooleanFormula greaterThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        return this.numericFormulaManager.greaterThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula greaterOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        return this.numericFormulaManager.greaterOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula lessThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        return this.numericFormulaManager.lessThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula lessOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        return this.numericFormulaManager.lessOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BitvectorFormula shiftRight(BitvectorFormula pNumber, BitvectorFormula pToShift, boolean signed) {
        assert (this.getLength(pNumber) == this.getLength(pToShift)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pNumber), this.rightShiftUfDecl, pNumber, pToShift);
    }

    @Override
    public BitvectorFormula shiftLeft(BitvectorFormula pNumber, BitvectorFormula pToShift) {
        assert (this.getLength(pNumber) == this.getLength(pToShift)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pNumber), this.leftShiftUfDecl, pNumber, pToShift);
    }

    @Override
    public BitvectorFormula concat(BitvectorFormula pFirst, BitvectorFormula pSecound) {
        int firstLength = this.getLength(pFirst);
        int secoundLength = this.getLength(pSecound);
        FormulaType.BitvectorType returnType = FormulaType.getBitvectorTypeWithSize(firstLength + secoundLength);
        if (this.ignoreExtractConcat) {
            return this.wrap(returnType, this.unwrap(pSecound));
        }
        UninterpretedFunctionDeclaration<T> concatUfDecl = this.getConcatDecl(firstLength, secoundLength);
        return this.makeUf(returnType, concatUfDecl, pFirst, pSecound);
    }

    @Override
    public BitvectorFormula extract(BitvectorFormula pFirst, int pMsb, int pLsb) {
        FormulaType.BitvectorType returnType = FormulaType.getBitvectorTypeWithSize(pMsb + 1 - pLsb);
        if (this.ignoreExtractConcat) {
            return this.wrap(returnType, this.unwrap(pFirst));
        }
        UninterpretedFunctionDeclaration<T> extractUfDecl = this.getExtractDecl(pMsb, pLsb);
        return this.makeUf(returnType, extractUfDecl, pFirst);
    }

    @Override
    public BitvectorFormula extend(BitvectorFormula pNumber, int pExtensionBits, boolean pSigned) {
        FormulaType.BitvectorType returnType = FormulaType.getBitvectorTypeWithSize(this.getLength(pNumber) + pExtensionBits);
        if (this.ignoreExtractConcat) {
            return this.wrap(returnType, this.unwrap(pNumber));
        }
        UninterpretedFunctionDeclaration<T> extendUfDecl = this.getExtendDecl(pExtensionBits, pSigned);
        return this.makeUf(returnType, extendUfDecl, pNumber);
    }

    @Override
    public BitvectorFormula not(BitvectorFormula pBits) {
        return this.makeUf(this.getFormulaType(pBits), this.bitwiseNotUfDecl, pBits);
    }

    @Override
    public BitvectorFormula and(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pBits1), this.bitwiseAndUfDecl, pBits1, pBits2);
    }

    @Override
    public BitvectorFormula or(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pBits1), this.bitwiseOrUfDecl, pBits1, pBits2);
    }

    @Override
    public BitvectorFormula xor(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pBits1), this.bitwiseXorUfDecl, pBits1, pBits2);
    }
}

