/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.view;

import java.math.BigDecimal;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;

public class ReplaceFloatingPointWithNumeralAndFunctionTheory<T extends NumeralFormula>
extends BaseManagerView
implements FloatingPointFormulaManager {
    private final BooleanFormulaManagerView booleanManager;
    private final FunctionFormulaManagerView functionManager;
    private final NumeralFormulaManagerView<? super T, T> numericFormulaManager;
    private final FormulaType<T> formulaType;
    private final UninterpretedFunctionDeclaration<BooleanFormula> isSubnormalUfDecl;
    private final T zero;
    private final T nanVariable;
    private final T plusInfinityVariable;
    private final T minusInfinityVariable;

    public ReplaceFloatingPointWithNumeralAndFunctionTheory(FormulaManagerView pViewManager, NumeralFormulaManagerView<? super T, T> pReplacementManager) {
        super(pViewManager);
        this.numericFormulaManager = pReplacementManager;
        this.booleanManager = pViewManager.getBooleanFormulaManager();
        this.functionManager = pViewManager.getFunctionFormulaManager();
        this.formulaType = this.numericFormulaManager.getFormulaType();
        this.isSubnormalUfDecl = this.functionManager.declareUninterpretedFunction("__isSubnormal__", FormulaType.BooleanType, this.formulaType);
        this.zero = this.numericFormulaManager.makeNumber(0L);
        this.nanVariable = this.numericFormulaManager.makeVariable("__NaN__");
        this.plusInfinityVariable = this.numericFormulaManager.makeVariable("__+Infinity__");
        this.minusInfinityVariable = this.numericFormulaManager.makeVariable("__-Infinity__");
    }

    private T unwrap(FloatingPointFormula pNumber) {
        return (T)((NumeralFormula)super.unwrap(pNumber));
    }

    public <T2 extends Formula> T2 castTo(FloatingPointFormula pNumber, FormulaType<T2> pTargetType) {
        return this.genericCast(pNumber, pTargetType);
    }

    @Override
    public FloatingPointFormula castFrom(Formula pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType) {
        return this.genericCast(pNumber, pTargetType);
    }

    private <T2 extends Formula> T2 genericCast(Formula pNumber, FormulaType<T2> pTargetType) {
        FormulaType<?> targetType;
        Formula number = this.unwrap(pNumber);
        FormulaType<Formula> type = this.getFormulaType(number);
        if (type.equals(targetType = this.unwrapType(pTargetType))) {
            return this.wrap(pTargetType, number);
        }
        return this.functionManager.declareAndCallUninterpretedFunction("__cast_" + type + "_to_" + pTargetType + "__", pTargetType, number);
    }

    @Override
    public FloatingPointFormula negate(FloatingPointFormula pNumber) {
        return this.wrap(this.getFormulaType(pNumber), this.numericFormulaManager.negate(this.unwrap(pNumber)));
    }

    @Override
    public FloatingPointFormula add(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.add(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public FloatingPointFormula subtract(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.subtract(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public FloatingPointFormula divide(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        T number1 = this.unwrap(pNumber1);
        T number2 = this.unwrap(pNumber2);
        FormulaType<FloatingPointFormula> targetType = this.getFormulaType(pNumber1);
        if (number2.equals(this.zero)) {
            return this.wrap(targetType, this.booleanManager.ifThenElse(this.numericFormulaManager.equal(number1, this.zero), this.nanVariable, this.booleanManager.ifThenElse(this.numericFormulaManager.lessThan(number1, this.zero), this.minusInfinityVariable, this.plusInfinityVariable)));
        }
        return this.wrap(targetType, this.numericFormulaManager.divide(number1, number2));
    }

    @Override
    public FloatingPointFormula multiply(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.multiply(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    @Override
    public BooleanFormula assignment(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula equalWithFPSemantics(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula greaterThan(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.greaterThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula greaterOrEquals(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.greaterOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula lessThan(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.lessThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula lessOrEquals(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.lessOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    @Override
    public BooleanFormula isNaN(FloatingPointFormula pNumber) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber), this.nanVariable);
    }

    @Override
    public BooleanFormula isInfinity(FloatingPointFormula pNumber) {
        T number = this.unwrap(pNumber);
        return this.booleanManager.or(this.numericFormulaManager.equal(number, this.plusInfinityVariable), this.numericFormulaManager.equal(number, this.minusInfinityVariable));
    }

    @Override
    public BooleanFormula isZero(FloatingPointFormula pNumber) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber), this.numericFormulaManager.makeNumber(0L));
    }

    @Override
    public BooleanFormula isSubnormal(FloatingPointFormula pNumber) {
        return this.functionManager.callUninterpretedFunction(this.isSubnormalUfDecl, new Formula[]{this.unwrap(pNumber)});
    }

    @Override
    public FloatingPointFormula makeNumber(double pN, FormulaType.FloatingPointType type) {
        return this.wrap(type, this.numericFormulaManager.makeNumber(pN));
    }

    @Override
    public FloatingPointFormula makeNumber(BigDecimal pN, FormulaType.FloatingPointType type) {
        return this.wrap(type, this.numericFormulaManager.makeNumber(pN));
    }

    @Override
    public FloatingPointFormula makeNumber(String pN, FormulaType.FloatingPointType type) {
        return this.wrap(type, this.numericFormulaManager.makeNumber(pN));
    }

    @Override
    public FloatingPointFormula makeVariable(String pVar, FormulaType.FloatingPointType pType) {
        return this.wrap(pType, this.numericFormulaManager.makeVariable(pVar));
    }

    @Override
    public FloatingPointFormula makePlusInfinity(FormulaType.FloatingPointType pType) {
        return this.wrap(pType, this.plusInfinityVariable);
    }

    @Override
    public FloatingPointFormula makeMinusInfinity(FormulaType.FloatingPointType pType) {
        return this.wrap(pType, this.minusInfinityVariable);
    }

    @Override
    public FloatingPointFormula makeNaN(FormulaType.FloatingPointType pType) {
        return this.wrap(pType, this.nanVariable);
    }
}

