/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;

public class CounterexampleTraceInfo {
    private final boolean spurious;
    private final ImmutableList<BooleanFormula> interpolants;
    private final Model mCounterexampleModel;
    private final ImmutableList<BooleanFormula> mCounterexampleFormula;
    private final ImmutableMap<Integer, Boolean> branchingPreds;

    private CounterexampleTraceInfo(boolean pSpurious, ImmutableList<BooleanFormula> pInterpolants, Model pCounterexampleModel, ImmutableList<BooleanFormula> pCounterexampleFormula, ImmutableMap<Integer, Boolean> pBranchingPreds) {
        this.spurious = pSpurious;
        this.interpolants = pInterpolants;
        this.mCounterexampleModel = pCounterexampleModel;
        this.mCounterexampleFormula = pCounterexampleFormula;
        this.branchingPreds = pBranchingPreds;
    }

    static CounterexampleTraceInfo infeasible(List<BooleanFormula> pInterpolants) {
        return new CounterexampleTraceInfo(true, (ImmutableList<BooleanFormula>)ImmutableList.copyOf(pInterpolants), null, (ImmutableList<BooleanFormula>)ImmutableList.of(), (ImmutableMap<Integer, Boolean>)ImmutableMap.of());
    }

    public static CounterexampleTraceInfo infeasibleNoItp() {
        return new CounterexampleTraceInfo(true, null, null, (ImmutableList<BooleanFormula>)ImmutableList.of(), (ImmutableMap<Integer, Boolean>)ImmutableMap.of());
    }

    public static CounterexampleTraceInfo feasible(List<BooleanFormula> pCounterexampleFormula, Model pModel, Map<Integer, Boolean> preds) {
        return new CounterexampleTraceInfo(false, (ImmutableList<BooleanFormula>)ImmutableList.of(), (Model)((Object)Preconditions.checkNotNull((Object)((Object)pModel))), (ImmutableList<BooleanFormula>)ImmutableList.copyOf(pCounterexampleFormula), (ImmutableMap<Integer, Boolean>)ImmutableMap.copyOf(preds));
    }

    public boolean isSpurious() {
        return this.spurious;
    }

    public List<BooleanFormula> getInterpolants() {
        Preconditions.checkState((boolean)this.spurious);
        return this.interpolants;
    }

    public String toString() {
        return "Spurious: " + this.isSpurious() + (this.isSpurious() ? ", interpolants: " + this.interpolants : "");
    }

    public List<BooleanFormula> getCounterExampleFormulas() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.mCounterexampleFormula;
    }

    public Model getModel() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.mCounterexampleModel;
    }

    public Map<Integer, Boolean> getBranchingPredicates() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.branchingPreds;
    }
}

