/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.concurrency.Threads;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BasicProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cpa.predicate.refinement")
public final class InterpolationManager {
    private final Timer cexAnalysisTimer = new Timer();
    private final Timer satCheckTimer = new Timer();
    private final Timer getInterpolantTimer = new Timer();
    private final Timer cexAnalysisGetUsefulBlocksTimer = new Timer();
    private final Timer interpolantVerificationTimer = new Timer();
    private int reusedFormulasOnSolverStack = 0;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PathFormulaManager pmgr;
    private final Solver solver;
    private final Interpolator<?> interpolator;
    @Option(secure=true, description="apply deletion-filter to the abstract counterexample, to get a minimal set of blocks, before applying interpolation-based refinement")
    private boolean getUsefulBlocks = false;
    @Option(secure=true, name="incrementalCexTraceCheck", description="use incremental search in counterexample analysis, to find the minimal infeasible prefix")
    private boolean incrementalCheck = false;
    @Option(secure=true, name="cexTraceCheckDirection", description="Direction for doing counterexample analysis: from start of trace, from end of trace, or alternatingly from start and end of the trace towards the middle")
    private CexTraceAnalysisDirection direction = CexTraceAnalysisDirection.FORWARDS;
    @Option(secure=true, description="Strategy how to interact woith the intepolating prover. If a strategy starts with 'CPACHECKER_', we use our own implementation and do not use the solver's method. In our own implementation the properties of interpolants are guaranteed for special cases only.\n- CPACHECKER_SEQ: We simply return each interpolant for i={0..n-1} for the partitions A=[0 .. i] and B=[i+1 .. n]. The result is similar to INDUCTIVE_SEQ, but we do not guarantee the 'inductiveness', i.e. the solver has to generate nice interpolants. \n- INDUCTIVE_SEQ: Generate an inductive sequence of interpolants the partitions [1,...n]. \n- CPACHECKER_WELLSCOPED: We return each interpolant for i={0..n-1} for the partitions A=[lastFunctionEntryIndex .. i] and B=[0 .. lastFunctionEntryIndex-1 , i+1 .. n].\n- NESTED: use callstack and previous interpolants for next interpolants (see 'Nested Interpolants').")
    private InterpolationStrategy strategy = InterpolationStrategy.CPACHECKER_SEQ;
    @Option(secure=true, description="dump all interpolation problems")
    private boolean dumpInterpolationProblems = false;
    @Option(secure=true, description="verify if the interpolants fulfill the interpolant properties")
    private boolean verifyInterpolants = false;
    @Option(secure=true, name="timelimit", description="time limit for refinement (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private TimeSpan itpTimeLimit = TimeSpan.ofMillis((long)0L);
    @Option(secure=true, description="skip refinement if input formula is larger than this amount of bytes (ignored if 0)")
    private int maxRefinementSize = 0;
    @Option(secure=true, description="Use a single SMT solver environment for several interpolation queries")
    private boolean reuseInterpolationEnvironment = false;
    private final ExecutorService executor;

    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        out.println("  Counterexample analysis:            " + this.cexAnalysisTimer + " (Max: " + this.cexAnalysisTimer.getMaxTime().formatAs(TimeUnit.SECONDS) + ", Calls: " + this.cexAnalysisTimer.getNumberOfIntervals() + ")");
        if (this.cexAnalysisGetUsefulBlocksTimer.getNumberOfIntervals() > 0) {
            out.println("    Cex.focusing:                     " + this.cexAnalysisGetUsefulBlocksTimer + " (Max: " + this.cexAnalysisGetUsefulBlocksTimer.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
        }
        out.println("    Refinement sat check:             " + this.satCheckTimer);
        if (this.reuseInterpolationEnvironment && this.satCheckTimer.getNumberOfIntervals() > 0) {
            out.println("    Reused formulas on solver stack:  " + this.reusedFormulasOnSolverStack + " (Avg: " + StatisticsUtils.div(this.reusedFormulasOnSolverStack, this.satCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("    Interpolant computation:          " + this.getInterpolantTimer);
        if (this.interpolantVerificationTimer.getNumberOfIntervals() > 0) {
            out.println("    Interpolant verification:         " + this.interpolantVerificationTimer);
        }
    }

    public InterpolationManager(PathFormulaManager pPmgr, Solver pSolver, Configuration config, ShutdownNotifier pShutdownNotifier, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, InterpolationManager.class);
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pmgr = pPmgr;
        this.solver = pSolver;
        this.executor = this.itpTimeLimit.isEmpty() ? null : Executors.newSingleThreadExecutor(Threads.threadFactoryBuilder().setDaemon(true).build());
        this.interpolator = this.reuseInterpolationEnvironment ? new Interpolator() : null;
    }

    public Appender dumpCounterexample(CounterexampleTraceInfo cex) {
        return this.fmgr.dumpFormula(this.bfmgr.and(cex.getCounterExampleFormulas()));
    }

    public CounterexampleTraceInfo buildCounterexampleTrace(final List<BooleanFormula> pFormulas, final List<AbstractState> pAbstractionStates, final Set<ARGState> elementsOnPath, final boolean computeInterpolants) throws CPAException, InterruptedException {
        assert (pAbstractionStates.isEmpty() || pFormulas.size() == pAbstractionStates.size());
        if (this.itpTimeLimit.isEmpty()) {
            return this.buildCounterexampleTrace0(pFormulas, pAbstractionStates, elementsOnPath, computeInterpolants);
        }
        assert (this.executor != null);
        Callable<CounterexampleTraceInfo> tc = new Callable<CounterexampleTraceInfo>(){

            @Override
            public CounterexampleTraceInfo call() throws CPAException, InterruptedException {
                return InterpolationManager.this.buildCounterexampleTrace0(pFormulas, pAbstractionStates, elementsOnPath, computeInterpolants);
            }
        };
        Future<CounterexampleTraceInfo> future = this.executor.submit(tc);
        try {
            return future.get(this.itpTimeLimit.asNanos(), TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            this.logger.log(Level.SEVERE, new Object[]{"SMT-solver timed out during interpolation process"});
            throw new RefinementFailedException(RefinementFailedException.Reason.TIMEOUT, null);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible((Throwable)t, CPAException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("interpolation", t);
        }
    }

    public CounterexampleTraceInfo buildCounterexampleTrace(List<BooleanFormula> pFormulas, List<AbstractState> pAbstractionStates, Set<ARGState> elementsOnPath) throws CPAException, InterruptedException {
        return this.buildCounterexampleTrace(pFormulas, pAbstractionStates, elementsOnPath, true);
    }

    public CounterexampleTraceInfo buildCounterexampleTrace(List<BooleanFormula> pFormulas) throws CPAException, InterruptedException {
        return this.buildCounterexampleTrace(pFormulas, Collections.emptyList(), Collections.emptySet(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CounterexampleTraceInfo buildCounterexampleTrace0(List<BooleanFormula> pFormulas, List<AbstractState> pAbstractionStates, Set<ARGState> elementsOnPath, boolean computeInterpolants) throws CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Building counterexample trace"});
        this.cexAnalysisTimer.start();
        try {
            CounterexampleTraceInfo counterexampleTraceInfo;
            block33: {
                int size;
                List<BooleanFormula> f = new ArrayList<BooleanFormula>(pFormulas);
                if (this.fmgr.useBitwiseAxioms()) {
                    this.addBitwiseAxioms(f);
                }
                f = Collections.unmodifiableList(f);
                this.logger.log(Level.ALL, new Object[]{"Counterexample trace formulas:", f});
                if (this.maxRefinementSize > 0 && (size = this.fmgr.dumpFormula(this.bfmgr.and(f)).toString().length()) > this.maxRefinementSize) {
                    this.logger.log(Level.FINEST, new Object[]{"Skipping refinement because input formula is", size, "bytes large."});
                    throw new RefinementFailedException(RefinementFailedException.Reason.TooMuchUnrolling, null);
                }
                Interpolator currentInterpolator = this.reuseInterpolationEnvironment ? (Interpolator)Preconditions.checkNotNull(this.interpolator) : new Interpolator();
                try {
                    counterexampleTraceInfo = currentInterpolator.buildCounterexampleTrace(f, pAbstractionStates, elementsOnPath, computeInterpolants);
                    if (this.reuseInterpolationEnvironment) break block33;
                }
                catch (Throwable throwable) {
                    try {
                        if (!this.reuseInterpolationEnvironment) {
                            currentInterpolator.close();
                        }
                        throw throwable;
                    }
                    catch (SolverException e) {
                        block37: {
                            Throwable throwable2;
                            ProverEnvironment prover;
                            block34: {
                                CounterexampleTraceInfo i$;
                                block35: {
                                    block36: {
                                        this.logger.logUserException(Level.FINEST, (Throwable)e, "Interpolation failed, attempting to solve without interpolation");
                                        prover = this.solver.newProverEnvironmentWithModelGeneration();
                                        throwable2 = null;
                                        for (BooleanFormula block : f) {
                                            prover.push(block);
                                        }
                                        if (prover.isUnsat()) break block34;
                                        i$ = this.getErrorPath(f, prover, elementsOnPath);
                                        if (prover == null) break block35;
                                        if (throwable2 == null) break block36;
                                        try {
                                            prover.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable2.addSuppressed(x2);
                                        }
                                        break block35;
                                    }
                                    prover.close();
                                }
                                this.cexAnalysisTimer.stop();
                                return i$;
                            }
                            try {
                                if (prover != null) {
                                    if (throwable2 != null) {
                                        try {
                                            prover.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable2.addSuppressed(x2);
                                        }
                                    } else {
                                        prover.close();
                                    }
                                }
                                break block37;
                                {
                                    catch (Throwable throwable3) {
                                        try {
                                            throwable2 = throwable3;
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            if (prover != null) {
                                                if (throwable2 != null) {
                                                    try {
                                                        prover.close();
                                                    }
                                                    catch (Throwable x2) {
                                                        throwable2.addSuppressed(x2);
                                                    }
                                                } else {
                                                    prover.close();
                                                }
                                            }
                                            throw throwable4;
                                        }
                                    }
                                }
                            }
                            catch (SolverException e2) {
                                this.logger.logDebugException((Throwable)e2, "Solving trace failed even without interpolation");
                            }
                        }
                        throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null, e);
                    }
                }
                currentInterpolator.close();
            }
            return counterexampleTraceInfo;
        }
        finally {
            this.cexAnalysisTimer.stop();
        }
    }

    private void addBitwiseAxioms(List<BooleanFormula> f) {
        BooleanFormula bitwiseAxioms = this.bfmgr.makeBoolean(true);
        for (BooleanFormula fm : f) {
            BooleanFormula a = this.fmgr.getBitwiseAxioms(fm);
            if (this.bfmgr.isTrue(a)) continue;
            bitwiseAxioms = this.fmgr.getBooleanFormulaManager().and(bitwiseAxioms, a);
        }
        if (!this.bfmgr.isTrue(bitwiseAxioms)) {
            this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "ADDING BITWISE AXIOMS TO THE", "LAST GROUP: ", bitwiseAxioms});
            int lastIndex = f.size() - 1;
            f.set(lastIndex, this.bfmgr.and(f.get(lastIndex), bitwiseAxioms));
        }
    }

    private List<BooleanFormula> getUsefulBlocks(List<BooleanFormula> f) throws SolverException, InterruptedException {
        this.cexAnalysisGetUsefulBlocksTimer.start();
        try (ProverEnvironment thmProver = this.solver.newProverEnvironment();){
            boolean consistent;
            this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Calling getUsefulBlocks on path", "of length:", f.size()});
            BooleanFormula[] needed = new BooleanFormula[f.size()];
            for (int i = 0; i < needed.length; ++i) {
                needed[i] = this.bfmgr.makeBoolean(true);
            }
            boolean backwards = this.direction == CexTraceAnalysisDirection.BACKWARDS;
            int start = backwards ? f.size() - 1 : 0;
            int increment = backwards ? -1 : 1;
            int toPop = 0;
            block10: do {
                int i;
                consistent = true;
                for (i = 0; i < needed.length; ++i) {
                    if (this.bfmgr.isTrue(needed[i])) continue;
                    thmProver.push(needed[i]);
                    ++toPop;
                }
                if (thmProver.isUnsat()) {
                    f = Arrays.asList(needed);
                    break;
                }
                if (this.direction == CexTraceAnalysisDirection.ZIGZAG) {
                    int s = 0;
                    int e = f.size() - 1;
                    boolean fromStart = false;
                    do {
                        int i2 = fromStart ? s++ : e--;
                        fromStart = !fromStart;
                        BooleanFormula t = f.get(i2);
                        thmProver.push(t);
                        ++toPop;
                        if (!thmProver.isUnsat()) continue;
                        needed[i2] = t;
                        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Found needed block: ", i2, ", term: ", t});
                        while (toPop > 0) {
                            --toPop;
                            thmProver.pop();
                        }
                        consistent = false;
                        continue block10;
                    } while (e >= s);
                    continue;
                }
                i = start;
                while (backwards ? i >= 0 : i < f.size()) {
                    BooleanFormula t = f.get(i);
                    thmProver.push(t);
                    ++toPop;
                    if (thmProver.isUnsat()) {
                        needed[i] = t;
                        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Found needed block: ", i, ", term: ", t});
                        while (toPop > 0) {
                            --toPop;
                            thmProver.pop();
                        }
                        consistent = false;
                        continue block10;
                    }
                    i += increment;
                }
            } while (!consistent);
            while (toPop > 0) {
                --toPop;
                thmProver.pop();
            }
        }
        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Done getUsefulBlocks"});
        this.cexAnalysisGetUsefulBlocksTimer.stop();
        return f;
    }

    private List<Triple<BooleanFormula, AbstractState, Integer>> orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> pAbstractionStates) {
        ImmutableList.Builder orderedFormulas = ImmutableList.builder();
        if (this.direction == CexTraceAnalysisDirection.ZIGZAG) {
            int e = traceFormulas.size() - 1;
            int s = 0;
            boolean fromStart = false;
            while (s <= e) {
                int i = fromStart ? s++ : e--;
                fromStart = !fromStart;
                orderedFormulas.add((Object)Triple.of((Object)traceFormulas.get(i), (Object)pAbstractionStates.get(i), (Object)i));
            }
        } else {
            int i;
            boolean backwards = this.direction == CexTraceAnalysisDirection.BACKWARDS;
            int increment = backwards ? -1 : 1;
            int n = i = backwards ? traceFormulas.size() - 1 : 0;
            while (backwards ? i >= 0 : i < traceFormulas.size()) {
                orderedFormulas.add((Object)Triple.of((Object)traceFormulas.get(i), (Object)pAbstractionStates.get(i), (Object)i));
                i += increment;
            }
        }
        ImmutableList result = orderedFormulas.build();
        assert (traceFormulas.size() == result.size());
        assert (ImmutableMultiset.copyOf((Iterable)FluentIterable.from((Iterable)result).transform(Triple.getProjectionToFirst())).equals((Object)ImmutableMultiset.copyOf(traceFormulas))) : "Ordered list does not contain the same formulas with the same count";
        return result;
    }

    private <T> List<BooleanFormula> getInterpolants(Interpolator<T> interpolator, List<T> itpGroupsIds, List<Triple<BooleanFormula, AbstractState, Integer>> orderedFormulas) throws InterruptedException, SolverException {
        assert (itpGroupsIds.size() == orderedFormulas.size());
        Preconditions.checkState((this.strategy == InterpolationStrategy.CPACHECKER_SEQ || this.direction == CexTraceAnalysisDirection.FORWARDS ? 1 : 0) != 0, (Object)"well-scoped or nested interpolants are based on function-scopes and need to traverse the error-trace in forward direction.");
        switch (this.strategy) {
            case CPACHECKER_SEQ: {
                ArrayList<BooleanFormula> interpolants = new ArrayList<BooleanFormula>();
                for (int end_of_A = 0; end_of_A < itpGroupsIds.size() - 1; ++end_of_A) {
                    boolean start_of_A = false;
                    interpolants.add(this.getInterpolantFromSublist(((Interpolator)interpolator).itpProver, itpGroupsIds, 0, end_of_A, 0));
                }
                return interpolants;
            }
            case INDUCTIVE_SEQ: {
                ArrayList itpGroups = new ArrayList();
                for (T f : itpGroupsIds) {
                    itpGroups.add(Collections.singleton(f));
                }
                return ((Interpolator)interpolator).itpProver.getSeqInterpolants(itpGroups);
            }
            case CPACHECKER_WELLSCOPED: {
                ArrayList<BooleanFormula> interpolants = new ArrayList<BooleanFormula>();
                ArrayDeque<Pair<Integer, CFANode>> callstack = new ArrayDeque<Pair<Integer, CFANode>>();
                for (int end_of_A = 0; end_of_A < itpGroupsIds.size() - 1; ++end_of_A) {
                    int start_of_A = this.getWellScopedStartOfA(orderedFormulas, callstack, end_of_A);
                    interpolants.add(this.getInterpolantFromSublist(((Interpolator)interpolator).itpProver, itpGroupsIds, start_of_A, end_of_A, callstack.size()));
                }
                return interpolants;
            }
            case NESTED: {
                ArrayList<BooleanFormula> interpolants = new ArrayList<BooleanFormula>();
                BooleanFormula lastItp = this.bfmgr.makeBoolean(true);
                ArrayDeque<Triple<BooleanFormula, BooleanFormula, CFANode>> callstack = new ArrayDeque<Triple<BooleanFormula, BooleanFormula, CFANode>>();
                for (int positionOfA = 0; positionOfA < orderedFormulas.size() - 1; ++positionOfA) {
                    lastItp = this.getNestedInterpolant(orderedFormulas, interpolants, callstack, interpolator, positionOfA, lastItp);
                }
                return interpolants;
            }
        }
        throw new AssertionError((Object)"unknown intepolation strategy");
    }

    private int getWellScopedStartOfA(List<Triple<BooleanFormula, AbstractState, Integer>> orderedFormulas, Deque<Pair<Integer, CFANode>> callstack, int end_of_A) {
        Preconditions.checkState((this.direction == CexTraceAnalysisDirection.FORWARDS ? 1 : 0) != 0, (Object)"well-scoped predicated need to traverse the error-trace in a normal way.");
        if (end_of_A == 0) {
            return 0;
        }
        AbstractState abstractionState = (AbstractState)Preconditions.checkNotNull((Object)orderedFormulas.get(end_of_A - 1).getSecond());
        CFANode node = AbstractStates.extractLocation(abstractionState);
        if (node instanceof FunctionEntryNode) {
            callstack.addLast((Pair<Integer, CFANode>)Pair.of((Object)end_of_A, (Object)node));
        }
        if (!callstack.isEmpty()) {
            CFANode lastEntryNode = (CFANode)callstack.getLast().getSecond();
            if (node instanceof FunctionExitNode && ((FunctionExitNode)node).getEntryNode() == lastEntryNode) {
                callstack.removeLast();
            }
        }
        if (callstack.isEmpty()) {
            return 0;
        }
        return (Integer)callstack.getLast().getFirst();
    }

    private <T> BooleanFormula getNestedInterpolant(List<Triple<BooleanFormula, AbstractState, Integer>> orderedFormulas, List<BooleanFormula> interpolants, Deque<Triple<BooleanFormula, BooleanFormula, CFANode>> callstack, Interpolator<T> interpolator, int positionOfA, BooleanFormula lastItp) throws InterruptedException, SolverException {
        try (InterpolatingProverEnvironment itpProver = ((Interpolator)interpolator).newEnvironment();){
            ArrayList A = new ArrayList();
            ArrayList B = new ArrayList();
            AbstractState abstractionState = (AbstractState)Preconditions.checkNotNull((Object)orderedFormulas.get(positionOfA).getSecond());
            CFANode node = AbstractStates.extractLocation(abstractionState);
            if (node instanceof FunctionEntryNode && this.callHasReturn(orderedFormulas, positionOfA)) {
                BooleanFormula call = (BooleanFormula)orderedFormulas.get(positionOfA).getFirst();
                callstack.addLast((Triple<BooleanFormula, BooleanFormula, CFANode>)Triple.of((Object)lastItp, (Object)call, (Object)node));
                BooleanFormula booleanFormula = this.bfmgr.makeBoolean(true);
                interpolants.add(booleanFormula);
                BooleanFormula booleanFormula2 = booleanFormula;
                return booleanFormula2;
            }
            A.add(itpProver.push(lastItp));
            A.add(itpProver.push((BooleanFormula)orderedFormulas.get(positionOfA).getFirst()));
            for (Triple triple : Iterables.skip(orderedFormulas, (int)(positionOfA + 1))) {
                B.add(itpProver.push((BooleanFormula)triple.getFirst()));
            }
            for (Triple triple : callstack) {
                B.add(itpProver.push((BooleanFormula)triple.getFirst()));
                B.add(itpProver.push((BooleanFormula)triple.getSecond()));
            }
            boolean unsat = itpProver.isUnsat();
            assert (unsat) : "formulas were unsat before, they have to be unsat now.";
            BooleanFormula booleanFormula = itpProver.getInterpolant(A);
            if (!callstack.isEmpty() && node instanceof FunctionExitNode) {
                Triple<BooleanFormula, BooleanFormula, CFANode> scopingItp = callstack.removeLast();
                InterpolatingProverEnvironment itpProver2 = ((Interpolator)interpolator).newEnvironment();
                ArrayList A2 = new ArrayList();
                ArrayList B2 = new ArrayList();
                A2.add(itpProver2.push(booleanFormula));
                A2.add(itpProver2.push((BooleanFormula)scopingItp.getFirst()));
                A2.add(itpProver2.push((BooleanFormula)scopingItp.getSecond()));
                for (Triple triple : Iterables.skip(orderedFormulas, (int)(positionOfA + 1))) {
                    B2.add(itpProver2.push((BooleanFormula)triple.getFirst()));
                }
                for (Triple triple : callstack) {
                    B2.add(itpProver2.push((BooleanFormula)triple.getFirst()));
                    B2.add(itpProver2.push((BooleanFormula)triple.getSecond()));
                }
                boolean unsat2 = itpProver2.isUnsat();
                assert (unsat2) : "formulas2 were unsat before, they have to be unsat now.";
                BooleanFormula booleanFormula3 = itpProver2.getInterpolant(A2);
                itpProver2.close();
                interpolants.add(this.rebuildInterpolant(booleanFormula, booleanFormula3));
                BooleanFormula booleanFormula4 = booleanFormula3;
                return booleanFormula4;
            }
            interpolants.add(booleanFormula);
            BooleanFormula booleanFormula5 = booleanFormula;
            return booleanFormula5;
        }
    }

    private BooleanFormula rebuildInterpolant(BooleanFormula functionSummary, BooleanFormula functionExecution) {
        BooleanFormula rebuildItp = this.bfmgr.isTrue(functionSummary) || this.bfmgr.isFalse(functionSummary) ? functionExecution : (this.bfmgr.isTrue(functionExecution) || this.bfmgr.isFalse(functionExecution) ? functionSummary : this.bfmgr.or(functionSummary, functionExecution));
        return rebuildItp;
    }

    private boolean callHasReturn(List<Triple<BooleanFormula, AbstractState, Integer>> orderedFormulas, int callIndex) {
        ArrayDeque<CFANode> callstack = new ArrayDeque<CFANode>();
        AbstractState abstractionState = (AbstractState)orderedFormulas.get(callIndex).getSecond();
        CFANode node = AbstractStates.extractLocation(abstractionState);
        assert (node instanceof FunctionEntryNode) : "call needed as input param";
        callstack.addLast(node);
        for (Triple t : Iterables.skip(orderedFormulas, (int)(callIndex + 1))) {
            assert (!callstack.isEmpty()) : "should have returned when callstack is empty";
            AbstractState abstractionState2 = (AbstractState)Preconditions.checkNotNull((Object)t.getSecond());
            CFANode node2 = AbstractStates.extractLocation(abstractionState2);
            if (node2 instanceof FunctionEntryNode) {
                callstack.addLast(node2);
            }
            CFANode lastEntryNode = (CFANode)callstack.getLast();
            if (!(node2 instanceof FunctionExitNode) || ((FunctionExitNode)node2).getEntryNode() != lastEntryNode) continue;
            callstack.removeLast();
            if (!callstack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private <T> BooleanFormula getInterpolantFromSublist(InterpolatingProverEnvironment<T> pItpProver, List<T> itpGroupsIds, int start_of_A, int end_of_A, int depth) throws SolverException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.ALL, new Object[]{"Looking for interpolant for formulas from", start_of_A, "to", end_of_A, "(depth", depth, ")"});
        this.getInterpolantTimer.start();
        BooleanFormula itp = pItpProver.getInterpolant(itpGroupsIds.subList(start_of_A, end_of_A + 1));
        this.getInterpolantTimer.stop();
        this.logger.log(Level.ALL, new Object[]{"Received interpolant", itp});
        if (this.dumpInterpolationProblems) {
            this.dumpFormulaToFile("interpolant", itp, end_of_A);
        }
        return itp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void verifyInterpolants(List<BooleanFormula> interpolants, List<BooleanFormula> formulas, InterpolatingProverEnvironment<T> prover) throws SolverException, InterruptedException {
        this.interpolantVerificationTimer.start();
        try {
            int n = interpolants.size();
            assert (n == formulas.size() - 1);
            if (!this.solver.implies(formulas.get(0), interpolants.get(0))) {
                throw new SolverException("First interpolant is not implied by first formula");
            }
            for (int i = 1; i <= n - 1; ++i) {
                BooleanFormula conjunct = this.bfmgr.and(interpolants.get(i - 1), formulas.get(i));
                if (this.solver.implies(conjunct, interpolants.get(i))) continue;
                throw new SolverException("Interpolant " + interpolants.get(i) + " is not implied by previous part of the path");
            }
            BooleanFormula conjunct = this.bfmgr.and(interpolants.get(n - 1), formulas.get(n));
            if (!this.solver.implies(conjunct, this.bfmgr.makeBoolean(false))) {
                throw new SolverException("Last interpolant fails to prove infeasibility of the path");
            }
            ArrayList variablesInFormulas = Lists.newArrayListWithExpectedSize((int)formulas.size());
            for (BooleanFormula f : formulas) {
                variablesInFormulas.add(this.fmgr.extractVariableNames(f));
            }
            for (int i = 0; i < interpolants.size(); ++i) {
                HashSet variablesInA = new HashSet();
                for (int j = 0; j <= i; ++j) {
                    variablesInA.addAll((Collection)variablesInFormulas.get(j));
                }
                HashSet variablesInB = new HashSet();
                for (int j = i + 1; j < formulas.size(); ++j) {
                    variablesInB.addAll((Collection)variablesInFormulas.get(j));
                }
                ImmutableSet allowedVariables = Sets.intersection(variablesInA, variablesInB).immutableCopy();
                Set<String> variablesInInterpolant = this.fmgr.extractVariableNames(interpolants.get(i));
                variablesInInterpolant.removeAll((Collection<?>)allowedVariables);
                if (variablesInInterpolant.isEmpty()) continue;
                throw new SolverException("Interpolant " + interpolants.get(i) + " contains forbidden variable(s) " + variablesInInterpolant);
            }
        }
        finally {
            this.interpolantVerificationTimer.stop();
        }
    }

    private CounterexampleTraceInfo getErrorPath(List<BooleanFormula> f, BasicProverEnvironment<?> pProver, Set<ARGState> elementsOnPath) throws CPATransferException, SolverException, InterruptedException {
        boolean stillSatisfiable;
        BooleanFormula branchingFormula = this.pmgr.buildBranchingFormula(elementsOnPath);
        if (this.bfmgr.isTrue(branchingFormula)) {
            return CounterexampleTraceInfo.feasible(f, this.getModel(pProver), (Map<Integer, Boolean>)ImmutableMap.of());
        }
        pProver.push(branchingFormula);
        boolean bl = stillSatisfiable = !pProver.isUnsat();
        if (stillSatisfiable) {
            Model model = this.getModel(pProver);
            return CounterexampleTraceInfo.feasible(f, model, this.pmgr.getBranchingPredicateValuesFromModel(model));
        }
        this.logger.log(Level.WARNING, new Object[]{"Could not get precise error path information because of inconsistent reachingPathsFormula!"});
        this.dumpInterpolationProblem(f);
        this.dumpFormulaToFile("formula", branchingFormula, f.size());
        return CounterexampleTraceInfo.feasible(f, Model.empty(), (Map<Integer, Boolean>)ImmutableMap.of());
    }

    private Model getModel(BasicProverEnvironment<?> pItpProver) {
        try {
            return pItpProver.getModel();
        }
        catch (SolverException e) {
            this.logger.log(Level.WARNING, new Object[]{"Solver could not produce model, variable assignment of error path can not be dumped."});
            this.logger.logDebugException((Throwable)e);
            return Model.empty();
        }
    }

    private void dumpInterpolationProblem(List<BooleanFormula> f) {
        int k = 0;
        for (BooleanFormula formula : f) {
            this.dumpFormulaToFile("formula", formula, k++);
        }
    }

    private void dumpFormulaToFile(String name, BooleanFormula f, int i) {
        Path dumpFile = this.formatFormulaOutputFile(name, i);
        this.fmgr.dumpFormulaToFile(f, dumpFile);
    }

    private Path formatFormulaOutputFile(String formula, int index) {
        return this.fmgr.formatFormulaOutputFile("interpolation", this.cexAnalysisTimer.getNumberOfIntervals(), formula, index);
    }

    private class Interpolator<T> {
        private InterpolatingProverEnvironment<T> itpProver;
        private final List<Triple<BooleanFormula, AbstractState, T>> currentlyAssertedFormulas = new ArrayList<Triple<BooleanFormula, AbstractState, T>>();

        Interpolator() {
            this.itpProver = this.newEnvironment();
        }

        private InterpolatingProverEnvironment<T> newEnvironment() {
            return InterpolationManager.this.solver.newProverEnvironmentWithInterpolation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CounterexampleTraceInfo buildCounterexampleTrace(List<BooleanFormula> f, List<AbstractState> pAbstractionStates, Set<ARGState> elementsOnPath, boolean computeInterpolants) throws CPAException, InterruptedException {
            CounterexampleTraceInfo info;
            boolean spurious;
            ArrayList<Object> itpGroupsIds;
            List orderedFormulas;
            InterpolationManager.this.logger.log(Level.FINEST, new Object[]{"Checking feasibility of counterexample trace"});
            InterpolationManager.this.satCheckTimer.start();
            if (pAbstractionStates.isEmpty()) {
                pAbstractionStates = new ArrayList<Object>(Collections.nCopies(f.size(), null));
            }
            assert (pAbstractionStates.size() == f.size()) : "each pathFormula must end with an abstract State";
            try {
                if (InterpolationManager.this.getUsefulBlocks) {
                    f = Collections.unmodifiableList(InterpolationManager.this.getUsefulBlocks(f));
                }
                if (InterpolationManager.this.dumpInterpolationProblems) {
                    InterpolationManager.this.dumpInterpolationProblem(f);
                }
                orderedFormulas = InterpolationManager.this.orderFormulas(f, pAbstractionStates);
                assert (orderedFormulas.size() == f.size());
                itpGroupsIds = new ArrayList<Object>(Collections.nCopies(f.size(), null));
                spurious = this.checkInfeasabilityOfTrace(orderedFormulas, itpGroupsIds);
                assert (itpGroupsIds.size() == f.size());
                assert (!itpGroupsIds.contains(null));
            }
            finally {
                InterpolationManager.this.satCheckTimer.stop();
            }
            InterpolationManager.this.logger.log(Level.FINEST, new Object[]{"Counterexample trace is", spurious ? "infeasible" : "feasible"});
            if (spurious) {
                if (computeInterpolants) {
                    List interpolants = InterpolationManager.this.getInterpolants(this, itpGroupsIds, orderedFormulas);
                    if (InterpolationManager.this.verifyInterpolants) {
                        InterpolationManager.this.verifyInterpolants(interpolants, f, this.itpProver);
                    }
                    if (InterpolationManager.this.logger.wouldBeLogged(Level.ALL)) {
                        int i = 1;
                        for (BooleanFormula itp : interpolants) {
                            InterpolationManager.this.logger.log(Level.ALL, new Object[]{"For step", i++, "got:", "interpolant", itp});
                        }
                    }
                    info = CounterexampleTraceInfo.infeasible(interpolants);
                } else {
                    info = CounterexampleTraceInfo.infeasibleNoItp();
                }
            } else {
                info = InterpolationManager.this.getErrorPath(f, this.itpProver, elementsOnPath);
            }
            InterpolationManager.this.logger.log(Level.ALL, new Object[]{"Counterexample information:", info});
            return info;
        }

        private boolean checkInfeasabilityOfTrace(List<Triple<BooleanFormula, AbstractState, Integer>> traceFormulas, List<T> itpGroupsIds) throws InterruptedException, SolverException {
            ListIterator<Triple<BooleanFormula, AbstractState, Integer>> todoIterator = traceFormulas.listIterator();
            ListIterator<Triple<BooleanFormula, AbstractState, T>> assertedIterator = this.currentlyAssertedFormulas.listIterator();
            int firstBadIndex = -1;
            while (assertedIterator.hasNext()) {
                Triple<BooleanFormula, AbstractState, T> assertedFormula = assertedIterator.next();
                if (!todoIterator.hasNext()) {
                    firstBadIndex = assertedIterator.previousIndex();
                    break;
                }
                Triple<BooleanFormula, AbstractState, Integer> todoFormula = todoIterator.next();
                if (((BooleanFormula)todoFormula.getFirst()).equals(assertedFormula.getFirst())) {
                    Object itpGroupId = assertedFormula.getThird();
                    itpGroupsIds.set((Integer)todoFormula.getThird(), itpGroupId);
                    continue;
                }
                firstBadIndex = assertedIterator.previousIndex();
                todoIterator.previous();
                break;
            }
            if (firstBadIndex != -1) {
                if (firstBadIndex == 0) {
                    this.itpProver.close();
                    this.itpProver = this.newEnvironment();
                    this.currentlyAssertedFormulas.clear();
                } else {
                    assert (firstBadIndex > 0);
                    List<Triple<BooleanFormula, AbstractState, T>> toDeleteFormulas = this.currentlyAssertedFormulas.subList(firstBadIndex, this.currentlyAssertedFormulas.size());
                    for (int i = 0; i < toDeleteFormulas.size(); ++i) {
                        this.itpProver.pop();
                    }
                    toDeleteFormulas.clear();
                    InterpolationManager.this.reusedFormulasOnSolverStack += this.currentlyAssertedFormulas.size();
                }
            }
            boolean isStillFeasible = true;
            if (InterpolationManager.this.incrementalCheck && !this.currentlyAssertedFormulas.isEmpty() && this.itpProver.isUnsat()) {
                isStillFeasible = false;
            }
            while (todoIterator.hasNext()) {
                Triple<BooleanFormula, AbstractState, Integer> p = todoIterator.next();
                BooleanFormula f = (BooleanFormula)p.getFirst();
                AbstractState state = (AbstractState)p.getSecond();
                int index = (Integer)p.getThird();
                assert (itpGroupsIds.get(index) == null);
                T itpGroupId = this.itpProver.push(f);
                itpGroupsIds.set(index, itpGroupId);
                this.currentlyAssertedFormulas.add(Triple.of((Object)f, (Object)state, itpGroupId));
                if (!InterpolationManager.this.incrementalCheck || !isStillFeasible || InterpolationManager.this.bfmgr.isTrue(f) || !this.itpProver.isUnsat()) continue;
                isStillFeasible = false;
            }
            assert (Iterables.elementsEqual((Iterable)FluentIterable.from(traceFormulas).transform(Triple.getProjectionToFirst()), (Iterable)FluentIterable.from(this.currentlyAssertedFormulas).transform(Triple.getProjectionToFirst())));
            if (InterpolationManager.this.incrementalCheck) {
                return !isStillFeasible;
            }
            return this.itpProver.isUnsat();
        }

        private void close() {
            this.itpProver.close();
            this.itpProver = null;
            this.currentlyAssertedFormulas.clear();
        }
    }

    private static enum InterpolationStrategy {
        CPACHECKER_SEQ,
        INDUCTIVE_SEQ,
        CPACHECKER_WELLSCOPED,
        NESTED;

    }

    private static enum CexTraceAnalysisDirection {
        FORWARDS,
        BACKWARDS,
        ZIGZAG;

    }
}

