/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;

public class SeparateInterpolatingProverEnvironment<T>
implements InterpolatingProverEnvironment<T> {
    private final FormulaManager mainFmgr;
    private final FormulaManager itpFmgr;
    private final InterpolatingProverEnvironment<T> itpEnv;

    public SeparateInterpolatingProverEnvironment(FormulaManager pMainFmgr, FormulaManager pItpFmgr, InterpolatingProverEnvironment<T> pItpEnv) {
        this.mainFmgr = (FormulaManager)Preconditions.checkNotNull((Object)pMainFmgr);
        this.itpFmgr = (FormulaManager)Preconditions.checkNotNull((Object)pItpFmgr);
        this.itpEnv = (InterpolatingProverEnvironment)Preconditions.checkNotNull(pItpEnv);
    }

    @Override
    public T push(BooleanFormula mainF) {
        BooleanFormula itpF = this.itpFmgr.parse(this.mainFmgr.dumpFormula(mainF).toString());
        return this.itpEnv.push(itpF);
    }

    @Override
    public void pop() {
        this.itpEnv.pop();
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        return this.itpEnv.isUnsat();
    }

    @Override
    public void close() {
        this.itpEnv.close();
    }

    @Override
    public BooleanFormula getInterpolant(List<T> pFormulasOfA) throws SolverException {
        BooleanFormula itpF = this.itpEnv.getInterpolant(pFormulasOfA);
        return this.mainFmgr.parse(this.itpFmgr.dumpFormula(itpF).toString());
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<T>> pFormulasOfA) {
        List<BooleanFormula> itps = this.itpEnv.getSeqInterpolants(pFormulasOfA);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (BooleanFormula itp : itps) {
            result.add(this.mainFmgr.parse(this.itpFmgr.dumpFormula(itp).toString()));
        }
        return result;
    }

    @Override
    public Model getModel() throws SolverException {
        return this.itpEnv.getModel();
    }
}

