/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.ldd;

import edu.cmu.sei.rtss.jldd.swig.CIntArray;
import edu.cmu.sei.rtss.jldd.swig.JLDD;
import edu.cmu.sei.rtss.jldd.swig.theory_t;
import java.util.Collection;
import java.util.LinkedList;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.predicates.ldd.ExistsType;
import org.sosy_lab.cpachecker.util.predicates.ldd.LDD;
import org.sosy_lab.cpachecker.util.predicates.ldd.TheoryType;

class LDDFactory {
    private final theory_t theory;
    private final int lddManagerPtr;

    public LDDFactory(int size) {
        this.theory = LDDFactory.createTheory(TheoryType.TVPI, size);
        this.lddManagerPtr = JLDD.jldd_init((theory_t)this.theory);
        this.setExistsType(ExistsType.FM);
        this.setDynamicVariableOrdering(true);
    }

    private static theory_t createTheory(TheoryType type, int size) {
        switch (type) {
            case TVPI: {
                return JLDD.tvpi_create_theory((long)size);
            }
            case TVPIZ: {
                return JLDD.tvpi_create_tvpiz_theory((long)size);
            }
            case UTVPIZ: {
                return JLDD.tvpi_create_utvpiz_theory((long)size);
            }
        }
        assert (false);
        return null;
    }

    public void setExistsType(ExistsType type) {
        switch (type) {
            case FM: {
                JLDD.jldd_use_fm_exists((int)this.lddManagerPtr);
                break;
            }
            case SFM: {
                JLDD.jldd_use_sfm_exists((int)this.lddManagerPtr);
                break;
            }
            case LW: {
                JLDD.jldd_use_lw_exists((int)this.lddManagerPtr);
            }
        }
    }

    public void setDynamicVariableOrdering(boolean enable) {
        if (enable) {
            JLDD.jldd_autodyn_enable((int)this.lddManagerPtr);
        } else {
            JLDD.jldd_autodyn_disable((int)this.lddManagerPtr);
        }
    }

    public LDD zero() {
        return this.createLDD(JLDD.Ldd_GetFalse((int)this.lddManagerPtr));
    }

    public LDD one() {
        return this.createLDD(JLDD.Ldd_GetTrue((int)this.lddManagerPtr));
    }

    private LDD createLDD(int lddPtr) {
        JLDD.jldd_ref((int)lddPtr);
        return new LDD(this, lddPtr);
    }

    public LDD createOr(LDD pLdd, LDD pLdd2) {
        int ldd = JLDD.Ldd_Or((int)this.lddManagerPtr, (int)pLdd.getLddPtr(), (int)pLdd2.getLddPtr());
        return this.createLDD(ldd);
    }

    public LDD createAnd(LDD pLdd, LDD pLdd2) {
        int ldd = JLDD.Ldd_And((int)this.lddManagerPtr, (int)pLdd.getLddPtr(), (int)pLdd2.getLddPtr());
        return this.createLDD(ldd);
    }

    public LDD createXor(LDD pLdd, LDD pLdd2) {
        int ldd = JLDD.Ldd_Xor((int)this.lddManagerPtr, (int)pLdd.getLddPtr(), (int)pLdd2.getLddPtr());
        return this.createLDD(ldd);
    }

    public LDD createExists(LDD pLdd, LDD pLdd2) {
        int ldd = JLDD.Ldd_ExistsAbstract((int)this.lddManagerPtr, (int)pLdd.getLddPtr(), (int)pLdd2.getLddPtr());
        return this.createLDD(ldd);
    }

    public LDD createIfThenElse(LDD condition, LDD positive, LDD negative) {
        int ldd = JLDD.Ldd_Ite((int)this.lddManagerPtr, (int)condition.getLddPtr(), (int)positive.getLddPtr(), (int)negative.getLddPtr());
        return this.createLDD(ldd);
    }

    public LDD makeConstantAssignment(Collection<Pair<Integer, Integer>> varCoeffs, int varCount, int constValue) {
        LDD positive = this.makeNode(varCoeffs, varCount, true, constValue);
        LinkedList<Pair<Integer, Integer>> negVarCoeffs = new LinkedList<Pair<Integer, Integer>>();
        for (Pair<Integer, Integer> varCoefficient : varCoeffs) {
            negVarCoeffs.add((Pair<Integer, Integer>)Pair.of((Object)varCoefficient.getFirst(), (Object)(-((Integer)varCoefficient.getSecond()).intValue())));
        }
        LDD negative = this.makeNode(negVarCoeffs, varCount, true, -constValue);
        return positive.and(negative);
    }

    public LDD makeNode(Collection<Pair<Integer, Integer>> varCoeffs, int varCount, boolean leq, int constValue) {
        int constant = this.theory.create_int_cst(constValue);
        CIntArray array = new CIntArray(varCount);
        for (Pair<Integer, Integer> varCoefficient : varCoeffs) {
            array.setitem(((Integer)varCoefficient.getFirst()).intValue(), ((Integer)varCoefficient.getSecond()).intValue());
        }
        int leqParameter = leq ? 0 : 1;
        int linearTerm = this.theory.create_linterm(array.cast(), (long)varCount);
        int constraint = this.theory.create_cons(linearTerm, leqParameter, constant);
        int ldd = JLDD.Ldd_FromCons((int)this.lddManagerPtr, (int)constraint);
        return this.createLDD(ldd);
    }

    public LDD replace(LDD previous, int varIndex, Collection<Pair<Integer, Integer>> pIndexCoefficients, int varCount, int constValue) {
        int constant = this.theory.create_int_cst(constValue);
        CIntArray array = new CIntArray(varCount);
        for (Pair<Integer, Integer> varCoefficient : pIndexCoefficients) {
            array.setitem(((Integer)varCoefficient.getFirst()).intValue(), ((Integer)varCoefficient.getSecond()).intValue());
        }
        int linearTerm = this.theory.create_linterm(array.cast(), (long)varCount);
        int ldd = JLDD.Ldd_SubstTermForVar((int)this.lddManagerPtr, (int)previous.getLddPtr(), (int)varIndex, (int)linearTerm, (int)constant);
        return this.createLDD(ldd);
    }
}

