/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.logging;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;

public class LoggingInterpolatingProverEnvironment<T>
implements InterpolatingProverEnvironment<T> {
    private final InterpolatingProverEnvironment<T> wrapped;
    private final LogManager logger;
    int level = 0;

    public LoggingInterpolatingProverEnvironment(LogManager logger, InterpolatingProverEnvironment<T> ipe) {
        this.wrapped = ipe;
        this.logger = logger;
    }

    @Override
    public T push(BooleanFormula f) {
        ++this.level;
        this.logger.log(Level.FINER, new Object[]{"up to level " + this.level});
        this.logger.log(Level.FINE, new Object[]{"formula pushed:", f});
        T result = this.wrapped.push(f);
        return result;
    }

    @Override
    public void pop() {
        --this.level;
        this.logger.log(Level.FINER, new Object[]{"down to level " + this.level});
        this.wrapped.pop();
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        boolean result = this.wrapped.isUnsat();
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public BooleanFormula getInterpolant(List<T> formulasOfA) throws SolverException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", formulasOfA});
        BooleanFormula bf = this.wrapped.getInterpolant(formulasOfA);
        this.logger.log(Level.FINE, new Object[]{"interpolant:", bf});
        return bf;
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<T>> formulas) {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", formulas});
        List<BooleanFormula> bf = this.wrapped.getSeqInterpolants(formulas);
        this.logger.log(Level.FINE, new Object[]{"interpolants:", bf});
        return bf;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

