/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.logging;

import com.google.common.base.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class LoggingOptEnvironment
implements OptEnvironment {
    private final OptEnvironment wrapped;
    LogManager logger;

    public LoggingOptEnvironment(LogManager logger, OptEnvironment oe) {
        this.wrapped = oe;
        this.logger = logger;
    }

    @Override
    public void addConstraint(BooleanFormula constraint) {
        this.logger.log(Level.FINE, new Object[]{"Asserting: " + constraint});
        this.wrapped.addConstraint(constraint);
    }

    @Override
    public int maximize(Formula objective) {
        this.logger.log(Level.FINE, new Object[]{"Maximizing: " + objective});
        return this.wrapped.maximize(objective);
    }

    @Override
    public int minimize(Formula objective) {
        this.logger.log(Level.FINE, new Object[]{"Minimizing: " + objective});
        return this.wrapped.minimize(objective);
    }

    @Override
    public OptEnvironment.OptStatus check() throws InterruptedException, SolverException {
        this.logger.log(Level.FINE, new Object[]{"Performing optimization"});
        return this.wrapped.check();
    }

    @Override
    public void push() {
        this.logger.log(Level.FINE, new Object[]{"Creating backtracking point"});
        this.wrapped.push();
    }

    @Override
    public void pop() {
        this.logger.log(Level.FINE, new Object[]{"Backtracking one level"});
        this.wrapped.pop();
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        return this.wrapped.upper(handle, epsilon);
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        return this.wrapped.lower(handle, epsilon);
    }

    @Override
    public Model getModel() throws SolverException {
        return this.wrapped.getModel();
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

