/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.logging;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.NestedTimer;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;

public class LoggingProverEnvironment
implements ProverEnvironment {
    private final ProverEnvironment wrapped;
    LogManager logger;
    int level = 0;

    public LoggingProverEnvironment(LogManager logger, ProverEnvironment pe) {
        this.wrapped = pe;
        this.logger = logger;
    }

    @Override
    public Void push(BooleanFormula f) {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.logger.log(Level.FINE, new Object[]{"formula pushed:", f});
        return (Void)this.wrapped.push(f);
    }

    @Override
    public void pop() {
        this.logger.log(Level.FINER, new Object[]{"down to level " + this.level--});
        this.wrapped.pop();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        boolean result = this.wrapped.isUnsat();
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        List<BooleanFormula> unsatCore = this.wrapped.getUnsatCore();
        this.logger.log(Level.FINE, new Object[]{"unsat-core", unsatCore});
        return unsatCore;
    }

    @Override
    public ProverEnvironment.AllSatResult allSat(Collection<BooleanFormula> important, AbstractionManager.RegionCreator mgr, Timer solveTime, NestedTimer enumTime) throws InterruptedException {
        ProverEnvironment.AllSatResult asr = this.wrapped.allSat(important, mgr, solveTime, enumTime);
        this.logger.log(Level.FINE, new Object[]{"allsat-result:", asr});
        return asr;
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

