/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.matching;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResultImpl;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionElement;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFunctionApplicationPattern;

public abstract class AbstractSmtAstMatcher
implements SmtAstMatcher {
    protected final Multimap<Comparable<?>, Comparable<?>> functionAliases = HashMultimap.create();
    protected final Multimap<Comparable<?>, Comparable<?>> functionImpliedBy = HashMultimap.create();
    protected final Map<Comparable<?>, Comparable<?>> functionRotations = Maps.newHashMap();
    protected final Set<Comparable<?>> commutativeFunctions = Sets.newTreeSet();

    public AbstractSmtAstMatcher() {
        this.defineRotations(">=", "<=");
        this.defineRotations(">", "<");
        this.defineCommutative("=");
        this.defineCommutative("+");
        this.defineCommutative("*");
        this.defineCommutative("and");
        this.defineFunctionAliases("*", Sets.newHashSet((Object[])new String[]{"Integer__*_", "Real__*_"}));
        this.defineFunctionAliases("-", Sets.newHashSet((Object[])new String[]{"Integer__-_", "Real__-_"}));
        this.defineFunctionAliases("+", Sets.newHashSet((Object[])new String[]{"Integer__+_", "Real__+_"}));
    }

    protected SmtAstMatchResult newMatchFailedResult(Object ... pDescription) {
        return SmtAstMatchResult.NOMATCH_RESULT;
    }

    protected SmtAstMatchResult wrapPositiveMatchResult(SmtAstMatchResult pResult, Object ... pDescription) {
        return pResult;
    }

    @Override
    public SmtAstMatchResult perform(SmtAstPatternSelection pPatternSelection, @Nullable Formula pParent, Formula pF, Optional<Multimap<String, Formula>> bBindingRestrictions) {
        return this.matchSelectionOnOneFormula(pParent, pF, new Stack<String>(), pPatternSelection, bBindingRestrictions);
    }

    protected abstract SmtAstMatchResult internalPerform(Formula var1, Formula var2, Stack<String> var3, SmtAstPattern var4, Optional<Multimap<String, Formula>> var5);

    private SmtAstMatchResult matchSelectionOnOneFormula(Formula pParentFormula, Formula pF, Stack<String> pQuantifiedVariables, SmtAstPatternSelection pPatternSelection, Optional<Multimap<String, Formula>> pBindingRestrictions) {
        int matches = 0;
        SmtAstMatchResultImpl aggregatedResult = new SmtAstMatchResultImpl();
        for (SmtAstPatternSelectionElement p : pPatternSelection) {
            SmtAstMatchResult r;
            if (p instanceof SmtAstPattern) {
                SmtAstPattern asp = (SmtAstPattern)p;
                r = this.internalPerform(pParentFormula, pF, pQuantifiedVariables, asp, pBindingRestrictions);
            } else if (p instanceof SmtAstPatternSelection) {
                r = this.matchSelectionOnOneFormula(pParentFormula, pF, pQuantifiedVariables, (SmtAstPatternSelection)p, pBindingRestrictions);
            } else {
                throw new UnsupportedOperationException("Unknown Ast Pattern Type!");
            }
            matches += r.matches() ? 1 : 0;
            if (r.matches() && pPatternSelection.getRelationship().isNone()) {
                return this.newMatchFailedResult("Match but NONE should!");
            }
            if (!r.matches() && pPatternSelection.getRelationship().isAnd()) {
                return this.newMatchFailedResult("No match but ALL should!");
            }
            if (r.matches() && pPatternSelection.getRelationship().isOr()) {
                return this.wrapPositiveMatchResult(r, "OR logic");
            }
            if (!r.matches()) continue;
            aggregatedResult.setMatchingRootFormula(pF);
            aggregatedResult.putMatchingArgumentFormula(p, pF);
            for (String boundVar : r.getBoundVariables()) {
                for (Formula varBinding : r.getVariableBindings(boundVar)) {
                    aggregatedResult.putBoundVaribale(boundVar, varBinding);
                }
            }
        }
        if (matches == 0 && pPatternSelection.getRelationship().isOr()) {
            return this.newMatchFailedResult("No match but ANY should!");
        }
        return this.wrapPositiveMatchResult(aggregatedResult, "Late return");
    }

    protected SmtAstMatchResult handleFunctionApplication(Formula pFunctionRootFormula, Stack<String> pBoundQuantifiedVariables, SmtAstMatchResultImpl result, SmtFunctionApplicationPattern fp, String functionSymbol, ArrayList<Formula> pFunctionArguments, Optional<Multimap<String, Formula>> pBindingRestrictions) {
        boolean considerArgumentsInReverse = false;
        if (fp.function.isPresent()) {
            Comparable<?> functionSymbolRotated;
            boolean isExpectedFunctApp = this.isExpectedFunctionSymbol((Comparable)fp.function.get(), (Comparable<?>)((Object)functionSymbol));
            if (!isExpectedFunctApp && (functionSymbolRotated = this.functionRotations.get(functionSymbol)) != null && this.isExpectedFunctionSymbol((Comparable)fp.function.get(), functionSymbolRotated)) {
                isExpectedFunctApp = true;
                considerArgumentsInReverse = true;
            }
            if (!isExpectedFunctApp) {
                return this.newMatchFailedResult("Function missmatch!", fp.function.get(), functionSymbol);
            }
        }
        if (fp.getArgumentsLogic().isAnd() && fp.getArgumentPatternCount() != pFunctionArguments.size()) {
            return SmtAstMatchResult.NOMATCH_RESULT;
        }
        boolean initialReverseMatching = considerArgumentsInReverse;
        SmtAstMatchResult argumentMatchingResult = this.matchFormulaChildsInSequence(pFunctionRootFormula, pBoundQuantifiedVariables, pFunctionArguments, fp.argumentPatterns, pBindingRestrictions, initialReverseMatching);
        if (!argumentMatchingResult.matches() && this.isCommutative(functionSymbol)) {
            argumentMatchingResult = this.matchFormulaChildsInSequence(pFunctionRootFormula, pBoundQuantifiedVariables, pFunctionArguments, fp.argumentPatterns, pBindingRestrictions, !initialReverseMatching);
        }
        if (argumentMatchingResult.matches()) {
            result.addSubResults(argumentMatchingResult);
            return result;
        }
        return argumentMatchingResult;
    }

    protected SmtAstMatchResult matchFormulaChildsInSequence(Formula pRootFormula, Stack<String> pBoundQuantifiedVariables, List<? extends Formula> pChildFormulas, SmtAstPatternSelection pChildPatterns, Optional<Multimap<String, Formula>> pBindingRestrictions, boolean pConsiderPatternsInReverse) {
        SmtAstPatternSelection.LogicalConnection logic = pChildPatterns.getRelationship();
        Iterator<Object> pItPatternsInSequence = pConsiderPatternsInReverse ? Lists.reverse(pChildPatterns.getPatterns()).iterator() : pChildPatterns.iterator();
        SmtAstMatchResultImpl result = new SmtAstMatchResultImpl();
        result.setMatchingRootFormula(pRootFormula);
        if (logic.isDontCare()) {
            return this.wrapPositiveMatchResult(result, "Dont care");
        }
        HashSet argPatternsMatched = Sets.newHashSet();
        for (Formula formula : pChildFormulas) {
            if (!pItPatternsInSequence.hasNext()) break;
            SmtAstPatternSelectionElement argPattern = (SmtAstPatternSelectionElement)pItPatternsInSequence.next();
            SmtAstMatchResult functionArgumentResult = argPattern instanceof SmtAstPattern ? this.internalPerform(pRootFormula, formula, pBoundQuantifiedVariables, (SmtAstPattern)argPattern, pBindingRestrictions) : this.matchSelectionOnOneFormula(pRootFormula, formula, pBoundQuantifiedVariables, (SmtAstPatternSelection)argPattern, pBindingRestrictions);
            if (functionArgumentResult.matches()) {
                argPatternsMatched.add(argPattern);
                result.putMatchingArgumentFormula(argPattern, formula);
                for (String boundVar : functionArgumentResult.getBoundVariables()) {
                    for (Formula varBinding : functionArgumentResult.getVariableBindings(boundVar)) {
                        result.putBoundVaribale(boundVar, varBinding);
                    }
                }
                if (!logic.isNone()) continue;
                return this.newMatchFailedResult("Match but NONE should!");
            }
            if (!logic.isAnd()) continue;
            return this.newMatchFailedResult("No match but ALL should!");
        }
        if (argPatternsMatched.isEmpty() && logic.isOr()) {
            return this.newMatchFailedResult("No match but ANY should!");
        }
        if (argPatternsMatched.size() != pChildPatterns.getPatterns().size() && logic.isAnd()) {
            return this.newMatchFailedResult("No match but ALL should!");
        }
        return this.wrapPositiveMatchResult(result, "Last in matchFormulaChildsInSequence");
    }

    protected boolean isExpectedFunctionSymbol(Comparable<?> pExpectedSymbol, Comparable<?> pFound) {
        boolean result = pExpectedSymbol.equals(pFound);
        if (!result) {
            Collection definedAliase = this.functionAliases.get(pExpectedSymbol);
            for (Comparable alias : definedAliase) {
                if (!alias.equals(pFound)) continue;
                return true;
            }
        }
        if (!result && this.functionImpliedBy.get(pExpectedSymbol).contains(pFound)) {
            return true;
        }
        return result;
    }

    protected boolean isCommutative(String pFunctionName) {
        return this.commutativeFunctions.contains(pFunctionName);
    }

    @Override
    public void defineCommutative(String pFunctionName) {
        this.commutativeFunctions.add((Comparable<?>)((Object)pFunctionName));
    }

    @Override
    public void defineRotations(String pFunctionName, String pRotationFunctionName) {
        this.functionRotations.put((Comparable<?>)((Object)pFunctionName), (Comparable<?>)((Object)pRotationFunctionName));
        this.functionRotations.put((Comparable<?>)((Object)pRotationFunctionName), (Comparable<?>)((Object)pFunctionName));
    }

    @Override
    public void defineFunctionAliases(String pFunctionName, Set<String> pAliases) {
        this.functionAliases.putAll((Object)pFunctionName, pAliases);
    }

    @Override
    public SmtAstMatchResult perform(SmtAstPatternSelection pPatternSelection, Formula pF) {
        return this.perform(pPatternSelection, null, pF, (Optional<Multimap<String, Formula>>)Optional.absent());
    }
}

