/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.matching;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionElement;

public class SmtAstMatchResultImpl
implements SmtAstMatchResult {
    private final Multimap<SmtAstPatternSelectionElement, Formula> argumentPatternMatches = HashMultimap.create();
    private final Multimap<String, Formula> variableBindings = HashMultimap.create();
    private final Multimap<Formula, String> variableBindingsReverse = HashMultimap.create();
    private Formula matchingRootFormula;

    public void putMatchingArgumentFormula(SmtAstPatternSelectionElement pArgumentPattern, Formula pMatchingFormula) {
        this.argumentPatternMatches.put((Object)pArgumentPattern, (Object)pMatchingFormula);
    }

    public void setMatchingRootFormula(Formula pMatchingFormula) {
        this.matchingRootFormula = pMatchingFormula;
    }

    public void putBoundVaribale(String pVariable, Formula pBoundFormula) {
        this.variableBindings.put((Object)pVariable, (Object)pBoundFormula);
        this.variableBindingsReverse.put((Object)pBoundFormula, (Object)pVariable);
    }

    @Override
    public Collection<Formula> getMatchingArgumentFormula(SmtAstPatternSelectionElement pArgumentPattern) {
        return this.argumentPatternMatches.get((Object)pArgumentPattern);
    }

    @Override
    public Optional<Formula> getMatchingRootFormula() {
        Preconditions.checkNotNull((Object)this.matchingRootFormula);
        return Optional.of((Object)this.matchingRootFormula);
    }

    @Override
    public Collection<Formula> getVariableBindings(String pString) {
        return this.variableBindings.get((Object)pString);
    }

    @Override
    public boolean matches() {
        Preconditions.checkNotNull((Object)this.matchingRootFormula);
        return true;
    }

    @Override
    public Collection<String> getBoundVariables() {
        return this.variableBindings.keySet();
    }

    public String toString() {
        return String.format("VarBindings: %s", this.variableBindings.toString());
    }

    @Override
    public void appendBindingsTo(Multimap<String, Formula> pTarget) {
        pTarget.putAll(this.variableBindings);
    }

    public void addSubResults(SmtAstMatchResult pSubResults) {
        SmtAstMatchResultImpl sr = (SmtAstMatchResultImpl)pSubResults;
        this.argumentPatternMatches.putAll(sr.argumentPatternMatches);
        this.variableBindings.putAll(sr.variableBindings);
    }

    @Override
    public Collection<String> getFormulaBindings(Formula pFormula) {
        return this.variableBindingsReverse.get((Object)pFormula);
    }

    @Override
    public ImmutableMultimap<SmtAstPatternSelectionElement, Formula> getMatchings() {
        return ImmutableMultimap.copyOf(this.argumentPatternMatches);
    }
}

