/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.matching;

import com.google.common.base.Optional;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionElement;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionImpl;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFormulaMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFunctionApplicationPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtQuantificationPattern;

public class SmtAstPatternBuilder {
    public static SmtAstPattern match(Comparable<?> pFunction, SmtAstPattern ... argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.of(pFunction), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.and(argumentMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern match(SmtAstPattern ... argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.and(argumentMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern match(Comparable<?> pFunction, SmtAstPatternSelection pArgumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.of(pFunction), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), pArgumentMatchers, new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchBind(Comparable<?> pFunction, String pBindMatchTo, SmtAstPattern ... argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.of(pFunction), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.and(argumentMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchBind(Comparable<?> pFunction, String pBindMatchTo, SmtAstPatternSelection argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.of(pFunction), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), argumentMatchers, new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchAnyBind(String pBindMatchTo, SmtAstPattern ... argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.and(argumentMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchAnyBind(String pBindMatchTo, SmtAstPatternSelection argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), argumentMatchers, new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchAny(SmtAstPattern ... argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.and(argumentMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchAnyWithArgs(SmtAstPatternSelection argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), argumentMatchers, new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchAnyWithAnyArgs() {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.dontcare(), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchAnyWithAnyArgsBind(String pBindMatchTo) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.dontcare(), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchIfNot(Comparable<?> pFunction, SmtAstPattern ... argumentMatchers) {
        return new SmtFunctionApplicationPattern(Optional.of(pFunction), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.none(argumentMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchIfNot(SmtAstPattern ... pMatchers) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.none(pMatchers), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNullaryBind(String pBindMatchTo) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNumeralExpressionBind(String pBindMatchTo) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.of((Object)new SmtFormulaMatcher(){

            @Override
            public boolean formulaMatches(FormulaManager pMgr, Formula pF) {
                return pMgr.getFormulaType(pF) instanceof FormulaType.NumeralType;
            }
        }), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.dontcare(), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNumeralVariableBind(String pBindMatchTo) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.of((Object)new SmtFormulaMatcher(){

            @Override
            public boolean formulaMatches(FormulaManager pMgr, Formula pF) {
                return pMgr.getUnsafeFormulaManager().isVariable(pF) && pMgr.getFormulaType(pF) instanceof FormulaType.NumeralType;
            }
        }), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchFreeVariableBind(String pBindMatchTo) {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.of((Object)new SmtFormulaMatcher(){

            @Override
            public boolean formulaMatches(FormulaManager pMgr, Formula pF) {
                return pMgr.getUnsafeFormulaManager().isFreeVariable(pF);
            }
        }), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNullaryBind(Comparable<?> pSymbol, String pBindMatchTo) {
        return new SmtFunctionApplicationPattern(Optional.of(pSymbol), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.of((Object)pBindMatchTo), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNullary(Comparable<?> pSymbol) {
        return new SmtFunctionApplicationPattern(Optional.of(pSymbol), (Optional<SmtFormulaMatcher>)Optional.absent(), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNotLiteral() {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.of((Object)new SmtFormulaMatcher(){

            @Override
            public boolean formulaMatches(FormulaManager pMgr, Formula pF) {
                return !pMgr.getUnsafeFormulaManager().isLiteral(pF);
            }
        }), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPattern matchNegativeNumber() {
        return new SmtFunctionApplicationPattern(Optional.absent(), (Optional<SmtFormulaMatcher>)Optional.of((Object)new SmtFormulaMatcher(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean formulaMatches(FormulaManager pMgr, Formula pF) {
                if (!(pF instanceof NumeralFormula)) {
                    return false;
                }
                NumeralFormula.IntegerFormula minusOne = pMgr.getIntegerFormulaManager().makeNumber(-1L);
                if (pF.equals(minusOne)) {
                    return true;
                }
                try (ProverEnvironment prover = pMgr.newProverEnvironment(false, false);){
                    BooleanFormula largerEqualZero = pMgr.getIntegerFormulaManager().greaterOrEquals((NumeralFormula.IntegerFormula)pF, pMgr.getIntegerFormulaManager().makeNumber(0L));
                    prover.push(largerEqualZero);
                    boolean bl = prover.isUnsat();
                    return bl;
                }
                catch (InterruptedException | SolverException e) {
                    return false;
                }
            }
        }), (Optional<String>)Optional.absent(), SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]), new SmtAstPattern.SmtAstMatchFlag[0]);
    }

    public static SmtAstPatternSelection or(SmtAstPatternSelectionElement ... pDisjuncts) {
        return new SmtAstPatternSelectionImpl(SmtAstPatternSelection.LogicalConnection.OR, Arrays.asList(pDisjuncts), Collections.emptyMap());
    }

    public static SmtAstPatternSelection and(SmtAstPatternSelectionElement ... pDisjuncts) {
        return new SmtAstPatternSelectionImpl(SmtAstPatternSelection.LogicalConnection.AND, Arrays.asList(pDisjuncts), Collections.emptyMap());
    }

    public static SmtAstPatternSelection dontcare() {
        return new SmtAstPatternSelectionImpl(SmtAstPatternSelection.LogicalConnection.DONTCARE, Collections.emptyList(), Collections.emptyMap());
    }

    public static SmtAstPatternSelection none(SmtAstPatternSelectionElement ... pDisjuncts) {
        return new SmtAstPatternSelectionImpl(SmtAstPatternSelection.LogicalConnection.NONE, Arrays.asList(pDisjuncts), Collections.emptyMap());
    }

    public static SmtAstPatternSelection withDefaultBinding(String pVariableName, Formula pDefaultBinding, SmtAstPatternSelection pSelection) {
        HashMap defaultBindings = Maps.newHashMap(pSelection.getDefaultBindings());
        defaultBindings.put(pVariableName, pDefaultBinding);
        return new SmtAstPatternSelectionImpl(pSelection.getRelationship(), pSelection.getPatterns(), defaultBindings);
    }

    public static SmtAstPatternSelection concat(SmtAstPatternSelection ... pSelections) {
        HashMap defaultBindings = Maps.newHashMap();
        ArrayList patterns = Lists.newArrayList();
        SmtAstPatternSelection.LogicalConnection logicRelation = null;
        for (SmtAstPatternSelection sel : pSelections) {
            if (logicRelation == null) {
                logicRelation = sel.getRelationship();
            }
            Verify.verify((logicRelation == sel.getRelationship() ? 1 : 0) != 0, (String)"Logic relations must match!", (Object[])new Object[0]);
            for (SmtAstPatternSelectionElement p : sel.getPatterns()) {
                patterns.add(p);
            }
            defaultBindings.putAll(sel.getDefaultBindings());
        }
        return new SmtAstPatternSelectionImpl(logicRelation, patterns, defaultBindings);
    }

    public static SmtAstPattern matchExistsQuant(SmtAstPatternSelection pBodyMatchers) {
        return new SmtQuantificationPattern((Optional<SmtQuantificationPattern.QuantifierType>)Optional.of((Object)((Object)SmtQuantificationPattern.QuantifierType.EXISTS)), (Optional<String>)Optional.absent(), pBodyMatchers);
    }

    public static SmtAstPattern matchExistsQuantBind(String pBindMatchTo, SmtAstPatternSelection pBodyMatchers) {
        return new SmtQuantificationPattern((Optional<SmtQuantificationPattern.QuantifierType>)Optional.of((Object)((Object)SmtQuantificationPattern.QuantifierType.EXISTS)), (Optional<String>)Optional.of((Object)pBindMatchTo), pBodyMatchers);
    }

    public static SmtAstPattern matchForallQuant(SmtAstPatternSelection pBodyMatchers) {
        return new SmtQuantificationPattern((Optional<SmtQuantificationPattern.QuantifierType>)Optional.of((Object)((Object)SmtQuantificationPattern.QuantifierType.FORALL)), (Optional<String>)Optional.absent(), pBodyMatchers);
    }

    public static SmtAstPattern matchForallQuantBind(String pBindMatchTo, SmtAstPatternSelection pBodyMatchers) {
        return new SmtQuantificationPattern((Optional<SmtQuantificationPattern.QuantifierType>)Optional.of((Object)((Object)SmtQuantificationPattern.QuantifierType.FORALL)), (Optional<String>)Optional.of((Object)pBindMatchTo), pBodyMatchers);
    }

    public static SmtAstPattern matchInSubtree(SmtAstPattern pPattern) {
        if (pPattern instanceof SmtFunctionApplicationPattern) {
            SmtFunctionApplicationPattern ap = (SmtFunctionApplicationPattern)pPattern;
            HashSet newFlags = Sets.newHashSet(ap.flags);
            newFlags.add(SmtAstPattern.SmtAstMatchFlag.IN_SUBTREE_RECURSIVE);
            SmtFunctionApplicationPattern patternWithRecursionFlag = new SmtFunctionApplicationPattern(ap.function, ap.customFormulaMatcher, ap.bindMatchTo, ap.argumentPatterns, newFlags.toArray(new SmtAstPattern.SmtAstMatchFlag[newFlags.size()]));
            return patternWithRecursionFlag;
        }
        throw new UnsupportedOperationException("Subtree matching not (yet) available for the requested pattern class!");
    }

    public static SmtAstPatternSelection matchInSubtreeBoundedDepth(int pMaxDepth, SmtAstPattern pPattern) {
        if (pMaxDepth <= 0) {
            return SmtAstPatternBuilder.and(new SmtAstPatternSelectionElement[0]);
        }
        return SmtAstPatternBuilder.or(pPattern, SmtAstPatternBuilder.matchAnyWithArgs(SmtAstPatternBuilder.matchInSubtreeBoundedDepth(pMaxDepth - 1, pPattern)));
    }

    public static String quantified(String pVariableName) {
        return "." + pVariableName;
    }

    public static String parentOf(String pVariableName) {
        return pVariableName + ".parent";
    }
}

