/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.matching;

import java.io.IOException;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionElement;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFunctionApplicationPattern;

public class SmtAstPatternPrinter {
    public static void print(Appendable pOut, SmtAstPattern pPattern) throws IOException {
        SmtAstPatternPrinter.internalPrint(pOut, pPattern, 0);
    }

    public static void print(Appendable pOut, SmtAstPatternSelection pPattern) throws IOException {
        SmtAstPatternPrinter.internalPrint(pOut, pPattern, 0);
    }

    private static void internalPrint(Appendable pOut, SmtAstPatternSelection pPattern, int pDepth) throws IOException {
        String ident = String.format("%" + Integer.valueOf(1 + pDepth * 4) + "s", "");
        pOut.append(String.format("%s%s%n", new Object[]{ident, pPattern.getRelationship()}));
        for (SmtAstPatternSelectionElement elementPattern : pPattern) {
            if (elementPattern instanceof SmtAstPatternSelection) {
                SmtAstPatternPrinter.internalPrint(pOut, (SmtAstPatternSelection)elementPattern, pDepth + 1);
                continue;
            }
            SmtAstPatternPrinter.internalPrint(pOut, (SmtAstPattern)elementPattern, pDepth + 1);
        }
    }

    private static void internalPrint(Appendable pOut, SmtAstPattern pPattern, int pDepth) throws IOException {
        if (pPattern instanceof SmtFunctionApplicationPattern) {
            SmtFunctionApplicationPattern pApp = (SmtFunctionApplicationPattern)pPattern;
            String ident = String.format("%" + Integer.valueOf(1 + pDepth * 4) + "s", "");
            pOut.append(String.format("%s%s%n", ident, pApp.toString()));
            for (SmtAstPatternSelectionElement argP : pApp.getArgumentPatterns(false)) {
                if (argP instanceof SmtAstPatternSelection) {
                    SmtAstPatternPrinter.internalPrint(pOut, (SmtAstPatternSelection)argP, pDepth + 1);
                    continue;
                }
                SmtAstPatternPrinter.internalPrint(pOut, (SmtAstPattern)argP, pDepth + 1);
            }
        }
    }
}

