/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.matching;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternPrinter;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionElement;

public class SmtAstPatternSelectionImpl
implements SmtAstPatternSelection {
    private final ImmutableList<SmtAstPatternSelectionElement> patterns;
    private final SmtAstPatternSelection.LogicalConnection relation;
    private final ImmutableMap<String, Formula> defaultBindings;

    public SmtAstPatternSelectionImpl(SmtAstPatternSelection.LogicalConnection pRelation, Iterable<SmtAstPatternSelectionElement> pDisjuncts, Map<String, Formula> pDefaultBindings) {
        this.relation = pRelation;
        this.patterns = ImmutableList.copyOf(pDisjuncts);
        this.defaultBindings = ImmutableMap.copyOf(pDefaultBindings);
    }

    @Override
    public List<SmtAstPatternSelectionElement> getPatterns() {
        return this.patterns;
    }

    @Override
    public SmtAstPatternSelection.LogicalConnection getRelationship() {
        return this.relation;
    }

    @Override
    public Iterator<SmtAstPatternSelectionElement> iterator() {
        return this.getPatterns().iterator();
    }

    @Override
    public Map<String, Formula> getDefaultBindings() {
        return this.defaultBindings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            SmtAstPatternPrinter.print((Appendable)sb, this);
        }
        catch (IOException e) {
            throw new AssertionError("StringBuilder threw IOException", e);
        }
        return sb.toString();
    }
}

