/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.matching;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelectionElement;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFormulaMatcher;

public class SmtFunctionApplicationPattern
implements SmtAstPattern {
    public final Optional<Comparable<?>> function;
    public final Optional<String> bindMatchTo;
    public final SmtAstPatternSelection argumentPatterns;
    public final ImmutableSet<SmtAstPattern.SmtAstMatchFlag> flags;
    public final Optional<SmtFormulaMatcher> customFormulaMatcher;

    public SmtFunctionApplicationPattern(Optional<Comparable<?>> pFunction, Optional<SmtFormulaMatcher> pCustomFormulaMatcher, Optional<String> pBindMatchTo, SmtAstPatternSelection pArgumentPatterns, SmtAstPattern.SmtAstMatchFlag ... pFlags) {
        this.function = pFunction;
        this.bindMatchTo = pBindMatchTo;
        this.argumentPatterns = pArgumentPatterns;
        this.customFormulaMatcher = pCustomFormulaMatcher;
        this.flags = ImmutableSet.copyOf((Object[])pFlags);
    }

    @Override
    public Optional<String> getBindMatchTo() {
        return this.bindMatchTo;
    }

    public SmtAstPatternSelection.LogicalConnection getArgumentsLogic() {
        return this.argumentPatterns.getRelationship();
    }

    public int getArgumentPatternCount() {
        return this.argumentPatterns.getPatterns().size();
    }

    public Iterator<SmtAstPatternSelectionElement> getArgumentPatternIterator(boolean reversed) {
        return this.getArgumentPatterns(reversed).iterator();
    }

    public List<SmtAstPatternSelectionElement> getArgumentPatterns(boolean reversed) {
        if (reversed) {
            return Lists.reverse(this.argumentPatterns.getPatterns());
        }
        return this.argumentPatterns.getPatterns();
    }

    public String toString() {
        String functionText = this.function.isPresent() ? ((Comparable)this.function.get()).toString() : "?";
        String bindToText = this.bindMatchTo.isPresent() ? ((String)this.bindMatchTo.get()).toString() : "-";
        return String.format("%s | %s | %d args %s", functionText, bindToText, this.argumentPatterns.getPatterns().size(), this.argumentPatterns.getRelationship().toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argumentPatterns == null ? 0 : this.argumentPatterns.hashCode());
        result = 31 * result + (this.bindMatchTo == null ? 0 : this.bindMatchTo.hashCode());
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmtFunctionApplicationPattern)) {
            return false;
        }
        SmtFunctionApplicationPattern other = (SmtFunctionApplicationPattern)obj;
        if (this.argumentPatterns == null ? other.argumentPatterns != null : !this.argumentPatterns.equals(other.argumentPatterns)) {
            return false;
        }
        if (this.bindMatchTo == null ? other.bindMatchTo != null : !this.bindMatchTo.equals(other.bindMatchTo)) {
            return false;
        }
        return !(this.function == null ? other.function != null : !this.function.equals(other.function));
    }
}

