/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Model;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

abstract class Mathsat5AbstractProver {
    protected final Mathsat5FormulaManager mgr;
    protected long curEnv;
    private final long curConfig;
    private final long terminationTest;

    protected Mathsat5AbstractProver(Mathsat5FormulaManager pMgr, long pConfig, boolean pShared, boolean pGhostFilter) {
        this.mgr = pMgr;
        this.curConfig = pConfig;
        this.curEnv = this.mgr.createEnvironment(pConfig, pShared, pGhostFilter);
        this.terminationTest = this.mgr.addTerminationTest(this.curEnv);
    }

    public boolean isUnsat() throws InterruptedException, SolverException {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        try {
            return !Mathsat5NativeApi.msat_check_sat(this.curEnv);
        }
        catch (IllegalStateException e) {
            String msg = Strings.nullToEmpty((String)e.getMessage());
            if (msg.contains("too many iterations") || msg.contains("impossible to build a suitable congruence graph!") || msg.contains("can't produce proofs")) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
    }

    public Model getModel() throws SolverException {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        return Mathsat5Model.createMathsatModel(this.curEnv, this.mgr);
    }

    public void pop() {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
    }

    public void close() {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_destroy_env(this.curEnv);
        this.curEnv = 0L;
        Mathsat5NativeApi.msat_free_termination_test(this.terminationTest);
        Mathsat5NativeApi.msat_destroy_config(this.curConfig);
    }
}

