/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5IntegerFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5RationalFormula;

class Mathsat5FormulaCreator
extends FormulaCreator<Long, Long, Long> {
    public Mathsat5FormulaCreator(Long msatEnv) {
        super(msatEnv, Mathsat5NativeApi.msat_get_bool_type(msatEnv), Mathsat5NativeApi.msat_get_integer_type(msatEnv), Mathsat5NativeApi.msat_get_rational_type(msatEnv));
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        long funcDecl = Mathsat5NativeApi.msat_declare_function((Long)this.getEnv(), varName, type);
        return Mathsat5NativeApi.msat_make_constant((Long)this.getEnv(), funcDecl);
    }

    @Override
    public Long extractInfo(Formula pT) {
        return Mathsat5FormulaManager.getMsatTerm(pT);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        long env = (Long)this.getEnv();
        if (pFormula instanceof BitvectorFormula) {
            long type = Mathsat5NativeApi.msat_term_get_type(this.extractInfo(pFormula));
            Preconditions.checkArgument((boolean)Mathsat5NativeApi.msat_is_bv_type(env, type), (Object)("BitvectorFormula with actual type " + Mathsat5NativeApi.msat_type_repr(type) + ": " + pFormula));
            return FormulaType.getBitvectorTypeWithSize(Mathsat5NativeApi.msat_get_bv_type_size(env, type));
        }
        if (pFormula instanceof FloatingPointFormula) {
            long type = Mathsat5NativeApi.msat_term_get_type(this.extractInfo(pFormula));
            Preconditions.checkArgument((boolean)Mathsat5NativeApi.msat_is_fp_type(env, type), (Object)("FloatingPointFormula with actual type " + Mathsat5NativeApi.msat_type_repr(type) + ": " + pFormula));
            return FormulaType.getFloatingPointType(Mathsat5NativeApi.msat_get_fp_type_exp_width(env, type), Mathsat5NativeApi.msat_get_fp_type_mant_width(env, type));
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long type;
        long env = (Long)this.getEnv();
        if (Mathsat5NativeApi.msat_is_bool_type(env, type = Mathsat5NativeApi.msat_term_get_type(pFormula))) {
            return FormulaType.BooleanType;
        }
        if (Mathsat5NativeApi.msat_is_integer_type(env, type)) {
            return FormulaType.IntegerType;
        }
        if (Mathsat5NativeApi.msat_is_rational_type(env, type)) {
            return FormulaType.RationalType;
        }
        if (Mathsat5NativeApi.msat_is_bv_type(env, type)) {
            return FormulaType.getBitvectorTypeWithSize(Mathsat5NativeApi.msat_get_bv_type_size(env, type));
        }
        if (Mathsat5NativeApi.msat_is_fp_type(env, type)) {
            return FormulaType.getFloatingPointType(Mathsat5NativeApi.msat_get_fp_type_exp_width(env, type), Mathsat5NativeApi.msat_get_fp_type_mant_width(env, type));
        }
        throw new IllegalArgumentException("Unknown formula type " + Mathsat5NativeApi.msat_type_repr(type) + " for term " + Mathsat5NativeApi.msat_term_repr(pFormula));
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        return Mathsat5NativeApi.msat_get_bv_type((Long)this.getEnv(), pBitwidth);
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType pType) {
        return Mathsat5NativeApi.msat_get_fp_type((Long)this.getEnv(), pType.getExponentSize(), pType.getMantissaSize());
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        if (pType.isBooleanType()) {
            return (T)new Mathsat5BooleanFormula(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new Mathsat5IntegerFormula(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new Mathsat5RationalFormula(pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)new Mathsat5BitvectorFormula(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new Mathsat5FloatingPointFormula(pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in MathSAT");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        return new Mathsat5BooleanFormula(pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        return new Mathsat5BitvectorFormula(pTerm);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Long pTerm) {
        return new Mathsat5FloatingPointFormula(pTerm);
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        throw new IllegalArgumentException("MathSAT5.getArrayType(): Implement me!");
    }
}

