/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5ArrayFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5BitvectorFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FloatingPointFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5IntegerFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5InterpolatingProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5RationalFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5UnsafeFormulaManager;

public class Mathsat5FormulaManager
extends AbstractFormulaManager<Long, Long, Long>
implements AutoCloseable {
    private final LogManager logger;
    private final long mathsatConfig;
    private final Mathsat5Settings settings;
    private final ShutdownNotifier shutdownNotifier;
    private final Mathsat5NativeApi.TerminationTest terminationTest;

    private Mathsat5FormulaManager(LogManager pLogger, long pMathsatConfig, Mathsat5FormulaCreator creator, Mathsat5UnsafeFormulaManager unsafeManager, Mathsat5FunctionFormulaManager pFunctionManager, Mathsat5BooleanFormulaManager pBooleanManager, Mathsat5IntegerFormulaManager pIntegerManager, Mathsat5RationalFormulaManager pRationalManager, Mathsat5BitvectorFormulaManager pBitpreciseManager, Mathsat5FloatingPointFormulaManager pFloatingPointmanager, Mathsat5ArrayFormulaManager pArrayManager, Mathsat5Settings pSettings, final ShutdownNotifier pShutdownNotifier) {
        super(creator, unsafeManager, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, pFloatingPointmanager, null, null);
        this.mathsatConfig = pMathsatConfig;
        this.settings = pSettings;
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.terminationTest = new Mathsat5NativeApi.TerminationTest(){

            @Override
            public boolean shouldTerminate() throws InterruptedException {
                pShutdownNotifier.shutdownIfNecessary();
                return false;
            }
        };
    }

    ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    static long getMsatTerm(Formula pT) {
        return ((Mathsat5Formula)pT).getTerm();
    }

    public static Mathsat5FormulaManager create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogFile) throws InvalidConfigurationException {
        Mathsat5Settings settings = new Mathsat5Settings(config, solverLogFile);
        long msatConf = Mathsat5NativeApi.msat_create_config();
        Mathsat5NativeApi.msat_set_option_checked(msatConf, "theory.la.split_rat_eq", "false");
        for (Map.Entry option : settings.furtherOptionsMap.entrySet()) {
            try {
                Mathsat5NativeApi.msat_set_option_checked(msatConf, (String)option.getKey(), (String)option.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        long msatEnv = Mathsat5NativeApi.msat_create_env(msatConf);
        Mathsat5FormulaCreator creator = new Mathsat5FormulaCreator(msatEnv);
        Mathsat5UnsafeFormulaManager unsafeManager = new Mathsat5UnsafeFormulaManager(creator);
        Mathsat5FunctionFormulaManager functionTheory = new Mathsat5FunctionFormulaManager(creator, unsafeManager);
        Mathsat5BooleanFormulaManager booleanTheory = Mathsat5BooleanFormulaManager.create(creator);
        Mathsat5IntegerFormulaManager integerTheory = new Mathsat5IntegerFormulaManager(creator, functionTheory);
        Mathsat5RationalFormulaManager rationalTheory = new Mathsat5RationalFormulaManager(creator, functionTheory);
        Mathsat5BitvectorFormulaManager bitvectorTheory = Mathsat5BitvectorFormulaManager.create(creator);
        Mathsat5FloatingPointFormulaManager floatingPointTheory = new Mathsat5FloatingPointFormulaManager(creator, functionTheory);
        Mathsat5ArrayFormulaManager arrayTheory = null;
        return new Mathsat5FormulaManager(logger, msatConf, creator, unsafeManager, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, floatingPointTheory, arrayTheory, settings, pShutdownNotifier);
    }

    BooleanFormula encapsulateBooleanFormula(long t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public ProverEnvironment newProverEnvironment(boolean pGenerateModels, boolean pGenerateUnsatCore) {
        return new Mathsat5TheoremProver(this, pGenerateModels, pGenerateUnsatCore);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(boolean pShared) {
        return new Mathsat5InterpolatingProver(this, pShared);
    }

    @Override
    public OptEnvironment newOptEnvironment() {
        throw new UnsupportedOperationException("MathSAT5 does not support optimization");
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        long f = Mathsat5NativeApi.msat_from_smtlib2((Long)this.getEnvironment(), pS);
        return this.encapsulateBooleanFormula(f);
    }

    @Override
    public Appender dumpFormula(final Long f) {
        return Appenders.fromToStringMethod((Object)new Object(){

            public String toString() {
                return Mathsat5NativeApi.msat_to_smtlib2((Long)Mathsat5FormulaManager.this.getEnvironment(), f);
            }
        });
    }

    @Override
    public String getVersion() {
        return Mathsat5NativeApi.msat_get_version();
    }

    long createEnvironment(long cfg, boolean shared, boolean ghostFilter) {
        if (ghostFilter) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, "dpll.ghost_filtering", "true");
        }
        Mathsat5NativeApi.msat_set_option_checked(cfg, "theory.la.split_rat_eq", "false");
        for (Map.Entry option : this.settings.furtherOptionsMap.entrySet()) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, (String)option.getKey(), (String)option.getValue());
        }
        if (this.settings.logfile != null) {
            Path filename = this.settings.logfile.getFreshPath();
            try {
                Files.createParentDirs((Path)filename);
            }
            catch (IOException e) {
                this.logger.logException(Level.WARNING, (Throwable)e, "Cannot create directory for MathSAT logfile");
            }
            Mathsat5NativeApi.msat_set_option_checked(cfg, "debug.api_call_trace", "1");
            Mathsat5NativeApi.msat_set_option_checked(cfg, "debug.api_call_trace_filename", filename.toAbsolutePath().toString());
        }
        long env = shared ? Mathsat5NativeApi.msat_create_shared_env(cfg, (Long)this.getEnvironment()) : Mathsat5NativeApi.msat_create_env(cfg);
        return env;
    }

    long addTerminationTest(long env) {
        return Mathsat5NativeApi.msat_set_termination_test(env, this.terminationTest);
    }

    @Override
    public void close() {
        this.logger.log(Level.FINER, new Object[]{"Freeing Mathsat environment"});
        Mathsat5NativeApi.msat_destroy_env((Long)this.getEnvironment());
        Mathsat5NativeApi.msat_destroy_config(this.mathsatConfig);
    }

    @Options(prefix="cpa.predicate.solver.mathsat5")
    private static class Mathsat5Settings {
        @Option(secure=true, description="List of further options which will be passed to Mathsat in addition to the default options. Format is 'key1=value1,key2=value2'")
        private String furtherOptions = "random_seed=42";
        @Nullable
        private final PathCounterTemplate logfile;
        private final ImmutableMap<String, String> furtherOptionsMap;

        private Mathsat5Settings(Configuration config, PathCounterTemplate pLogfile) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.logfile = pLogfile;
            Splitter.MapSplitter optionSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator(Splitter.on((char)'=').limit(2).trimResults());
            try {
                this.furtherOptionsMap = ImmutableMap.copyOf((Map)optionSplitter.split((CharSequence)this.furtherOptions));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Invalid Mathsat option in \"" + this.furtherOptions + "\": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

