/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

class Mathsat5InterpolatingProver
extends Mathsat5AbstractProver
implements InterpolatingProverEnvironment<Integer> {
    private final boolean useSharedEnv;

    Mathsat5InterpolatingProver(Mathsat5FormulaManager pMgr, boolean shared) {
        super(pMgr, Mathsat5InterpolatingProver.createConfig(pMgr), shared, false);
        this.useSharedEnv = shared;
    }

    private static long createConfig(Mathsat5FormulaManager mgr) {
        long cfg = Mathsat5NativeApi.msat_create_config();
        Mathsat5NativeApi.msat_set_option_checked(cfg, "interpolation", "true");
        Mathsat5NativeApi.msat_set_option_checked(cfg, "model_generation", "true");
        Mathsat5NativeApi.msat_set_option_checked(cfg, "theory.bv.eager", "false");
        return cfg;
    }

    @Override
    public Integer push(BooleanFormula f) {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        long t = Mathsat5FormulaManager.getMsatTerm(f);
        if (!this.useSharedEnv) {
            t = Mathsat5NativeApi.msat_make_copy_from(this.curEnv, t, (Long)this.mgr.getEnvironment());
        }
        int group = Mathsat5NativeApi.msat_create_itp_group(this.curEnv);
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
        Mathsat5NativeApi.msat_set_itp_group(this.curEnv, group);
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, t);
        return group;
    }

    @Override
    public BooleanFormula getInterpolant(List<Integer> formulasOfA) throws SolverException {
        long itp;
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        int[] groupsOfA = new int[formulasOfA.size()];
        int i = 0;
        for (Integer f : formulasOfA) {
            groupsOfA[i++] = f;
        }
        try {
            itp = Mathsat5NativeApi.msat_get_interpolant(this.curEnv, groupsOfA);
        }
        catch (IllegalArgumentException e) {
            String msg = Strings.nullToEmpty((String)e.getMessage());
            if (msg.contains("impossible to build a suitable congruence graph") || msg.contains("splitting of AB-mixed terms not supported")) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
        if (!this.useSharedEnv) {
            itp = Mathsat5NativeApi.msat_make_copy_from((Long)this.mgr.getEnvironment(), itp, this.curEnv);
        }
        return this.mgr.encapsulateBooleanFormula(itp);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Integer>> partitionedFormulas) {
        throw new UnsupportedOperationException("directly receiving an inductive sequence of interpolants is not supported.Use another solver or another strategy for interpolants.");
    }
}

