/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import java.math.BigDecimal;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NumeralFormulaManager;

class Mathsat5RationalFormulaManager
extends Mathsat5NumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula> {
    public Mathsat5RationalFormulaManager(Mathsat5FormulaCreator pCreator, Mathsat5FunctionFormulaManager functionManager) {
        super(pCreator, functionManager);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getRationalType();
    }

    @Override
    public FormulaType<NumeralFormula.RationalFormula> getFormulaType() {
        return FormulaType.RationalType;
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl(Double.toString(pNumber));
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return this.makeNumberImpl(pNumber.toPlainString());
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        String n;
        long mathsatEnv = (Long)this.getFormulaCreator().getEnv();
        long t1 = pNumber1;
        long t2 = pNumber2;
        if (Mathsat5NativeApi.msat_term_is_number(mathsatEnv, t2)) {
            String[] frac;
            n = Mathsat5NativeApi.msat_term_repr(t2);
            if (n.startsWith("(")) {
                n = n.substring(1, n.length() - 1);
            }
            if ((frac = n.split("/")).length == 1) {
                n = "1/" + n;
            } else {
                assert (frac.length == 2);
                n = frac[1] + "/" + frac[0];
            }
        } else {
            return super.divide(pNumber1, pNumber2);
        }
        t2 = Mathsat5NativeApi.msat_make_number(mathsatEnv, n);
        long result = Mathsat5NativeApi.msat_make_times(mathsatEnv, t2, t1);
        return result;
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return Mathsat5NativeApi.msat_make_true((Long)this.getFormulaCreator().getEnv());
    }
}

