/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.time.NestedTimer;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

class Mathsat5TheoremProver
extends Mathsat5AbstractProver
implements ProverEnvironment {
    private static final boolean USE_SHARED_ENV = true;

    Mathsat5TheoremProver(Mathsat5FormulaManager pMgr, boolean generateModels, boolean generateUnsatCore) {
        super(pMgr, Mathsat5TheoremProver.createConfig(pMgr, generateModels, generateUnsatCore), true, true);
    }

    private static long createConfig(Mathsat5FormulaManager mgr, boolean generateModels, boolean generateUnsatCore) {
        long cfg = Mathsat5NativeApi.msat_create_config();
        if (generateModels) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, "model_generation", "true");
        }
        if (generateUnsatCore) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, "unsat_core_generation", "1");
        }
        return cfg;
    }

    @Override
    public Void push(BooleanFormula f) {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, Mathsat5FormulaManager.getMsatTerm(f));
        return null;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        long[] terms = Mathsat5NativeApi.msat_get_unsat_core(this.curEnv);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>(terms.length);
        for (long t : terms) {
            result.add(new Mathsat5BooleanFormula(t));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProverEnvironment.AllSatResult allSat(Collection<BooleanFormula> important, AbstractionManager.RegionCreator rmgr, Timer solveTime, NestedTimer enumTime) throws InterruptedException {
        int numModels;
        Preconditions.checkNotNull((Object)rmgr);
        Preconditions.checkNotNull((Object)solveTime);
        Preconditions.checkNotNull((Object)enumTime);
        Preconditions.checkState((this.curEnv != 0L ? 1 : 0) != 0);
        if (important.isEmpty()) {
            throw new RuntimeException("Error occurred during Mathsat allsat: all-sat should not be called with empty 'important'-Collection");
        }
        long[] imp = new long[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            imp[i++] = Mathsat5FormulaManager.getMsatTerm(impF);
        }
        MathsatAllSatCallback callback = new MathsatAllSatCallback(this, rmgr, solveTime, enumTime, this.curEnv);
        solveTime.start();
        try {
            numModels = Mathsat5NativeApi.msat_all_sat(this.curEnv, imp, callback);
        }
        finally {
            if (solveTime.isRunning()) {
                solveTime.stop();
            } else {
                enumTime.stopOuter();
            }
        }
        if (numModels == -1) {
            throw new RuntimeException("Error occurred during Mathsat allsat: " + Mathsat5NativeApi.msat_last_error_message(this.curEnv));
        }
        if (numModels == -2) {
            callback.setInfiniteNumberOfModels();
        } else assert (numModels == callback.count);
        return callback;
    }

    static class MathsatAllSatCallback
    implements Mathsat5NativeApi.AllSatModelCallback,
    ProverEnvironment.AllSatResult {
        private final ShutdownNotifier shutdownNotifier;
        private final AbstractionManager.RegionCreator rmgr;
        private final RegionManager.RegionBuilder builder;
        private final Timer solveTime;
        private final NestedTimer enumTime;
        private Timer regionTime = null;
        private int count = 0;
        private Region formula = null;
        private long env;
        private Mathsat5TheoremProver prover;

        public MathsatAllSatCallback(Mathsat5TheoremProver prover, AbstractionManager.RegionCreator rmgr, Timer pSolveTime, NestedTimer pEnumTime, long env) {
            this.rmgr = rmgr;
            this.prover = prover;
            this.solveTime = pSolveTime;
            this.enumTime = pEnumTime;
            this.env = env;
            this.shutdownNotifier = prover.mgr.getShutdownNotifier();
            this.builder = rmgr.newRegionBuilder(this.shutdownNotifier);
        }

        public void setInfiniteNumberOfModels() {
            this.count = Integer.MAX_VALUE;
            this.formula = this.rmgr.makeTrue();
        }

        @Override
        public int getCount() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Region getResult() throws InterruptedException {
            if (this.formula == null) {
                this.enumTime.startBoth();
                try {
                    this.formula = this.builder.getResult();
                    this.builder.close();
                }
                finally {
                    this.enumTime.stopBoth();
                }
            }
            return this.formula;
        }

        @Override
        public void callback(long[] model) throws InterruptedException {
            if (this.count == 0) {
                this.solveTime.stop();
                this.enumTime.startOuter();
                this.regionTime = this.enumTime.getCurentInnerTimer();
            }
            this.shutdownNotifier.shutdownIfNecessary();
            this.regionTime.start();
            this.builder.startNewConjunction();
            for (long t : model) {
                if (Mathsat5NativeApi.msat_term_is_not(this.env, t)) {
                    t = Mathsat5NativeApi.msat_term_get_arg(t, 0);
                    this.builder.addNegativeRegion(this.rmgr.getPredicate(this.prover.mgr.encapsulateBooleanFormula(t)));
                    continue;
                }
                this.builder.addPositiveRegion(this.rmgr.getPredicate(this.prover.mgr.encapsulateBooleanFormula(t)));
            }
            this.builder.finishConjunction();
            ++this.count;
            this.regionTime.stop();
        }
    }
}

