/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.mathsat5;

import com.google.common.primitives.Longs;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5Formula;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.mathsat5.Mathsat5NativeApi;

class Mathsat5UnsafeFormulaManager
extends AbstractUnsafeFormulaManager<Long, Long, Long> {
    private final long msatEnv;
    private final Mathsat5FormulaCreator creator;

    public Mathsat5UnsafeFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
        this.msatEnv = (Long)pCreator.getEnv();
        this.creator = pCreator;
    }

    @Override
    public boolean isAtom(Long t) {
        return Mathsat5NativeApi.msat_term_is_atom(this.msatEnv, t);
    }

    @Override
    public boolean isLiteral(Long t) {
        return Mathsat5NativeApi.msat_term_is_not(this.msatEnv, t) || this.isAtom(t);
    }

    @Override
    public int getArity(Long pT) {
        return Mathsat5NativeApi.msat_term_arity(pT);
    }

    @Override
    public Formula getArg(Formula pF, int pN) {
        long f = Mathsat5FormulaManager.getMsatTerm(pF);
        long arg = Mathsat5NativeApi.msat_term_get_arg(f, pN);
        if (Mathsat5NativeApi.msat_is_fp_roundingmode_type(this.msatEnv, Mathsat5NativeApi.msat_term_get_type(arg))) {
            return new Mathsat5Formula(f){};
        }
        return super.getArg(pF, pN);
    }

    @Override
    public Long getArg(Long t, int n) {
        return Mathsat5NativeApi.msat_term_get_arg(t, n);
    }

    @Override
    public boolean isVariable(Long t) {
        return Mathsat5NativeApi.msat_term_is_constant(this.msatEnv, t);
    }

    @Override
    public boolean isUF(Long t) {
        return Mathsat5NativeApi.msat_term_is_uf(this.msatEnv, t);
    }

    @Override
    public String getName(Long t) {
        if (this.isUF(t)) {
            return Mathsat5NativeApi.msat_decl_get_name(Mathsat5NativeApi.msat_term_get_decl(t));
        }
        if (this.isVariable(t)) {
            return Mathsat5NativeApi.msat_term_repr(t);
        }
        throw new IllegalArgumentException("Can't get the name from the given formula!");
    }

    @Override
    public Long replaceArgs(Long t, List<Long> newArgs) {
        long tDecl = Mathsat5NativeApi.msat_term_get_decl(t);
        return Mathsat5NativeApi.msat_make_term(this.msatEnv, tDecl, Longs.toArray(newArgs));
    }

    @Override
    public Long replaceName(Long t, String newName) {
        if (this.isUF(t)) {
            long decl = Mathsat5NativeApi.msat_term_get_decl(t);
            int arity = Mathsat5NativeApi.msat_decl_get_arity(decl);
            long retType = Mathsat5NativeApi.msat_decl_get_return_type(decl);
            long[] argTypes = new long[arity];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = Mathsat5NativeApi.msat_decl_get_arg_type(decl, i);
            }
            long funcType = Mathsat5NativeApi.msat_get_function_type(this.msatEnv, argTypes, argTypes.length, retType);
            long funcDecl = Mathsat5NativeApi.msat_declare_function(this.msatEnv, newName, funcType);
            return Mathsat5NativeApi.msat_make_uf(this.msatEnv, funcDecl, Longs.toArray(this.getArguments(t)));
        }
        if (this.isVariable(t)) {
            return this.creator.makeVariable(Mathsat5NativeApi.msat_term_get_type(t), newName);
        }
        throw new IllegalArgumentException("Can't set the name from the given formula!");
    }

    @Override
    public boolean isNumber(Long pT) {
        return Mathsat5NativeApi.msat_term_is_number(this.msatEnv, pT);
    }

    @Override
    protected Long substitute(Long expr, List<Long> substituteFrom, List<Long> substituteTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Long simplify(Long pF) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isQuantification(Long pT) {
        return false;
    }

    @Override
    protected boolean isFreeVariable(Long pT) {
        return this.isVariable(pT);
    }

    @Override
    protected boolean isBoundVariable(Long pT) {
        return false;
    }

    @Override
    protected Long getQuantifiedBody(Long pT) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Long replaceQuantifiedBody(Long pF, Long pBody) {
        throw new UnsupportedOperationException();
    }
}

