/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class CachingPathFormulaManager
implements PathFormulaManager {
    public final Timer pathFormulaComputationTimer = new Timer();
    public int pathFormulaCacheHits = 0;
    public final PathFormulaManager delegate;
    private final Map<Pair<CFAEdge, PathFormula>, Pair<PathFormula, ErrorConditions>> andFormulaWithConditionsCache = new HashMap<Pair<CFAEdge, PathFormula>, Pair<PathFormula, ErrorConditions>>();
    private final Map<Pair<CFAEdge, PathFormula>, PathFormula> andFormulaCache = new HashMap<Pair<CFAEdge, PathFormula>, PathFormula>();
    private final Map<Pair<PathFormula, PathFormula>, PathFormula> orFormulaCache = new HashMap<Pair<PathFormula, PathFormula>, PathFormula>();
    private final Map<PathFormula, PathFormula> emptyFormulaCache = new HashMap<PathFormula, PathFormula>();
    private final PathFormula emptyFormula;

    public CachingPathFormulaManager(PathFormulaManager pDelegate) {
        this.delegate = pDelegate;
        this.emptyFormula = this.delegate.makeEmptyPathFormula();
    }

    @Override
    public Pair<PathFormula, ErrorConditions> makeAndWithErrorConditions(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        Pair formulaCacheKey = Pair.of((Object)pEdge, (Object)pOldFormula);
        Pair<PathFormula, ErrorConditions> result = this.andFormulaWithConditionsCache.get(formulaCacheKey);
        if (result == null) {
            this.pathFormulaComputationTimer.start();
            result = this.delegate.makeAndWithErrorConditions(pOldFormula, pEdge);
            this.pathFormulaComputationTimer.stop();
            this.andFormulaWithConditionsCache.put((Pair<CFAEdge, PathFormula>)formulaCacheKey, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        Pair formulaCacheKey = Pair.of((Object)pEdge, (Object)pOldFormula);
        PathFormula result = this.andFormulaCache.get(formulaCacheKey);
        if (result == null) {
            this.pathFormulaComputationTimer.start();
            result = this.delegate.makeAnd(pOldFormula, pEdge);
            this.pathFormulaComputationTimer.stop();
            this.andFormulaCache.put((Pair<CFAEdge, PathFormula>)formulaCacheKey, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeOr(PathFormula pF1, PathFormula pF2) throws InterruptedException {
        Pair formulaCacheKey = Pair.of((Object)pF1, (Object)pF2);
        PathFormula result = this.orFormulaCache.get(formulaCacheKey);
        if (result == null) {
            result = this.orFormulaCache.get(Pair.of((Object)pF2, (Object)pF1));
        }
        if (result == null) {
            result = this.delegate.makeOr(pF1, pF2);
            this.orFormulaCache.put((Pair<PathFormula, PathFormula>)formulaCacheKey, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeEmptyPathFormula() {
        return this.emptyFormula;
    }

    @Override
    public PathFormula makeEmptyPathFormula(PathFormula pOldFormula) {
        if (pOldFormula.getFormula() == null) {
            return this.delegate.makeEmptyPathFormula(pOldFormula);
        }
        PathFormula result = this.emptyFormulaCache.get(pOldFormula);
        if (result == null) {
            result = this.delegate.makeEmptyPathFormula(pOldFormula);
            this.emptyFormulaCache.put(pOldFormula, result);
        } else {
            ++this.pathFormulaCacheHits;
        }
        return result;
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, BooleanFormula pOtherFormula) {
        return this.delegate.makeAnd(pPathFormula, pOtherFormula);
    }

    @Override
    public PathFormula makeNewPathFormula(PathFormula pOldFormula, SSAMap pM) {
        return this.delegate.makeNewPathFormula(pOldFormula, pM);
    }

    @Override
    public PathFormula makeFormulaForPath(List<CFAEdge> pPath) throws CPATransferException, InterruptedException {
        return this.delegate.makeFormulaForPath(pPath);
    }

    @Override
    public BooleanFormula buildBranchingFormula(Iterable<ARGState> pElementsOnPath) throws CPATransferException, InterruptedException {
        return this.delegate.buildBranchingFormula(pElementsOnPath);
    }

    @Override
    public Map<Integer, Boolean> getBranchingPredicateValuesFromModel(Model pModel) {
        return this.delegate.getBranchingPredicateValuesFromModel(pModel);
    }

    @Override
    public Formula expressionToFormula(PathFormula pFormula, CIdExpression expr, CFAEdge edge) throws UnrecognizedCCodeException {
        return this.delegate.expressionToFormula(pFormula, expr, edge);
    }

    @Override
    public BooleanFormula buildImplicationTestAsUnsat(PathFormula pF1, PathFormula pF2) throws InterruptedException {
        return this.delegate.buildImplicationTestAsUnsat(pF1, pF2);
    }
}

