/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

public final class PathFormula
implements Serializable {
    private static final long serialVersionUID = -7716850731790578619L;
    private final BooleanFormula formula;
    private final SSAMap ssa;
    private final int length;
    private final PointerTargetSet pts;

    public PathFormula(BooleanFormula pf, SSAMap ssa, PointerTargetSet pts, int pLength) {
        this.formula = (BooleanFormula)Preconditions.checkNotNull((Object)pf);
        this.ssa = (SSAMap)Preconditions.checkNotNull((Object)ssa);
        this.pts = (PointerTargetSet)Preconditions.checkNotNull((Object)pts);
        this.length = pLength;
    }

    public BooleanFormula getFormula() {
        return this.formula;
    }

    public SSAMap getSsa() {
        return this.ssa;
    }

    public PointerTargetSet getPointerTargetSet() {
        return this.pts;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return this.getFormula().toString();
    }

    public PathFormula updateFormula(BooleanFormula newConstraint) {
        return new PathFormula(newConstraint, this.ssa, this.pts, this.length);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathFormula)) {
            return false;
        }
        PathFormula other = (PathFormula)obj;
        return this.length == other.length && this.formula.equals(other.formula) && this.ssa.equals(other.ssa) && this.pts.equals(other.pts);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.formula.hashCode();
        result = 31 * result + this.length;
        result = 31 * result + this.pts.hashCode();
        result = 31 * result + this.ssa.hashCode();
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("", e);
        }
    }
}

