/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.CToFormulaConverterWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.CtoFormulaTypeHandlerWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

@Options(prefix="cpa.predicate")
public class PathFormulaManagerImpl
implements PathFormulaManager {
    @Option(secure=true, description="Handle aliasing of pointers. This adds disjunctions to the formulas, so be careful when using cartesian abstraction.")
    private boolean handlePointerAliasing = true;
    @Option(secure=true, description="Handle arrays using the theory of arrays.")
    private boolean handleArrays = false;
    private static final String BRANCHING_PREDICATE_NAME = "__ART__";
    private static final Pattern BRANCHING_PREDICATE_NAME_PATTERN = Pattern.compile("^.*__ART__(?=\\d+$)");
    private static final String NONDET_VARIABLE = "__nondet__";
    private static final String NONDET_FLAG_VARIABLE = "__nondet__flag__";
    private static final CType NONDET_TYPE = CNumericTypes.INT;
    private final FormulaType<?> NONDET_FORMULA_TYPE;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final FunctionFormulaManagerView ffmgr;
    private final CtoFormulaConverter converter;
    private final CtoFormulaTypeHandler typeHandler;
    @Nullable
    private final PointerTargetSetManager ptsManager;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    @Option(secure=true, description="add special information to formulas about non-deterministic functions")
    private boolean useNondetFlags = false;
    private final AnalysisDirection direction;

    @Deprecated
    public PathFormulaManagerImpl(FormulaManagerView pFmgr, Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, MachineModel pMachineModel, AnalysisDirection pDirection) throws InvalidConfigurationException {
        this(pFmgr, config, pLogger, pShutdownNotifier, pMachineModel, (Optional<VariableClassification>)Optional.absent(), pDirection);
    }

    public PathFormulaManagerImpl(FormulaManagerView pFmgr, Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, AnalysisDirection pDirection) throws InvalidConfigurationException {
        this(pFmgr, config, pLogger, pShutdownNotifier, pCfa.getMachineModel(), pCfa.getVarClassification(), pDirection);
    }

    @VisibleForTesting
    PathFormulaManagerImpl(FormulaManagerView pFmgr, Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, AnalysisDirection pDirection) throws InvalidConfigurationException {
        config.inject((Object)this, PathFormulaManagerImpl.class);
        this.fmgr = pFmgr;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.ffmgr = this.fmgr.getFunctionFormulaManager();
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.direction = pDirection;
        if (this.handleArrays) {
            FormulaEncodingOptions options = new FormulaEncodingOptions(config);
            this.typeHandler = new CtoFormulaTypeHandlerWithArrays(pLogger, options, pMachineModel, pFmgr);
            this.converter = this.createCtoFormulaConverterWithArrays(options, pMachineModel, pVariableClassification, this.typeHandler);
            this.ptsManager = null;
            this.logger.log(Level.WARNING, new Object[]{"Handling of pointer aliasing is disabled, analysis is unsound if aliased pointers exist."});
        } else if (this.handlePointerAliasing) {
            FormulaEncodingWithPointerAliasingOptions options = new FormulaEncodingWithPointerAliasingOptions(config);
            TypeHandlerWithPointerAliasing aliasingTypeHandler = new TypeHandlerWithPointerAliasing(pLogger, pMachineModel, pFmgr, options);
            this.typeHandler = aliasingTypeHandler;
            this.ptsManager = new PointerTargetSetManager(options, this.fmgr, aliasingTypeHandler, this.shutdownNotifier);
            this.converter = this.createCToFormulaConverterWithPointerAliasing(options, pMachineModel, this.ptsManager, pVariableClassification, aliasingTypeHandler);
        } else {
            FormulaEncodingOptions options = new FormulaEncodingOptions(config);
            this.typeHandler = new CtoFormulaTypeHandler(pLogger, options, pMachineModel, pFmgr);
            this.converter = this.createCtoFormulaConverter(options, pMachineModel, pVariableClassification, this.typeHandler);
            this.ptsManager = null;
            this.logger.log(Level.WARNING, new Object[]{"Handling of pointer aliasing is disabled, analysis is unsound if aliased pointers exist."});
        }
        this.NONDET_FORMULA_TYPE = this.converter.getFormulaTypeFromCType(NONDET_TYPE);
    }

    private CtoFormulaConverter createCtoFormulaConverterWithArrays(FormulaEncodingOptions pOptions, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, CtoFormulaTypeHandler pTypeHandler) {
        return new CToFormulaConverterWithArrays(pOptions, this.fmgr, pMachineModel, pVariableClassification, this.logger, this.shutdownNotifier, pTypeHandler, this.direction);
    }

    private CtoFormulaConverter createCtoFormulaConverter(FormulaEncodingOptions pOptions, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, CtoFormulaTypeHandler pTypeHandler) {
        return new CtoFormulaConverter(pOptions, this.fmgr, pMachineModel, pVariableClassification, this.logger, this.shutdownNotifier, pTypeHandler, this.direction);
    }

    private CtoFormulaConverter createCToFormulaConverterWithPointerAliasing(FormulaEncodingWithPointerAliasingOptions pOptions, MachineModel pMachineModel, PointerTargetSetManager pPtsManager, Optional<VariableClassification> pVariableClassification, TypeHandlerWithPointerAliasing pAliasingTypeHandler) throws InvalidConfigurationException {
        return new CToFormulaConverterWithPointerAliasing(pOptions, this.fmgr, pMachineModel, pPtsManager, pVariableClassification, this.logger, this.shutdownNotifier, pAliasingTypeHandler, this.direction);
    }

    @Override
    public Pair<PathFormula, ErrorConditions> makeAndWithErrorConditions(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        ErrorConditions errorConditions = new ErrorConditions(this.bfmgr);
        PathFormula pf = this.makeAnd(pOldFormula, pEdge, errorConditions);
        return Pair.of((Object)pf, (Object)errorConditions);
    }

    private PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge, ErrorConditions errorConditions) throws UnrecognizedCCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        int lFlagIndex;
        SSAMap.SSAMapBuilder ssa;
        int lNondetIndex;
        PathFormula pf = this.converter.makeAnd(pOldFormula, pEdge, errorConditions);
        if (this.useNondetFlags && (lNondetIndex = (ssa = pf.getSsa().builder()).getIndex(NONDET_VARIABLE)) != (lFlagIndex = ssa.getIndex(NONDET_FLAG_VARIABLE))) {
            if (lFlagIndex < 0) {
                lFlagIndex = 1;
            }
            BooleanFormula edgeFormula = pf.getFormula();
            for (int lIndex = lFlagIndex + 1; lIndex <= lNondetIndex; ++lIndex) {
                Object nondetVar = this.fmgr.makeVariable(this.NONDET_FORMULA_TYPE, NONDET_FLAG_VARIABLE, lIndex);
                BooleanFormula lAssignment = this.fmgr.assignment(nondetVar, this.fmgr.makeNumber(this.NONDET_FORMULA_TYPE, 1L));
                edgeFormula = this.bfmgr.and(edgeFormula, lAssignment);
            }
            ssa.setIndex(NONDET_FLAG_VARIABLE, NONDET_TYPE, lNondetIndex);
            pf = new PathFormula(edgeFormula, ssa.build(), pf.getPointerTargetSet(), pf.getLength());
        }
        return pf;
    }

    @Override
    public PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        ErrorConditions errorConditions = ErrorConditions.dummyInstance(this.bfmgr);
        return this.makeAnd(pOldFormula, pEdge, errorConditions);
    }

    @Override
    public PathFormula makeEmptyPathFormula() {
        return new PathFormula(this.bfmgr.makeBoolean(true), SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), 0);
    }

    @Override
    public PathFormula makeEmptyPathFormula(PathFormula oldFormula) {
        return new PathFormula(this.bfmgr.makeBoolean(true), oldFormula.getSsa(), oldFormula.getPointerTargetSet(), 0);
    }

    @Override
    public PathFormula makeNewPathFormula(PathFormula oldFormula, SSAMap m) {
        return new PathFormula(oldFormula.getFormula(), m, oldFormula.getPointerTargetSet(), oldFormula.getLength());
    }

    @Override
    public PathFormula makeOr(PathFormula pathFormula1, PathFormula pathFormula2) throws InterruptedException {
        BooleanFormula formula1 = pathFormula1.getFormula();
        BooleanFormula formula2 = pathFormula2.getFormula();
        SSAMap ssa1 = pathFormula1.getSsa();
        SSAMap ssa2 = pathFormula2.getSsa();
        PointerTargetSet pts1 = pathFormula1.getPointerTargetSet();
        PointerTargetSet pts2 = pathFormula2.getPointerTargetSet();
        MergeResult<SSAMap> mergeSSAResult = this.mergeSSAMaps(ssa1, pts1, ssa2, pts2);
        SSAMap newSSA = mergeSSAResult.getResult();
        MergeResult<PointerTargetSet> mergePtsResult = this.ptsManager != null ? this.ptsManager.mergePointerTargetSets(pts1, pts2, newSSA) : MergeResult.trivial(pts1, this.bfmgr);
        BooleanFormula newFormula1 = this.bfmgr.and(formula1, this.bfmgr.and(mergeSSAResult.getLeftConjunct(), mergePtsResult.getLeftConjunct()));
        BooleanFormula newFormula2 = this.bfmgr.and(formula2, this.bfmgr.and(mergeSSAResult.getRightConjunct(), mergePtsResult.getRightConjunct()));
        BooleanFormula newFormula = this.bfmgr.and(this.bfmgr.or(newFormula1, newFormula2), this.bfmgr.and(mergeSSAResult.getFinalConjunct(), mergePtsResult.getFinalConjunct()));
        PointerTargetSet newPTS = mergePtsResult.getResult();
        int newLength = Math.max(pathFormula1.getLength(), pathFormula2.getLength());
        return new PathFormula(newFormula, newSSA, newPTS, newLength);
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, BooleanFormula pOtherFormula) {
        SSAMap ssa = pPathFormula.getSsa();
        BooleanFormula otherFormula = this.fmgr.instantiate(pOtherFormula, ssa);
        BooleanFormula resultFormula = this.bfmgr.and(pPathFormula.getFormula(), otherFormula);
        PointerTargetSet pts = pPathFormula.getPointerTargetSet();
        return new PathFormula(resultFormula, ssa, pts, pPathFormula.getLength());
    }

    private MergeResult<SSAMap> mergeSSAMaps(SSAMap ssa1, PointerTargetSet pts1, SSAMap ssa2, PointerTargetSet pts2) throws InterruptedException {
        Pair<SSAMap, List<Triple<String, Integer, Integer>>> ssaMergeResult = SSAMap.merge(ssa1, ssa2);
        SSAMap resultSSA = (SSAMap)ssaMergeResult.getFirst();
        List symbolDifferences = (List)ssaMergeResult.getSecond();
        BooleanFormula mergeFormula1 = this.bfmgr.makeBoolean(true);
        BooleanFormula mergeFormula2 = this.bfmgr.makeBoolean(true);
        for (Triple symbolDifference : symbolDifferences) {
            BooleanFormula mergeFormula;
            this.shutdownNotifier.shutdownIfNecessary();
            String symbolName = (String)symbolDifference.getFirst();
            CType symbolType = resultSSA.getType(symbolName);
            int index1 = (Integer)MoreObjects.firstNonNull((Object)symbolDifference.getSecond(), (Object)1);
            int index2 = (Integer)MoreObjects.firstNonNull((Object)symbolDifference.getThird(), (Object)1);
            assert (symbolName != null);
            if (index1 > index2 && index1 > 1) {
                mergeFormula = this.makeSsaMerger(symbolName, symbolType, index2, index1, pts2);
                mergeFormula2 = this.bfmgr.and(mergeFormula2, mergeFormula);
                continue;
            }
            if (index2 <= 1) continue;
            assert (index1 < index2);
            mergeFormula = this.makeSsaMerger(symbolName, symbolType, index1, index2, pts1);
            mergeFormula1 = this.bfmgr.and(mergeFormula1, mergeFormula);
        }
        return new MergeResult<SSAMap>(resultSSA, mergeFormula1, mergeFormula2, this.bfmgr.makeBoolean(true));
    }

    private BooleanFormula makeSsaMerger(String symbolName, CType symbolType, int oldIndex, int newIndex, PointerTargetSet oldPts) throws InterruptedException {
        assert (oldIndex > 0);
        assert (newIndex > oldIndex);
        if (this.useNondetFlags && symbolName.equals(NONDET_FLAG_VARIABLE)) {
            return this.makeSsaNondetFlagMerger(oldIndex, newIndex);
        }
        if (CToFormulaConverterWithPointerAliasing.isUF(symbolName)) {
            assert (symbolName.equals(CToFormulaConverterWithPointerAliasing.getUFName(symbolType)));
            return this.makeSsaUFMerger(symbolName, symbolType, oldIndex, newIndex, oldPts);
        }
        return this.makeSsaVariableMerger(symbolName, symbolType, oldIndex, newIndex);
    }

    private BooleanFormula makeSsaVariableMerger(String variableName, CType variableType, int oldIndex, int newIndex) {
        assert (oldIndex < newIndex);
        FormulaType<?> variableFormulaType = this.converter.getFormulaTypeFromCType(variableType);
        Object oldVariable = this.fmgr.makeVariable(variableFormulaType, variableName, oldIndex);
        Object newVariable = this.fmgr.makeVariable(variableFormulaType, variableName, newIndex);
        return this.fmgr.assignment(newVariable, oldVariable);
    }

    private BooleanFormula makeSsaUFMerger(String functionName, CType returnType, int oldIndex, int newIndex, PointerTargetSet pts) throws InterruptedException {
        assert (oldIndex < newIndex);
        FormulaType<?> returnFormulaType = this.converter.getFormulaTypeFromCType(returnType);
        BooleanFormula result = this.bfmgr.makeBoolean(true);
        for (PointerTarget target : pts.getAllTargets(returnType)) {
            this.shutdownNotifier.shutdownIfNecessary();
            Object targetAddress = this.fmgr.makePlus(this.fmgr.makeVariable(this.typeHandler.getPointerType(), target.getBaseName()), this.fmgr.makeNumber(this.typeHandler.getPointerType(), target.getOffset()));
            BooleanFormula retention = this.fmgr.assignment(this.ffmgr.declareAndCallUninterpretedFunction(functionName, newIndex, returnFormulaType, new Formula[]{targetAddress}), this.ffmgr.declareAndCallUninterpretedFunction(functionName, oldIndex, returnFormulaType, new Formula[]{targetAddress}));
            result = this.fmgr.makeAnd(result, retention);
        }
        return result;
    }

    private BooleanFormula makeSsaNondetFlagMerger(int iSmaller, int iBigger) {
        Object pInitialValue = this.fmgr.makeNumber(this.NONDET_FORMULA_TYPE, 0L);
        assert (iSmaller < iBigger);
        BooleanFormula lResult = this.bfmgr.makeBoolean(true);
        FormulaType<?> type = this.fmgr.getFormulaType(pInitialValue);
        for (int i = iSmaller + 1; i <= iBigger; ++i) {
            Object currentVar = this.fmgr.makeVariable(type, NONDET_FLAG_VARIABLE, i);
            BooleanFormula e = this.fmgr.assignment(currentVar, pInitialValue);
            lResult = this.bfmgr.and(lResult, e);
        }
        return lResult;
    }

    private BooleanFormula addMergeAssumptions(BooleanFormula pFormula, SSAMap ssa1, PointerTargetSet pts1, SSAMap ssa2) throws InterruptedException {
        Pair<SSAMap, List<Triple<String, Integer, Integer>>> ssaMergeResult = SSAMap.merge(ssa1, ssa2);
        SSAMap resultSSA = (SSAMap)ssaMergeResult.getFirst();
        List symbolDifferences = (List)ssaMergeResult.getSecond();
        BooleanFormula mergeFormula1 = pFormula;
        for (Triple symbolDifference : symbolDifferences) {
            this.shutdownNotifier.shutdownIfNecessary();
            String symbolName = (String)symbolDifference.getFirst();
            CType symbolType = resultSSA.getType(symbolName);
            int index1 = (Integer)MoreObjects.firstNonNull((Object)symbolDifference.getSecond(), (Object)1);
            int index2 = (Integer)MoreObjects.firstNonNull((Object)symbolDifference.getThird(), (Object)1);
            assert (symbolName != null);
            if (index1 > index2 && index1 > 1) {
                return this.bfmgr.makeBoolean(true);
            }
            if (index2 <= 1) continue;
            assert (index1 < index2);
            for (int i = index1; i < index2; ++i) {
                BooleanFormula mergeFormula = this.makeSsaMerger(symbolName, symbolType, i, i + 1, pts1);
                mergeFormula1 = this.bfmgr.and(mergeFormula1, mergeFormula);
            }
        }
        return mergeFormula1;
    }

    @Override
    public PathFormula makeFormulaForPath(List<CFAEdge> pPath) throws CPATransferException, InterruptedException {
        PathFormula pathFormula = this.makeEmptyPathFormula();
        for (CFAEdge edge : pPath) {
            pathFormula = this.makeAnd(pathFormula, edge);
        }
        return pathFormula;
    }

    @Override
    public BooleanFormula buildBranchingFormula(Iterable<ARGState> elementsOnPath) throws CPATransferException, InterruptedException {
        BooleanFormula branchingFormula = this.bfmgr.makeBoolean(true);
        for (final ARGState pathElement : elementsOnPath) {
            if (pathElement.getChildren().size() <= 1) continue;
            if (pathElement.getChildren().size() > 2) {
                if (FluentIterable.from(pathElement.getChildren()).anyMatch(AbstractStates.IS_TARGET_STATE)) continue;
                this.logger.log(Level.WARNING, new Object[]{"ARG branching with more than two outgoing edges at ARG node " + pathElement.getStateId() + "."});
                return this.bfmgr.makeBoolean(true);
            }
            FluentIterable outgoingEdges = FluentIterable.from(pathElement.getChildren()).transform((Function)new Function<ARGState, CFAEdge>(){

                public CFAEdge apply(ARGState child) {
                    return pathElement.getEdgeToChild(child);
                }
            });
            if (!outgoingEdges.allMatch(Predicates.instanceOf(AssumeEdge.class))) {
                if (FluentIterable.from(pathElement.getChildren()).anyMatch(AbstractStates.IS_TARGET_STATE)) continue;
                this.logger.log(Level.WARNING, new Object[]{"ARG branching without AssumeEdge at ARG node " + pathElement.getStateId() + "."});
                return this.bfmgr.makeBoolean(true);
            }
            AssumeEdge edge = null;
            for (CFAEdge currentEdge : outgoingEdges) {
                if (!((AssumeEdge)currentEdge).getTruthAssumption()) continue;
                edge = (AssumeEdge)currentEdge;
                break;
            }
            assert (edge != null);
            BooleanFormula pred = this.bfmgr.makeVariable(BRANCHING_PREDICATE_NAME + pathElement.getStateId(), 0);
            PredicateAbstractState pe = AbstractStates.extractStateByType(pathElement, PredicateAbstractState.class);
            if (pe == null) {
                this.logger.log(Level.WARNING, new Object[]{"Cannot find precise error path information without PredicateCPA"});
                return this.bfmgr.makeBoolean(true);
            }
            PathFormula pf = pe.getPathFormula();
            pf = this.makeEmptyPathFormula(pf);
            pf = this.makeAnd(pf, edge);
            BooleanFormula equiv = this.bfmgr.equivalence(pred, pf.getFormula());
            branchingFormula = this.bfmgr.and(branchingFormula, equiv);
        }
        return branchingFormula;
    }

    @Override
    public Map<Integer, Boolean> getBranchingPredicateValuesFromModel(Model model) {
        if (model.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"No satisfying assignment given by solver!"});
            return Collections.emptyMap();
        }
        HashMap preds = Maps.newHashMap();
        for (Map.Entry entry : model.entrySet()) {
            String name;
            Model.AssignableTerm a = (Model.AssignableTerm)entry.getKey();
            if (!(a instanceof Model.Variable) || a.getType() != Model.TermType.Boolean || (name = BRANCHING_PREDICATE_NAME_PATTERN.matcher(a.getName()).replaceFirst("")).equals(a.getName())) continue;
            Integer nodeId = Integer.parseInt(name);
            assert (!preds.containsKey(nodeId));
            preds.put(nodeId, (Boolean)entry.getValue());
        }
        return preds;
    }

    @Override
    public Formula expressionToFormula(PathFormula pFormula, CIdExpression expr, CFAEdge edge) throws UnrecognizedCCodeException {
        return this.converter.buildTermFromPathFormula(pFormula, expr, edge);
    }

    @Override
    public BooleanFormula buildImplicationTestAsUnsat(PathFormula pF1, PathFormula pF2) throws InterruptedException {
        BooleanFormula bF = pF2.getFormula();
        bF = this.bfmgr.not(bF);
        bF = this.bfmgr.and(this.addMergeAssumptions(pF1.getFormula(), pF1.getSsa(), pF1.getPointerTargetSet(), pF2.getSsa()), bF);
        return bF;
    }

    public static class MergeResult<T> {
        private final BooleanFormula leftConjunct;
        private final BooleanFormula rightConjunct;
        private final BooleanFormula finalConjunct;
        private final T result;

        public MergeResult(T pResult, BooleanFormula pLeftConjunct, BooleanFormula pRightConjunct, BooleanFormula pFinalConjunct) {
            this.result = Preconditions.checkNotNull(pResult);
            this.leftConjunct = (BooleanFormula)Preconditions.checkNotNull((Object)pLeftConjunct);
            this.rightConjunct = (BooleanFormula)Preconditions.checkNotNull((Object)pRightConjunct);
            this.finalConjunct = (BooleanFormula)Preconditions.checkNotNull((Object)pFinalConjunct);
        }

        public static <T> MergeResult<T> trivial(T result, BooleanFormulaManagerView bfmgr) {
            BooleanFormula trueFormula = bfmgr.makeBoolean(true);
            return new MergeResult<T>(result, trueFormula, trueFormula, trueFormula);
        }

        BooleanFormula getLeftConjunct() {
            return this.leftConjunct;
        }

        BooleanFormula getRightConjunct() {
            return this.rightConjunct;
        }

        BooleanFormula getFinalConjunct() {
            return this.finalConjunct;
        }

        T getResult() {
            return this.result;
        }
    }
}

