/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class PathFormulaManagerImplArraysTest0
extends SolverBasedTest0 {
    private static final CArrayType unlimitedIntArrayType = new CArrayType(false, false, CNumericTypes.INT, null);
    private Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _a;
    private CArraySubscriptExpression _a_at_1;
    private CArraySubscriptExpression _a_at_2;
    private CArraySubscriptExpression _a_at_3;
    private CArraySubscriptExpression _a_at_0;
    private CIntegerLiteralExpression _1;
    private CIntegerLiteralExpression _2;
    private CIntegerLiteralExpression _10;
    private CIntegerLiteralExpression _20;
    private CIntegerLiteralExpression _30;
    private CIntegerLiteralExpression _100;
    private PathFormulaManagerImpl pfmgrFwd;
    private PathFormulaManagerImpl pfmgrBwd;
    private CBinaryExpressionBuilder eb;
    private FormulaManagerView mgv;
    private Solver solver;
    private CExpression _0;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Before
    public void setUp() throws Exception {
        Configuration myConfig = Configuration.builder().copyFrom(this.config).setOption("cpa.predicate.handlePointerAliasing", "false").setOption("cpa.predicate.handleArrays", "true").build();
        this.mgv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.solver = new Solver(this.mgv, this.factory, this.config, TestLogManager.getInstance());
        this.pfmgrFwd = new PathFormulaManagerImpl(this.mgv, myConfig, TestLogManager.getInstance(), ShutdownNotifier.create(), MachineModel.LINUX32, (Optional<VariableClassification>)Optional.absent(), AnalysisDirection.FORWARD);
        this.pfmgrBwd = new PathFormulaManagerImpl(this.mgv, myConfig, TestLogManager.getInstance(), ShutdownNotifier.create(), MachineModel.LINUX32, (Optional<VariableClassification>)Optional.absent(), AnalysisDirection.BACKWARD);
        this.eb = new CBinaryExpressionBuilder(MachineModel.LINUX64, this.logger);
        this._a = TestDataTools.makeDeclaration("a", unlimitedIntArrayType, null);
        this._0 = CIntegerLiteralExpression.createDummyLiteral(0L, CNumericTypes.INT);
        this._1 = CIntegerLiteralExpression.createDummyLiteral(1L, CNumericTypes.INT);
        this._2 = CIntegerLiteralExpression.createDummyLiteral(2L, CNumericTypes.INT);
        this._10 = CIntegerLiteralExpression.createDummyLiteral(10L, CNumericTypes.INT);
        this._20 = CIntegerLiteralExpression.createDummyLiteral(20L, CNumericTypes.INT);
        this._30 = CIntegerLiteralExpression.createDummyLiteral(30L, CNumericTypes.INT);
        this._100 = CIntegerLiteralExpression.createDummyLiteral(100L, CNumericTypes.INT);
        this._a_at_0 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), CIntegerLiteralExpression.ZERO);
        this._a_at_1 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), CIntegerLiteralExpression.ONE);
        this._a_at_2 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), CIntegerLiteralExpression.createDummyLiteral(2L, CNumericTypes.INT));
        this._a_at_3 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), CIntegerLiteralExpression.createDummyLiteral(2L, CNumericTypes.INT));
    }

    @Test
    public void testForwardArrayPathSat1() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isFalse();
    }

    @Test
    public void testForwardArrayPathUnsat1() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testForwardArrayPathSat2() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_1, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isFalse();
    }

    @Test
    public void testForwardArrayPathUnsat2() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_1, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._2, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testForwardArrayPathUnsat3() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_0, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testForwardArrayPathSat3() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_0, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isFalse();
    }

    @Test
    public void testForwardArrayBranchingUnsat1() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._0);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CAssumeEdge, CExpression> _op5 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CFAEdge, CExpressionAssignmentStatement> _op3 = TestDataTools.makeAssignment(this._a_at_2, this._20);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op4 = TestDataTools.makeAssignment(this._a_at_3, this._30);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op6 = TestDataTools.makeAssignment(this._a_at_2, this._0);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op7 = TestDataTools.makeAssignment(this._a_at_3, this._0);
        Pair<CAssumeEdge, CExpression> _op8 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_2, this._100, CBinaryExpression.BinaryOperator.GREATER_THAN));
        PathFormula branch1 = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst(), (CFAEdge)_op4.getFirst()}));
        PathFormula branch2 = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op5.getFirst(), (CFAEdge)_op6.getFirst(), (CFAEdge)_op7.getFirst()}));
        PathFormula result = this.pfmgrFwd.makeOr(branch1, branch2);
        result = this.pfmgrFwd.makeAnd(result, (CFAEdge)_op8.getFirst());
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testForwardArrayBranchingUnsat2() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._0);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CAssumeEdge, CExpression> _op5 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CFAEdge, CExpressionAssignmentStatement> _op3 = TestDataTools.makeAssignment(this._a_at_2, this._20);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op4 = TestDataTools.makeAssignment(this._a_at_3, this._30);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op6 = TestDataTools.makeAssignment(this._a_at_2, this._0);
        Pair<CAssumeEdge, CExpression> _op8 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_2, this._100, CBinaryExpression.BinaryOperator.GREATER_THAN));
        PathFormula branch1 = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst(), (CFAEdge)_op4.getFirst()}));
        PathFormula branch2 = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op5.getFirst(), (CFAEdge)_op6.getFirst()}));
        PathFormula result = this.pfmgrFwd.makeOr(branch1, branch2);
        result = this.pfmgrFwd.makeAnd(result, (CFAEdge)_op8.getFirst());
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testForwardArrayBranchingUnsat3() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._0);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CAssumeEdge, CExpression> _op5 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CFAEdge, CExpressionAssignmentStatement> _op3 = TestDataTools.makeAssignment(this._a_at_2, this._20);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op4 = TestDataTools.makeAssignment(this._a_at_3, this._30);
        Pair<CAssumeEdge, CExpression> _op8 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_2, this._100, CBinaryExpression.BinaryOperator.GREATER_THAN));
        PathFormula branch1 = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op3.getFirst(), (CFAEdge)_op4.getFirst()}));
        PathFormula branch2 = this.pfmgrFwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op1.getFirst(), (CFAEdge)_op5.getFirst()}));
        PathFormula result = this.pfmgrFwd.makeOr(branch1, branch2);
        result = this.pfmgrFwd.makeAnd(result, (CFAEdge)_op8.getFirst());
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testBackwardArrayPathSat1() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op2.getFirst(), (CFAEdge)_op1.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isFalse();
    }

    @Test
    public void testBackwardArrayPathUnsat1() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op2.getFirst(), (CFAEdge)_op1.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testBackwardArrayPathSat2() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_1, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op1.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isFalse();
    }

    @Test
    public void testBackwardArrayPathUnsat2() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_1, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._2, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op1.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testBackwardArrayPathUnsat3() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_0, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op1.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testBackwardArrayPathSat3() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._1);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op2 = TestDataTools.makeAssignment(this._a_at_0, this._2);
        Pair<CAssumeEdge, CExpression> _op3 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._1, CBinaryExpression.BinaryOperator.EQUALS));
        PathFormula result = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst(), (CFAEdge)_op1.getFirst()}));
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isFalse();
    }

    @Test
    public void testBackwardArrayBranchingUnsat1() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._0);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CAssumeEdge, CExpression> _op5 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CFAEdge, CExpressionAssignmentStatement> _op3 = TestDataTools.makeAssignment(this._a_at_2, this._20);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op4 = TestDataTools.makeAssignment(this._a_at_3, this._30);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op6 = TestDataTools.makeAssignment(this._a_at_2, this._0);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op7 = TestDataTools.makeAssignment(this._a_at_3, this._0);
        Pair<CAssumeEdge, CExpression> _op8 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_2, this._100, CBinaryExpression.BinaryOperator.GREATER_THAN));
        PathFormula branch1 = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op8.getFirst(), (CFAEdge)_op4.getFirst(), (CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst()}));
        PathFormula branch2 = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op8.getFirst(), (CFAEdge)_op7.getFirst(), (CFAEdge)_op6.getFirst(), (CFAEdge)_op5.getFirst()}));
        PathFormula result = this.pfmgrBwd.makeOr(branch1, branch2);
        result = this.pfmgrBwd.makeAnd(result, (CFAEdge)_op1.getFirst());
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testBackwardArrayBranchingUnsat2() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._0);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CAssumeEdge, CExpression> _op5 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CFAEdge, CExpressionAssignmentStatement> _op3 = TestDataTools.makeAssignment(this._a_at_2, this._20);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op4 = TestDataTools.makeAssignment(this._a_at_3, this._30);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op6 = TestDataTools.makeAssignment(this._a_at_2, this._0);
        Pair<CAssumeEdge, CExpression> _op8 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_2, this._100, CBinaryExpression.BinaryOperator.GREATER_THAN));
        PathFormula branch1 = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op8.getFirst(), (CFAEdge)_op4.getFirst(), (CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst()}));
        PathFormula branch2 = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op8.getFirst(), (CFAEdge)_op6.getFirst(), (CFAEdge)_op5.getFirst()}));
        PathFormula result = this.pfmgrBwd.makeOr(branch1, branch2);
        result = this.pfmgrBwd.makeAnd(result, (CFAEdge)_op1.getFirst());
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }

    @Test
    public void testBackwardArrayBranchingUnsat3() throws CPATransferException, InterruptedException, SolverException {
        Pair<CFAEdge, CExpressionAssignmentStatement> _op1 = TestDataTools.makeAssignment(this._a_at_0, this._0);
        Pair<CAssumeEdge, CExpression> _op2 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CAssumeEdge, CExpression> _op5 = TestDataTools.makeNegatedAssume(this.eb.buildBinaryExpression(this._a_at_0, this._10, CBinaryExpression.BinaryOperator.EQUALS));
        Pair<CFAEdge, CExpressionAssignmentStatement> _op3 = TestDataTools.makeAssignment(this._a_at_2, this._20);
        Pair<CFAEdge, CExpressionAssignmentStatement> _op4 = TestDataTools.makeAssignment(this._a_at_3, this._30);
        Pair<CAssumeEdge, CExpression> _op8 = TestDataTools.makeAssume(this.eb.buildBinaryExpression(this._a_at_2, this._100, CBinaryExpression.BinaryOperator.GREATER_THAN));
        PathFormula branch1 = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op8.getFirst(), (CFAEdge)_op4.getFirst(), (CFAEdge)_op3.getFirst(), (CFAEdge)_op2.getFirst()}));
        PathFormula branch2 = this.pfmgrBwd.makeFormulaForPath(Lists.newArrayList((Object[])new CFAEdge[]{(CFAEdge)_op8.getFirst(), (CFAEdge)_op5.getFirst()}));
        PathFormula result = this.pfmgrBwd.makeOr(branch1, branch2);
        result = this.pfmgrBwd.makeAnd(result, (CFAEdge)_op1.getFirst());
        Truth.assertThat((Boolean)this.solver.isUnsat(result.getFormula())).isTrue();
    }
}

