/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Optional;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collections;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.test.BooleanFormulaSubject;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

public class PathFormulaManagerImplTest
extends SolverBasedTest0 {
    private FormulaManagerView fmgr;
    private PathFormulaManager pfmgrFwd;
    private PathFormulaManager pfmgrBwd;
    private CDeclarationEdge x_decl;

    @Before
    public void setup() throws Exception {
        Configuration configBackwards = Configuration.builder().copyFrom(this.config).setOption("cpa.predicate.handlePointerAliasing", "false").build();
        this.fmgr = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.pfmgrFwd = new PathFormulaManagerImpl(this.fmgr, this.config, TestLogManager.getInstance(), ShutdownNotifier.create(), MachineModel.LINUX32, (Optional<VariableClassification>)Optional.absent(), AnalysisDirection.FORWARD);
        this.pfmgrBwd = new PathFormulaManagerImpl(this.fmgr, configBackwards, TestLogManager.getInstance(), ShutdownNotifier.create(), MachineModel.LINUX32, (Optional<VariableClassification>)Optional.absent(), AnalysisDirection.BACKWARD);
    }

    private Triple<CFAEdge, CFAEdge, MutableCFA> createCFA() throws UnrecognizedCCodeException {
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(MachineModel.LINUX32, TestLogManager.getInstance());
        String fName = "main";
        TreeMap<String, FunctionEntryNode> functions = new TreeMap<String, FunctionEntryNode>();
        FunctionEntryNode entryNode = this.dummyFunction(fName);
        CFANode a = new CFANode(fName);
        CFANode b = new CFANode(fName);
        BlankEdge init = new BlankEdge("", FileLocation.DUMMY, entryNode, a, "init");
        entryNode.addLeavingEdge(init);
        a.addEnteringEdge(init);
        CVariableDeclaration xDeclaration = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, CNumericTypes.INT, "x", "x", "x", new CInitializerExpression(FileLocation.DUMMY, CIntegerLiteralExpression.ZERO));
        this.x_decl = new CDeclarationEdge("int x = 0", FileLocation.DUMMY, a, b, xDeclaration);
        CBinaryExpression rhs = expressionBuilder.buildBinaryExpression(new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "x", xDeclaration), CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.PLUS);
        CStatementEdge a_to_b = new CStatementEdge("x := x + 1", new CExpressionAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "x", xDeclaration), rhs), FileLocation.DUMMY, a, b);
        CBinaryExpression guard = expressionBuilder.buildBinaryExpression(new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "x", xDeclaration), this.intConstant(BigInteger.TEN), CBinaryExpression.BinaryOperator.LESS_THAN);
        CStatementEdge b_to_a = new CStatementEdge("x <= 10", new CExpressionStatement(FileLocation.DUMMY, guard), FileLocation.DUMMY, b, a);
        TreeMultimap nodes = TreeMultimap.create();
        nodes.put((Object)"main", (Object)a);
        nodes.put((Object)"main", (Object)b);
        functions.put("main", entryNode);
        MutableCFA cfa = new MutableCFA(MachineModel.LINUX32, functions, (SortedSetMultimap<String, CFANode>)nodes, entryNode, Language.C);
        return Triple.of((Object)a_to_b, (Object)b_to_a, (Object)cfa);
    }

    private CExpression intConstant(BigInteger constant) {
        return new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, constant);
    }

    private FunctionEntryNode dummyFunction(String name) {
        CFunctionType functionType = CFunctionType.functionTypeWithReturnType(CNumericTypes.BOOL);
        CFunctionEntryNode main = new CFunctionEntryNode(FileLocation.DUMMY, new CFunctionDeclaration(FileLocation.DUMMY, functionType, name, Collections.emptyList()), new FunctionExitNode(name), Collections.emptyList(), (Optional<CVariableDeclaration>)Optional.absent());
        return main;
    }

    @Test
    public void testCustomSSAIdx() throws Exception {
        Triple<CFAEdge, CFAEdge, MutableCFA> data = this.createCFA();
        CFAEdge a_to_b = (CFAEdge)data.getFirst();
        int customIdx = 1337;
        PathFormula p = this.makePathFormulaWithCustomIdx(a_to_b, customIdx);
        Assert.assertEquals((long)(customIdx + 1), (long)p.getSsa().getIndex("x"));
    }

    @Test
    public void testAssignmentSSABackward() throws Exception {
        Triple<CFAEdge, CFAEdge, MutableCFA> data = this.createCFA();
        CFAEdge a_to_b = (CFAEdge)data.getFirst();
        PathFormula pf = this.pfmgrBwd.makeEmptyPathFormula();
        pf = this.pfmgrBwd.makeNewPathFormula(pf, pf.getSsa().builder().setIndex("x", CNumericTypes.INT, 10).build());
        pf = this.pfmgrBwd.makeAnd(pf, a_to_b);
        Assert.assertEquals((Object)"(= x@10 (+ x@11 1))", (Object)pf.toString());
    }

    @Test
    public void testDeclarationSSABackward() throws Exception {
        this.createCFA();
        PathFormula pf = this.pfmgrBwd.makeEmptyPathFormula();
        pf = this.pfmgrBwd.makeNewPathFormula(pf, pf.getSsa().builder().setIndex("x", CNumericTypes.INT, 10).build());
        pf = this.pfmgrBwd.makeAnd(pf, this.x_decl);
        Assert.assertEquals((long)11L, (long)pf.getSsa().getIndex("x"));
    }

    @Test
    public void testDeclarationSSAForward() throws Exception {
        this.createCFA();
        PathFormula pf = this.pfmgrFwd.makeEmptyPathFormula();
        pf = this.pfmgrFwd.makeNewPathFormula(pf, pf.getSsa().builder().setIndex("x", CNumericTypes.INT, 10).build());
        pf = this.pfmgrFwd.makeAnd(pf, this.x_decl);
        Assert.assertEquals((long)11L, (long)pf.getSsa().getIndex("x"));
    }

    @Test
    public void testAssignmentSSAForward() throws Exception {
        Triple<CFAEdge, CFAEdge, MutableCFA> data = this.createCFA();
        CFAEdge a_to_b = (CFAEdge)data.getFirst();
        PathFormula pf = this.pfmgrFwd.makeEmptyPathFormula();
        pf = this.pfmgrFwd.makeNewPathFormula(pf, pf.getSsa().builder().setIndex("x", CNumericTypes.INT, 10).build());
        pf = this.pfmgrFwd.makeAnd(pf, a_to_b);
        Assert.assertEquals((Object)"(= x@11 (+ x@10 1))", (Object)pf.toString());
    }

    private PathFormula makePathFormulaWithCustomIdx(CFAEdge edge, int ssaIdx) throws CPATransferException, InterruptedException {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula emptyWithCustomSSA = this.pfmgrFwd.makeNewPathFormula(empty, SSAMap.emptySSAMap().withDefault(ssaIdx));
        return this.pfmgrFwd.makeAnd(emptyWithCustomSSA, edge);
    }

    @Test
    public void testEmpty() {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula expected = new PathFormula(this.fmgr.getBooleanFormulaManager().makeBoolean(true), SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), 0);
        Assert.assertEquals((Object)expected, (Object)empty);
    }

    private PathFormula makePathFormulaWithVariable(String var, int index) throws Exception {
        NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> rfmgr = this.fmgr.getRationalFormulaManager();
        BooleanFormula f = rfmgr.equal(rfmgr.makeVariable(var, index), rfmgr.makeNumber(0L));
        SSAMap s = SSAMap.emptySSAMap().builder().setIndex(var, CNumericTypes.DOUBLE, index).build();
        return new PathFormula(f, s, PointerTargetSet.emptyPointerTargetSet(), 1);
    }

    private BooleanFormula makeVariableEquality(String var, int index1, int index2) throws Exception {
        NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> rfmgr = this.fmgr.getRationalFormulaManager();
        return rfmgr.equal(rfmgr.makeVariable(var, index2), rfmgr.makeVariable(var, index1));
    }

    @Test
    public void testMakeOrBothEmpty() throws Exception {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula result = this.pfmgrFwd.makeOr(empty, empty);
        Assert.assertEquals((Object)empty, (Object)result);
    }

    @Test
    public void testMakeOrLeftEmpty() throws Exception {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula pf = this.makePathFormulaWithVariable("a", 2);
        PathFormula result = this.pfmgrFwd.makeOr(empty, pf);
        PathFormula expected = new PathFormula(this.fmgr.makeOr(this.makeVariableEquality("a", 1, 2), pf.getFormula()), pf.getSsa(), pf.getPointerTargetSet(), 1);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testMakeOrRightEmpty() throws Exception {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula pf = this.makePathFormulaWithVariable("a", 2);
        PathFormula result = this.pfmgrFwd.makeOr(pf, empty);
        PathFormula expected = new PathFormula(this.fmgr.makeOr(pf.getFormula(), this.makeVariableEquality("a", 1, 2)), pf.getSsa(), pf.getPointerTargetSet(), 1);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testMakeOr() throws Exception {
        PathFormula pf1 = this.makePathFormulaWithVariable("a", 2);
        PathFormula pf2 = this.makePathFormulaWithVariable("a", 3);
        PathFormula result = this.pfmgrFwd.makeOr(pf1, pf2);
        BooleanFormula left = this.fmgr.makeAnd(pf1.getFormula(), this.makeVariableEquality("a", 2, 3));
        BooleanFormula right = pf2.getFormula();
        PathFormula expected = new PathFormula(this.fmgr.makeOr(left, right), pf2.getSsa(), PointerTargetSet.emptyPointerTargetSet(), 1);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testMakeOrCommutative() throws Exception {
        PathFormula pf1 = this.makePathFormulaWithVariable("a", 2);
        PathFormula pf2 = this.makePathFormulaWithVariable("b", 3);
        PathFormula resultA = this.pfmgrFwd.makeOr(pf1, pf2);
        PathFormula resultB = this.pfmgrFwd.makeOr(pf2, pf1);
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)resultA.getFormula())).isEquivalentTo(resultB.getFormula());
    }
}

