/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.testing.ClassSanityTester;
import com.google.common.truth.Truth;
import java.lang.reflect.Constructor;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.predicate.BAMFreshValueProvider;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

public class PathFormulaTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private SSAMap.SSAMapBuilder builder;

    private ClassSanityTester classSanityTester() throws Exception {
        Constructor<?> ptsConstructor = PointerTargetSet.class.getDeclaredConstructors()[0];
        ptsConstructor.setAccessible(true);
        PointerTargetSet dummyPTS = (PointerTargetSet)ptsConstructor.newInstance(PathCopyingPersistentTreeMap.of().putAndCopy((Object)"foo", (Object)CVoidType.VOID), null, PathCopyingPersistentTreeMap.of(), PathCopyingPersistentTreeMap.of(), PathCopyingPersistentTreeMap.of());
        return new ClassSanityTester().setDistinctValues(SSAMap.class, (Object)SSAMap.emptySSAMap(), (Object)SSAMap.emptySSAMap().builder().setIndex("a", CVoidType.VOID, 1).build()).setDistinctValues(PointerTargetSet.class, (Object)PointerTargetSet.emptyPointerTargetSet(), (Object)dummyPTS);
    }

    @Before
    public void createBuilder() {
        this.builder = SSAMap.emptySSAMap().builder();
    }

    @Test
    public void testEquals() throws Exception {
        this.classSanityTester().testEquals(PathFormula.class);
    }

    @Test
    public void testNulls() throws Exception {
        this.classSanityTester().testNulls(PathFormula.class);
    }

    @Test
    public void testSSA() {
        this.builder.setIndex("a", CNumericTypes.INT, 1).setIndex("b", CNumericTypes.INT, 2).setIndex("c", CNumericTypes.INT, 3);
        Truth.assertThat((Integer)this.builder.getIndex("a")).is(1L);
        Truth.assertThat((Integer)this.builder.getIndex("b")).is(2L);
        Truth.assertThat((Integer)this.builder.getIndex("c")).is(3L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("a")).is(2L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).is(3L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).is(4L);
        this.builder = this.builder.setIndex("b", CNumericTypes.INT, 5);
        Truth.assertThat((Integer)this.builder.getIndex("b")).is(5L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).is(6L);
    }

    @Test
    public void testSSAbam() {
        this.builder.setIndex("a", CNumericTypes.INT, 1).setIndex("b", CNumericTypes.INT, 2).setIndex("c", CNumericTypes.INT, 3);
        Truth.assertThat((Integer)this.builder.getIndex("a")).is(1L);
        Truth.assertThat((Integer)this.builder.getIndex("b")).is(2L);
        Truth.assertThat((Integer)this.builder.getIndex("c")).is(3L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("a")).is(2L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).is(3L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).is(4L);
        this.builder = this.builder.setIndex("b", CNumericTypes.INT, 5);
        Truth.assertThat((Integer)this.builder.getIndex("b")).is(5L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).is(6L);
        BAMFreshValueProvider bamfvp = new BAMFreshValueProvider();
        bamfvp.put("c", 7);
        this.builder.mergeFreshValueProviderWith(bamfvp);
        Truth.assertThat((Integer)this.builder.getIndex("c")).is(3L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).is(8L);
        BAMFreshValueProvider bamfvp2 = new BAMFreshValueProvider();
        bamfvp2.put("c", 9);
        this.builder.mergeFreshValueProviderWith(bamfvp2);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).is(10L);
        this.builder = this.builder.setIndex("c", CNumericTypes.INT, 15);
        Truth.assertThat((Integer)this.builder.getIndex("c")).is(15L);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).is(16L);
    }

    @Test
    public void testSSAExceptionMonotone() {
        this.builder.setIndex("a", CNumericTypes.INT, 2);
        this.thrown.expect(IllegalArgumentException.class);
        this.builder.setIndex("a", CNumericTypes.INT, 1);
    }

    @Test
    public void testSSAExceptionNegative() {
        this.thrown.expect(IllegalArgumentException.class);
        this.builder.setIndex("a", CNumericTypes.INT, -5);
    }

    @Test
    public void testSSAExceptionMonotone2() {
        this.builder.setIndex("a", CNumericTypes.INT, 2);
        this.thrown.expect(IllegalArgumentException.class);
        this.builder.setIndex("a", CNumericTypes.INT, 1);
    }
}

