/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMaps;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.util.predicates.pathformula.FreshValueProvider;

public class SSAMap
implements Serializable {
    private static final long serialVersionUID = 7618801653203679876L;
    private static final int DEFAULT_DEFAULT_IDX = -1;
    private final int defaultValue;
    private static PersistentSortedMaps.MergeConflictHandler<String, CType> TYPE_CONFLICT_CHECKER = new PersistentSortedMaps.MergeConflictHandler<String, CType>(){

        public CType resolveConflict(String name, CType type1, CType type2) {
            Preconditions.checkArgument((type1 instanceof CFunctionType || type2 instanceof CFunctionType || this.isEnumPointerType(type1) && this.isEnumPointerType(type2) || type1.equals(type2) ? 1 : 0) != 0, (String)"Cannot change type of variable %s in SSAMap from %s to %s", (Object[])new Object[]{name, type1, type2});
            return type1;
        }

        private boolean isEnumPointerType(CType type) {
            if (type instanceof CPointerType) {
                return (type = ((CPointerType)type).getType()) instanceof CComplexType && ((CComplexType)type).getKind() == CComplexType.ComplexTypeKind.ENUM || type instanceof CElaboratedType && ((CElaboratedType)type).getKind() == CComplexType.ComplexTypeKind.ENUM;
            }
            return false;
        }
    };
    private static final SSAMap EMPTY_SSA_MAP = new SSAMap((PersistentSortedMap<String, Integer>)PathCopyingPersistentTreeMap.of(), new FreshValueProvider.DefaultFreshValueProvider(), 0, (PersistentSortedMap<String, CType>)PathCopyingPersistentTreeMap.of());
    private final PersistentSortedMap<String, Integer> vars;
    private final FreshValueProvider freshValueProvider;
    private final PersistentSortedMap<String, CType> varTypes;
    private final int varsHashCode;
    private static final Joiner joiner = Joiner.on((String)" ");

    public static SSAMap emptySSAMap() {
        return EMPTY_SSA_MAP;
    }

    public SSAMap withDefault(int defaultValue) {
        return new SSAMap(this.vars, this.freshValueProvider, this.varsHashCode, this.varTypes, defaultValue);
    }

    public static Pair<SSAMap, List<Triple<String, Integer, Integer>>> merge(SSAMap s1, SSAMap s2) {
        if (s1.vars == s2.vars && s1.freshValueProvider == s2.freshValueProvider) {
            ImmutableList differences = ImmutableList.of();
            return Pair.of((Object)s1, (Object)differences);
        }
        ArrayList differences = new ArrayList();
        PersistentSortedMap vars = PersistentSortedMaps.merge(s1.vars, s2.vars, (Equivalence)Equivalence.equals(), (PersistentSortedMaps.MergeConflictHandler)PersistentSortedMaps.getMaximumMergeConflictHandler(), differences);
        FreshValueProvider freshValueProvider = s1.freshValueProvider.merge(s2.freshValueProvider);
        PersistentSortedMap varTypes = PersistentSortedMaps.merge(s1.varTypes, s2.varTypes, CTypes.canonicalTypeEquivalence(), TYPE_CONFLICT_CHECKER, null);
        return Pair.of((Object)new SSAMap((PersistentSortedMap<String, Integer>)vars, freshValueProvider, 0, (PersistentSortedMap<String, CType>)varTypes), differences);
    }

    private SSAMap(PersistentSortedMap<String, Integer> vars, FreshValueProvider freshValueProvider, int varsHashCode, PersistentSortedMap<String, CType> varTypes, int defaultSSAIdx) {
        this.vars = vars;
        this.freshValueProvider = freshValueProvider;
        this.varTypes = varTypes;
        if (varsHashCode == 0) {
            this.varsHashCode = vars.hashCode();
        } else {
            this.varsHashCode = varsHashCode;
            assert (varsHashCode == vars.hashCode());
        }
        this.defaultValue = defaultSSAIdx;
    }

    private SSAMap(PersistentSortedMap<String, Integer> vars, FreshValueProvider freshValueProvider, int varsHashCode, PersistentSortedMap<String, CType> varTypes) {
        this(vars, freshValueProvider, varsHashCode, varTypes, -1);
    }

    public SSAMapBuilder builder() {
        return new SSAMapBuilder(this);
    }

    private static int getIndex(String variable, Map<String, Integer> vars, int defaultValue) {
        Integer value = vars.get(variable);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getIndex(String variable) {
        return SSAMap.getIndex(variable, this.vars, this.defaultValue);
    }

    public boolean containsVariable(String variable) {
        return this.vars.containsKey((Object)variable);
    }

    public CType getType(String name) {
        return (CType)this.varTypes.get((Object)name);
    }

    public SortedSet<String> allVariables() {
        return this.vars.keySet();
    }

    public String toString() {
        return joiner.join((Iterable)this.vars.entrySet());
    }

    public int hashCode() {
        return this.varsHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SSAMap)) {
            return false;
        }
        SSAMap other = (SSAMap)obj;
        return this.varsHashCode == other.varsHashCode && this.vars.equals(other.vars) && this.freshValueProvider.equals(other.freshValueProvider);
    }

    public static class SSAMapBuilder {
        private SSAMap ssa;
        private PersistentSortedMap<String, Integer> vars;
        private FreshValueProvider freshValueProvider;
        private PersistentSortedMap<String, CType> varTypes;
        private int varsHashCode;

        private SSAMapBuilder(SSAMap ssa) {
            this.ssa = ssa;
            this.vars = ssa.vars;
            this.freshValueProvider = ssa.freshValueProvider;
            this.varTypes = ssa.varTypes;
            this.varsHashCode = ssa.varsHashCode;
        }

        public int getIndex(String variable) {
            return SSAMap.getIndex(variable, this.vars, this.ssa.defaultValue);
        }

        public int getFreshIndex(String variable) {
            return this.freshValueProvider.getFreshValue(variable, SSAMap.getIndex(variable, this.vars, this.ssa.defaultValue));
        }

        public CType getType(String name) {
            return (CType)this.varTypes.get((Object)name);
        }

        public SSAMapBuilder setIndex(String name, CType type, int idx) {
            Preconditions.checkArgument((idx > 0 ? 1 : 0) != 0, (String)"Indices need to be positive for this SSAMap implementation:", (Object[])new Object[]{name, type, idx});
            int oldIdx = this.getIndex(name);
            Preconditions.checkArgument((idx >= oldIdx ? 1 : 0) != 0, (String)"SSAMap updates need to be strictly monotone:", (Object[])new Object[]{name, type, idx});
            type = type.getCanonicalType();
            CType oldType = (CType)this.varTypes.get((Object)name);
            if (oldType != null) {
                TYPE_CONFLICT_CHECKER.resolveConflict((Object)name, (Object)type, (Object)oldType);
            } else {
                this.varTypes = this.varTypes.putAndCopy((Object)name, (Object)type);
            }
            if (idx > oldIdx || idx == this.ssa.defaultValue) {
                this.vars = this.vars.putAndCopy((Object)name, (Object)idx);
                if (oldIdx != this.ssa.defaultValue) {
                    this.varsHashCode -= SSAMapBuilder.mapEntryHashCode(name, oldIdx);
                }
                this.varsHashCode += SSAMapBuilder.mapEntryHashCode(name, idx);
            }
            return this;
        }

        public void mergeFreshValueProviderWith(FreshValueProvider fvp) {
            this.freshValueProvider = this.freshValueProvider.merge(fvp);
        }

        public SSAMapBuilder deleteVariable(String variable) {
            int index = this.getIndex(variable);
            if (index != this.ssa.defaultValue) {
                this.vars = this.vars.removeAndCopy((Object)variable);
                this.varsHashCode -= SSAMapBuilder.mapEntryHashCode(variable, index);
                this.varTypes = this.varTypes.removeAndCopy((Object)variable);
            }
            return this;
        }

        public SortedSet<String> allVariables() {
            return this.varTypes.keySet();
        }

        public SortedMap<String, CType> allVariablesWithPrefix(String prefix) {
            return Collections3.subMapWithPrefix(this.varTypes, (String)prefix);
        }

        public SSAMap build() {
            if (this.vars == this.ssa.vars && this.freshValueProvider == this.ssa.freshValueProvider) {
                return this.ssa;
            }
            this.ssa = new SSAMap(this.vars, this.freshValueProvider, this.varsHashCode, this.varTypes, this.ssa.defaultValue);
            return this.ssa;
        }

        private static int mapEntryHashCode(Object key, int value) {
            return key.hashCode() ^ value;
        }
    }
}

