/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.arrays;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.ExpressionToFormulaVisitorWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.LvalueVisitorWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;

public class CToFormulaConverterWithArrays
extends CtoFormulaConverter {
    protected final ArrayFormulaManagerView afmgr;

    public CToFormulaConverterWithArrays(FormulaEncodingOptions pOptions, FormulaManagerView pFmgr, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CtoFormulaTypeHandler pTypeHandler, AnalysisDirection pDirection) {
        super(pOptions, pFmgr, pMachineModel, pVariableClassification, pLogger, pShutdownNotifier, pTypeHandler, pDirection);
        Preconditions.checkNotNull((Object)pFmgr.getArrayFormulaManager());
        this.afmgr = pFmgr.getArrayFormulaManager();
    }

    @Override
    protected CRightHandSideVisitor<Formula, UnrecognizedCCodeException> createCRightHandSideVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) {
        return new ExpressionToFormulaVisitorWithArrays(this, this.fmgr, this.machineModel, pEdge, pFunction, pSsa, pConstraints);
    }

    @Override
    protected Formula buildLvalueTerm(CLeftHandSide pExp, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) throws UnrecognizedCCodeException {
        return pExp.accept(new LvalueVisitorWithArrays(this, pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions));
    }

    @Override
    protected Formula makeCast(CType pFromType, CType pToType, Formula pFormula, Constraints pConstraints, CFAEdge pEdge) throws UnrecognizedCCodeException {
        return super.makeCast(pFromType, pToType, pFormula, pConstraints, pEdge);
    }

    @Override
    protected Formula makeVariable(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.makeVariable(pName, pType, pSsa);
    }

    private <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeArrayVariable(String pName, CType pType, SSAMap.SSAMapBuilder pSsa, boolean bMakeFresh) {
        if (bMakeFresh) {
            int freshIndex = this.makeFreshIndex(pName, pType, pSsa);
            return (ArrayFormula)this.fmgr.makeVariable(this.getFormulaTypeFromCType(pType), pName, freshIndex);
        }
        int useIndex = this.getIndex(pName, pType, pSsa);
        return (ArrayFormula)this.fmgr.makeVariable(this.getFormulaTypeFromCType(pType), pName, useIndex);
    }

    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeAssignedArrayVariableForStore(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return this.makeArrayVariable(pName, pType, pSsa, this.direction == AnalysisDirection.BACKWARD);
    }

    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeAssignedArrayVariableForEquivalence(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return this.makeArrayVariable(pName, pType, pSsa, this.direction == AnalysisDirection.FORWARD);
    }

    @Override
    protected boolean isRelevantLeftHandSide(CLeftHandSide pLhs) {
        if (pLhs.getExpressionType().getCanonicalType() instanceof CArrayType) {
            return true;
        }
        return super.isRelevantLeftHandSide(pLhs);
    }

    @Override
    protected BooleanFormula makeAssignment(CLeftHandSide pLhs, CLeftHandSide pLhsForChecking, CRightHandSide pRhs, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) throws UnrecognizedCCodeException, InterruptedException {
        SSAMap pSsaBeforeStatement = pSsa.build();
        SSAMap.SSAMapBuilder lhsSsaBuilder = pSsaBeforeStatement.builder();
        SSAMap.SSAMapBuilder rhsSsaBuilder = pSsaBeforeStatement.builder();
        if (pLhs instanceof CIdExpression && ((CIdExpression)pLhs).getExpressionType() instanceof CArrayType) {
            this.logger.logOnce(Level.WARNING, new Object[]{"Result might be unsound. Aliasing of array variables detected!", pEdge.getRawStatement()});
            return this.bfmgr.makeBoolean(true);
        }
        if (pLhs instanceof CArraySubscriptExpression) {
            if (pLhs.getExpressionType() instanceof CArrayType && ((CArrayType)pLhs.getExpressionType()).getType() instanceof CArrayType) {
                this.logger.logOnce(Level.WARNING, new Object[]{"Result might be unsound. Unsupported multi-dimensional arrays found!", pEdge.getRawStatement()});
                return this.bfmgr.makeBoolean(true);
            }
            CArraySubscriptExpression lhsExpr = (CArraySubscriptExpression)pLhs;
            Verify.verify((boolean)(lhsExpr.getArrayExpression() instanceof CIdExpression));
            CIdExpression lhsArrExpr = (CIdExpression)lhsExpr.getArrayExpression();
            String arrayVariableName = lhsArrExpr.getDeclaration().getQualifiedName();
            ArrayFormula unchangedArrayFormula = this.makeAssignedArrayVariableForStore(arrayVariableName, lhsArrExpr.getExpressionType(), lhsSsaBuilder);
            Formula subscriptFormula = this.buildTerm(lhsExpr.getSubscriptExpression(), pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions);
            Formula rhsFormula = this.buildTerm(pRhs, pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions);
            ArrayFormula storeArrayFormula = this.afmgr.store(unchangedArrayFormula, subscriptFormula, rhsFormula);
            ArrayFormula changedArrayFormula = this.makeAssignedArrayVariableForEquivalence(arrayVariableName, lhsArrExpr.getExpressionType(), rhsSsaBuilder);
            int arrayVariableNewIndex = Math.max(lhsSsaBuilder.getIndex(arrayVariableName), rhsSsaBuilder.getIndex(arrayVariableName));
            pSsa.setIndex(arrayVariableName, lhsArrExpr.getExpressionType(), arrayVariableNewIndex);
            return this.afmgr.equivalence(changedArrayFormula, storeArrayFormula);
        }
        return super.makeAssignment(pLhs, pLhsForChecking, pRhs, pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions);
    }
}

