/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.arrays;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.CToFormulaConverterWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.CtoFormulaTypeHandlerWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class CToFormulaConverterWithArraysTest0
extends SolverBasedTest0 {
    private static final CArrayType unlimitedIntArrayType = new CArrayType(false, false, CNumericTypes.INT, null);
    private CToFormulaConverterWithArraysUnderTest ctfBwd;
    private CToFormulaConverterWithArraysUnderTest ctfFwd;
    private CBinaryExpressionBuilder expressionBuilder;
    private FormulaManagerView mgrv;
    private Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _a;
    private Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _b;
    private Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _bl;
    private Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _i;
    private Pair<CFAEdge, CExpressionAssignmentStatement> _i_assign_i_plus_1;
    private Pair<CAssumeEdge, CExpression> _b_at_i_notequal_0;
    private Pair<CAssumeEdge, CExpression> _a_at_i_equal_b_at_i;
    private Pair<CFAEdge, CExpressionAssignmentStatement> _a_at_i_assign_b_at_i;
    private Pair<CAssumeEdge, CExpression> _a_at_2_notequal_0;
    private Pair<CFAEdge, CExpressionAssignmentStatement> _a_assign_0_at_2;
    private Pair<CAssumeEdge, CExpression> _i_notequal_0;
    private CArraySubscriptExpression _b_at_i;
    private CArraySubscriptExpression _a_at_i;
    private CArraySubscriptExpression _a_at_1;
    private CArraySubscriptExpression _a_at_2;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _smt_a_ssa1;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _smt_b_ssa1;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _smt_a_ssa2;
    private ArrayFormula<NumeralFormula.IntegerFormula, ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>> _smt_a2d;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Before
    public void setUp() throws Exception {
        MachineModel mm = MachineModel.LINUX64;
        this.mgrv = new FormulaManagerView(this.factory, this.config, this.logger);
        FormulaEncodingOptions opts = new FormulaEncodingOptions(Configuration.defaultConfiguration());
        CtoFormulaTypeHandlerWithArrays th = new CtoFormulaTypeHandlerWithArrays(this.logger, opts, mm, this.mgrv);
        this.expressionBuilder = new CBinaryExpressionBuilder(mm, this.logger);
        this.ctfBwd = new CToFormulaConverterWithArraysUnderTest(opts, this.mgrv, mm, (Optional<VariableClassification>)Optional.absent(), this.logger, ShutdownNotifier.create(), th, AnalysisDirection.BACKWARD);
        this.ctfFwd = new CToFormulaConverterWithArraysUnderTest(opts, this.mgrv, mm, (Optional<VariableClassification>)Optional.absent(), this.logger, ShutdownNotifier.create(), th, AnalysisDirection.FORWARD);
    }

    @Before
    public void setupCfaTestData() throws UnrecognizedCCodeException {
        this._smt_b_ssa1 = this.amgr.makeArray("b@1", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._smt_a_ssa1 = this.amgr.makeArray("a@1", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._smt_a_ssa2 = this.amgr.makeArray("a@2", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._smt_a2d = this.amgr.makeArray("a2d@1", FormulaType.NumeralType.IntegerType, FormulaType.getArrayType(FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType));
        this._a = TestDataTools.makeDeclaration("a", unlimitedIntArrayType, null);
        this._b = TestDataTools.makeDeclaration("b", unlimitedIntArrayType, null);
        this._bl = TestDataTools.makeDeclaration("bl", CNumericTypes.INT, null);
        this._i = TestDataTools.makeDeclaration("i", CNumericTypes.INT, TestDataTools.INT_ZERO_INITIALIZER);
        this._b_at_i = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._b.getThird(), (CExpression)this._i.getThird());
        this._a_at_i = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), (CExpression)this._i.getThird());
        this._a_at_1 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), CIntegerLiteralExpression.ONE);
        this._a_at_2 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), CIntegerLiteralExpression.createDummyLiteral(2L, CNumericTypes.INT));
        this._i_assign_i_plus_1 = TestDataTools.makeAssignment((CLeftHandSide)this._i.getThird(), this.expressionBuilder.buildBinaryExpression((CExpression)this._i.getThird(), CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.PLUS));
        this._b_at_i_notequal_0 = TestDataTools.makeAssume(this.expressionBuilder.buildBinaryExpression(this._b_at_i, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.NOT_EQUALS));
        this._a_at_2_notequal_0 = TestDataTools.makeAssume(this.expressionBuilder.buildBinaryExpression(this._a_at_2, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.NOT_EQUALS));
        this._a_assign_0_at_2 = TestDataTools.makeAssignment(this._a_at_2, CIntegerLiteralExpression.ZERO);
        this._i_notequal_0 = TestDataTools.makeAssume(this.expressionBuilder.buildBinaryExpression((CExpression)this._i.getThird(), CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.NOT_EQUALS));
        this._a_at_i_equal_b_at_i = TestDataTools.makeAssume(this.expressionBuilder.buildBinaryExpression(this._a_at_i, this._b_at_i, CBinaryExpression.BinaryOperator.EQUALS));
        this._a_at_i_assign_b_at_i = TestDataTools.makeAssignment(this._a_at_i, this._b_at_i);
    }

    @Test
    public void testArrayView1() {
        NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> imgv = this.mgrv.getIntegerFormulaManager();
        ArrayFormulaManagerView amgv = this.mgrv.getArrayFormulaManager();
        NumeralFormula.IntegerFormula _i = imgv.makeVariable("i");
        NumeralFormula.IntegerFormula _1 = imgv.makeNumber(1L);
        NumeralFormula.IntegerFormula _i_plus_1 = imgv.add(_i, _1);
        ArrayFormula _b = amgv.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        NumeralFormula.IntegerFormula _b_at_i_plus_1 = (NumeralFormula.IntegerFormula)amgv.select(_b, _i_plus_1);
        Truth.assertThat((String)_b_at_i_plus_1.toString()).isEqualTo((Object)"(select b (+ i 1))");
    }

    @Test
    public void testArrayView2() {
        NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> imgv = this.mgrv.getIntegerFormulaManager();
        ArrayFormulaManagerView amgv = this.mgrv.getArrayFormulaManager();
        NumeralFormula.IntegerFormula _i = imgv.makeVariable("i");
        ArrayFormula multi = amgv.makeArray("multi", FormulaType.NumeralType.IntegerType, FormulaType.getArrayType(FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.RationalType));
        NumeralFormula.RationalFormula valueInMulti = (NumeralFormula.RationalFormula)amgv.select((ArrayFormula)amgv.select(multi, _i), _i);
        Truth.assertThat((String)valueInMulti.toString()).isEqualTo((Object)"(select (select multi i) i)");
    }

    @Test
    public void testArrayView3() {
        NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> imgv = this.mgrv.getIntegerFormulaManager();
        ArrayFormulaManagerView amgv = this.mgrv.getArrayFormulaManager();
        NumeralFormula.IntegerFormula _i = imgv.makeVariable("i");
        ArrayFormula multi = amgv.makeArray("multi", FormulaType.NumeralType.IntegerType, FormulaType.getArrayType(FormulaType.NumeralType.IntegerType, FormulaType.getBitvectorTypeWithSize(32)));
        BitvectorFormula valueInMulti = (BitvectorFormula)amgv.select((ArrayFormula)amgv.select(multi, _i), _i);
        Truth.assertThat((String)valueInMulti.toString()).isEqualTo((Object)"(select (select multi i) i)");
    }

    @Test
    public void testSimpleArrayAssume() throws UnrecognizedCCodeException, InterruptedException {
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula result = this.ctfBwd.makePredicate((CExpression)this._a_at_2_notequal_0.getSecond(), (CFAEdge)this._a_at_2_notequal_0.getFirst(), "foo", ssa);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.bmgr.not(this.imgr.equal((NumeralFormula)this.amgr.select(this._smt_a_ssa1, (Formula)this.imgr.makeNumber(2L)), this.imgr.makeNumber(0L))).toString()));
    }

    @Test
    public void testSimpleArrayAssignForward() throws UnrecognizedCCodeException, InterruptedException {
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        ssa = ssa.setIndex("a", unlimitedIntArrayType, 1);
        Pair<CFAEdge, CExpressionAssignmentStatement> assign = TestDataTools.makeAssignment(((CExpressionAssignmentStatement)this._a_assign_0_at_2.getSecond()).getLeftHandSide(), CIntegerLiteralExpression.ONE);
        BooleanFormula result = this.ctfFwd.makeAssignment(((CExpressionAssignmentStatement)assign.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)assign.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)assign.getSecond()).getRightHandSide(), (CFAEdge)assign.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.amgr.equivalence(this._smt_a_ssa2, this.amgr.store(this._smt_a_ssa1, (Formula)this.imgr.makeNumber(2L), (Formula)this.imgr.makeNumber(1L))).toString()));
    }

    @Test
    public void testSimpleArrayAssignBackward() throws UnrecognizedCCodeException, InterruptedException {
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        ssa = ssa.setIndex("a", unlimitedIntArrayType, 1);
        Pair<CFAEdge, CExpressionAssignmentStatement> assign = TestDataTools.makeAssignment(((CExpressionAssignmentStatement)this._a_assign_0_at_2.getSecond()).getLeftHandSide(), CIntegerLiteralExpression.ONE);
        BooleanFormula result = this.ctfBwd.makeAssignment(((CExpressionAssignmentStatement)assign.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)assign.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)assign.getSecond()).getRightHandSide(), (CFAEdge)assign.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.amgr.equivalence(this._smt_a_ssa1, this.amgr.store(this._smt_a_ssa2, (Formula)this.imgr.makeNumber(2L), (Formula)this.imgr.makeNumber(1L))).toString()));
    }

    @Test
    public void testSimpleRhsArrayAssign() throws UnrecognizedCCodeException, InterruptedException {
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        Pair<CFAEdge, CExpressionAssignmentStatement> op = TestDataTools.makeAssignment((CLeftHandSide)this._i.getThird(), this._a_at_2);
        BooleanFormula result = this.ctfBwd.makeAssignment(((CExpressionAssignmentStatement)op.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)op.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)op.getSecond()).getRightHandSide(), (CFAEdge)op.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.imgr.equal(this.imgr.makeVariable("i@1"), (NumeralFormula)this.amgr.select(this._smt_a_ssa1, (Formula)this.imgr.makeNumber(2L))).toString()));
    }

    @Test
    public void testNestedArrayAssign() throws UnrecognizedCCodeException, InterruptedException {
        CArraySubscriptExpression _a_at__a_at_2 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), this._a_at_2);
        Pair<CFAEdge, CExpressionAssignmentStatement> op = TestDataTools.makeAssignment(_a_at__a_at_2, CIntegerLiteralExpression.ONE);
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula result = this.ctfFwd.makeAssignment(((CExpressionAssignmentStatement)op.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)op.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)op.getSecond()).getRightHandSide(), (CFAEdge)op.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.amgr.equivalence(this._smt_a_ssa2, this.amgr.store(this._smt_a_ssa1, this.amgr.select(this._smt_a_ssa1, (Formula)this.imgr.makeNumber(2L)), (Formula)this.imgr.makeNumber(1L))).toString()));
    }

    @Test
    public void testNestedArrayAssume() throws UnrecognizedCCodeException, InterruptedException {
        CArraySubscriptExpression _a_at__a_at_2 = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)this._a.getThird(), this._a_at_2);
        Pair<CAssumeEdge, CExpression> _a_at__a_at_2_notequal_0 = TestDataTools.makeAssume(this.expressionBuilder.buildBinaryExpression(_a_at__a_at_2, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.NOT_EQUALS));
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula result = this.ctfBwd.makePredicate((CExpression)_a_at__a_at_2_notequal_0.getSecond(), (CFAEdge)_a_at__a_at_2_notequal_0.getFirst(), "foo", ssa);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.bmgr.not(this.imgr.equal((NumeralFormula)this.amgr.select(this._smt_a_ssa1, this.amgr.select(this._smt_a_ssa1, (Formula)this.imgr.makeNumber(2L))), this.imgr.makeNumber(0L))).toString()));
    }

    @Test
    public void testArrayDesignatedList() throws UnrecognizedCCodeException, InterruptedException {
        Truth.assertThat((Boolean)true).isFalse();
    }

    private CInitializerExpression createIntInitExpr(int pValue) {
        return new CInitializerExpression(FileLocation.DUMMY, CIntegerLiteralExpression.createDummyLiteral(pValue, CNumericTypes.INT));
    }

    @Test
    public void testArrayInitializerList() throws InterruptedException, CPATransferException {
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _x = TestDataTools.makeDeclaration("x", new CArrayType(false, false, CNumericTypes.INT, null), new CInitializerList(FileLocation.DUMMY, Lists.newArrayList((Object[])new CInitializer[]{this.createIntInitExpr(1), this.createIntInitExpr(3), this.createIntInitExpr(5), this.createIntInitExpr(7)})));
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula result = this.ctfFwd.makeDeclaration((CDeclarationEdge)_x.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString().replaceAll("\n", " ").replaceAll("  ", " ")).isEqualTo((Object)"TODO");
    }

    @Test
    public void testArrayDeclaration1() throws InterruptedException, CPATransferException {
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _arr = TestDataTools.makeDeclaration("arr", new CArrayType(false, false, CNumericTypes.INT, CIntegerLiteralExpression.createDummyLiteral(100L, CNumericTypes.INT)), null);
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula resultBwd = this.ctfBwd.makeDeclaration((CDeclarationEdge)_arr.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(resultBwd).toString()).comparesEqualTo((Comparable)((Object)"true"));
        BooleanFormula resultFwd = this.ctfFwd.makeDeclaration((CDeclarationEdge)_arr.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(resultFwd).toString()).isEqualTo((Object)"The result should be an initialized array");
    }

    @Test
    public void testArrayAssignment() throws UnrecognizedCCodeException, InterruptedException {
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        Pair<CFAEdge, CExpressionAssignmentStatement> _assing = TestDataTools.makeAssignment((CLeftHandSide)this._a.getThird(), (CExpression)this._b.getThird());
        BooleanFormula result = this.ctfFwd.makeAssignment(((CExpressionAssignmentStatement)_assing.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)_assing.getSecond()).getLeftHandSide(), ((CExpressionAssignmentStatement)_assing.getSecond()).getRightHandSide(), (CFAEdge)_assing.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)result.toString()).isEqualTo((Object)this.amgr.equivalence(this._smt_a_ssa1, this._smt_b_ssa1));
    }

    @Test
    @Ignore
    public void testMultiDimensional1() throws InterruptedException, CPATransferException {
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _arr2d = TestDataTools.makeDeclaration("_arr2d", new CArrayType(false, false, new CArrayType(false, false, CNumericTypes.INT, CIntegerLiteralExpression.createDummyLiteral(7L, CNumericTypes.INT)), CIntegerLiteralExpression.createDummyLiteral(3L, CNumericTypes.INT)), null);
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula resultBwd = this.ctfBwd.makeDeclaration((CDeclarationEdge)_arr2d.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(resultBwd).toString()).isEqualTo((Object)"true");
        BooleanFormula resultFwd = this.ctfFwd.makeDeclaration((CDeclarationEdge)_arr2d.getFirst(), "foo", ssa, null, null, null);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(resultFwd).toString()).isEqualTo((Object)"The result should be an initialized array");
    }

    @Test
    @Ignore
    public void testMultiDimensionalAssign() throws UnrecognizedCCodeException, InterruptedException {
        Truth.assertThat((Boolean)true).isFalse();
    }

    @Test
    @Ignore
    public void testMultiDimensionalAssume() throws UnrecognizedCCodeException, InterruptedException {
        CArrayType arrayWith10 = new CArrayType(false, false, CNumericTypes.INT, CIntegerLiteralExpression.createDummyLiteral(10L, CNumericTypes.INT));
        CArrayType typeOf_arr2d = new CArrayType(false, false, arrayWith10, CIntegerLiteralExpression.createDummyLiteral(10L, CNumericTypes.INT));
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _arr2d = TestDataTools.makeDeclaration("a2d", typeOf_arr2d, null);
        CArraySubscriptExpression _arr2d_at_3_7 = new CArraySubscriptExpression(FileLocation.DUMMY, CNumericTypes.INT, new CArraySubscriptExpression(FileLocation.DUMMY, arrayWith10, (CExpression)_arr2d.getThird(), CIntegerLiteralExpression.createDummyLiteral(3L, CNumericTypes.INT)), CIntegerLiteralExpression.createDummyLiteral(7L, CNumericTypes.INT));
        Pair<CAssumeEdge, CExpression> _arr2d_at_3_7_equal_23 = TestDataTools.makeAssume(this.expressionBuilder.buildBinaryExpression(_arr2d_at_3_7, CIntegerLiteralExpression.createDummyLiteral(23L, CNumericTypes.INT), CBinaryExpression.BinaryOperator.EQUALS));
        SSAMap.SSAMapBuilder ssa = SSAMap.emptySSAMap().builder();
        BooleanFormula result = this.ctfBwd.makePredicate((CExpression)_arr2d_at_3_7_equal_23.getSecond(), (CFAEdge)_arr2d_at_3_7_equal_23.getFirst(), "foo", ssa);
        Truth.assertThat((String)this.mgr.getUnsafeFormulaManager().simplify(result).toString()).comparesEqualTo((Comparable)((Object)this.imgr.equal((NumeralFormula)this.amgr.select(this.amgr.select(this._smt_a2d, (Formula)this.imgr.makeNumber(3L)), (Formula)this.imgr.makeNumber(7L)), this.imgr.makeNumber(23L)).toString()));
    }

    @Test
    @Ignore
    public void testArrayAsPointer1() throws UnrecognizedCCodeException, InterruptedException {
    }

    @Test
    @Ignore
    public void testArrayAsPointer2() throws UnrecognizedCCodeException, InterruptedException {
    }

    @Test
    @Ignore
    public void testArrayAsPointer3() throws UnrecognizedCCodeException, InterruptedException {
    }

    @Test
    @Ignore
    public void testArrayAsPointer4() throws UnrecognizedCCodeException, InterruptedException {
    }

    @Test
    @Ignore
    public void testArrayMalloc() throws UnrecognizedCCodeException, InterruptedException {
    }

    @VisibleForTesting
    private static class CToFormulaConverterWithArraysUnderTest
    extends CToFormulaConverterWithArrays {
        public CToFormulaConverterWithArraysUnderTest(FormulaEncodingOptions pOptions, FormulaManagerView pFmgr, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CtoFormulaTypeHandler pTypeHandler, AnalysisDirection pDirection) {
            super(pOptions, pFmgr, pMachineModel, pVariableClassification, pLogger, pShutdownNotifier, pTypeHandler, pDirection);
        }

        @Override
        protected BooleanFormula makeDeclaration(CDeclarationEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) throws UnrecognizedCCodeException, InterruptedException {
            return super.makeDeclaration(pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions);
        }

        @Override
        protected BooleanFormula makeAssignment(CLeftHandSide pLhs, CLeftHandSide pLhsForChecking, CRightHandSide pRhs, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) throws UnrecognizedCCodeException, InterruptedException {
            return super.makeAssignment(pLhs, pLhsForChecking, pRhs, pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions);
        }
    }
}

