/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.arrays;

import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.arrays.CToFormulaConverterWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExpressionToFormulaVisitor;

public class ExpressionToFormulaVisitorWithArrays
extends ExpressionToFormulaVisitor {
    private final ArrayFormulaManagerView amgr;
    private final CToFormulaConverterWithArrays ctfa;
    private final MachineModel machine;

    public ExpressionToFormulaVisitorWithArrays(CToFormulaConverterWithArrays pCtoFormulaConverter, FormulaManagerView pMgr, MachineModel pMachineModel, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pConstraints) {
        super(pCtoFormulaConverter, pMgr, pEdge, pFunction, pSsa, pConstraints);
        this.amgr = this.mgr.getArrayFormulaManager();
        this.ctfa = pCtoFormulaConverter;
        this.machine = pMachineModel;
    }

    @Override
    public Formula visit(CArraySubscriptExpression pE) throws UnrecognizedCCodeException {
        ArrayFormula selectFrom;
        if (pE.getArrayExpression() instanceof CIdExpression) {
            CIdExpression idExpr = (CIdExpression)pE.getArrayExpression();
            String arrayVarName = idExpr.getDeclaration().getQualifiedName();
            CType arrayType = pE.getArrayExpression().getExpressionType();
            selectFrom = (ArrayFormula)this.ctfa.makeVariable(arrayVarName, arrayType, this.ssa);
        } else if (pE.getArrayExpression() instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression subExpr = (CArraySubscriptExpression)pE.getArrayExpression();
            selectFrom = (ArrayFormula)subExpr.accept(this);
        } else {
            throw new UnrecognizedCCodeException("CArraySubscriptExpression: Unknown type of array-expression!", pE);
        }
        Formula indexExprFormula = pE.getSubscriptExpression().accept(this);
        Formula castedIndexExprFormula = this.ctfa.makeCast(pE.getSubscriptExpression().getExpressionType(), this.machine.getPointerEquivalentSimpleType(), indexExprFormula, null, null);
        return this.amgr.select(selectFrom, castedIndexExprFormula);
    }

    @Override
    public Formula visit(CUnaryExpression pExp) throws UnrecognizedCCodeException {
        CExpression operand = pExp.getOperand();
        CUnaryExpression.UnaryOperator op = pExp.getOperator();
        if (op == CUnaryExpression.UnaryOperator.AMPER && operand instanceof CArraySubscriptExpression) {
            return operand.accept(this);
        }
        return super.visit(pExp);
    }
}

