/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.IsRelevantLhsVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.LvalueVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;

public class CtoFormulaConverter {
    public static final Set<String> PURE_EXTERNAL_FUNCTIONS = ImmutableSet.of((Object)"abort", (Object)"exit", (Object)"__assert_fail", (Object)"__VERIFIER_error", (Object)"free", (Object)"kfree", (Object[])new String[]{"fprintf", "printf", "puts", "printk", "sprintf", "swprintf", "strcasecmp", "strchr", "strcmp", "strlen", "strncmp", "strrchr", "strstr"});
    public static final Map<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"pthread_create", (Object)"threads", (Object)"fesetround", (Object)"floating-point rounding modes");
    @Deprecated
    public static final String RETURN_VARIABLE_NAME = "__retval__";
    public static final String PARAM_VARIABLE_NAME = "__param__";
    private static final Set<String> SAFE_VAR_ARG_FUNCTIONS = ImmutableSet.of((Object)"printf", (Object)"printk");
    private static final CharMatcher ILLEGAL_VARNAME_CHARACTERS = CharMatcher.anyOf((CharSequence)"|\\");
    private final Map<String, Formula> stringLitToFormula = new HashMap<String, Formula>();
    private int nextStringLitIndex = 0;
    final FormulaEncodingOptions options;
    protected final MachineModel machineModel;
    private final Optional<VariableClassification> variableClassification;
    final CtoFormulaTypeHandler typeHandler;
    protected final FormulaManagerView fmgr;
    protected final BooleanFormulaManagerView bfmgr;
    private final NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> nfmgr;
    private final BitvectorFormulaManagerView efmgr;
    protected final FunctionFormulaManagerView ffmgr;
    protected final LogManagerWithoutDuplicates logger;
    protected final ShutdownNotifier shutdownNotifier;
    protected final AnalysisDirection direction;
    private static final int VARIABLE_UNINITIALIZED = 1;
    private static final int VARIABLE_FIRST_ASSIGNMENT = 2;
    private final UninterpretedFunctionDeclaration<?> stringUfDecl;
    protected final HashSet<CVariableDeclaration> globalDeclarations = new HashSet();

    public CtoFormulaConverter(FormulaEncodingOptions pOptions, FormulaManagerView fmgr, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, LogManager logger, ShutdownNotifier pShutdownNotifier, CtoFormulaTypeHandler pTypeHandler, AnalysisDirection pDirection) {
        this.fmgr = fmgr;
        this.options = pOptions;
        this.machineModel = pMachineModel;
        this.variableClassification = pVariableClassification;
        this.typeHandler = pTypeHandler;
        this.bfmgr = fmgr.getBooleanFormulaManager();
        this.nfmgr = fmgr.getIntegerFormulaManager();
        this.efmgr = fmgr.getBitvectorFormulaManager();
        this.ffmgr = fmgr.getFunctionFormulaManager();
        this.logger = new LogManagerWithoutDuplicates(logger);
        this.shutdownNotifier = pShutdownNotifier;
        this.direction = pDirection;
        this.stringUfDecl = this.ffmgr.declareUninterpretedFunction("__string__", this.typeHandler.getPointerType(), FormulaType.IntegerType);
    }

    void logfOnce(Level level, CFAEdge edge, String msg, Object ... args) {
        if (this.logger.wouldBeLogged(level)) {
            this.logger.logfOnce(level, "%s: %s: %s", new Object[]{edge.getFileLocation(), String.format(msg, args), edge.getDescription()});
        }
    }

    protected int getSizeof(CType pType) {
        return this.typeHandler.getSizeof(pType);
    }

    protected boolean isRelevantField(CCompositeType compositeType, String fieldName) {
        return !this.variableClassification.isPresent() || !this.options.ignoreIrrelevantVariables() || ((VariableClassification)this.variableClassification.get()).getRelevantFields().containsEntry((Object)compositeType, (Object)fieldName);
    }

    protected boolean isRelevantLeftHandSide(CLeftHandSide lhs) {
        if (this.options.ignoreIrrelevantVariables() && this.variableClassification.isPresent()) {
            return lhs.accept(new IsRelevantLhsVisitor(this));
        }
        return true;
    }

    protected final boolean isRelevantVariable(CSimpleDeclaration var) {
        if (this.options.ignoreIrrelevantVariables() && this.variableClassification.isPresent()) {
            return var.getName().equals(RETURN_VARIABLE_NAME) || ((VariableClassification)this.variableClassification.get()).getRelevantVariables().contains(var.getQualifiedName());
        }
        return true;
    }

    public FormulaType<?> getFormulaTypeFromCType(CType type) {
        return this.typeHandler.getFormulaTypeFromCType(type);
    }

    static String exprToVarNameUnscoped(AAstNode e) {
        return ILLEGAL_VARNAME_CHARACTERS.replaceFrom((CharSequence)CharMatcher.WHITESPACE.removeFrom((CharSequence)e.toASTString()), '_');
    }

    static String exprToVarName(AAstNode e, String function) {
        return (function + "::" + CtoFormulaConverter.exprToVarNameUnscoped(e)).intern().intern();
    }

    protected int makeFreshIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        int idx = this.getFreshIndex(name, type, ssa);
        ssa.setIndex(name, type, idx);
        return idx;
    }

    protected int getFreshIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        this.checkSsaSavedType(name, type, ssa.getType(name));
        int idx = ssa.getFreshIndex(name);
        if (idx <= 0) {
            idx = 2;
        }
        return idx;
    }

    protected int getIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        this.checkSsaSavedType(name, type, ssa.getType(name));
        int idx = ssa.getIndex(name);
        if (idx <= 0) {
            this.logger.log(Level.ALL, new Object[]{"WARNING: Auto-instantiating variable:", name});
            idx = 1;
            ssa.setIndex(name, type, idx);
        }
        return idx;
    }

    protected void checkSsaSavedType(String name, CType type, CType t) {
        if (t != null && !CtoFormulaTypeUtils.areEqualWithMatchingPointerArray(t, type)) {
            if (this.getFormulaTypeFromCType(t) != this.getFormulaTypeFromCType(type)) {
                throw new UnsupportedOperationException("Variable " + name + " used with types of different sizes! " + "(Type1: " + t + ", Type2: " + type + ")");
            }
            this.logger.logf(Level.FINEST, "Variable %s was found with multiple types! (Type1: %s, Type2: %s)", new Object[]{name, t, type});
        }
    }

    protected Formula makeConstant(String name, CType type) {
        return this.fmgr.makeVariable(this.getFormulaTypeFromCType(type), name);
    }

    protected Formula makeVariable(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        int useIndex = this.getIndex(name, type, ssa);
        return this.fmgr.makeVariable(this.getFormulaTypeFromCType(type), name, useIndex);
    }

    protected Formula makeFreshVariable(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        int useIndex = this.direction == AnalysisDirection.BACKWARD ? this.getIndex(name, type, ssa) : this.makeFreshIndex(name, type, ssa);
        Object result = this.fmgr.makeVariable(this.getFormulaTypeFromCType(type), name, useIndex);
        if (this.direction == AnalysisDirection.BACKWARD) {
            this.makeFreshIndex(name, type, ssa);
        }
        return result;
    }

    Formula makeStringLiteral(String literal) {
        Formula result = this.stringLitToFormula.get(literal);
        if (result == null) {
            int n = this.nextStringLitIndex++;
            result = this.ffmgr.callUninterpretedFunction(this.stringUfDecl, this.nfmgr.makeNumber(n));
            this.stringLitToFormula.put(literal, result);
        }
        return result;
    }

    protected Formula makeCast(CType pFromType, CType pToType, Formula formula, Constraints constraints, CFAEdge edge) throws UnrecognizedCCodeException {
        boolean toCanBeHandledAsInt;
        CType toType;
        CType fromType = pFromType.getCanonicalType();
        if (fromType.equals(toType = pToType.getCanonicalType())) {
            return formula;
        }
        if (fromType instanceof CFunctionType) {
            fromType = new CPointerType(false, false, fromType);
        }
        boolean fromIsPointer = fromType instanceof CPointerType;
        boolean toIsPointer = toType instanceof CPointerType;
        boolean fromCanBeHandledAsInt = fromIsPointer || fromType instanceof CEnumType || fromType instanceof CElaboratedType && ((CElaboratedType)fromType).getKind() == CComplexType.ComplexTypeKind.ENUM;
        boolean bl = toCanBeHandledAsInt = toIsPointer || toType instanceof CEnumType || toType instanceof CElaboratedType && ((CElaboratedType)toType).getKind() == CComplexType.ComplexTypeKind.ENUM;
        if (fromCanBeHandledAsInt || toCanBeHandledAsInt) {
            if (fromCanBeHandledAsInt) {
                fromType = fromIsPointer ? this.machineModel.getPointerEquivalentSimpleType() : CNumericTypes.INT;
                fromType = fromType.getCanonicalType();
            }
            if (toCanBeHandledAsInt) {
                toType = toIsPointer ? this.machineModel.getPointerEquivalentSimpleType() : CNumericTypes.INT;
                toType = toType.getCanonicalType();
            }
        }
        if (fromType instanceof CSimpleType) {
            CSimpleType sfromType = (CSimpleType)fromType;
            if (toType instanceof CSimpleType) {
                CSimpleType stoType = (CSimpleType)toType;
                return this.makeSimpleCast(sfromType, stoType, formula, constraints);
            }
        }
        if ((fromType instanceof CPointerType || toType instanceof CPointerType) && this.getFormulaTypeFromCType(toType).equals(this.getFormulaTypeFromCType(fromType))) {
            return formula;
        }
        if (this.getSizeof(fromType) == this.getSizeof(toType)) {
            this.logger.logfOnce(Level.WARNING, "Ignoring cast from %s to %s.", new Object[]{fromType, toType});
            return formula;
        }
        throw new UnrecognizedCCodeException("Cast from " + pFromType + " to " + pToType + " not supported!", edge);
    }

    protected CExpression makeCastFromArrayToPointerIfNecessary(CExpression exp, CType targetType) {
        if (exp.getExpressionType().getCanonicalType() instanceof CArrayType && ((targetType = targetType.getCanonicalType()) instanceof CPointerType || targetType instanceof CSimpleType)) {
            return CtoFormulaConverter.makeCastFromArrayToPointer(exp);
        }
        return exp;
    }

    private static CExpression makeCastFromArrayToPointer(CExpression arrayExpression) {
        CArrayType arrayType = (CArrayType)arrayExpression.getExpressionType().getCanonicalType();
        CPointerType pointerType = new CPointerType(arrayType.isConst(), arrayType.isVolatile(), arrayType.getType());
        return new CUnaryExpression(arrayExpression.getFileLocation(), pointerType, arrayExpression, CUnaryExpression.UnaryOperator.AMPER);
    }

    private Formula makeSimpleCast(CSimpleType pFromCType, CSimpleType pToCType, Formula pFormula, Constraints constraints) {
        Formula ret;
        FormulaType<?> toType;
        FormulaType<?> fromType = this.typeHandler.getFormulaTypeFromCType(pFromCType);
        if (fromType.equals(toType = this.typeHandler.getFormulaTypeFromCType(pToCType))) {
            ret = pFormula;
        } else if (fromType.isBitvectorType() && toType.isBitvectorType()) {
            int toSize;
            int fromSize = ((FormulaType.BitvectorType)fromType).getSize();
            ret = fromSize > (toSize = ((FormulaType.BitvectorType)toType).getSize()) ? this.fmgr.makeExtract(pFormula, toSize - 1, 0) : (fromSize < toSize ? this.fmgr.makeExtend(pFormula, toSize - fromSize, this.machineModel.isSigned(pFromCType)) : pFormula);
        } else if (fromType.isFloatingPointType()) {
            ret = this.fmgr.getFloatingPointFormulaManager().castTo((FloatingPointFormula)pFormula, toType);
        } else if (toType.isFloatingPointType()) {
            ret = this.fmgr.getFloatingPointFormulaManager().castFrom(pFormula, this.machineModel.isSigned(pFromCType), (FormulaType.FloatingPointType)toType);
        } else {
            throw new IllegalArgumentException("Cast from " + pFromCType + " to " + pToCType + " needs theory conversion between " + fromType + " and " + toType);
        }
        assert (this.fmgr.getFormulaType(ret).equals(toType)) : "types do not match: " + this.fmgr.getFormulaType(ret) + " vs " + toType;
        return ret;
    }

    public CExpression convertLiteralToFloatIfNecessary(CExpression pExp, CType targetType) {
        if (!CtoFormulaConverter.isFloatingPointType(targetType)) {
            return pExp;
        }
        CExpression e = pExp;
        boolean negative = false;
        if (e instanceof CUnaryExpression && ((CUnaryExpression)e).getOperator() == CUnaryExpression.UnaryOperator.MINUS) {
            e = ((CUnaryExpression)e).getOperand();
            negative = true;
        }
        if (e instanceof CIntegerLiteralExpression) {
            NumericValue intValue = new NumericValue(((CIntegerLiteralExpression)e).getValue());
            if (negative) {
                intValue = intValue.negate();
            }
            Value floatValue = AbstractExpressionValueVisitor.castCValue(intValue, e.getExpressionType(), targetType, this.machineModel, this.logger, e.getFileLocation());
            return new CFloatLiteralExpression(e.getFileLocation(), targetType, floatValue.asNumericValue().bigDecimalValue());
        }
        return pExp;
    }

    private static boolean isFloatingPointType(CType pType) {
        if (pType instanceof CSimpleType) {
            return ((CSimpleType)pType).getType().isFloatingPointType();
        }
        return false;
    }

    public PathFormula makeAnd(PathFormula oldFormula, CFAEdge edge, ErrorConditions errorConditions) throws UnrecognizedCCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        String function = edge.getPredecessor() != null ? edge.getPredecessor().getFunctionName() : null;
        SSAMap.SSAMapBuilder ssa = oldFormula.getSsa().builder();
        Constraints constraints = new Constraints(this.bfmgr);
        PointerTargetSetBuilder pts = this.createPointerTargetSetBuilder(oldFormula.getPointerTargetSet());
        if (edge.getPredecessor() instanceof CFunctionEntryNode) {
            this.addParameterConstraints(edge, function, ssa, pts, constraints, errorConditions, (CFunctionEntryNode)edge.getPredecessor());
            this.addGlobalAssignmentConstraints(edge, function, ssa, pts, constraints, errorConditions, PARAM_VARIABLE_NAME, false);
        }
        BooleanFormula edgeFormula = this.createFormulaForEdge(edge, function, ssa, pts, constraints, errorConditions);
        if (edge.getSuccessor() instanceof FunctionExitNode) {
            this.addGlobalAssignmentConstraints(edge, function, ssa, pts, constraints, errorConditions, RETURN_VARIABLE_NAME, true);
        }
        edgeFormula = this.bfmgr.and(edgeFormula, constraints.get());
        SSAMap newSsa = ssa.build();
        PointerTargetSet newPts = pts.build();
        if (this.bfmgr.isTrue(edgeFormula) && newSsa == oldFormula.getSsa() && newPts.equals(oldFormula.getPointerTargetSet())) {
            return oldFormula;
        }
        BooleanFormula newFormula = this.bfmgr.and(oldFormula.getFormula(), edgeFormula);
        int newLength = oldFormula.getLength() + 1;
        return new PathFormula(newFormula, newSsa, newPts, newLength);
    }

    private void addParameterConstraints(CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions, CFunctionEntryNode entryNode) throws UnrecognizedCCodeException, InterruptedException {
        if (this.options.useParameterVariables() || entryNode.getNumEnteringEdges() == 0) {
            for (CParameterDeclaration formalParam : entryNode.getFunctionParameters()) {
                CParameterDeclaration tmpParameterExpression = new CParameterDeclaration(formalParam.getFileLocation(), formalParam.getType(), formalParam.getName() + PARAM_VARIABLE_NAME);
                tmpParameterExpression.setQualifiedName(formalParam.getQualifiedName() + PARAM_VARIABLE_NAME);
                CIdExpression lhs = new CIdExpression(formalParam.getFileLocation(), formalParam);
                CIdExpression rhs = new CIdExpression(formalParam.getFileLocation(), tmpParameterExpression);
                BooleanFormula eq = this.makeAssignment(lhs, rhs, edge, function, ssa, pts, constraints, errorConditions);
                constraints.addConstraint(eq);
            }
        }
    }

    private void addGlobalAssignmentConstraints(CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions, String tmpNamePart, boolean tmpAsLHS) throws UnrecognizedCCodeException, InterruptedException {
        if (this.options.useParameterVariablesForGlobals()) {
            for (CVariableDeclaration decl : this.globalDeclarations) {
                CParameterDeclaration tmpParameter = new CParameterDeclaration(decl.getFileLocation(), decl.getType(), decl.getName() + tmpNamePart + function);
                tmpParameter.setQualifiedName(decl.getQualifiedName() + tmpNamePart + function);
                CIdExpression tmp = new CIdExpression(decl.getFileLocation(), tmpParameter);
                CIdExpression glob = new CIdExpression(decl.getFileLocation(), decl);
                BooleanFormula eq = tmpAsLHS ? this.makeAssignment(tmp, glob, glob, edge, function, ssa, pts, constraints, errorConditions) : this.makeAssignment(glob, glob, tmp, edge, function, ssa, pts, constraints, errorConditions);
                constraints.addConstraint(eq);
            }
        }
    }

    private BooleanFormula createFormulaForEdge(CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        switch (edge.getEdgeType()) {
            case StatementEdge: {
                return this.makeStatement((CStatementEdge)edge, function, ssa, pts, constraints, errorConditions);
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)edge;
                return this.makeReturn(returnEdge.asAssignment(), returnEdge, function, ssa, pts, constraints, errorConditions);
            }
            case DeclarationEdge: {
                return this.makeDeclaration((CDeclarationEdge)edge, function, ssa, pts, constraints, errorConditions);
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)edge;
                return this.makePredicate(assumeEdge.getExpression(), assumeEdge.getTruthAssumption(), assumeEdge, function, ssa, pts, constraints, errorConditions);
            }
            case BlankEdge: {
                return this.bfmgr.makeBoolean(true);
            }
            case FunctionCallEdge: {
                return this.makeFunctionCall((CFunctionCallEdge)edge, function, ssa, pts, constraints, errorConditions);
            }
            case FunctionReturnEdge: {
                CFunctionSummaryEdge ce = ((CFunctionReturnEdge)edge).getSummaryEdge();
                return this.makeExitFunction(ce, function, ssa, pts, constraints, errorConditions);
            }
            case MultiEdge: {
                ArrayList<BooleanFormula> multiEdgeFormulas = new ArrayList<BooleanFormula>(((MultiEdge)edge).getEdges().size());
                for (CFAEdge singleEdge : (MultiEdge)edge) {
                    if (singleEdge instanceof BlankEdge) continue;
                    multiEdgeFormulas.add(this.createFormulaForEdge(singleEdge, function, ssa, pts, constraints, errorConditions));
                    this.shutdownNotifier.shutdownIfNecessary();
                }
                return this.bfmgr.and(multiEdgeFormulas);
            }
        }
        throw new UnrecognizedCFAEdgeException(edge);
    }

    protected BooleanFormula makeStatement(CStatementEdge statement, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        CStatement stmt = statement.getStatement();
        if (stmt instanceof CAssignment) {
            CAssignment assignment = (CAssignment)stmt;
            return this.makeAssignment(assignment.getLeftHandSide(), assignment.getRightHandSide(), statement, function, ssa, pts, constraints, errorConditions);
        }
        if (stmt instanceof CFunctionCallStatement) {
            CRightHandSideVisitor<Formula, UnrecognizedCCodeException> ev = this.createCRightHandSideVisitor(statement, function, ssa, pts, constraints, errorConditions);
            CFunctionCallStatement callStmt = (CFunctionCallStatement)stmt;
            callStmt.getFunctionCallExpression().accept(ev);
        } else if (!(stmt instanceof CExpressionStatement)) {
            throw new UnrecognizedCCodeException("Unknown statement", (CFAEdge)statement, stmt);
        }
        return this.bfmgr.makeBoolean(true);
    }

    protected BooleanFormula makeDeclaration(CDeclarationEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        int size;
        CExpression length;
        CType elementType;
        if (!(edge.getDeclaration() instanceof CVariableDeclaration)) {
            this.logfOnce(Level.FINEST, edge, "Ignoring declaration", new Object[0]);
            return this.bfmgr.makeBoolean(true);
        }
        CVariableDeclaration decl = (CVariableDeclaration)edge.getDeclaration();
        String varName = decl.getQualifiedName();
        if (!this.isRelevantVariable(decl)) {
            this.logger.logfOnce(Level.FINEST, "%s: Ignoring declaration of unused variable: %s", new Object[]{decl.getFileLocation(), decl.toASTString()});
            return this.bfmgr.makeBoolean(true);
        }
        CType declarationType = decl.getType().getCanonicalType();
        if (declarationType instanceof CArrayType && (elementType = ((CArrayType)declarationType).getType()) instanceof CSimpleType && ((CSimpleType)elementType).getType().isFloatingPointType() && (length = ((CArrayType)declarationType).getLength()) instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)length).getValue().longValue() > 100L) {
            throw new UnsupportedCCodeException("large floating-point array", edge);
        }
        if (this.options.useParameterVariablesForGlobals() && decl.isGlobal()) {
            this.globalDeclarations.add(decl);
        }
        if (this.direction == AnalysisDirection.FORWARD) {
            this.makeFreshIndex(varName, decl.getType(), ssa);
        }
        BooleanFormula result = this.bfmgr.makeBoolean(true);
        if (decl.getInitializer() instanceof CInitializerList && (size = this.machineModel.getSizeof(decl.getType())) > 0) {
            Formula formula = this.makeVariable(varName, decl.getType(), ssa);
            CType elementCType = decl.getType();
            FormulaType<?> elementFormulaType = this.getFormulaTypeFromCType(elementCType);
            Object zero = this.fmgr.makeNumber(elementFormulaType, 0L);
            result = this.bfmgr.and(result, this.fmgr.assignment(formula, zero));
        }
        for (CAssignment cAssignment : CInitializers.convertToAssignments(decl, edge)) {
            result = this.bfmgr.and(result, this.makeAssignment(cAssignment.getLeftHandSide(), cAssignment.getRightHandSide(), edge, function, ssa, pts, constraints, errorConditions));
        }
        return result;
    }

    protected BooleanFormula makeExitFunction(CFunctionSummaryEdge ce, String calledFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        this.addGlobalAssignmentConstraints(ce, calledFunction, ssa, pts, constraints, errorConditions, RETURN_VARIABLE_NAME, false);
        CFunctionCall retExp = ce.getExpression();
        if (retExp instanceof CFunctionCallStatement) {
            return this.bfmgr.makeBoolean(true);
        }
        if (retExp instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement exp = (CFunctionCallAssignmentStatement)retExp;
            CFunctionCallExpression funcCallExp = exp.getRightHandSide();
            String callerFunction = ce.getSuccessor().getFunctionName();
            Optional<CVariableDeclaration> returnVariableDeclaration = ce.getFunctionEntry().getReturnVariable();
            if (!returnVariableDeclaration.isPresent()) {
                throw new UnrecognizedCCodeException("Void function used in assignment", (CFAEdge)ce, retExp);
            }
            CIdExpression rhs = new CIdExpression(funcCallExp.getFileLocation(), (CSimpleDeclaration)returnVariableDeclaration.get());
            return this.makeAssignment(exp.getLeftHandSide(), rhs, ce, callerFunction, ssa, pts, constraints, errorConditions);
        }
        throw new UnrecognizedCCodeException("Unknown function exit expression", (CFAEdge)ce, retExp);
    }

    protected CType getReturnType(CFunctionCallExpression funcCallExp, CFAEdge edge) throws UnrecognizedCCodeException {
        CType expType;
        CType retType;
        CFunctionDeclaration funcDecl = funcCallExp.getDeclaration();
        if (funcDecl == null) {
            CExpression functionNameExpression = funcCallExp.getFunctionNameExpression();
            CType expressionType = functionNameExpression.getExpressionType().getCanonicalType();
            if (expressionType instanceof CFunctionType) {
                CFunctionType funcPtrType = (CFunctionType)expressionType;
                retType = funcPtrType.getReturnType();
            } else if (expressionType instanceof CPointerType && ((CPointerType)expressionType).getType().getCanonicalType() instanceof CFunctionType) {
                CFunctionType funcPtrType = (CFunctionType)((CPointerType)expressionType).getType().getCanonicalType();
                retType = funcPtrType.getReturnType();
            } else {
                throw new UnrecognizedCCodeException("Cannot handle function pointer call with unknown type " + expressionType, edge, funcCallExp);
            }
            assert (retType != null);
        } else {
            retType = funcDecl.getType().getReturnType();
        }
        if (!(expType = funcCallExp.getExpressionType()).getCanonicalType().equals(retType.getCanonicalType())) {
            String functionName = funcDecl != null ? funcDecl.getName() : funcCallExp.getFunctionNameExpression().toASTString();
            this.logfOnce(Level.WARNING, edge, "Return type of function %s is %s, but result is used as type %s", functionName, retType, expType);
        }
        return expType;
    }

    protected BooleanFormula makeFunctionCall(CFunctionCallEdge edge, String callerFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        List<CExpression> actualParams = edge.getArguments();
        CFunctionEntryNode fn = edge.getSuccessor();
        List<CParameterDeclaration> formalParams = fn.getFunctionParameters();
        if (fn.getFunctionDefinition().getType().takesVarArgs()) {
            if (formalParams.size() > actualParams.size()) {
                throw new UnrecognizedCCodeException("Number of parameters on function call does not match function definition", edge);
            }
            if (!SAFE_VAR_ARG_FUNCTIONS.contains(fn.getFunctionName())) {
                this.logfOnce(Level.WARNING, edge, "Ignoring parameters passed as varargs to function %s", fn.getFunctionName());
            }
        } else if (formalParams.size() != actualParams.size()) {
            throw new UnrecognizedCCodeException("Number of parameters on function call does not match function definition", edge);
        }
        int i = 0;
        BooleanFormula result = this.bfmgr.makeBoolean(true);
        for (CParameterDeclaration formalParam : formalParams) {
            CIdExpression paramLHS;
            CExpression paramExpression = actualParams.get(i++);
            CIdExpression lhs = new CIdExpression(paramExpression.getFileLocation(), formalParam);
            if (this.options.useParameterVariables()) {
                CParameterDeclaration tmpParameter = new CParameterDeclaration(formalParam.getFileLocation(), formalParam.getType(), formalParam.getName() + PARAM_VARIABLE_NAME);
                tmpParameter.setQualifiedName(formalParam.getQualifiedName() + PARAM_VARIABLE_NAME);
                paramLHS = new CIdExpression(paramExpression.getFileLocation(), tmpParameter);
            } else {
                paramLHS = lhs;
            }
            BooleanFormula eq = this.makeAssignment(paramLHS, lhs, paramExpression, edge, callerFunction, ssa, pts, constraints, errorConditions);
            result = this.bfmgr.and(result, eq);
        }
        this.addGlobalAssignmentConstraints(edge, fn.getFunctionName(), ssa, pts, constraints, errorConditions, PARAM_VARIABLE_NAME, true);
        return result;
    }

    protected BooleanFormula makeReturn(Optional<CAssignment> assignment, CReturnStatementEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        if (!assignment.isPresent()) {
            return this.bfmgr.makeBoolean(true);
        }
        return this.makeAssignment(((CAssignment)assignment.get()).getLeftHandSide(), ((CAssignment)assignment.get()).getRightHandSide(), edge, function, ssa, pts, constraints, errorConditions);
    }

    private BooleanFormula makeAssignment(CLeftHandSide lhs, CRightHandSide rhs, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        return this.makeAssignment(lhs, lhs, rhs, edge, function, ssa, pts, constraints, errorConditions);
    }

    protected BooleanFormula makeAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, CRightHandSide rhs, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        if (!this.isRelevantLeftHandSide(lhsForChecking)) {
            return this.bfmgr.makeBoolean(true);
        }
        CType lhsType = lhs.getExpressionType().getCanonicalType();
        if (lhsType instanceof CArrayType) {
            return this.bfmgr.makeBoolean(true);
        }
        if (rhs instanceof CExpression) {
            rhs = this.makeCastFromArrayToPointerIfNecessary((CExpression)rhs, lhsType);
        }
        Formula l = null;
        Formula r = null;
        if (this.direction == AnalysisDirection.BACKWARD) {
            l = this.buildLvalueTerm(lhs, edge, function, ssa, pts, constraints, errorConditions);
            r = this.buildTerm(rhs, edge, function, ssa, pts, constraints, errorConditions);
        } else {
            r = this.buildTerm(rhs, edge, function, ssa, pts, constraints, errorConditions);
            l = this.buildLvalueTerm(lhs, edge, function, ssa, pts, constraints, errorConditions);
        }
        r = this.makeCast(rhs.getExpressionType(), lhsType, r, constraints, edge);
        return this.fmgr.assignment(l, r);
    }

    public Formula buildTermFromPathFormula(PathFormula pFormula, CIdExpression expr, CFAEdge edge) throws UnrecognizedCCodeException {
        String functionName = edge.getPredecessor().getFunctionName();
        Constraints constraints = new Constraints(this.bfmgr);
        return this.buildTerm(expr, edge, functionName, pFormula.getSsa().builder(), this.createPointerTargetSetBuilder(pFormula.getPointerTargetSet()), constraints, ErrorConditions.dummyInstance(this.bfmgr));
    }

    protected Formula buildTerm(CRightHandSide exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException {
        return exp.accept(this.createCRightHandSideVisitor(edge, function, ssa, pts, constraints, errorConditions));
    }

    protected Formula buildLvalueTerm(CLeftHandSide exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException {
        return exp.accept(new LvalueVisitor(this, edge, function, ssa, pts, constraints, errorConditions));
    }

    <T extends Formula> T ifTrueThenOneElseZero(FormulaType<T> type, BooleanFormula pCond) {
        T one = this.fmgr.makeNumber(type, 1L);
        T zero = this.fmgr.makeNumber(type, 0L);
        return this.bfmgr.ifThenElse(pCond, one, zero);
    }

    protected final <T extends Formula> BooleanFormula toBooleanFormula(T pF) {
        assert (!this.fmgr.getFormulaType(pF).isBooleanType());
        T zero = this.fmgr.makeNumber(this.fmgr.getFormulaType(pF), 0L);
        if (this.bfmgr.isIfThenElse(pF)) {
            Triple<BooleanFormula, T, T> parts = this.bfmgr.splitIfThenElse(pF);
            T one = this.fmgr.makeNumber(this.fmgr.getFormulaType(pF), 1L);
            if (((Formula)parts.getSecond()).equals(one) && ((Formula)parts.getThird()).equals(zero)) {
                return (BooleanFormula)parts.getFirst();
            }
            if (((Formula)parts.getSecond()).equals(zero) && ((Formula)parts.getThird()).equals(one)) {
                return this.bfmgr.not((BooleanFormula)parts.getFirst());
            }
        }
        return this.bfmgr.not(this.fmgr.makeEqual(pF, zero));
    }

    protected BooleanFormula makePredicate(CExpression exp, boolean isTrue, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        Formula f = exp.accept(this.createCRightHandSideVisitor(edge, function, ssa, pts, constraints, errorConditions));
        BooleanFormula result = this.toBooleanFormula(f);
        if (!isTrue) {
            result = this.bfmgr.not(result);
        }
        return result;
    }

    public BooleanFormula makePredicate(CExpression exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa) throws UnrecognizedCCodeException, InterruptedException {
        PointerTargetSetBuilder.DummyPointerTargetSetBuilder pts = PointerTargetSetBuilder.DummyPointerTargetSetBuilder.INSTANCE;
        Constraints constraints = new Constraints(this.bfmgr);
        ErrorConditions errorConditions = ErrorConditions.dummyInstance(this.bfmgr);
        BooleanFormula f = this.makePredicate(exp, true, edge, function, ssa, pts, constraints, errorConditions);
        return this.bfmgr.and(f, constraints.get());
    }

    protected PointerTargetSetBuilder createPointerTargetSetBuilder(PointerTargetSet pts) {
        return PointerTargetSetBuilder.DummyPointerTargetSetBuilder.INSTANCE;
    }

    protected CRightHandSideVisitor<Formula, UnrecognizedCCodeException> createCRightHandSideVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) {
        return new ExpressionToFormulaVisitor(this, this.fmgr, pEdge, pFunction, ssa, constraints);
    }

    private BitvectorFormula accessField(Pair<Integer, Integer> msb_Lsb, BitvectorFormula f) {
        return this.fmgr.makeExtract(f, (Integer)msb_Lsb.getFirst(), (Integer)msb_Lsb.getSecond());
    }

    BitvectorFormula accessField(CFieldReference fExp, Formula f) throws UnrecognizedCCodeException {
        assert (this.options.handleFieldAccess()) : "Fieldaccess if only allowed with handleFieldAccess";
        assert (f instanceof BitvectorFormula) : "Fields need to be represented with bitvectors";
        Pair<Integer, Integer> msb_Lsb = this.getFieldOffsetMsbLsb(fExp);
        return this.accessField(msb_Lsb, (BitvectorFormula)f);
    }

    Formula replaceField(CFieldReference fExp, Formula pLVar, Optional<Formula> pRightVariable) throws UnrecognizedCCodeException {
        assert (this.options.handleFieldAccess()) : "Fieldaccess if only allowed with handleFieldAccess";
        Pair<Integer, Integer> msb_Lsb = this.getFieldOffsetMsbLsb(fExp);
        int size = this.efmgr.getLength((BitvectorFormula)pLVar);
        assert (size > (Integer)msb_Lsb.getFirst()) : "pLVar is too small";
        assert (0 <= (Integer)msb_Lsb.getSecond() && (Integer)msb_Lsb.getFirst() >= (Integer)msb_Lsb.getSecond()) : "msb_Lsb is invalid";
        ArrayList<Object> parts = new ArrayList<Object>(3);
        if ((Integer)msb_Lsb.getFirst() + 1 < size) {
            parts.add(this.fmgr.makeExtract(pLVar, size - 1, (Integer)msb_Lsb.getFirst() + 1));
        }
        if (pRightVariable.isPresent()) {
            assert (this.efmgr.getLength((BitvectorFormula)pRightVariable.get()) == (Integer)msb_Lsb.getFirst() + 1 - (Integer)msb_Lsb.getSecond()) : "The new formula has not the right size";
            parts.add(pRightVariable.get());
        }
        if ((Integer)msb_Lsb.getSecond() > 0) {
            parts.add(this.fmgr.makeExtract(pLVar, (Integer)msb_Lsb.getSecond() - 1, 0));
        }
        if (parts.isEmpty()) {
            return this.efmgr.makeBitvector(0, 0L);
        }
        return this.fmgr.makeConcat(parts);
    }

    private Pair<Integer, Integer> getFieldOffsetMsbLsb(CFieldReference fExp) throws UnrecognizedCCodeException {
        int offset;
        CExpression fieldRef = CtoFormulaTypeUtils.getRealFieldOwner(fExp);
        CCompositeType structType = (CCompositeType)fieldRef.getExpressionType().getCanonicalType();
        int bitsPerByte = this.machineModel.getSizeofCharInBits();
        switch (structType.getKind()) {
            case UNION: {
                offset = 0;
                break;
            }
            case STRUCT: {
                offset = this.getFieldOffset(structType, fExp.getFieldName()) * bitsPerByte;
                break;
            }
            default: {
                throw new UnrecognizedCCodeException("Unexpected field access", fExp);
            }
        }
        int fieldSize = this.getSizeof(fExp.getExpressionType()) * bitsPerByte;
        if (fieldSize == 0 && structType.getKind() == CComplexType.ComplexTypeKind.UNION) {
            fieldSize = this.getSizeof(fieldRef.getExpressionType());
        }
        int lsb = offset;
        int msb = offset + fieldSize - 1;
        assert (lsb >= 0);
        assert (msb >= lsb);
        Pair msb_Lsb = Pair.of((Object)msb, (Object)lsb);
        return msb_Lsb;
    }

    private int getFieldOffset(CCompositeType structType, String fieldName) {
        int off = 0;
        for (CCompositeType.CCompositeTypeMemberDeclaration member : structType.getMembers()) {
            if (member.getName().equals(fieldName)) {
                return off;
            }
            off += this.getSizeof(member.getType());
        }
        throw new AssertionError((Object)("field " + fieldName + " was not found in " + structType));
    }

    Formula makeVariableUnsafe(CExpression exp, String function, SSAMap.SSAMapBuilder ssa, boolean makeFresh) {
        if (makeFresh) {
            this.logger.logOnce(Level.WARNING, new Object[]{"Program contains array, or pointer (multiple level of indirection), or field (enable handleFieldAccess and handleFieldAliasing) access; analysis is imprecise in case of aliasing."});
        }
        this.logger.logfOnce(Level.FINEST, "%s: Unhandled expression treated as free variable: %s", new Object[]{exp.getFileLocation(), exp.toASTString()});
        String var = CtoFormulaConverter.exprToVarName(exp, function);
        if (makeFresh) {
            return this.makeFreshVariable(var, exp.getExpressionType(), ssa);
        }
        return this.makeVariable(var, exp.getExpressionType(), ssa);
    }
}

