/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;

public class CtoFormulaTypeHandler {
    protected final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel.BaseSizeofVisitor sizeofVisitor;
    private final FormulaType<?> pointerType;

    public CtoFormulaTypeHandler(LogManager pLogger, FormulaEncodingOptions pOptions, MachineModel pMachineModel, FormulaManagerView pFmgr) {
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.machineModel = pMachineModel;
        this.sizeofVisitor = new MachineModel.BaseSizeofVisitor(pMachineModel);
        int pointerSize = this.machineModel.getSizeofPtr();
        int bitsPerByte = this.machineModel.getSizeofCharInBits();
        this.pointerType = FormulaType.getBitvectorTypeWithSize(pointerSize * bitsPerByte);
    }

    public int getSizeof(CType pType) {
        int size = pType.accept(this.sizeofVisitor);
        if (size == 0) {
            CType type = pType.getCanonicalType();
            if (type instanceof CArrayType) {
                this.logger.logOnce(Level.WARNING, new Object[]{"Type", pType, "is a zero-length array, this is undefined."});
            } else if (type instanceof CCompositeType) {
                this.logger.logOnce(Level.WARNING, new Object[]{"Type", pType, "has no fields, this is undefined."});
            } else {
                this.logger.logOnce(Level.WARNING, new Object[]{"Type", pType, "has size 0 bytes."});
            }
        }
        return size;
    }

    public FormulaType<?> getFormulaTypeFromCType(CType type) {
        if (type instanceof CSimpleType) {
            CSimpleType simpleType = (CSimpleType)type;
            switch (simpleType.getType()) {
                case FLOAT: {
                    return FormulaType.getSinglePrecisionFloatingPointType();
                }
                case DOUBLE: {
                    return FormulaType.getDoublePrecisionFloatingPointType();
                }
            }
        }
        int byteSize = this.getSizeof(type);
        int bitsPerByte = this.machineModel.getSizeofCharInBits();
        return FormulaType.getBitvectorTypeWithSize(byteSize * bitsPerByte);
    }

    public FormulaType<?> getPointerType() {
        return this.pointerType;
    }
}

