/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExternModelLoader;

public class ExpressionToFormulaVisitor
extends DefaultCExpressionVisitor<Formula, UnrecognizedCCodeException>
implements CRightHandSideVisitor<Formula, UnrecognizedCCodeException> {
    private final CtoFormulaConverter conv;
    private final CFAEdge edge;
    private final String function;
    private final Constraints constraints;
    protected final FormulaManagerView mgr;
    protected final SSAMap.SSAMapBuilder ssa;

    public ExpressionToFormulaVisitor(CtoFormulaConverter pCtoFormulaConverter, FormulaManagerView pFmgr, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pConstraints) {
        this.conv = pCtoFormulaConverter;
        this.edge = pEdge;
        this.function = pFunction;
        this.ssa = pSsa;
        this.constraints = pConstraints;
        this.mgr = pFmgr;
    }

    @Override
    protected Formula visitDefault(CExpression exp) throws UnrecognizedCCodeException {
        return this.conv.makeVariableUnsafe(exp, this.function, this.ssa, false);
    }

    protected Formula toFormula(CExpression e) throws UnrecognizedCCodeException {
        return e.accept(this);
    }

    public Formula processOperand(CExpression e, CType calculationType, CType returnType) throws UnrecognizedCCodeException {
        e = this.conv.convertLiteralToFloatIfNecessary(e, calculationType);
        e = this.conv.makeCastFromArrayToPointerIfNecessary(e, returnType);
        CType t = e.getExpressionType();
        Formula f = this.toFormula(e);
        return this.conv.makeCast(t, calculationType, f, this.constraints, this.edge);
    }

    private Formula getPointerTargetSizeLiteral(CPointerType pointerType, CType implicitType) {
        int pointerTargetSize = this.conv.getSizeof(pointerType.getType());
        return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(implicitType), pointerTargetSize);
    }

    private CType getPromotedCType(CType t) {
        if ((t = t.getCanonicalType()) instanceof CSimpleType) {
            return this.conv.machineModel.getPromotedCType((CSimpleType)t);
        }
        return t;
    }

    @Override
    public Formula visit(CBinaryExpression exp) throws UnrecognizedCCodeException {
        CType returnType = exp.getExpressionType();
        CType calculationType = exp.getCalculationType();
        Formula f1 = this.processOperand(exp.getOperand1(), calculationType, returnType);
        Formula f2 = this.processOperand(exp.getOperand2(), calculationType, returnType);
        return this.handleBinaryExpression(exp, f1, f2);
    }

    public final Formula handleBinaryExpression(CBinaryExpression exp, Formula f1, Formula f2) throws UnrecognizedCCodeException {
        Formula ret;
        CBinaryExpression.BinaryOperator op = exp.getOperator();
        CType returnType = exp.getExpressionType();
        CType calculationType = exp.getCalculationType();
        FormulaType<?> returnFormulaType = this.conv.getFormulaTypeFromCType(returnType);
        boolean signed = calculationType instanceof CSimpleType ? this.conv.machineModel.isSigned((CSimpleType)calculationType) : false;
        CType t1 = exp.getOperand1().getExpressionType();
        CType t2 = exp.getOperand2().getExpressionType();
        CType promT1 = this.getPromotedCType(t1).getCanonicalType();
        CType promT2 = this.getPromotedCType(t2).getCanonicalType();
        switch (op) {
            case PLUS: {
                if (!(promT1 instanceof CPointerType) && !(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makePlus(f1, f2);
                    break;
                }
                if (!(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makePlus(f1, this.mgr.makeMultiply(f2, this.getPointerTargetSizeLiteral((CPointerType)promT1, calculationType)));
                    break;
                }
                if (!(promT1 instanceof CPointerType)) {
                    ret = this.mgr.makePlus(f2, this.mgr.makeMultiply(f1, this.getPointerTargetSizeLiteral((CPointerType)promT2, calculationType)));
                    break;
                }
                throw new UnrecognizedCCodeException("Can't add pointers", this.edge, exp);
            }
            case MINUS: {
                if (!(promT1 instanceof CPointerType) && !(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makeMinus(f1, f2);
                    break;
                }
                if (!(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makeMinus(f1, this.mgr.makeMultiply(f2, this.getPointerTargetSizeLiteral((CPointerType)promT1, calculationType)));
                    break;
                }
                if (promT1 instanceof CPointerType) {
                    if (promT1.equals(promT2)) {
                        ret = this.mgr.makeDivide(this.mgr.makeMinus(f1, f2), this.getPointerTargetSizeLiteral((CPointerType)promT1, calculationType), true);
                        break;
                    }
                    throw new UnrecognizedCCodeException("Can't subtract pointers of different types", this.edge, exp);
                }
                throw new UnrecognizedCCodeException("Can't subtract a pointer from a non-pointer", this.edge, exp);
            }
            case MULTIPLY: {
                ret = this.mgr.makeMultiply(f1, f2);
                break;
            }
            case DIVIDE: {
                ret = this.mgr.makeDivide(f1, f2, signed);
                break;
            }
            case MODULO: {
                long modulo;
                BooleanFormula modularCongruence;
                ret = this.mgr.makeModulo(f1, f2, signed);
                BooleanFormulaManagerView bfmgr = this.mgr.getBooleanFormulaManager();
                if (exp.getOperand2() instanceof CIntegerLiteralExpression && !bfmgr.isTrue(modularCongruence = this.mgr.makeModularCongruence(ret, f1, modulo = ((CIntegerLiteralExpression)exp.getOperand2()).asLong()))) {
                    this.constraints.addConstraint(modularCongruence);
                }
                FormulaType<Formula> numberType = this.mgr.getFormulaType(f1);
                Formula zero = this.mgr.makeNumber(numberType, 0L);
                BooleanFormula signAndNumBound = bfmgr.ifThenElse(this.mgr.makeGreaterOrEqual(f1, zero, signed), bfmgr.and(this.mgr.makeGreaterOrEqual(ret, zero, signed), this.mgr.makeLessOrEqual(ret, f1, signed)), bfmgr.and(this.mgr.makeLessOrEqual(ret, zero, signed), this.mgr.makeGreaterOrEqual(ret, f1, signed)));
                BooleanFormula denomBound = bfmgr.ifThenElse(this.mgr.makeGreaterOrEqual(f2, zero, signed), this.mgr.makeLessThan(ret, f2, signed), this.mgr.makeLessThan(f2, ret, signed));
                this.constraints.addConstraint(signAndNumBound);
                this.constraints.addConstraint(denomBound);
                break;
            }
            case BINARY_AND: {
                ret = this.mgr.makeAnd(f1, f2);
                break;
            }
            case BINARY_OR: {
                ret = this.mgr.makeOr(f1, f2);
                break;
            }
            case BINARY_XOR: {
                ret = this.mgr.makeXor(f1, f2);
                break;
            }
            case SHIFT_LEFT: {
                ret = this.mgr.makeShiftLeft(f1, f2);
                break;
            }
            case SHIFT_RIGHT: {
                ret = this.mgr.makeShiftRight(f1, f2, signed);
                break;
            }
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case EQUALS: 
            case NOT_EQUALS: {
                BooleanFormula result;
                switch (op) {
                    case GREATER_THAN: {
                        result = this.mgr.makeGreaterThan(f1, f2, signed);
                        break;
                    }
                    case GREATER_EQUAL: {
                        result = this.mgr.makeGreaterOrEqual(f1, f2, signed);
                        break;
                    }
                    case LESS_THAN: {
                        result = this.mgr.makeLessThan(f1, f2, signed);
                        break;
                    }
                    case LESS_EQUAL: {
                        result = this.mgr.makeLessOrEqual(f1, f2, signed);
                        break;
                    }
                    case EQUALS: {
                        result = this.mgr.makeEqual(f1, f2);
                        break;
                    }
                    case NOT_EQUALS: {
                        result = this.conv.bfmgr.not(this.mgr.makeEqual(f1, f2));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                return this.conv.ifTrueThenOneElseZero(returnFormulaType, result);
            }
            default: {
                throw new UnrecognizedCCodeException("Unknown binary operator", this.edge, exp);
            }
        }
        Formula castedResult = this.conv.makeCast(calculationType, returnType, ret, this.constraints, this.edge);
        assert (returnFormulaType.equals(this.mgr.getFormulaType(castedResult))) : "Returntype and Formulatype do not match in visit(CBinaryExpression): " + exp;
        return castedResult;
    }

    @Override
    public Formula visit(CCastExpression cexp) throws UnrecognizedCCodeException {
        CExpression op = cexp.getOperand();
        op = this.conv.makeCastFromArrayToPointerIfNecessary(op, cexp.getExpressionType());
        Formula operand = this.toFormula(op);
        CType after = cexp.getExpressionType();
        CType before = op.getExpressionType();
        return this.conv.makeCast(before, after, operand, this.constraints, this.edge);
    }

    @Override
    public Formula visit(CIdExpression idExp) throws UnrecognizedCCodeException {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            CType t = idExp.getExpressionType();
            if (enumerator.hasValue()) {
                return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(t), enumerator.getValue());
            }
            return this.conv.makeConstant(enumerator.getName(), t);
        }
        return this.conv.makeVariable(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.ssa);
    }

    @Override
    public Formula visit(CFieldReference fExp) throws UnrecognizedCCodeException {
        CSimpleDeclaration decl;
        if (this.conv.options.handleFieldAccess()) {
            CExpression fieldOwner = CtoFormulaTypeUtils.getRealFieldOwner(fExp);
            Formula f = this.toFormula(fieldOwner);
            return this.conv.accessField(fExp, f);
        }
        CExpression fieldRef = fExp.getFieldOwner();
        if (fieldRef instanceof CIdExpression && (decl = ((CIdExpression)fieldRef).getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal()) {
            return this.conv.makeVariable(CtoFormulaConverter.exprToVarNameUnscoped(fExp), fExp.getExpressionType(), this.ssa);
        }
        return (Formula)super.visit(fExp);
    }

    @Override
    public Formula visit(CCharLiteralExpression cExp) throws UnrecognizedCCodeException {
        FormulaType<?> t = this.conv.getFormulaTypeFromCType(cExp.getExpressionType());
        return this.mgr.makeNumber(t, cExp.getCharacter());
    }

    @Override
    public Formula visit(CIntegerLiteralExpression iExp) throws UnrecognizedCCodeException {
        FormulaType<?> t = this.conv.getFormulaTypeFromCType(iExp.getExpressionType());
        return this.mgr.makeNumber(t, iExp.getValue());
    }

    @Override
    public Formula visit(CImaginaryLiteralExpression exp) throws UnrecognizedCCodeException {
        return this.toFormula(exp.getValue());
    }

    @Override
    public Formula visit(CFloatLiteralExpression fExp) throws UnrecognizedCCodeException {
        FormulaType<?> t = this.conv.getFormulaTypeFromCType(fExp.getExpressionType());
        return this.mgr.getFloatingPointFormulaManager().makeNumber(fExp.getValue(), (FormulaType.FloatingPointType)t);
    }

    @Override
    public Formula visit(CStringLiteralExpression lexp) throws UnrecognizedCCodeException {
        return this.conv.makeStringLiteral(lexp.getValue());
    }

    @Override
    public Formula visit(CUnaryExpression exp) throws UnrecognizedCCodeException {
        CExpression operand = exp.getOperand();
        CUnaryExpression.UnaryOperator op = exp.getOperator();
        switch (op) {
            case MINUS: 
            case TILDE: {
                Formula ret;
                CType t = operand.getExpressionType();
                CType promoted = this.getPromotedCType(t.getCanonicalType());
                Formula operandFormula = this.toFormula(operand);
                operandFormula = this.conv.makeCast(t, promoted, operandFormula, this.constraints, this.edge);
                if (op == CUnaryExpression.UnaryOperator.MINUS) {
                    ret = this.mgr.makeNegate(operandFormula);
                } else {
                    assert (op == CUnaryExpression.UnaryOperator.TILDE) : "This case should be impossible because of switch";
                    ret = this.mgr.makeNot(operandFormula);
                }
                CType returnType = exp.getExpressionType();
                FormulaType<?> returnFormulaType = this.conv.getFormulaTypeFromCType(returnType);
                assert (returnFormulaType.equals(this.mgr.getFormulaType(ret))) : "Returntype and Formulatype do not match in visit(CUnaryExpression)";
                return ret;
            }
            case AMPER: {
                return this.visitDefault(exp);
            }
            case SIZEOF: {
                CType lCType = exp.getOperand().getExpressionType();
                return this.handleSizeof(exp, lCType);
            }
        }
        throw new UnrecognizedCCodeException("Unknown unary operator", this.edge, exp);
    }

    @Override
    public Formula visit(CTypeIdExpression tIdExp) throws UnrecognizedCCodeException {
        if (tIdExp.getOperator() == CTypeIdExpression.TypeIdOperator.SIZEOF) {
            CType lCType = tIdExp.getType();
            return this.handleSizeof(tIdExp, lCType);
        }
        return this.visitDefault(tIdExp);
    }

    private Formula handleSizeof(CExpression pExp, CType pCType) throws UnrecognizedCCodeException {
        return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(pExp.getExpressionType()), this.conv.getSizeof(pCType));
    }

    @Override
    public Formula visit(CFunctionCallExpression e) throws UnrecognizedCCodeException {
        String functionName;
        CExpression functionNameExpression = e.getFunctionNameExpression();
        CType returnType = e.getExpressionType();
        List<CExpression> parameters = e.getParameterExpressions();
        if (functionNameExpression instanceof CIdExpression) {
            CType paramType;
            CType resultType;
            FormulaType<?> formulaType;
            functionName = ((CIdExpression)functionNameExpression).getName();
            if (this.conv.options.isNondetFunction(functionName) || this.conv.options.isMemoryAllocationFunction(functionName) || this.conv.options.isMemoryAllocationFunctionWithZeroing(functionName)) {
                return this.makeNondet(functionName, returnType);
            }
            if (this.conv.options.isExternModelFunction(functionName)) {
                ExternModelLoader loader = new ExternModelLoader(this.conv.typeHandler, this.conv.bfmgr, this.conv.fmgr);
                BooleanFormula result = loader.handleExternModelFunction(e, parameters, this.ssa);
                FormulaType<?> returnFormulaType = this.conv.getFormulaTypeFromCType(e.getExpressionType());
                return this.conv.ifTrueThenOneElseZero(returnFormulaType, result);
            }
            if (CtoFormulaConverter.UNSUPPORTED_FUNCTIONS.containsKey(functionName)) {
                throw new UnsupportedCCodeException(CtoFormulaConverter.UNSUPPORTED_FUNCTIONS.get(functionName), this.edge, e);
            }
            if (functionName.equals("__builtin_inf") || functionName.equals("__builtin_inff") || functionName.equals("__builtin_infl")) {
                if (parameters.size() == 0 && (formulaType = this.conv.getFormulaTypeFromCType(resultType = this.getTypeForFloatFunction("__builtin_inf", functionName))).isFloatingPointType()) {
                    return this.mgr.getFloatingPointFormulaManager().makePlusInfinity((FormulaType.FloatingPointType)formulaType);
                }
            } else if (functionName.equals("__builtin_huge_val") || functionName.equals("__builtin_huge_valf") || functionName.equals("__builtin_huge_vall")) {
                if (parameters.size() == 0 && (formulaType = this.conv.getFormulaTypeFromCType(resultType = this.getTypeForFloatFunction("__builtin_huge_val", functionName))).isFloatingPointType()) {
                    return this.mgr.getFloatingPointFormulaManager().makePlusInfinity((FormulaType.FloatingPointType)formulaType);
                }
            } else if (functionName.equals("__builtin_nan") || functionName.equals("__builtin_nanf") || functionName.equals("__builtin_nanl")) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(resultType = this.getTypeForFloatFunction("__builtin_nan", functionName))).isFloatingPointType()) {
                    return this.mgr.getFloatingPointFormulaManager().makeNaN((FormulaType.FloatingPointType)formulaType);
                }
            } else if (functionName.equals("__builtin_fabs") || functionName.equals("__builtin_fabsf") || functionName.equals("__builtin_fabsl")) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = this.getTypeForFloatFunction("__builtin_fabs", functionName))).isFloatingPointType()) {
                    Formula param = this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula zero = this.mgr.getFloatingPointFormulaManager().makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    BooleanFormula isNegative = this.mgr.makeLessThan(param, zero, true);
                    return this.mgr.getBooleanFormulaManager().ifThenElse(isNegative, this.mgr.makeNegate(param), param);
                }
            } else if (functionName.equals("__fpclassify") || functionName.equals("__fpclassifyd") || functionName.equals("__fpclassifyf") || functionName.equals("__fpclassifyl")) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = this.getTypeForFloatFunction("__fpclassify", functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FormulaType<?> resultType2 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    Object zero = this.mgr.makeNumber(resultType2, 0L);
                    Object one = this.mgr.makeNumber(resultType2, 1L);
                    Object two = this.mgr.makeNumber(resultType2, 2L);
                    Object three = this.mgr.makeNumber(resultType2, 3L);
                    Object four = this.mgr.makeNumber(resultType2, 4L);
                    return this.conv.bfmgr.ifThenElse(fpfmgr.isNaN(param), zero, this.conv.bfmgr.ifThenElse(fpfmgr.isInfinity(param), one, this.conv.bfmgr.ifThenElse(fpfmgr.isZero(param), two, this.conv.bfmgr.ifThenElse(fpfmgr.isSubnormal(param), three, four))));
                }
            } else if (!CtoFormulaConverter.PURE_EXTERNAL_FUNCTIONS.contains(functionName)) {
                if (parameters.isEmpty()) {
                    this.conv.logger.logOnce(Level.INFO, new Object[]{"Assuming external function", functionName, "to be a constant function."});
                } else {
                    this.conv.logger.logOnce(Level.INFO, new Object[]{"Assuming external function", functionName, "to be a pure function."});
                }
            }
        } else {
            this.conv.logfOnce(Level.WARNING, this.edge, "Ignoring function call through function pointer %s", functionNameExpression);
            String escapedName = CtoFormulaConverter.exprToVarName(functionNameExpression, this.function);
            functionName = ("<func>{" + escapedName + "}").intern();
        }
        if (parameters.isEmpty()) {
            return this.conv.makeConstant(functionName, returnType);
        }
        CFunctionDeclaration functionDeclaration = e.getDeclaration();
        if (functionDeclaration == null) {
            if (functionNameExpression instanceof CIdExpression) {
                this.conv.logger.logfOnce(Level.WARNING, "Cannot get declaration of function %s, ignoring calls to it.", new Object[]{functionNameExpression});
            }
            return this.makeNondet(functionName, returnType);
        }
        if (functionDeclaration.getType().takesVarArgs()) {
            return this.makeNondet(functionName, returnType);
        }
        List<CType> formalParameterTypes = functionDeclaration.getType().getParameters();
        if (formalParameterTypes.size() != parameters.size()) {
            throw new UnrecognizedCCodeException("Function " + functionDeclaration + " received " + parameters.size() + " parameters" + " instead of the expected " + formalParameterTypes.size(), this.edge, e);
        }
        ArrayList<Formula> arguments = new ArrayList<Formula>(parameters.size());
        Iterator<CType> formalParameterTypesIt = formalParameterTypes.iterator();
        Iterator<CExpression> parametersIt = parameters.iterator();
        while (formalParameterTypesIt.hasNext() && parametersIt.hasNext()) {
            CType formalParameterType = formalParameterTypesIt.next();
            CExpression parameter = parametersIt.next();
            parameter = this.conv.makeCastFromArrayToPointerIfNecessary(parameter, formalParameterType);
            Formula argument = this.toFormula(parameter);
            arguments.add(this.conv.makeCast(parameter.getExpressionType(), formalParameterType, argument, this.constraints, this.edge));
        }
        assert (!formalParameterTypesIt.hasNext() && !parametersIt.hasNext());
        CType realReturnType = this.conv.getReturnType(e, this.edge);
        FormulaType<?> resultFormulaType = this.conv.getFormulaTypeFromCType(realReturnType);
        return this.conv.ffmgr.declareAndCallUninterpretedFunction(functionName, resultFormulaType, arguments);
    }

    private CType getTypeForFloatFunction(String prefix, String name) {
        assert (name.startsWith(prefix));
        name = name.substring(prefix.length());
        assert (name.length() <= 1);
        if (name.isEmpty()) {
            return CNumericTypes.DOUBLE;
        }
        switch (name.charAt(0)) {
            case 'f': {
                return CNumericTypes.FLOAT;
            }
            case 'd': {
                return CNumericTypes.DOUBLE;
            }
            case 'l': {
                return CNumericTypes.LONG_DOUBLE;
            }
        }
        throw new AssertionError();
    }

    protected Formula makeNondet(String varName, CType type) {
        return this.conv.makeFreshVariable(varName, type, this.ssa);
    }
}

