/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;

public class ExternModelLoader {
    private final CtoFormulaTypeHandler typeHandler;
    private final BooleanFormulaManagerView bfmgr;
    private final FormulaManagerView fmgr;

    public ExternModelLoader(CtoFormulaTypeHandler pTypeHandler, BooleanFormulaManagerView pBfmgr, FormulaManagerView pFmgr) {
        this.typeHandler = pTypeHandler;
        this.bfmgr = pBfmgr;
        this.fmgr = pFmgr;
    }

    public BooleanFormula handleExternModelFunction(CFunctionCallExpression fexp, List<CExpression> parameters, SSAMap.SSAMapBuilder ssa) {
        assert (parameters.size() > 0) : "No external model given!";
        String filename = parameters.get(0).toASTString().replaceAll("\"", "");
        Path modelFile = Paths.get((String)filename, (String[])new String[0]);
        return this.loadExternalFormula(modelFile, ssa);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BooleanFormula loadExternalFormula(Path pModelFile, SSAMap.SSAMapBuilder ssa) {
        if (!pModelFile.getName().endsWith(".dimacs")) {
            throw new UnsupportedOperationException("Sorry, we can only load dimacs models.");
        }
        try (BufferedReader br = pModelFile.asCharSource(StandardCharsets.UTF_8).openBufferedStream();){
            ArrayList<String> predicates = new ArrayList<String>(10000);
            predicates.add("RheinDummyVar");
            BooleanFormula externalModel = this.bfmgr.makeBoolean(true);
            BitvectorFormula zero = this.fmgr.makeNumber(FormulaType.getBitvectorTypeWithSize(32), 0L);
            String line = "";
            while (true) {
                int len$;
                String[] arr$;
                BooleanFormula constraint;
                if ((line = br.readLine()) != null) {
                    String[] parts;
                    String[] parts2;
                    if (line.startsWith("c ")) {
                        parts2 = line.split(" ");
                        int varID = Integer.parseInt(parts2[1].replace("$", ""));
                        assert (predicates.size() == varID) : "messed up the dimacs parsing!";
                        predicates.add(parts2[2]);
                        continue;
                    }
                    if (line.startsWith("p ")) {
                        parts2 = line.split(" ");
                        assert (predicates.size() == Integer.parseInt(parts2[2]) + 1) : "did not get all dimcas variables?";
                        continue;
                    }
                    if (line.trim().length() <= 0) continue;
                    constraint = this.bfmgr.makeBoolean(false);
                    arr$ = parts = line.split(" ");
                    len$ = arr$.length;
                } else {
                    BooleanFormula booleanFormula = externalModel;
                    return booleanFormula;
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    BooleanFormula formulaVar;
                    String elementStr = arr$[i$];
                    if (elementStr.equals("0") || elementStr.isEmpty()) continue;
                    int elem = Integer.parseInt(elementStr);
                    String predName = "";
                    predName = elem > 0 ? (String)predicates.get(elem) : (String)predicates.get(-elem);
                    int ssaIndex = ssa.getIndex(predName);
                    BooleanFormula constraintPart = null;
                    if (ssaIndex != -1) {
                        formulaVar = this.fmgr.makeVariable(this.typeHandler.getFormulaTypeFromCType(ssa.getType(predName)), predName, ssaIndex);
                        constraintPart = elem > 0 ? this.fmgr.makeNot(this.fmgr.makeEqual(formulaVar, zero)) : this.fmgr.makeEqual(formulaVar, zero);
                    } else {
                        formulaVar = this.fmgr.makeVariable(FormulaType.BooleanType, predName, 1);
                        constraintPart = elem > 0 ? formulaVar : this.bfmgr.not(formulaVar);
                    }
                    constraint = constraint == null ? constraintPart : this.bfmgr.or(constraint, constraintPart);
                }
                if (externalModel == null) {
                    externalModel = constraint;
                    continue;
                }
                externalModel = this.bfmgr.and(externalModel, constraint);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

