/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;

@Options(prefix="cpa.predicate")
public class FormulaEncodingOptions {
    @Option(secure=true, description="Handle field access via extract and concat instead of new variables.")
    private boolean handleFieldAccess = false;
    @Option(secure=true, description="Set of functions that should be considered as giving a non-deterministic return value. If you specify this option, the default values are not added automatically to the list, so you need to specify them explicitly if you need them. Mentioning a function in this list has only an effect, if it is an 'external function', i.e., no source is given in the code for this function.")
    private Set<String> nondetFunctions = ImmutableSet.of((Object)"sscanf", (Object)"random");
    @Option(secure=true, description="Regexp pattern for functions that should be considered as giving a non-deterministic return value (c.f. cpa.predicate.nondedFunctions)")
    private Pattern nondetFunctionsRegexp = Pattern.compile("^(__VERIFIER_)?nondet_[a-zA-Z0-9_]*");
    @Option(secure=true, description="Name of an external function that will be interpreted as if the function call would be replaced by an externally defined expression over the program variables. This will only work when all variables referenced by the dimacs file are global and declared before this function is called.")
    private String externModelFunctionName = "__VERIFIER_externModelSatisfied";
    @Option(secure=true, description="Set of functions that non-deterministically provide new memory on the heap, i.e. they can return either a valid pointer or zero.")
    private Set<String> memoryAllocationFunctions = ImmutableSet.of((Object)"malloc", (Object)"__kmalloc", (Object)"kmalloc");
    @Option(secure=true, description="Set of functions that non-deterministically provide new zeroed memory on the heap, i.e. they can return either a valid pointer or zero.")
    private Set<String> memoryAllocationFunctionsWithZeroing = ImmutableSet.of((Object)"kzalloc", (Object)"calloc");
    @Option(secure=true, description="Ignore variables that are not relevant for reachability properties.")
    private boolean ignoreIrrelevantVariables = true;
    @Option(secure=true, description="Insert tmp-variables for parameters at function-entries. The variables are similar to return-variables at function-exit.")
    private boolean useParameterVariables = false;
    @Option(secure=true, description="Insert tmp-parameters for global variables at function-entries. The global variables are also encoded with return-variables at function-exit.")
    private boolean useParameterVariablesForGlobals = false;

    public FormulaEncodingOptions(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this, FormulaEncodingOptions.class);
    }

    public boolean handleFieldAccess() {
        return this.handleFieldAccess;
    }

    public boolean isNondetFunction(String function) {
        return this.nondetFunctions.contains(function) || this.nondetFunctionsRegexp.matcher(function).matches();
    }

    public boolean isMemoryAllocationFunction(String function) {
        return this.memoryAllocationFunctions.contains(function);
    }

    public boolean isExternModelFunction(String function) {
        return function.equals(this.externModelFunctionName);
    }

    public boolean isMemoryAllocationFunctionWithZeroing(String name) {
        return this.memoryAllocationFunctionsWithZeroing.contains(name);
    }

    public boolean ignoreIrrelevantVariables() {
        return this.ignoreIrrelevantVariables;
    }

    public boolean useParameterVariables() {
        return this.useParameterVariables;
    }

    public boolean useParameterVariablesForGlobals() {
        return this.useParameterVariablesForGlobals;
    }
}

