/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;

class IsRelevantLhsVisitor
extends DefaultCExpressionVisitor<Boolean, RuntimeException> {
    private final CtoFormulaConverter conv;

    IsRelevantLhsVisitor(CtoFormulaConverter pConv) {
        this.conv = pConv;
    }

    @Override
    public Boolean visit(CArraySubscriptExpression e) {
        return e.getArrayExpression().accept(this);
    }

    @Override
    public Boolean visit(CCastExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public Boolean visit(CComplexCastExpression e) {
        return e.getOperand().accept(this);
    }

    @Override
    public Boolean visit(CFieldReference e) {
        CType fieldOwnerType = e.getFieldOwner().getExpressionType().getCanonicalType();
        if (fieldOwnerType instanceof CPointerType) {
            fieldOwnerType = ((CPointerType)fieldOwnerType).getType();
        }
        assert (fieldOwnerType instanceof CCompositeType) : "Field owner should have composite type";
        return this.conv.isRelevantField((CCompositeType)fieldOwnerType, e.getFieldName());
    }

    @Override
    public Boolean visit(CIdExpression e) {
        return this.conv.isRelevantVariable(e.getDeclaration());
    }

    @Override
    public Boolean visit(CPointerExpression e) {
        return true;
    }

    @Override
    protected Boolean visitDefault(CExpression e) {
        throw new IllegalArgumentException("Undexpected left hand side: " + e.toString());
    }
}

