/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CExpressionVisitorWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Expression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetPattern;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Variable;

class AssignmentHandler {
    private final FormulaEncodingWithPointerAliasingOptions options;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final FunctionFormulaManagerView ffmgr;
    private final CToFormulaConverterWithPointerAliasing conv;
    private final CFAEdge edge;
    private final String function;
    private final SSAMap.SSAMapBuilder ssa;
    private final PointerTargetSetBuilder pts;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;

    AssignmentHandler(CToFormulaConverterWithPointerAliasing pConv, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) {
        this.conv = pConv;
        this.options = this.conv.options;
        this.fmgr = this.conv.fmgr;
        this.bfmgr = this.conv.bfmgr;
        this.ffmgr = this.conv.ffmgr;
        this.edge = pEdge;
        this.function = pFunction;
        this.ssa = pSsa;
        this.pts = pPts;
        this.constraints = pConstraints;
        this.errorConditions = pErrorConditions;
    }

    BooleanFormula handleAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, @Nullable CRightHandSide rhs, boolean batchMode, @Nullable Set<CType> destroyedTypes) throws UnrecognizedCCodeException, InterruptedException {
        PointerTargetPattern pattern;
        Object rhsUsedDeferredAllocationPointers;
        Object rhsAddressedFields;
        Object rhsUsedFields;
        Expression rhsExpression;
        CSimpleType rhsType;
        if (!this.conv.isRelevantLeftHandSide(lhsForChecking)) {
            return this.conv.bfmgr.makeBoolean(true);
        }
        CType lhsType = CTypeUtils.simplifyType(lhs.getExpressionType());
        CType cType = rhsType = rhs != null ? CTypeUtils.simplifyType(rhs.getExpressionType()) : CNumericTypes.SIGNED_CHAR;
        if (!(rhs == null || rhs instanceof CFunctionCallExpression && ((CFunctionCallExpression)rhs).getFunctionNameExpression() instanceof CIdExpression && this.conv.options.isNondetFunction(((CIdExpression)((CFunctionCallExpression)rhs).getFunctionNameExpression()).getName()))) {
            CExpressionVisitorWithPointerAliasing rhsVisitor = new CExpressionVisitorWithPointerAliasing(this.conv, this.edge, this.function, this.ssa, this.constraints, this.errorConditions, this.pts);
            CRightHandSide r = rhs;
            if (r instanceof CExpression) {
                r = this.conv.convertLiteralToFloatIfNecessary((CExpression)r, lhsType);
            }
            rhsExpression = r.accept(rhsVisitor);
            this.pts.addEssentialFields(rhsVisitor.getInitializedFields());
            rhsUsedFields = rhsVisitor.getUsedFields();
            rhsAddressedFields = rhsVisitor.getAddressedFields();
            rhsUsedDeferredAllocationPointers = rhsVisitor.getUsedDeferredAllocationPointers();
        } else {
            rhsExpression = Expression.Value.nondetValue();
            rhsUsedFields = ImmutableList.of();
            rhsAddressedFields = ImmutableList.of();
            rhsUsedDeferredAllocationPointers = ImmutableMap.of();
        }
        CExpressionVisitorWithPointerAliasing lhsVisitor = new CExpressionVisitorWithPointerAliasing(this.conv, this.edge, this.function, this.ssa, this.constraints, this.errorConditions, this.pts);
        Expression.Location lhsLocation = lhs.accept(lhsVisitor).asLocation();
        Map<String, CType> lhsUsedDeferredAllocationPointers = lhsVisitor.getUsedDeferredAllocationPointers();
        this.pts.addEssentialFields(lhsVisitor.getInitializedFields());
        List<Pair<CCompositeType, String>> lhsUsedFields = lhsVisitor.getUsedFields();
        PointerTargetPattern pointerTargetPattern = pattern = lhsLocation.isUnaliasedLocation() ? null : PointerTargetPattern.forLeftHandSide(lhs, this.conv.typeHandler, this.conv.ptsMgr, this.edge, this.pts);
        if (this.conv.options.revealAllocationTypeFromLHS() || this.conv.options.deferUntypedAllocations()) {
            DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this.conv, this.edge, this.ssa, this.pts, this.constraints, this.errorConditions);
            memoryHandler.handleDeferredAllocationsInAssignment(lhs, rhs, lhsLocation, rhsExpression, lhsType, lhsUsedDeferredAllocationPointers, (Map<String, CType>)rhsUsedDeferredAllocationPointers);
        }
        BooleanFormula result = this.makeAssignment(lhsType, rhsType, lhsLocation, rhsExpression, pattern, batchMode, destroyedTypes);
        this.pts.addEssentialFields(lhsUsedFields);
        this.pts.addEssentialFields((List<Pair<CCompositeType, String>>)rhsUsedFields);
        Iterator i$ = rhsAddressedFields.iterator();
        while (i$.hasNext()) {
            Pair field = (Pair)i$.next();
            this.pts.addField((CCompositeType)field.getFirst(), (String)field.getSecond());
        }
        return result;
    }

    public BooleanFormula handleInitializationAssignments(CLeftHandSide variable, List<CExpressionAssignmentStatement> assignments) throws UnrecognizedCCodeException, InterruptedException {
        CExpressionVisitorWithPointerAliasing lhsVisitor = new CExpressionVisitorWithPointerAliasing(this.conv, this.edge, this.function, this.ssa, this.constraints, this.errorConditions, this.pts);
        Expression.Location lhsLocation = variable.accept(lhsVisitor).asLocation();
        HashSet<CType> updatedTypes = new HashSet<CType>();
        BooleanFormula result = this.conv.bfmgr.makeBoolean(true);
        for (CExpressionAssignmentStatement assignment : assignments) {
            CLeftHandSide lhs = assignment.getLeftHandSide();
            result = this.conv.bfmgr.and(result, this.handleAssignment(lhs, lhs, assignment.getRightHandSide(), lhsLocation.isAliased(), updatedTypes));
        }
        if (lhsLocation.isAliased()) {
            this.finishAssignments(CTypeUtils.simplifyType(variable.getExpressionType()), lhsLocation.asAliased(), PointerTargetPattern.forLeftHandSide(variable, this.conv.typeHandler, this.conv.ptsMgr, this.edge, this.pts), updatedTypes);
        }
        return result;
    }

    BooleanFormula makeAssignment(@Nonnull CType lvalueType, @Nonnull CType rvalueType, @Nonnull Expression.Location lvalue, @Nonnull Expression rvalue, @Nullable PointerTargetPattern pattern, boolean useOldSSAIndices, @Nullable Set<CType> updatedTypes) throws UnrecognizedCCodeException, InterruptedException {
        Preconditions.checkNotNull((Object)rvalue);
        lvalueType = CTypeUtils.simplifyType(lvalueType);
        updatedTypes = lvalue.isAliased() && !CTypeUtils.isSimpleType(lvalueType) && updatedTypes == null ? new HashSet<CType>() : null;
        Set<Variable> updatedVariables = null;
        if (!lvalue.isAliased() && !CTypeUtils.isSimpleType(lvalueType)) {
            updatedVariables = new HashSet<Variable>();
        }
        BooleanFormula result = this.makeDestructiveAssignment(lvalueType, rvalueType, lvalue, rvalue, useOldSSAIndices, updatedTypes, updatedVariables);
        if (!useOldSSAIndices) {
            if (lvalue.isAliased()) {
                this.addRetentionForAssignment(lvalueType, lvalue.asAliased().getAddress(), pattern, updatedTypes);
                if (updatedTypes == null) {
                    assert (CTypeUtils.isSimpleType(lvalueType)) : "Should be impossible due to the first if statement";
                    updatedTypes = Collections.singleton(lvalueType);
                }
                this.updateSSA(updatedTypes, this.ssa);
            } else {
                if (updatedVariables == null) {
                    assert (CTypeUtils.isSimpleType(lvalueType)) : "Should be impossible due to the first if statement";
                    updatedVariables = Collections.singleton(Variable.create(lvalue.asUnaliased().getVariableName(), lvalueType));
                }
                for (Variable variable : updatedVariables) {
                    String name = variable.getName();
                    CType type = variable.getType();
                    this.conv.makeFreshIndex(name, type, this.ssa);
                }
            }
        }
        return result;
    }

    void finishAssignments(@Nonnull CType lvalueType, @Nonnull Expression.Location.AliasedLocation lvalue, @Nonnull PointerTargetPattern pattern, @Nonnull Set<CType> updatedTypes) throws InterruptedException {
        this.addRetentionForAssignment(lvalueType, lvalue.asAliased().getAddress(), pattern, updatedTypes);
        this.updateSSA(updatedTypes, this.ssa);
    }

    private BooleanFormula makeDestructiveAssignment(@Nonnull CType lvalueType, @Nonnull CType rvalueType, @Nonnull Expression.Location lvalue, @Nonnull Expression rvalue, boolean useOldSSAIndices, @Nullable Set<CType> updatedTypes, @Nullable Set<Variable> updatedVariables) throws UnrecognizedCCodeException {
        lvalueType = CTypeUtils.simplifyType(lvalueType);
        rvalueType = CTypeUtils.simplifyType(rvalueType);
        if (lvalueType instanceof CArrayType) {
            Preconditions.checkArgument((boolean)lvalue.isAliased(), (Object)"Array elements are always aliased (i.e. can't be encoded with variables)");
            CArrayType lvalueArrayType = (CArrayType)lvalueType;
            CType lvalueElementType = CTypeUtils.simplifyType(lvalueArrayType.getType());
            Preconditions.checkArgument((rvalue.isValue() && CTypeUtils.isSimpleType(rvalueType) || rvalue.asLocation().isAliased() && rvalueType instanceof CArrayType && CTypeUtils.simplifyType(((CArrayType)rvalueType).getType()).equals(lvalueElementType) ? 1 : 0) != 0, (String)"Impossible array assignment due to incompatible types: assignment of %s to %s", (Object[])new Object[]{rvalueType, lvalueType});
            Integer length = CTypeUtils.getArrayLength(lvalueArrayType);
            if (length == null || length > this.options.maxArrayLength()) {
                Integer rLength;
                length = rvalue.isLocation() && (rLength = CTypeUtils.getArrayLength((CArrayType)rvalueType)) != null && rLength <= this.options.maxArrayLength() ? rLength : Integer.valueOf(this.options.defaultArrayLength());
            }
            BooleanFormula result = this.bfmgr.makeBoolean(true);
            int offset = 0;
            for (int i = 0; i < length; ++i) {
                Pair<Expression.Location.AliasedLocation, CType> newLvalue = this.shiftArrayLvalue(lvalue.asAliased(), offset, lvalueElementType);
                Pair<? extends Expression, CType> newRvalue = this.shiftArrayRvalue(rvalue, rvalueType, offset, lvalueElementType);
                result = this.bfmgr.and(result, this.makeDestructiveAssignment((CType)newLvalue.getSecond(), (CType)newRvalue.getSecond(), (Expression.Location)newLvalue.getFirst(), (Expression)newRvalue.getFirst(), useOldSSAIndices, updatedTypes, updatedVariables));
                offset += this.conv.getSizeof(lvalueArrayType.getType());
            }
            return result;
        }
        if (lvalueType instanceof CCompositeType) {
            CCompositeType lvalueCompositeType = (CCompositeType)lvalueType;
            assert (lvalueCompositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + lvalueCompositeType;
            if (!(rvalue.isValue() && CTypeUtils.isSimpleType(rvalueType) || rvalueType.equals(lvalueType))) {
                throw new UnrecognizedCCodeException("Impossible structure assignment due to incompatible types: assignment of " + rvalue + " with type " + rvalueType + " to " + lvalue + " with type " + lvalueType, this.edge);
            }
            BooleanFormula result = this.bfmgr.makeBoolean(true);
            int offset = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : lvalueCompositeType.getMembers()) {
                String memberName = memberDeclaration.getName();
                CType newLvalueType = CTypeUtils.simplifyType(memberDeclaration.getType());
                if (this.conv.isRelevantField(lvalueCompositeType, memberName) && (!lvalue.isAliased() || !CTypeUtils.isSimpleType(newLvalueType) || rvalue.isValue() || this.pts.tracksField(lvalueCompositeType, memberName) || !rvalue.asLocation().isAliased() && this.conv.hasIndex(rvalue.asLocation().asUnaliased().getVariableName() + "$" + memberName, newLvalueType, this.ssa))) {
                    Pair<? extends Expression.Location, CType> newLvalue = this.shiftCompositeLvalue(lvalue, offset, memberName, memberDeclaration.getType());
                    Pair<? extends Expression, CType> newRvalue = this.shiftCompositeRvalue(rvalue, offset, memberName, rvalueType, memberDeclaration.getType());
                    result = this.bfmgr.and(result, this.makeDestructiveAssignment((CType)newLvalue.getSecond(), (CType)newRvalue.getSecond(), (Expression.Location)newLvalue.getFirst(), (Expression)newRvalue.getFirst(), useOldSSAIndices, updatedTypes, updatedVariables));
                }
                if (lvalueCompositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
                offset += this.conv.getSizeof(memberDeclaration.getType());
            }
            return result;
        }
        return this.makeSimpleDestructiveAssignment(lvalueType, rvalueType, lvalue, rvalue, useOldSSAIndices, updatedTypes, updatedVariables);
    }

    private BooleanFormula makeSimpleDestructiveAssignment(@Nonnull CType lvalueType, @Nonnull CType rvalueType, @Nonnull Expression.Location lvalue, @Nonnull Expression rvalue, boolean useOldSSAIndices, @Nullable Set<CType> updatedTypes, @Nullable Set<Variable> updatedVariables) throws UnrecognizedCCodeException {
        BooleanFormula result;
        Formula rhs;
        Formula value;
        lvalueType = CTypeUtils.simplifyType(lvalueType);
        rvalueType = CTypeUtils.simplifyType(rvalueType);
        rvalueType = CTypeUtils.implicitCastToPointer(rvalueType);
        Preconditions.checkArgument((boolean)CTypeUtils.isSimpleType(lvalueType), (Object)"To assign to/from arrays/structures/unions use makeDestructiveAssignment");
        Preconditions.checkArgument((boolean)CTypeUtils.isSimpleType(rvalueType), (Object)"To assign to/from arrays/structures/unions use makeDestructiveAssignment");
        switch (rvalue.getKind()) {
            case ALIASED_LOCATION: {
                value = this.conv.makeDereference(rvalueType, rvalue.asAliasedLocation().getAddress(), this.ssa, this.errorConditions);
                break;
            }
            case UNALIASED_LOCATION: {
                value = this.conv.makeVariable(rvalue.asUnaliasedLocation().getVariableName(), rvalueType, this.ssa);
                break;
            }
            case DET_VALUE: {
                value = rvalue.asValue().getValue();
                break;
            }
            case NONDET: {
                value = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        assert (!(lvalueType instanceof CFunctionType)) : "Can't assign to functions";
        String targetName = !lvalue.isAliased() ? lvalue.asUnaliased().getVariableName() : CToFormulaConverterWithPointerAliasing.getUFName(lvalueType);
        FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(lvalueType);
        int newIndex = useOldSSAIndices ? this.conv.getIndex(targetName, lvalueType, this.ssa) : this.conv.getFreshIndex(targetName, lvalueType, this.ssa);
        rvalueType = CTypeUtils.implicitCastToPointer(rvalueType);
        Formula formula = rhs = value != null ? this.conv.makeCast(rvalueType, lvalueType, value, this.constraints, this.edge) : null;
        if (!lvalue.isAliased()) {
            result = rhs != null ? this.fmgr.assignment(this.fmgr.makeVariable(targetType, targetName, newIndex), rhs) : this.bfmgr.makeBoolean(true);
            if (updatedVariables != null) {
                updatedVariables.add(Variable.create(targetName, lvalueType));
            }
        } else {
            Object lhs = this.ffmgr.declareAndCallUninterpretedFunction(targetName, newIndex, targetType, lvalue.asAliased().getAddress());
            result = rhs != null ? this.fmgr.assignment(lhs, rhs) : this.bfmgr.makeBoolean(true);
            if (updatedTypes != null) {
                updatedTypes.add(lvalueType);
            }
        }
        return result;
    }

    private void addRetentionForAssignment(@Nonnull CType lvalueType, @Nullable Formula startAddress, @Nonnull PointerTargetPattern pattern, Set<CType> typesToRetain) throws InterruptedException {
        lvalueType = CTypeUtils.simplifyType(lvalueType);
        int size = this.conv.getSizeof(lvalueType);
        if (CTypeUtils.isSimpleType(lvalueType)) {
            Preconditions.checkArgument((startAddress != null ? 1 : 0) != 0, (Object)"Start address is mandatory for assigning to lvalues of simple types");
            String ufName = CToFormulaConverterWithPointerAliasing.getUFName(lvalueType);
            int oldIndex = this.conv.getIndex(ufName, lvalueType, this.ssa);
            int newIndex = this.conv.getFreshIndex(ufName, lvalueType, this.ssa);
            FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(lvalueType);
            this.addRetentionConstraints(pattern, lvalueType, ufName, oldIndex, newIndex, targetType, startAddress);
        } else if (pattern.isExact()) {
            pattern.setRange(size);
            for (CType type : typesToRetain) {
                String ufName = CToFormulaConverterWithPointerAliasing.getUFName(type);
                int oldIndex = this.conv.getIndex(ufName, type, this.ssa);
                int newIndex = this.conv.getFreshIndex(ufName, type, this.ssa);
                FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(type);
                this.addRetentionConstraints(pattern, type, ufName, oldIndex, newIndex, targetType, null);
            }
        } else if (pattern.isSemiexact()) {
            Preconditions.checkArgument((startAddress != null ? 1 : 0) != 0, (Object)"Start address is mandatory for semiexact pointer target patterns");
            lvalueType = lvalueType instanceof CArrayType ? CTypeUtils.simplifyType(((CArrayType)lvalueType).getType()) : CTypeUtils.simplifyType(((CCompositeType)lvalueType).getMembers().get(0).getType());
            this.addSemiexactRetentionConstraints(pattern, lvalueType, startAddress, size, typesToRetain);
        } else {
            Preconditions.checkArgument((startAddress != null ? 1 : 0) != 0, (Object)"Start address is mandatory for inexact pointer target patterns");
            this.addInexactRetentionConstraints(startAddress, size, typesToRetain);
        }
    }

    private void addRetentionConstraints(PointerTargetPattern pattern, CType lvalueType, String ufName, int oldIndex, int newIndex, FormulaType<?> returnType, Formula lvalue) throws InterruptedException {
        Object targetAddress;
        if (!pattern.isExact()) {
            for (PointerTarget target : this.pts.getMatchingTargets(lvalueType, pattern)) {
                this.conv.shutdownNotifier.shutdownIfNecessary();
                targetAddress = this.fmgr.makePlus(this.fmgr.makeVariable(this.conv.voidPointerFormulaType, target.getBaseName()), this.fmgr.makeNumber(this.conv.voidPointerFormulaType, target.getOffset()));
                BooleanFormula updateCondition = this.fmgr.makeEqual(targetAddress, lvalue);
                BooleanFormula retention = this.fmgr.makeEqual(this.ffmgr.declareAndCallUninterpretedFunction(ufName, newIndex, returnType, new Formula[]{targetAddress}), this.ffmgr.declareAndCallUninterpretedFunction(ufName, oldIndex, returnType, new Formula[]{targetAddress}));
                this.constraints.addConstraint(this.bfmgr.or(updateCondition, retention));
            }
        }
        for (PointerTarget target : this.pts.getSpuriousTargets(lvalueType, pattern)) {
            this.conv.shutdownNotifier.shutdownIfNecessary();
            targetAddress = this.fmgr.makePlus(this.fmgr.makeVariable(this.conv.voidPointerFormulaType, target.getBaseName()), this.fmgr.makeNumber(this.conv.voidPointerFormulaType, target.getOffset()));
            this.constraints.addConstraint(this.fmgr.makeEqual(this.ffmgr.declareAndCallUninterpretedFunction(ufName, newIndex, returnType, new Formula[]{targetAddress}), this.ffmgr.declareAndCallUninterpretedFunction(ufName, oldIndex, returnType, new Formula[]{targetAddress})));
        }
    }

    private void addSemiexactRetentionConstraints(PointerTargetPattern pattern, CType firstElementType, Formula startAddress, int size, Set<CType> types) throws InterruptedException {
        PointerTargetPattern exact = PointerTargetPattern.any();
        for (PointerTarget target : this.pts.getMatchingTargets(firstElementType, pattern)) {
            this.conv.shutdownNotifier.shutdownIfNecessary();
            Object candidateAddress = this.fmgr.makePlus(this.fmgr.makeVariable(this.conv.voidPointerFormulaType, target.getBaseName()), this.fmgr.makeNumber(this.conv.voidPointerFormulaType, target.getOffset()));
            BooleanFormula negAntecedent = this.bfmgr.not(this.fmgr.makeEqual(candidateAddress, startAddress));
            exact.setBase(target.getBase());
            exact.setRange(target.getOffset(), size);
            BooleanFormula consequent = this.bfmgr.makeBoolean(true);
            for (CType type : types) {
                String ufName = CToFormulaConverterWithPointerAliasing.getUFName(type);
                int oldIndex = this.conv.getIndex(ufName, type, this.ssa);
                int newIndex = this.conv.getFreshIndex(ufName, type, this.ssa);
                FormulaType<?> returnType = this.conv.getFormulaTypeFromCType(type);
                for (PointerTarget spurious : this.pts.getSpuriousTargets(type, exact)) {
                    Object targetAddress = this.fmgr.makePlus(this.fmgr.makeVariable(this.conv.voidPointerFormulaType, spurious.getBaseName()), this.fmgr.makeNumber(this.conv.voidPointerFormulaType, spurious.getOffset()));
                    consequent = this.bfmgr.and(consequent, this.fmgr.makeEqual(this.ffmgr.declareAndCallUninterpretedFunction(ufName, newIndex, returnType, new Formula[]{targetAddress}), this.ffmgr.declareAndCallUninterpretedFunction(ufName, oldIndex, returnType, new Formula[]{targetAddress})));
                }
            }
            this.constraints.addConstraint(this.bfmgr.or(negAntecedent, consequent));
        }
    }

    private void addInexactRetentionConstraints(Formula startAddress, int size, Set<CType> types) throws InterruptedException {
        PointerTargetPattern any = PointerTargetPattern.any();
        for (CType type : types) {
            String ufName = CToFormulaConverterWithPointerAliasing.getUFName(type);
            int oldIndex = this.conv.getIndex(ufName, type, this.ssa);
            int newIndex = this.conv.getFreshIndex(ufName, type, this.ssa);
            FormulaType<?> returnType = this.conv.getFormulaTypeFromCType(type);
            for (PointerTarget target : this.pts.getMatchingTargets(type, any)) {
                this.conv.shutdownNotifier.shutdownIfNecessary();
                Object targetAddress = this.fmgr.makePlus(this.fmgr.makeVariable(this.conv.voidPointerFormulaType, target.getBaseName()), this.fmgr.makeNumber(this.conv.voidPointerFormulaType, target.getOffset()));
                Formula endAddress = this.fmgr.makePlus(startAddress, this.fmgr.makeNumber(this.conv.voidPointerFormulaType, size - 1));
                this.constraints.addConstraint(this.bfmgr.or(this.bfmgr.and(this.fmgr.makeLessOrEqual(startAddress, targetAddress, false), this.fmgr.makeLessOrEqual(targetAddress, endAddress, false)), this.fmgr.makeEqual(this.ffmgr.declareAndCallUninterpretedFunction(ufName, newIndex, returnType, new Formula[]{targetAddress}), this.ffmgr.declareAndCallUninterpretedFunction(ufName, oldIndex, returnType, new Formula[]{targetAddress}))));
            }
        }
    }

    private void updateSSA(@Nonnull Set<CType> types, SSAMap.SSAMapBuilder ssa) {
        for (CType type : types) {
            String ufName = CToFormulaConverterWithPointerAliasing.getUFName(type);
            this.conv.makeFreshIndex(ufName, type, ssa);
        }
    }

    private Pair<Expression.Location.AliasedLocation, CType> shiftArrayLvalue(Expression.Location.AliasedLocation lvalue, int offset, CType lvalueElementType) {
        Object offsetFormula = this.fmgr.makeNumber(this.conv.voidPointerFormulaType, offset);
        Expression.Location.AliasedLocation newLvalue = Expression.Location.ofAddress(this.fmgr.makePlus(lvalue.getAddress(), offsetFormula));
        return Pair.of((Object)newLvalue, (Object)lvalueElementType);
    }

    private Pair<? extends Expression, CType> shiftArrayRvalue(Expression rvalue, CType rvalueType, int offset, CType lvalueElementType) {
        switch (rvalue.getKind()) {
            case ALIASED_LOCATION: {
                assert (rvalueType instanceof CArrayType) : "Non-array rvalue in array assignment";
                Object offsetFormula = this.fmgr.makeNumber(this.conv.voidPointerFormulaType, offset);
                Expression.Location.AliasedLocation newRvalue = Expression.Location.ofAddress(this.fmgr.makePlus(rvalue.asAliasedLocation().getAddress(), offsetFormula));
                CType newRvalueType = CTypeUtils.simplifyType(((CArrayType)rvalueType).getType());
                return Pair.of((Object)newRvalue, (Object)newRvalueType);
            }
            case DET_VALUE: {
                return Pair.of((Object)rvalue, (Object)rvalueType);
            }
            case NONDET: {
                CType newLvalueType = CTypeUtils.isSimpleType(lvalueElementType) ? lvalueElementType : CNumericTypes.SIGNED_CHAR;
                return Pair.of((Object)Expression.Value.nondetValue(), (Object)newLvalueType);
            }
            case UNALIASED_LOCATION: {
                throw new AssertionError((Object)"Array locations should always be aliased");
            }
        }
        throw new AssertionError();
    }

    private Pair<? extends Expression.Location, CType> shiftCompositeLvalue(Expression.Location lvalue, int offset, String memberName, CType memberType) {
        CType newLvalueType = CTypeUtils.simplifyType(memberType);
        if (lvalue.isAliased()) {
            Object offsetFormula = this.fmgr.makeNumber(this.conv.voidPointerFormulaType, offset);
            Expression.Location.AliasedLocation newLvalue = Expression.Location.ofAddress(this.fmgr.makePlus(lvalue.asAliased().getAddress(), offsetFormula));
            return Pair.of((Object)newLvalue, (Object)newLvalueType);
        }
        Expression.Location.UnaliasedLocation newLvalue = Expression.Location.ofVariableName(lvalue.asUnaliased().getVariableName() + "$" + memberName);
        return Pair.of((Object)newLvalue, (Object)newLvalueType);
    }

    private Pair<? extends Expression, CType> shiftCompositeRvalue(Expression rvalue, int offset, String memberName, CType rvalueType, CType memberType) {
        CType newLvalueType = CTypeUtils.simplifyType(memberType);
        switch (rvalue.getKind()) {
            case ALIASED_LOCATION: {
                Object offsetFormula = this.fmgr.makeNumber(this.conv.voidPointerFormulaType, offset);
                Expression.Location.AliasedLocation newRvalue = Expression.Location.ofAddress(this.fmgr.makePlus(rvalue.asAliasedLocation().getAddress(), offsetFormula));
                return Pair.of((Object)newRvalue, (Object)newLvalueType);
            }
            case UNALIASED_LOCATION: {
                Expression.Location.UnaliasedLocation newRvalue = Expression.Location.ofVariableName(rvalue.asUnaliasedLocation().getVariableName() + "$" + memberName);
                return Pair.of((Object)newRvalue, (Object)newLvalueType);
            }
            case DET_VALUE: {
                return Pair.of((Object)rvalue, (Object)rvalueType);
            }
            case NONDET: {
                CType newRvalueType = CTypeUtils.isSimpleType(newLvalueType) ? newLvalueType : CNumericTypes.SIGNED_CHAR;
                return Pair.of((Object)Expression.Value.nondetValue(), (Object)newRvalueType);
            }
        }
        throw new AssertionError();
    }
}

