/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Variable;

class BaseVisitor
implements CExpressionVisitor<Variable, UnrecognizedCCodeException> {
    private final PointerTargetSetBuilder pts;
    private final CFAEdge cfaEdge;
    private Variable lastBase = null;

    public BaseVisitor(CFAEdge cfaEdge, PointerTargetSetBuilder pts) {
        this.cfaEdge = cfaEdge;
        this.pts = pts;
    }

    @Override
    public Variable visit(CArraySubscriptExpression e) throws UnrecognizedCCodeException {
        return null;
    }

    @Override
    public Variable visit(CBinaryExpression e) throws UnrecognizedCCodeException {
        return null;
    }

    @Override
    public Variable visit(CCastExpression e) throws UnrecognizedCCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public Variable visit(CComplexCastExpression e) throws UnrecognizedCCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public Variable visit(CFieldReference e) throws UnrecognizedCCodeException {
        Variable base = (e = CToFormulaConverterWithPointerAliasing.eliminateArrow(e, this.cfaEdge)).getFieldOwner().accept(this);
        if (base != null) {
            return Variable.create(base.getName() + "$" + e.getFieldName(), CTypeUtils.simplifyType(e.getExpressionType()));
        }
        return null;
    }

    @Override
    public Variable visit(CIdExpression e) throws UnrecognizedCCodeException {
        CType type = CTypeUtils.simplifyType(e.getExpressionType());
        if (!this.pts.isActualBase(e.getDeclaration().getQualifiedName()) && !CTypeUtils.containsArray(type)) {
            this.lastBase = Variable.create(e.getDeclaration().getQualifiedName(), type);
            return this.lastBase;
        }
        return null;
    }

    @Override
    public Variable visit(CCharLiteralExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("Char literal in place of lvalue", this.cfaEdge, e);
    }

    @Override
    public Variable visit(CFloatLiteralExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("Float literal in place of lvalue", this.cfaEdge, e);
    }

    @Override
    public Variable visit(CIntegerLiteralExpression e) throws UnrecognizedCCodeException {
        return null;
    }

    @Override
    public Variable visit(CStringLiteralExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("String literal in place of lvalue", this.cfaEdge, e);
    }

    @Override
    public Variable visit(CImaginaryLiteralExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("Imaginary literal in place of lvalue", this.cfaEdge, e);
    }

    @Override
    public Variable visit(CTypeIdExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("TypeId in place of lvalue", this.cfaEdge, e);
    }

    @Override
    public Variable visit(CUnaryExpression e) throws UnrecognizedCCodeException {
        switch (e.getOperator()) {
            case AMPER: {
                throw new UnrecognizedCCodeException("Address in place of lvalue", this.cfaEdge, e);
            }
            case TILDE: 
            case MINUS: {
                throw new UnrecognizedCCodeException("Arithmetic in place of lvalue", this.cfaEdge, e);
            }
            case SIZEOF: {
                throw new UnrecognizedCCodeException("Constant in place of lvalue", this.cfaEdge, e);
            }
        }
        throw new UnrecognizedCCodeException("Unrecognized code in place of lvalue", this.cfaEdge, e);
    }

    @Override
    public Variable visit(CPointerExpression e) throws UnrecognizedCCodeException {
        return null;
    }

    @Override
    public Variable visit(CAddressOfLabelExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("Addess of label in place of lvalue", this.cfaEdge, e);
    }

    public Variable getLastBase() {
        return this.lastBase;
    }
}

