/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.AdaptingCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.BaseVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Expression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Variable;

class CExpressionVisitorWithPointerAliasing
extends DefaultCExpressionVisitor<Expression, UnrecognizedCCodeException>
implements CRightHandSideVisitor<Expression, UnrecognizedCCodeException> {
    private final CToFormulaConverterWithPointerAliasing conv;
    private final CFAEdge edge;
    private final SSAMap.SSAMapBuilder ssa;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;
    private final PointerTargetSetBuilder pts;
    private final BaseVisitor baseVisitor;
    private final ExpressionToFormulaVisitor delegate;
    private final List<Pair<CCompositeType, String>> usedFields = new ArrayList<Pair<CCompositeType, String>>(1);
    private final List<Pair<CCompositeType, String>> initializedFields = new ArrayList<Pair<CCompositeType, String>>();
    private final List<Pair<CCompositeType, String>> addressedFields = new ArrayList<Pair<CCompositeType, String>>();
    private final Map<String, CType> usedDeferredAllocationPointers = Maps.newHashMapWithExpectedSize((int)1);

    public CExpressionVisitorWithPointerAliasing(CToFormulaConverterWithPointerAliasing cToFormulaConverter, CFAEdge cfaEdge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints, ErrorConditions errorConditions, PointerTargetSetBuilder pts) {
        this.delegate = new ExpressionToFormulaVisitor(cToFormulaConverter, cToFormulaConverter.fmgr, cfaEdge, function, ssa, constraints){

            @Override
            protected Formula toFormula(CExpression e) throws UnrecognizedCCodeException {
                return CExpressionVisitorWithPointerAliasing.this.asValueFormula(e.accept(CExpressionVisitorWithPointerAliasing.this), CTypeUtils.simplifyType(e.getExpressionType()));
            }

            @Override
            protected Formula makeNondet(String pVarName, CType pType) {
                return null;
            }
        };
        this.conv = cToFormulaConverter;
        this.edge = cfaEdge;
        this.ssa = ssa;
        this.constraints = constraints;
        this.errorConditions = errorConditions;
        this.pts = pts;
        this.baseVisitor = new BaseVisitor(cfaEdge, pts);
    }

    public CRightHandSideVisitor<Formula, UnrecognizedCCodeException> asFormulaVisitor() {
        return new AdaptingExpressionToFormulaVisitor(this);
    }

    private void addEqualBaseAdressConstraint(Formula p1, Formula p2) {
        if (this.errorConditions.isEnabled()) {
            this.constraints.addConstraint(this.conv.fmgr.makeEqual(this.conv.makeBaseAddressOfTerm(p1), this.conv.makeBaseAddressOfTerm(p2)));
        }
    }

    Formula asValueFormula(Expression e, CType type, boolean isSafe) {
        if (e.isValue()) {
            return e.asValue().getValue();
        }
        if (e.asLocation().isAliased()) {
            return !isSafe ? this.conv.makeDereference(type, e.asLocation().asAliased().getAddress(), this.ssa, this.errorConditions) : this.conv.makeSafeDereference(type, e.asLocation().asAliased().getAddress(), this.ssa);
        }
        return this.conv.makeVariable(e.asLocation().asUnaliased().getVariableName(), type, this.ssa);
    }

    Formula asValueFormula(Expression e, CType type) {
        return this.asValueFormula(e, type, false);
    }

    Formula asSafeValueFormula(Expression e, CType type) {
        return this.asValueFormula(e, type, true);
    }

    @Override
    public Expression.Location.AliasedLocation visit(CArraySubscriptExpression e) throws UnrecognizedCCodeException {
        Expression base = e.getArrayExpression().accept(this);
        CType baseType = CTypeUtils.simplifyType(e.getArrayExpression().getExpressionType());
        if (baseType instanceof CArrayType && ((CArrayType)baseType).getLength() != null) {
            assert (base.isAliasedLocation());
        } else {
            base = Expression.Location.AliasedLocation.ofAddress(this.asValueFormula(base, CTypeUtils.implicitCastToPointer(baseType)));
        }
        assert (base.isAliasedLocation());
        CType elementType = CTypeUtils.simplifyType(e.getExpressionType());
        CExpression subscript = e.getSubscriptExpression();
        CType subscriptType = CTypeUtils.simplifyType(subscript.getExpressionType());
        Formula index = this.conv.makeCast(subscriptType, CPointerType.POINTER_TO_VOID, this.asValueFormula(subscript.accept(this), subscriptType), this.constraints, this.edge);
        Object coeff = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, this.conv.getSizeof(elementType));
        Formula baseAddress = base.asAliasedLocation().getAddress();
        Formula address = this.conv.fmgr.makePlus(baseAddress, this.conv.fmgr.makeMultiply(coeff, index));
        this.addEqualBaseAdressConstraint(baseAddress, address);
        return Expression.Location.AliasedLocation.ofAddress(address);
    }

    @Override
    public Expression.Location visit(CFieldReference e) throws UnrecognizedCCodeException {
        Variable variable = (e = CToFormulaConverterWithPointerAliasing.eliminateArrow(e, this.edge)).accept(this.baseVisitor);
        if (variable != null) {
            String variableName = variable.getName();
            if (this.pts.isDeferredAllocationPointer(variableName)) {
                this.usedDeferredAllocationPointers.put(variableName, CPointerType.POINTER_TO_VOID);
            }
            return Expression.Location.UnaliasedLocation.ofVariableName(variableName);
        }
        CType fieldOwnerType = CTypeUtils.simplifyType(e.getFieldOwner().getExpressionType());
        if (fieldOwnerType instanceof CCompositeType) {
            Expression.Location.AliasedLocation base = e.getFieldOwner().accept(this).asAliasedLocation();
            String fieldName = e.getFieldName();
            this.usedFields.add((Pair<CCompositeType, String>)Pair.of((Object)((CCompositeType)fieldOwnerType), (Object)fieldName));
            Object offset = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, this.conv.ptsMgr.getOffset((CCompositeType)fieldOwnerType, fieldName));
            Formula address = this.conv.fmgr.makePlus(base.getAddress(), offset);
            this.addEqualBaseAdressConstraint(base.getAddress(), address);
            return Expression.Location.AliasedLocation.ofAddress(address);
        }
        throw new UnrecognizedCCodeException("Field owner of a non-composite type", this.edge, e);
    }

    static boolean isUnaliasedLocation(CExpression e) {
        if (e instanceof CIdExpression) {
            return true;
        }
        if (e instanceof CFieldReference && !((CFieldReference)e).isPointerDereference()) {
            return CExpressionVisitorWithPointerAliasing.isUnaliasedLocation(((CFieldReference)e).getFieldOwner());
        }
        return false;
    }

    static boolean isRevealingType(CType type) {
        return (type instanceof CPointerType || type instanceof CArrayType) && !type.equals(CPointerType.POINTER_TO_VOID);
    }

    @Override
    public Expression visit(CCastExpression e) throws UnrecognizedCCodeException {
        String variableName;
        CType resultType = CTypeUtils.simplifyType(e.getExpressionType());
        CExpression operand = this.conv.makeCastFromArrayToPointerIfNecessary(e.getOperand(), resultType);
        Expression result = operand.accept(this);
        if (CExpressionVisitorWithPointerAliasing.isRevealingType(resultType) && CExpressionVisitorWithPointerAliasing.isUnaliasedLocation(operand) && result.isUnaliasedLocation() && this.pts.isDeferredAllocationPointer(variableName = result.asLocation().asUnaliased().getVariableName())) {
            assert (this.usedDeferredAllocationPointers.containsKey(variableName) && this.usedDeferredAllocationPointers.get(variableName).equals(CPointerType.POINTER_TO_VOID)) : "Wrong assumptions on deferred allocations tracking: unknown pointer encountered";
            this.usedDeferredAllocationPointers.put(variableName, resultType);
        }
        CType operandType = CTypeUtils.simplifyType(operand.getExpressionType());
        if (CTypeUtils.isSimpleType(resultType)) {
            return Expression.Value.ofValue(this.conv.makeCast(operandType, resultType, this.asValueFormula(result, operandType), this.constraints, this.edge));
        }
        if (CTypes.withoutConst(resultType).equals(CTypes.withoutConst(operandType))) {
            return result;
        }
        throw new UnrecognizedCCodeException("Conversion to non-scalar type requested", this.edge, e);
    }

    @Override
    public Expression visit(CIdExpression e) throws UnrecognizedCCodeException {
        Variable variable = e.accept(this.baseVisitor);
        CType resultType = CTypeUtils.simplifyType(e.getExpressionType());
        if (variable != null) {
            if (!(e.getDeclaration() instanceof CFunctionDeclaration)) {
                String variableName = variable.getName();
                if (this.pts.isDeferredAllocationPointer(variableName)) {
                    this.usedDeferredAllocationPointers.put(variableName, CPointerType.POINTER_TO_VOID);
                }
                return Expression.Location.UnaliasedLocation.ofVariableName(variableName);
            }
            return Expression.Value.ofValue(this.conv.makeConstant(variable.getName(), variable.getType()));
        }
        Formula address = this.conv.makeConstant(PointerTargetSet.getBaseName(e.getDeclaration().getQualifiedName()), CTypeUtils.getBaseType(resultType));
        return Expression.Location.AliasedLocation.ofAddress(address);
    }

    @Override
    public Expression.Value visit(CUnaryExpression e) throws UnrecognizedCCodeException {
        if (e.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            CExpression operand = e.getOperand();
            CType resultType = CTypeUtils.simplifyType(e.getExpressionType());
            if (!(resultType instanceof CFunctionType)) {
                Variable baseVariable = operand.accept(this.baseVisitor);
                if (baseVariable == null) {
                    Expression.Location.AliasedLocation addressExpression = null;
                    ImmutableList alreadyUsedFields = ImmutableList.copyOf(this.usedFields);
                    this.usedFields.clear();
                    if (this.errorConditions.isEnabled() && operand instanceof CFieldReference) {
                        CFieldReference field = (CFieldReference)operand;
                        CExpression fieldOwner = field.getFieldOwner();
                        boolean isDeref = field.isPointerDereference();
                        if (!isDeref && fieldOwner instanceof CPointerExpression) {
                            fieldOwner = ((CPointerExpression)fieldOwner).getOperand();
                            isDeref = true;
                        }
                        if (isDeref) {
                            CPointerType pointerType = (CPointerType)CTypeUtils.simplifyType(fieldOwner.getExpressionType());
                            Formula base = this.asSafeValueFormula(fieldOwner.accept(this), pointerType);
                            String fieldName = field.getFieldName();
                            CCompositeType compositeType = (CCompositeType)CTypeUtils.simplifyType(pointerType.getType());
                            this.usedFields.add((Pair<CCompositeType, String>)Pair.of((Object)compositeType, (Object)fieldName));
                            Object offset = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, this.conv.ptsMgr.getOffset(compositeType, fieldName));
                            addressExpression = Expression.Location.AliasedLocation.ofAddress(this.conv.fmgr.makePlus(base, offset));
                            this.addEqualBaseAdressConstraint(base, addressExpression.getAddress());
                        }
                    }
                    if (addressExpression == null) {
                        addressExpression = operand.accept(this).asAliasedLocation();
                    }
                    this.addressedFields.addAll(this.usedFields);
                    this.usedFields.addAll((Collection<Pair<CCompositeType, String>>)alreadyUsedFields);
                    return Expression.Value.ofValue(addressExpression.getAddress());
                }
                Variable base = this.baseVisitor.getLastBase();
                Formula baseAddress = this.conv.makeConstant(PointerTargetSet.getBaseName(base.getName()), CTypeUtils.getBaseType(base.getType()));
                this.conv.addValueImportConstraints(this.edge, baseAddress, base, this.initializedFields, this.ssa, this.constraints, this.pts);
                if (this.conv.hasIndex(base.getName(), base.getType(), this.ssa)) {
                    this.ssa.deleteVariable(base.getName());
                }
                this.conv.addPreFilledBase(base.getName(), base.getType(), this.pts.isPreparedBase(base.getName()), false, this.constraints, this.pts);
                return this.visit(e);
            }
            return operand.accept(this).asValue();
        }
        return this.visitDefault(e);
    }

    @Override
    public Expression.Location.AliasedLocation visit(CPointerExpression e) throws UnrecognizedCCodeException {
        CExpression operand = e.getOperand();
        CType operandType = CTypeUtils.simplifyType(operand.getExpressionType());
        Expression operandExpression = operand.accept(this);
        if (operandType instanceof CArrayType && ((CArrayType)operandType).getLength() != null) {
            return operandExpression.asAliasedLocation();
        }
        return Expression.Location.AliasedLocation.ofAddress(this.asValueFormula(operandExpression, operandType));
    }

    @Override
    public Expression.Value visit(CBinaryExpression exp) throws UnrecognizedCCodeException {
        CType returnType = exp.getExpressionType();
        CType calculationType = exp.getCalculationType();
        Formula f1 = this.delegate.processOperand(exp.getOperand1(), calculationType, returnType);
        Formula f2 = this.delegate.processOperand(exp.getOperand2(), calculationType, returnType);
        Formula result = this.delegate.handleBinaryExpression(exp, f1, f2);
        CType t1 = CTypeUtils.simplifyType(exp.getOperand1().getExpressionType());
        CType t2 = CTypeUtils.simplifyType(exp.getOperand2().getExpressionType());
        CBinaryExpression.BinaryOperator op = exp.getOperator();
        switch (op) {
            case PLUS: {
                if (t1 instanceof CPointerType) {
                    this.addEqualBaseAdressConstraint(result, f1);
                }
                if (!(t2 instanceof CPointerType)) break;
                this.addEqualBaseAdressConstraint(result, f2);
                break;
            }
        }
        return Expression.Value.ofValue(result);
    }

    @Override
    protected Expression.Value visitDefault(CExpression e) throws UnrecognizedCCodeException {
        return Expression.Value.ofValue(e.accept(this.delegate));
    }

    @Override
    public Expression.Value visit(CFunctionCallExpression e) throws UnrecognizedCCodeException {
        CType resultType;
        String functionName;
        CExpression functionNameExpression = e.getFunctionNameExpression();
        if (functionNameExpression instanceof CIdExpression && this.conv.options.isDynamicMemoryFunction(functionName = ((CIdExpression)functionNameExpression).getName())) {
            DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this.conv, this.edge, this.ssa, this.pts, this.constraints, this.errorConditions);
            try {
                return memoryHandler.handleDynamicMemoryFunction(e, functionName, this);
            }
            catch (InterruptedException exc) {
                Thread.currentThread().stop(exc);
            }
        }
        if ((resultType = CTypeUtils.simplifyType(this.conv.getReturnType(e, this.edge))) instanceof CCompositeType || CTypeUtils.containsArray(resultType)) {
            this.conv.logger.logfOnce(Level.WARNING, "Extern function %s returning a composite is treated as nondet.", new Object[]{e});
            return Expression.Value.nondetValue();
        }
        Formula result = this.delegate.visit(e);
        if (result == null) {
            return Expression.Value.nondetValue();
        }
        return Expression.Value.ofValue(result);
    }

    List<Pair<CCompositeType, String>> getUsedFields() {
        return Collections.unmodifiableList(this.usedFields);
    }

    List<Pair<CCompositeType, String>> getInitializedFields() {
        return Collections.unmodifiableList(this.initializedFields);
    }

    List<Pair<CCompositeType, String>> getAddressedFields() {
        return Collections.unmodifiableList(this.addressedFields);
    }

    Map<String, CType> getUsedDeferredAllocationPointers() {
        return Collections.unmodifiableMap(this.usedDeferredAllocationPointers);
    }

    private static class AdaptingExpressionToFormulaVisitor
    extends AdaptingCExpressionVisitor<Formula, Expression, UnrecognizedCCodeException>
    implements CRightHandSideVisitor<Formula, UnrecognizedCCodeException> {
        private AdaptingExpressionToFormulaVisitor(CExpressionVisitorWithPointerAliasing pDelegate) {
            super(pDelegate);
        }

        @Override
        protected Formula convert(Expression value, CExpression rhs) throws UnrecognizedCCodeException {
            return this.convert0(value, rhs);
        }

        private Formula convert0(Expression value, CRightHandSide rhs) throws UnrecognizedCCodeException {
            CType type = CTypeUtils.simplifyType(rhs.getExpressionType());
            return ((CExpressionVisitorWithPointerAliasing)this.delegate).asValueFormula(value, type);
        }

        @Override
        public Formula visit(CFunctionCallExpression e) throws UnrecognizedCCodeException {
            return this.convert0(((CExpressionVisitorWithPointerAliasing)this.delegate).visit(e), e);
        }
    }
}

