/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Optional;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.AssignmentHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CExpressionVisitorWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Variable;

public class CToFormulaConverterWithPointerAliasing
extends CtoFormulaConverter {
    final LogManagerWithoutDuplicates logger;
    final FormulaManagerView fmgr;
    final BooleanFormulaManagerView bfmgr;
    final FunctionFormulaManagerView ffmgr;
    final MachineModel machineModel;
    final ShutdownNotifier shutdownNotifier;
    final TypeHandlerWithPointerAliasing typeHandler;
    final PointerTargetSetManager ptsMgr;
    final FormulaType<?> voidPointerFormulaType;
    final Formula nullPointer;
    final FormulaEncodingWithPointerAliasingOptions options;
    private final Optional<VariableClassification> variableClassification;
    static final String UF_NAME_PREFIX = "*";
    static final String FIELD_NAME_SEPARATOR = "$";
    private static final Map<CType, String> ufNameCache = new IdentityHashMap<CType, String>();

    public CToFormulaConverterWithPointerAliasing(FormulaEncodingWithPointerAliasingOptions pOptions, FormulaManagerView formulaManagerView, MachineModel pMachineModel, PointerTargetSetManager pPtsMgr, Optional<VariableClassification> pVariableClassification, LogManager logger, ShutdownNotifier pShutdownNotifier, TypeHandlerWithPointerAliasing pTypeHandler, AnalysisDirection pDirection) throws InvalidConfigurationException {
        super(pOptions, formulaManagerView, pMachineModel, pVariableClassification, logger, pShutdownNotifier, pTypeHandler, pDirection);
        this.logger = ((CtoFormulaConverter)this).logger;
        this.fmgr = ((CtoFormulaConverter)this).fmgr;
        this.bfmgr = ((CtoFormulaConverter)this).bfmgr;
        this.ffmgr = ((CtoFormulaConverter)this).ffmgr;
        this.machineModel = ((CtoFormulaConverter)this).machineModel;
        this.shutdownNotifier = ((CtoFormulaConverter)this).shutdownNotifier;
        this.variableClassification = pVariableClassification;
        this.options = pOptions;
        this.ptsMgr = pPtsMgr;
        this.typeHandler = pTypeHandler;
        this.voidPointerFormulaType = this.typeHandler.getFormulaTypeFromCType(CPointerType.POINTER_TO_VOID);
        this.nullPointer = this.fmgr.makeNumber(this.voidPointerFormulaType, 0L);
    }

    public static String getUFName(CType type) {
        String result = ufNameCache.get(type);
        if (result != null) {
            return result;
        }
        result = UF_NAME_PREFIX + CTypeUtils.typeToString(type).replace(' ', '_');
        ufNameCache.put(type, result);
        return result;
    }

    public static boolean isUF(String symbol) {
        return symbol.startsWith(UF_NAME_PREFIX);
    }

    Formula makeBaseAddressOfTerm(Formula address) {
        return this.ffmgr.declareAndCallUninterpretedFunction("__BASE_ADDRESS_OF__", this.voidPointerFormulaType, address);
    }

    static CFieldReference eliminateArrow(CFieldReference e, CFAEdge edge) throws UnrecognizedCCodeException {
        if (e.isPointerDereference()) {
            CType fieldOwnerType = CTypeUtils.simplifyType(e.getFieldOwner().getExpressionType());
            if (fieldOwnerType instanceof CPointerType) {
                return new CFieldReference(e.getFileLocation(), e.getExpressionType(), e.getFieldName(), new CPointerExpression(e.getFieldOwner().getFileLocation(), ((CPointerType)fieldOwnerType).getType(), e.getFieldOwner()), false);
            }
            throw new UnrecognizedCCodeException("Can't dereference a non-pointer in the field reference", edge, e);
        }
        return e;
    }

    @Override
    protected void checkSsaSavedType(String name, CType type, CType ssaSavedType) {
        if (ssaSavedType != null) {
            ssaSavedType = CTypeUtils.simplifyType(ssaSavedType);
        }
        if (ssaSavedType != null && !ssaSavedType.equals(CTypeUtils.simplifyType(type))) {
            this.logger.logf(Level.FINEST, "Variable %s was found with multiple types! (Type1: %s, Type2: %s)", new Object[]{name, ssaSavedType, type});
        }
    }

    boolean hasIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        this.checkSsaSavedType(name, type, ssa.getType(name));
        return ssa.getIndex(name) > 0;
    }

    Formula makeDereference(CType type, Formula address, SSAMap.SSAMapBuilder ssa, ErrorConditions errorConditions) {
        if (errorConditions.isEnabled()) {
            errorConditions.addInvalidDerefCondition(this.fmgr.makeEqual(address, this.nullPointer));
            errorConditions.addInvalidDerefCondition(this.fmgr.makeLessThan(address, this.makeBaseAddressOfTerm(address), false));
        }
        return this.makeSafeDereference(type, address, ssa);
    }

    Formula makeSafeDereference(CType type, Formula address, SSAMap.SSAMapBuilder ssa) {
        type = CTypeUtils.simplifyType(type);
        String ufName = CToFormulaConverterWithPointerAliasing.getUFName(type);
        int index = this.getIndex(ufName, type, ssa);
        FormulaType<?> returnType = this.getFormulaTypeFromCType(type);
        return this.ffmgr.declareAndCallUninterpretedFunction(ufName, index, returnType, address);
    }

    @Override
    protected boolean isRelevantField(CCompositeType compositeType, String fieldName) {
        return super.isRelevantField(compositeType, fieldName) || this.getSizeof(compositeType) <= this.options.maxPreFilledAllocationSize();
    }

    boolean isAddressedVariable(CDeclaration var) {
        return !this.variableClassification.isPresent() || ((VariableClassification)this.variableClassification.get()).getAddressedVariables().contains(var.getQualifiedName());
    }

    private void addAllFields(CType type, PointerTargetSetBuilder pts) {
        if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                if (!this.isRelevantField(compositeType, memberDeclaration.getName())) continue;
                pts.addField(compositeType, memberDeclaration.getName());
                CType memberType = CTypeUtils.simplifyType(memberDeclaration.getType());
                this.addAllFields(memberType, pts);
            }
        } else if (type instanceof CArrayType) {
            CType elementType = CTypeUtils.simplifyType(((CArrayType)type).getType());
            this.addAllFields(elementType, pts);
        }
    }

    void addPreFilledBase(String base, CType type, boolean prepared, boolean forcePreFill, Constraints constraints, PointerTargetSetBuilder pts) {
        if (!prepared) {
            constraints.addConstraint(pts.addBase(base, type));
        } else {
            pts.shareBase(base, type);
        }
        if (forcePreFill || this.options.maxPreFilledAllocationSize() > 0 && this.getSizeof(type) <= this.options.maxPreFilledAllocationSize()) {
            this.addAllFields(type, pts);
        }
    }

    private void declareSharedBase(CDeclaration declaration, boolean shareImmediately, Constraints constraints, PointerTargetSetBuilder pts) {
        if (shareImmediately) {
            this.addPreFilledBase(declaration.getQualifiedName(), declaration.getType(), false, false, constraints, pts);
        } else if (this.isAddressedVariable(declaration) || CTypeUtils.containsArray(declaration.getType())) {
            constraints.addConstraint(pts.prepareBase(declaration.getQualifiedName(), CTypeUtils.simplifyType(declaration.getType())));
        }
    }

    void addValueImportConstraints(CFAEdge cfaEdge, Formula address, Variable base, List<Pair<CCompositeType, String>> fields, SSAMap.SSAMapBuilder ssa, Constraints constraints, PointerTargetSetBuilder pts) throws UnrecognizedCCodeException {
        CType baseType = CTypeUtils.simplifyType(base.getType());
        if (baseType instanceof CArrayType) {
            throw new UnrecognizedCCodeException("Array access can't be encoded as a varaible", cfaEdge);
        }
        if (baseType instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)baseType;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
            int offset = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                String memberName = memberDeclaration.getName();
                CType memberType = CTypeUtils.simplifyType(memberDeclaration.getType());
                Variable newBase = Variable.create(base.getName() + FIELD_NAME_SEPARATOR + memberName, memberType);
                if (this.hasIndex(newBase.getName(), newBase.getType(), ssa) && this.isRelevantField(compositeType, memberName)) {
                    fields.add((Pair<CCompositeType, String>)Pair.of((Object)compositeType, (Object)memberName));
                    this.addValueImportConstraints(cfaEdge, this.fmgr.makePlus(address, this.fmgr.makeNumber(this.voidPointerFormulaType, offset)), newBase, fields, ssa, constraints, pts);
                }
                if (compositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
                offset += this.getSizeof(memberType);
            }
        } else if (!(baseType instanceof CFunctionType)) {
            constraints.addConstraint(this.fmgr.makeEqual(this.makeSafeDereference(baseType, address, ssa), this.makeVariable(base.getName(), baseType, ssa)));
        }
    }

    private static List<CCharLiteralExpression> expandStringLiteral(CStringLiteralExpression e, CArrayType type) {
        int i;
        Integer length = CTypeUtils.getArrayLength(type);
        String s = e.getContentString();
        if (length == null) {
            length = s.length() + 1;
        }
        assert (length >= s.length());
        ArrayList<CCharLiteralExpression> result = new ArrayList<CCharLiteralExpression>();
        for (i = 0; i < s.length(); ++i) {
            result.add(new CCharLiteralExpression(e.getFileLocation(), CNumericTypes.SIGNED_CHAR, s.charAt(i)));
        }
        for (i = s.length(); i < length; ++i) {
            result.add(new CCharLiteralExpression(e.getFileLocation(), CNumericTypes.SIGNED_CHAR, '\u0000'));
        }
        return result;
    }

    private static List<CExpressionAssignmentStatement> expandStringLiterals(List<CExpressionAssignmentStatement> assignments) throws UnrecognizedCCodeException {
        ArrayList<CExpressionAssignmentStatement> result = new ArrayList<CExpressionAssignmentStatement>();
        for (CExpressionAssignmentStatement assignment : assignments) {
            CExpression rhs = assignment.getRightHandSide();
            if (rhs instanceof CStringLiteralExpression) {
                CArrayType lhsArrayType;
                CLeftHandSide lhs = assignment.getLeftHandSide();
                CType lhsType = lhs.getExpressionType();
                if (lhsType instanceof CArrayType) {
                    lhsArrayType = (CArrayType)lhsType;
                } else if (lhsType instanceof CPointerType) {
                    lhsArrayType = new CArrayType(false, false, ((CPointerType)lhsType).getType(), null);
                } else {
                    throw new UnrecognizedCCodeException("Assigning string literal to " + lhsType.toString(), assignment);
                }
                List<CCharLiteralExpression> chars = CToFormulaConverterWithPointerAliasing.expandStringLiteral((CStringLiteralExpression)rhs, lhsArrayType);
                int offset = 0;
                for (CCharLiteralExpression e : chars) {
                    result.add(new CExpressionAssignmentStatement(assignment.getFileLocation(), new CArraySubscriptExpression(lhs.getFileLocation(), lhsArrayType.getType(), lhs, new CIntegerLiteralExpression(lhs.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(offset))), e));
                    ++offset;
                }
                continue;
            }
            result.add(assignment);
        }
        return result;
    }

    static List<CExpressionAssignmentStatement> expandAssignmentList(CVariableDeclaration declaration, List<CExpressionAssignmentStatement> explicitAssignments) {
        CType variableType = CTypeUtils.simplifyType(declaration.getType());
        CIdExpression lhs = new CIdExpression(declaration.getFileLocation(), variableType, declaration.getName(), declaration);
        HashSet<String> alreadyAssigned = new HashSet<String>();
        for (CExpressionAssignmentStatement statement : explicitAssignments) {
            alreadyAssigned.add(statement.getLeftHandSide().toString());
        }
        ArrayList<CExpressionAssignmentStatement> defaultAssignments = new ArrayList<CExpressionAssignmentStatement>();
        CToFormulaConverterWithPointerAliasing.expandAssignmentList(variableType, lhs, alreadyAssigned, defaultAssignments);
        defaultAssignments.addAll(explicitAssignments);
        return defaultAssignments;
    }

    private static void expandAssignmentList(CType type, CLeftHandSide lhs, Set<String> alreadyAssigned, List<CExpressionAssignmentStatement> defaultAssignments) {
        if ((type = CTypeUtils.simplifyType(type)) instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)type;
            CType elementType = CTypeUtils.simplifyType(arrayType.getType());
            Integer length = CTypeUtils.getArrayLength(arrayType);
            if (length != null) {
                for (int i = 0; i < length; ++i) {
                    CArraySubscriptExpression newLhs = new CArraySubscriptExpression(lhs.getFileLocation(), elementType, lhs, new CIntegerLiteralExpression(lhs.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(i)));
                    CToFormulaConverterWithPointerAliasing.expandAssignmentList(elementType, newLhs, alreadyAssigned, defaultAssignments);
                }
            }
        } else if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                CType memberType = memberDeclaration.getType();
                CFieldReference newLhs = new CFieldReference(lhs.getFileLocation(), memberType, memberDeclaration.getName(), lhs, false);
                CToFormulaConverterWithPointerAliasing.expandAssignmentList(memberType, newLhs, alreadyAssigned, defaultAssignments);
            }
        } else {
            assert (CTypeUtils.isSimpleType(type));
            CExpression initExp = ((CInitializerExpression)CDefaults.forType(type, lhs.getFileLocation())).getExpression();
            if (!alreadyAssigned.contains(lhs.toString())) {
                defaultAssignments.add(new CExpressionAssignmentStatement(lhs.getFileLocation(), lhs, initExp));
            }
        }
    }

    @Override
    protected PointerTargetSetBuilder createPointerTargetSetBuilder(PointerTargetSet pts) {
        return new PointerTargetSetBuilder.RealPointerTargetSetBuilder(pts, this.fmgr, this.ptsMgr, this.options);
    }

    @Override
    protected CRightHandSideVisitor<Formula, UnrecognizedCCodeException> createCRightHandSideVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) {
        CExpressionVisitorWithPointerAliasing rhsVisitor = new CExpressionVisitorWithPointerAliasing(this, pEdge, pFunction, pSsa, pConstraints, pErrorConditions, pPts);
        return rhsVisitor.asFormulaVisitor();
    }

    @Override
    protected BooleanFormula makeReturn(Optional<CAssignment> assignment, CReturnStatementEdge returnEdge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        BooleanFormula result = super.makeReturn(assignment, returnEdge, function, ssa, pts, constraints, errorConditions);
        if (assignment.isPresent()) {
            CVariableDeclaration returnVariableDeclaraton = (CVariableDeclaration)((CFunctionEntryNode)returnEdge.getSuccessor().getEntryNode()).getReturnVariable().get();
            boolean containsArray = CTypeUtils.containsArray(returnVariableDeclaraton.getType());
            this.declareSharedBase(returnVariableDeclaraton, containsArray, constraints, pts);
        }
        return result;
    }

    @Override
    protected BooleanFormula makeAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, CRightHandSide rhs, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        AssignmentHandler assignmentHandler = new AssignmentHandler(this, edge, function, ssa, pts, constraints, errorConditions);
        return assignmentHandler.handleAssignment(lhs, lhsForChecking, rhs, false, null);
    }

    private static String getLogMessage(String msg, CFAEdge edge) {
        return edge.getFileLocation() + ": " + msg + ": " + edge.getDescription();
    }

    private void logDebug(String msg, CFAEdge edge) {
        if (this.logger.wouldBeLogged(Level.ALL)) {
            this.logger.log(Level.ALL, new Object[]{CToFormulaConverterWithPointerAliasing.getLogMessage(msg, edge)});
        }
    }

    @Override
    protected BooleanFormula makeDeclaration(CDeclarationEdge declarationEdge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        BooleanFormula result;
        Integer actualLength;
        CType declarationType;
        if (declarationEdge.getDeclaration() instanceof CTypeDeclaration && (declarationType = CTypeUtils.simplifyType(declarationEdge.getDeclaration().getType())) instanceof CCompositeType) {
            this.typeHandler.addCompositeTypeToCache((CCompositeType)declarationType);
        }
        if (!(declarationEdge.getDeclaration() instanceof CVariableDeclaration)) {
            this.logDebug("Ignoring declaration", declarationEdge);
            return this.bfmgr.makeBoolean(true);
        }
        CVariableDeclaration declaration = (CVariableDeclaration)declarationEdge.getDeclaration();
        CType declarationType2 = CTypeUtils.simplifyType(declaration.getType());
        if (!this.isRelevantVariable(declaration) && !this.isAddressedVariable(declaration)) {
            this.logDebug("Ignoring declaration of unused variable", declarationEdge);
            return this.bfmgr.makeBoolean(true);
        }
        if (declarationType2 instanceof CArrayType) {
            CExpression length;
            CType elementType = ((CArrayType)declarationType2).getType();
            if (elementType instanceof CSimpleType && ((CSimpleType)elementType).getType().isFloatingPointType() && (length = ((CArrayType)declarationType2).getLength()) instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)length).getValue().longValue() > 100L) {
                throw new UnsupportedCCodeException("large floating-point array", declarationEdge);
            }
            if (elementType instanceof CSimpleType && ((CSimpleType)elementType).getType() == CBasicType.INT && (length = ((CArrayType)declarationType2).getLength()) instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)length).getValue().longValue() >= 10000L) {
                throw new UnsupportedCCodeException("large integer array", declarationEdge);
            }
        }
        if (errorConditions.isEnabled()) {
            Formula address = this.makeConstant(PointerTargetSet.getBaseName(declaration.getQualifiedName()), CTypeUtils.getBaseType(declarationType2));
            constraints.addConstraint(this.fmgr.makeEqual(this.makeBaseAddressOfTerm(address), address));
        }
        CInitializer initializer = declaration.getInitializer();
        if (declarationType2 instanceof CArrayType && ((CArrayType)declarationType2).getLength() == null && (actualLength = initializer instanceof CInitializerList ? Integer.valueOf(((CInitializerList)initializer).getInitializers().size()) : (initializer instanceof CInitializerExpression && ((CInitializerExpression)initializer).getExpression() instanceof CStringLiteralExpression ? Integer.valueOf(((CStringLiteralExpression)((CInitializerExpression)initializer).getExpression()).getContentString().length() + 1) : null)) != null) {
            declarationType2 = new CArrayType(declarationType2.isConst(), declarationType2.isVolatile(), ((CArrayType)declarationType2).getType(), new CIntegerLiteralExpression(declaration.getFileLocation(), this.machineModel.getPointerDiffType(), BigInteger.valueOf(actualLength.intValue())));
            declaration = new CVariableDeclaration(declaration.getFileLocation(), declaration.isGlobal(), declaration.getCStorageClass(), declarationType2, declaration.getName(), declaration.getOrigName(), declaration.getQualifiedName(), initializer);
        }
        this.declareSharedBase(declaration, false, constraints, pts);
        if (CTypeUtils.containsArray(declarationType2)) {
            this.addPreFilledBase(declaration.getQualifiedName(), declarationType2, true, false, constraints, pts);
        }
        if (this.options.useParameterVariablesForGlobals() && declaration.isGlobal()) {
            this.globalDeclarations.add(declaration);
        }
        CIdExpression lhs = new CIdExpression(declaration.getFileLocation(), declaration);
        AssignmentHandler assignmentHandler = new AssignmentHandler(this, declarationEdge, function, ssa, pts, constraints, errorConditions);
        if (initializer instanceof CInitializerExpression || initializer == null) {
            result = initializer != null ? assignmentHandler.handleAssignment(lhs, lhs, ((CInitializerExpression)initializer).getExpression(), false, null) : (this.isRelevantVariable(declaration) ? assignmentHandler.handleAssignment(lhs, lhs, null, false, null) : this.bfmgr.makeBoolean(true));
        } else if (initializer instanceof CInitializerList) {
            List<CExpressionAssignmentStatement> assignments = CInitializers.convertToAssignments(declaration, declarationEdge);
            if (this.options.handleStringLiteralInitializers()) {
                assignments = CToFormulaConverterWithPointerAliasing.expandStringLiterals(assignments);
            }
            if (this.options.handleImplicitInitialization()) {
                assignments = CToFormulaConverterWithPointerAliasing.expandAssignmentList(declaration, assignments);
            }
            result = assignmentHandler.handleInitializationAssignments(lhs, assignments);
        } else {
            throw new UnrecognizedCCodeException("Unrecognized initializer", (CFAEdge)declarationEdge, initializer);
        }
        return result;
    }

    @Override
    protected BooleanFormula makePredicate(CExpression e, boolean truthAssumtion, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        CType expressionType = CTypeUtils.simplifyType(e.getExpressionType());
        CExpressionVisitorWithPointerAliasing ev = new CExpressionVisitorWithPointerAliasing(this, edge, function, ssa, constraints, errorConditions, pts);
        BooleanFormula result = this.toBooleanFormula(ev.asValueFormula(e.accept(ev), expressionType));
        if (this.options.deferUntypedAllocations()) {
            DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this, edge, ssa, pts, constraints, errorConditions);
            memoryHandler.handleDeferredAllocationsInAssume(e, ev.getUsedDeferredAllocationPointers());
        }
        if (!truthAssumtion) {
            result = this.bfmgr.not(result);
        }
        pts.addEssentialFields(ev.getInitializedFields());
        pts.addEssentialFields(ev.getUsedFields());
        return result;
    }

    @Override
    protected BooleanFormula makeFunctionCall(CFunctionCallEdge edge, String callerFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        CFunctionEntryNode entryNode = edge.getSuccessor();
        BooleanFormula result = super.makeFunctionCall(edge, callerFunction, ssa, pts, constraints, errorConditions);
        for (CParameterDeclaration formalParameter : entryNode.getFunctionParameters()) {
            CVariableDeclaration declaration;
            CType parameterType = CTypeUtils.simplifyType(formalParameter.getType());
            CVariableDeclaration formalDeclaration = formalParameter.asVariableDeclaration();
            if (this.options.useParameterVariables()) {
                CParameterDeclaration tmpParameter = new CParameterDeclaration(formalParameter.getFileLocation(), formalParameter.getType(), formalParameter.getName() + "__param__");
                tmpParameter.setQualifiedName(formalParameter.getQualifiedName() + "__param__");
                declaration = tmpParameter.asVariableDeclaration();
            } else {
                declaration = formalDeclaration;
            }
            this.declareSharedBase(declaration, CTypeUtils.containsArray(parameterType), constraints, pts);
        }
        return result;
    }

    @Override
    protected BooleanFormula makeExitFunction(CFunctionSummaryEdge summaryEdge, String calledFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCCodeException, InterruptedException {
        BooleanFormula result = super.makeExitFunction(summaryEdge, calledFunction, ssa, pts, constraints, errorConditions);
        DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this, summaryEdge, ssa, pts, constraints, errorConditions);
        memoryHandler.handleDeferredAllocationInFunctionExit(calledFunction);
        return result;
    }

    @Override
    protected CType getReturnType(CFunctionCallExpression pFuncCallExp, CFAEdge pEdge) throws UnrecognizedCCodeException {
        return super.getReturnType(pFuncCallExp, pEdge);
    }

    @Override
    protected CExpression makeCastFromArrayToPointerIfNecessary(CExpression pExp, CType pTargetType) {
        return super.makeCastFromArrayToPointerIfNecessary(pExp, pTargetType);
    }

    @Override
    protected Formula makeCast(CType pFromType, CType pToType, Formula pFormula, Constraints constraints, CFAEdge pEdge) throws UnrecognizedCCodeException {
        return super.makeCast(pFromType, pToType, pFormula, constraints, pEdge);
    }

    @Override
    protected Formula makeConstant(String pName, CType pType) {
        return super.makeConstant(pName, pType);
    }

    @Override
    protected Formula makeVariable(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.makeVariable(pName, pType, pSsa);
    }

    @Override
    protected Formula makeFreshVariable(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.makeFreshVariable(pName, pType, pSsa);
    }

    @Override
    protected int makeFreshIndex(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.makeFreshIndex(pName, pType, pSsa);
    }

    @Override
    protected int getIndex(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.getIndex(pName, pType, pSsa);
    }

    @Override
    protected int getFreshIndex(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.getFreshIndex(pName, pType, pSsa);
    }

    @Override
    protected int getSizeof(CType pType) {
        return super.getSizeof(pType);
    }

    @Override
    protected boolean isRelevantLeftHandSide(CLeftHandSide pLhs) {
        return super.isRelevantLeftHandSide(pLhs);
    }
}

