/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import javax.annotation.Nonnull;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CachingCanonizingCTypeVisitor;

class CTypeUtils {
    private static final CachingCanonizingCTypeVisitor typeVisitor = new CachingCanonizingCTypeVisitor(true, true);

    private CTypeUtils() {
    }

    public static Integer getArrayLength(CArrayType t) {
        CExpression arrayLength = t.getLength();
        if (arrayLength instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)arrayLength).getValue().intValue();
        }
        return null;
    }

    public static boolean containsArray(CType type) {
        if ((type = CTypeUtils.simplifyType(type)) instanceof CArrayType) {
            return true;
        }
        if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite!";
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                if (!CTypeUtils.containsArray(memberDeclaration.getType())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static CType getBaseType(CType type) {
        if (!((type = CTypeUtils.simplifyType(type)) instanceof CArrayType)) {
            return new CPointerType(false, false, type);
        }
        return new CPointerType(false, false, ((CArrayType)type).getType());
    }

    static boolean isCompositeType(CType type) {
        type = CTypeUtils.simplifyType(type);
        assert (!(type instanceof CElaboratedType)) : "Unresolved elaborated type";
        assert (!(type instanceof CCompositeType) || ((CCompositeType)type).getKind() == CComplexType.ComplexTypeKind.STRUCT || ((CCompositeType)type).getKind() == CComplexType.ComplexTypeKind.UNION) : "Enums are not composite";
        return type instanceof CArrayType || type instanceof CCompositeType;
    }

    static CType implicitCastToPointer(CType type) {
        if ((type = CTypeUtils.simplifyType(type)) instanceof CArrayType) {
            return new CPointerType(false, false, CTypeUtils.simplifyType(((CArrayType)type).getType()));
        }
        if (type instanceof CFunctionType) {
            return new CPointerType(false, false, type);
        }
        return type;
    }

    static boolean isSimpleType(CType type) {
        return !(type instanceof CArrayType) && !(type instanceof CCompositeType);
    }

    public static CType simplifyType(@Nonnull CType type) {
        return type.accept(typeVisitor);
    }

    public static String typeToString(CType type) {
        return CTypeUtils.simplifyType(type).toString();
    }
}

