/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;

class CachingCanonizingCTypeVisitor
extends DefaultCTypeVisitor<CType, RuntimeException> {
    private final Map<CType, CType> typeCache = new HashMap<CType, CType>();
    private final CTypeTransformerVisitor typeVisitor;

    public CachingCanonizingCTypeVisitor(boolean ignoreConst, boolean ignoreVolatile) {
        this.typeVisitor = new CTypeTransformerVisitor(ignoreConst, ignoreVolatile);
    }

    @Override
    public CCompositeType visit(CCompositeType t) {
        CCompositeType result = (CCompositeType)this.typeCache.get(t);
        if (result != null) {
            return result;
        }
        CCompositeType canonicalType = t.getCanonicalType();
        if (this.typeVisitor.ignoreConst && t.isConst() || this.typeVisitor.ignoreVolatile && t.isVolatile()) {
            canonicalType = new CCompositeType(!this.typeVisitor.ignoreConst && canonicalType.isConst(), !this.typeVisitor.ignoreVolatile && canonicalType.isVolatile(), canonicalType.getKind(), canonicalType.getMembers(), canonicalType.getName(), canonicalType.getOrigName());
        }
        this.typeCache.put(t, canonicalType);
        return this.typeVisitor.visit(canonicalType);
    }

    @Override
    public CType visitDefault(CType t) {
        CType result = this.typeCache.get(t);
        if (result != null) {
            return result;
        }
        result = t.getCanonicalType();
        result = !(result instanceof CCompositeType) ? result.accept(this.typeVisitor) : result.accept(this);
        this.typeCache.put(t, result);
        return result;
    }

    private class CTypeTransformerVisitor
    implements CTypeVisitor<CType, RuntimeException> {
        private final boolean ignoreConst;
        private final boolean ignoreVolatile;

        public CTypeTransformerVisitor(boolean ignoreConst, boolean ignoreVolatile) {
            this.ignoreConst = ignoreConst;
            this.ignoreVolatile = ignoreVolatile;
        }

        @Override
        public CType visit(CArrayType t) {
            CType oldType = t.getType();
            CType type = oldType.accept(CachingCanonizingCTypeVisitor.this);
            return !(type != oldType || t.isConst() && this.ignoreConst || t.isVolatile() && this.ignoreVolatile) ? t : new CArrayType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), type, t.getLength());
        }

        @Override
        public CCompositeType visit(CCompositeType t) {
            ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> memberDeclarations = null;
            int i = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration oldMemberDeclaration : t.getMembers()) {
                CType oldMemberType = oldMemberDeclaration.getType();
                CType memberType = oldMemberType.accept(CachingCanonizingCTypeVisitor.this);
                if (memberType != oldMemberType && memberDeclarations == null) {
                    memberDeclarations = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>();
                    memberDeclarations.addAll(t.getMembers().subList(0, i));
                }
                if (memberDeclarations != null) {
                    if (memberType != oldMemberType) {
                        memberDeclarations.add(new CCompositeType.CCompositeTypeMemberDeclaration(memberType, oldMemberDeclaration.getName()));
                    } else {
                        memberDeclarations.add(oldMemberDeclaration);
                    }
                }
                ++i;
            }
            if (memberDeclarations != null) {
                t.setMembers(memberDeclarations);
            }
            return t;
        }

        @Override
        public CElaboratedType visit(CElaboratedType t) {
            CComplexType realType;
            CComplexType oldRealType = t.getRealType();
            CComplexType cComplexType = realType = oldRealType != null ? (CComplexType)oldRealType.accept(CachingCanonizingCTypeVisitor.this) : null;
            return !(realType != oldRealType || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CElaboratedType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), t.getKind(), t.getName(), t.getOrigName(), realType);
        }

        @Override
        public CPointerType visit(CPointerType t) {
            CType oldType = t.getType();
            CType type = oldType.accept(CachingCanonizingCTypeVisitor.this);
            return !(type != oldType || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CPointerType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), type);
        }

        @Override
        public CTypedefType visit(CTypedefType t) {
            CType oldRealType = t.getRealType();
            CType realType = oldRealType.accept(CachingCanonizingCTypeVisitor.this);
            return !(realType != oldRealType || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CTypedefType(!this.ignoreConst && t.isConst(), !this.ignoreConst && t.isVolatile(), t.getName(), realType);
        }

        @Override
        public CFunctionType visit(CFunctionType t) {
            CFunctionType result;
            CType oldReturnType = t.getReturnType();
            CType returnType = oldReturnType.accept(CachingCanonizingCTypeVisitor.this);
            List<CType> parameterTypes = null;
            int i = 0;
            for (CType oldType : t.getParameters()) {
                CType type = oldType.accept(CachingCanonizingCTypeVisitor.this);
                if (type != oldType && parameterTypes == null) {
                    parameterTypes = new ArrayList<CType>();
                    parameterTypes.addAll(t.getParameters().subList(0, i));
                }
                if (parameterTypes != null) {
                    parameterTypes.add(type);
                }
                ++i;
            }
            if (!(returnType != oldReturnType || parameterTypes != null || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile())) {
                result = t;
            } else {
                result = new CFunctionType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), returnType, parameterTypes != null ? parameterTypes : t.getParameters(), t.takesVarArgs());
                result.setName(t.getName());
            }
            return result;
        }

        @Override
        public CEnumType visit(CEnumType t) {
            return !(this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CEnumType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), (List<CEnumType.CEnumerator>)t.getEnumerators(), t.getName(), t.getOrigName());
        }

        @Override
        public CProblemType visit(CProblemType t) {
            return t;
        }

        @Override
        public CSimpleType visit(CSimpleType t) {
            return !(this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CSimpleType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), t.getType(), t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }

        @Override
        public CType visit(CVoidType t) {
            return CVoidType.create(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile());
        }
    }
}

